/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha2;

import com.google.cloud.bigquery.storage.v1alpha2.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1alpha2.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1alpha2.SchemaCompatibility;
import com.google.cloud.bigquery.storage.v1alpha2.Storage;
import com.google.cloud.bigquery.storage.v1alpha2.Stream;
import com.google.cloud.bigquery.storage.v1alpha2.StreamWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WriterCache {
    private static final Logger LOG = Logger.getLogger(WriterCache.class.getName());
    private static String tablePatternString = "(projects/[^/]+/datasets/[^/]+/tables/[^/]+)";
    private static Pattern tablePattern = Pattern.compile(tablePatternString);
    private static WriterCache instance;
    private Cache<String, Cache<Descriptors.Descriptor, StreamWriter>> writerCache;
    private static final int MAX_TABLE_ENTRY = 100;
    private static final int MAX_WRITERS_PER_TABLE = 2;
    private final BigQueryWriteClient stub;
    private final SchemaCompatibility compact;

    private WriterCache(BigQueryWriteClient stub, int maxTableEntry, SchemaCompatibility compact) {
        this.stub = stub;
        this.compact = compact;
        this.writerCache = CacheBuilder.newBuilder().maximumSize((long)maxTableEntry).removalListener((RemovalListener)new RemovalListener<String, Cache<Descriptors.Descriptor, StreamWriter>>(){

            public void onRemoval(RemovalNotification<String, Cache<Descriptors.Descriptor, StreamWriter>> removalNotification) {
                ((Cache)removalNotification.getValue()).invalidateAll();
            }
        }).build();
    }

    public static WriterCache getInstance() throws IOException {
        if (instance == null) {
            BigQueryWriteSettings stubSettings = BigQueryWriteSettings.newBuilder().build();
            BigQueryWriteClient stub = BigQueryWriteClient.create(stubSettings);
            instance = new WriterCache(stub, 100, SchemaCompatibility.getInstance());
        }
        return instance;
    }

    @VisibleForTesting
    public static WriterCache getTestInstance(BigQueryWriteClient stub, int maxTableEntry, SchemaCompatibility compact) {
        return new WriterCache(stub, maxTableEntry, compact);
    }

    private String CreateNewStream(String tableName) {
        Stream.WriteStream stream = Stream.WriteStream.newBuilder().setType(Stream.WriteStream.Type.COMMITTED).build();
        stream = this.stub.createWriteStream(Storage.CreateWriteStreamRequest.newBuilder().setParent(tableName).setWriteStream(stream).build());
        LOG.info("Created write stream:" + stream.getName());
        return stream.getName();
    }

    StreamWriter CreateNewWriter(String streamName) throws IllegalArgumentException, IOException, InterruptedException {
        return StreamWriter.newBuilder(streamName).setChannelProvider(this.stub.getSettings().getTransportChannelProvider()).setCredentialsProvider(this.stub.getSettings().getCredentialsProvider()).setExecutorProvider(this.stub.getSettings().getExecutorProvider()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamWriter getTableWriter(String tableName, Descriptors.Descriptor userSchema) throws IllegalArgumentException, IOException, InterruptedException {
        Matcher matcher = tablePattern.matcher(tableName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid table name: " + tableName);
        }
        String streamName = null;
        Boolean streamExpired = false;
        StreamWriter writer = null;
        Cache tableEntry = null;
        WriterCache writerCache = this;
        synchronized (writerCache) {
            tableEntry = (Cache)this.writerCache.getIfPresent((Object)tableName);
            if (tableEntry != null) {
                writer = (StreamWriter)tableEntry.getIfPresent((Object)userSchema);
                if (writer != null) {
                    if (!writer.expired().booleanValue()) {
                        return writer;
                    }
                    writer.close();
                }
                this.compact.check(tableName, userSchema);
                streamName = this.CreateNewStream(tableName);
                writer = this.CreateNewWriter(streamName);
                tableEntry.put((Object)userSchema, (Object)writer);
            } else {
                this.compact.check(tableName, userSchema);
                streamName = this.CreateNewStream(tableName);
                tableEntry = CacheBuilder.newBuilder().maximumSize(2L).removalListener((RemovalListener)new RemovalListener<Descriptors.Descriptor, StreamWriter>(){

                    public void onRemoval(RemovalNotification<Descriptors.Descriptor, StreamWriter> removalNotification) {
                        ((StreamWriter)removalNotification.getValue()).close();
                    }
                }).build();
                writer = this.CreateNewWriter(streamName);
                tableEntry.put((Object)userSchema, (Object)writer);
                this.writerCache.put((Object)tableName, (Object)tableEntry);
            }
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        WriterCache writerCache = this;
        synchronized (writerCache) {
            ConcurrentMap map = this.writerCache.asMap();
            for (String key : map.keySet()) {
                Cache entry = (Cache)this.writerCache.getIfPresent((Object)key);
                ConcurrentMap entryMap = entry.asMap();
                for (Descriptors.Descriptor descriptor : entryMap.keySet()) {
                    StreamWriter writer = (StreamWriter)entry.getIfPresent((Object)descriptor);
                    writer.close();
                }
            }
            this.writerCache.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public long cachedTableCount() {
        Cache<String, Cache<Descriptors.Descriptor, StreamWriter>> cache = this.writerCache;
        synchronized (cache) {
            return this.writerCache.size();
        }
    }
}

