/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.UninitializedMessageException;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonToProtoMessage {
    private static final Logger LOG = Logger.getLogger(JsonToProtoMessage.class.getName());
    private static ImmutableMap<Descriptors.FieldDescriptor.Type, String> FieldTypeToDebugMessage = new ImmutableMap.Builder().put((Object)Descriptors.FieldDescriptor.Type.BOOL, (Object)"boolean").put((Object)Descriptors.FieldDescriptor.Type.BYTES, (Object)"bytes").put((Object)Descriptors.FieldDescriptor.Type.INT32, (Object)"int32").put((Object)Descriptors.FieldDescriptor.Type.DOUBLE, (Object)"double").put((Object)Descriptors.FieldDescriptor.Type.INT64, (Object)"int64").put((Object)Descriptors.FieldDescriptor.Type.STRING, (Object)"string").put((Object)Descriptors.FieldDescriptor.Type.MESSAGE, (Object)"object").build();

    public static DynamicMessage convertJsonToProtoMessage(Descriptors.Descriptor protoSchema, JSONObject json) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)json, (Object)"JSONObject is null.");
        Preconditions.checkNotNull((Object)protoSchema, (Object)"Protobuf descriptor is null.");
        Preconditions.checkState((json.length() != 0 ? 1 : 0) != 0, (Object)"JSONObject is empty.");
        return JsonToProtoMessage.convertJsonToProtoMessageImpl(protoSchema, json, "root", true);
    }

    private static DynamicMessage convertJsonToProtoMessageImpl(Descriptors.Descriptor protoSchema, JSONObject json, String jsonScope, boolean topLevel) throws IllegalArgumentException {
        DynamicMessage msg;
        DynamicMessage.Builder protoMsg = DynamicMessage.newBuilder((Descriptors.Descriptor)protoSchema);
        String[] jsonNames = JSONObject.getNames((JSONObject)json);
        if (jsonNames == null) {
            return protoMsg.build();
        }
        for (int i = 0; i < jsonNames.length; ++i) {
            String jsonName = jsonNames[i];
            String jsonLowercaseName = jsonName.toLowerCase();
            String currentScope = jsonScope + "." + jsonName;
            Descriptors.FieldDescriptor field = protoSchema.findFieldByName(jsonLowercaseName);
            if (field == null) {
                throw new IllegalArgumentException(String.format("JSONObject has fields unknown to BigQuery: %s.", currentScope));
            }
            if (!field.isRepeated()) {
                JsonToProtoMessage.fillField(protoMsg, field, json, jsonName, currentScope);
                continue;
            }
            JsonToProtoMessage.fillRepeatedField(protoMsg, field, json, jsonName, currentScope);
        }
        try {
            msg = protoMsg.build();
        }
        catch (UninitializedMessageException e) {
            String errorMsg = e.getMessage();
            int idxOfColon = errorMsg.indexOf(":");
            String missingFieldName = errorMsg.substring(idxOfColon + 2);
            throw new IllegalArgumentException(String.format("JSONObject does not have the required field %s.%s.", jsonScope, missingFieldName));
        }
        if (topLevel && msg.getSerializedSize() == 0) {
            throw new IllegalArgumentException("The created protobuf message is empty.");
        }
        return msg;
    }

    private static void fillField(DynamicMessage.Builder protoMsg, Descriptors.FieldDescriptor fieldDescriptor, JSONObject json, String exactJsonKeyName, String currentScope) throws IllegalArgumentException {
        Object val = json.get(exactJsonKeyName);
        switch (fieldDescriptor.getType()) {
            case BOOL: {
                if (!(val instanceof Boolean)) break;
                protoMsg.setField(fieldDescriptor, (Object)((Boolean)val));
                return;
            }
            case BYTES: {
                if (!(val instanceof ByteString)) break;
                protoMsg.setField(fieldDescriptor, (Object)((ByteString)val).toByteArray());
                return;
            }
            case INT64: {
                if (val instanceof Integer) {
                    protoMsg.setField(fieldDescriptor, (Object)new Long(((Integer)val).intValue()));
                    return;
                }
                if (!(val instanceof Long)) break;
                protoMsg.setField(fieldDescriptor, (Object)((Long)val));
                return;
            }
            case INT32: {
                if (!(val instanceof Integer)) break;
                protoMsg.setField(fieldDescriptor, (Object)((Integer)val));
                return;
            }
            case STRING: {
                if (!(val instanceof String)) break;
                protoMsg.setField(fieldDescriptor, (Object)((String)val));
                return;
            }
            case DOUBLE: {
                if (val instanceof Double) {
                    protoMsg.setField(fieldDescriptor, (Object)((Double)val));
                    return;
                }
                if (!(val instanceof Float)) break;
                protoMsg.setField(fieldDescriptor, (Object)new Double(((Float)val).floatValue()));
                return;
            }
            case MESSAGE: {
                if (!(val instanceof JSONObject)) break;
                DynamicMessage.Builder message = protoMsg.newBuilderForField(fieldDescriptor);
                protoMsg.setField(fieldDescriptor, (Object)JsonToProtoMessage.convertJsonToProtoMessageImpl(fieldDescriptor.getMessageType(), json.getJSONObject(exactJsonKeyName), currentScope, false));
                return;
            }
        }
        throw new IllegalArgumentException(String.format("JSONObject does not have a %s field at %s.", FieldTypeToDebugMessage.get((Object)fieldDescriptor.getType()), currentScope));
    }

    private static void fillRepeatedField(DynamicMessage.Builder protoMsg, Descriptors.FieldDescriptor fieldDescriptor, JSONObject json, String exactJsonKeyName, String currentScope) throws IllegalArgumentException {
        JSONArray jsonArray;
        try {
            jsonArray = json.getJSONArray(exactJsonKeyName);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("JSONObject does not have a array field at " + currentScope + ".");
        }
        boolean fail = false;
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object val = jsonArray.get(i);
            int index = i;
            switch (fieldDescriptor.getType()) {
                case BOOL: {
                    if (val instanceof Boolean) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((Boolean)val));
                        break;
                    }
                    fail = true;
                    break;
                }
                case BYTES: {
                    if (val instanceof JSONArray) {
                        try {
                            byte[] bytes = new byte[((JSONArray)val).length()];
                            for (int j = 0; j < ((JSONArray)val).length(); ++j) {
                                bytes[j] = (byte)((JSONArray)val).getInt(j);
                                if (bytes[j] == ((JSONArray)val).getInt(j)) continue;
                                throw new IllegalArgumentException(String.format("Error: " + currentScope + "[" + index + "] could not be converted to byte[].", new Object[0]));
                            }
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)bytes);
                            break;
                        }
                        catch (JSONException e) {
                            throw new IllegalArgumentException(String.format("Error: " + currentScope + "[" + index + "] could not be converted to byte[].", new Object[0]));
                        }
                    }
                    fail = true;
                    break;
                }
                case INT64: {
                    if (val instanceof Integer) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)new Long(((Integer)val).intValue()));
                        break;
                    }
                    if (val instanceof Long) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((Long)val));
                        break;
                    }
                    fail = true;
                    break;
                }
                case INT32: {
                    if (val instanceof Integer) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((Integer)val));
                        break;
                    }
                    fail = true;
                    break;
                }
                case STRING: {
                    if (val instanceof String) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((String)val));
                        break;
                    }
                    fail = true;
                    break;
                }
                case DOUBLE: {
                    if (val instanceof Double) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((Double)val));
                        break;
                    }
                    if (val instanceof Float) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)new Double(((Float)val).floatValue()));
                        break;
                    }
                    fail = true;
                    break;
                }
                case MESSAGE: {
                    if (val instanceof JSONObject) {
                        DynamicMessage.Builder message = protoMsg.newBuilderForField(fieldDescriptor);
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)JsonToProtoMessage.convertJsonToProtoMessageImpl(fieldDescriptor.getMessageType(), jsonArray.getJSONObject(i), currentScope, false));
                        break;
                    }
                    fail = true;
                }
            }
            if (!fail) continue;
            throw new IllegalArgumentException(String.format("JSONObject does not have a %s field at %s[%d].", FieldTypeToDebugMessage.get((Object)fieldDescriptor.getType()), currentScope, index));
        }
    }
}

