/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.migration.v2alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest;
import com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse;
import com.google.cloud.bigquery.migration.v2alpha.stub.GrpcSqlTranslationServiceCallableFactory;
import com.google.cloud.bigquery.migration.v2alpha.stub.SqlTranslationServiceStub;
import com.google.cloud.bigquery.migration.v2alpha.stub.SqlTranslationServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcSqlTranslationServiceStub
extends SqlTranslationServiceStub {
    private static final MethodDescriptor<TranslateQueryRequest, TranslateQueryResponse> translateQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.migration.v2alpha.SqlTranslationService/TranslateQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)TranslateQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TranslateQueryResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<TranslateQueryRequest, TranslateQueryResponse> translateQueryCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSqlTranslationServiceStub create(SqlTranslationServiceStubSettings settings) throws IOException {
        return new GrpcSqlTranslationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSqlTranslationServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcSqlTranslationServiceStub(SqlTranslationServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSqlTranslationServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSqlTranslationServiceStub(SqlTranslationServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSqlTranslationServiceStub(SqlTranslationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSqlTranslationServiceCallableFactory());
    }

    protected GrpcSqlTranslationServiceStub(SqlTranslationServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings translateQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(translateQueryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.translateQueryCallable = callableFactory.createUnaryCallable(translateQueryTransportSettings, settings.translateQuerySettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<TranslateQueryRequest, TranslateQueryResponse> translateQueryCallable() {
        return this.translateQueryCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

