/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.migration.v2alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.migration.v2alpha.CreateMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2alpha.DeleteMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2alpha.GetMigrationSubtaskRequest;
import com.google.cloud.bigquery.migration.v2alpha.GetMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2alpha.ListMigrationSubtasksRequest;
import com.google.cloud.bigquery.migration.v2alpha.ListMigrationSubtasksResponse;
import com.google.cloud.bigquery.migration.v2alpha.ListMigrationWorkflowsRequest;
import com.google.cloud.bigquery.migration.v2alpha.ListMigrationWorkflowsResponse;
import com.google.cloud.bigquery.migration.v2alpha.MigrationServiceClient;
import com.google.cloud.bigquery.migration.v2alpha.MigrationSubtask;
import com.google.cloud.bigquery.migration.v2alpha.MigrationWorkflow;
import com.google.cloud.bigquery.migration.v2alpha.StartMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2alpha.stub.GrpcMigrationServiceStub;
import com.google.cloud.bigquery.migration.v2alpha.stub.HttpJsonMigrationServiceStub;
import com.google.cloud.bigquery.migration.v2alpha.stub.MigrationServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class MigrationServiceStubSettings
extends StubSettings<MigrationServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateMigrationWorkflowRequest, MigrationWorkflow> createMigrationWorkflowSettings;
    private final UnaryCallSettings<GetMigrationWorkflowRequest, MigrationWorkflow> getMigrationWorkflowSettings;
    private final PagedCallSettings<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationServiceClient.ListMigrationWorkflowsPagedResponse> listMigrationWorkflowsSettings;
    private final UnaryCallSettings<DeleteMigrationWorkflowRequest, Empty> deleteMigrationWorkflowSettings;
    private final UnaryCallSettings<StartMigrationWorkflowRequest, Empty> startMigrationWorkflowSettings;
    private final UnaryCallSettings<GetMigrationSubtaskRequest, MigrationSubtask> getMigrationSubtaskSettings;
    private final PagedCallSettings<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationServiceClient.ListMigrationSubtasksPagedResponse> listMigrationSubtasksSettings;
    private static final PagedListDescriptor<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationWorkflow> LIST_MIGRATION_WORKFLOWS_PAGE_STR_DESC = new PagedListDescriptor<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationWorkflow>(){

        public String emptyToken() {
            return "";
        }

        public ListMigrationWorkflowsRequest injectToken(ListMigrationWorkflowsRequest payload, String token) {
            return ListMigrationWorkflowsRequest.newBuilder((ListMigrationWorkflowsRequest)payload).setPageToken(token).build();
        }

        public ListMigrationWorkflowsRequest injectPageSize(ListMigrationWorkflowsRequest payload, int pageSize) {
            return ListMigrationWorkflowsRequest.newBuilder((ListMigrationWorkflowsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMigrationWorkflowsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMigrationWorkflowsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MigrationWorkflow> extractResources(ListMigrationWorkflowsResponse payload) {
            return payload.getMigrationWorkflowsList();
        }
    };
    private static final PagedListDescriptor<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationSubtask> LIST_MIGRATION_SUBTASKS_PAGE_STR_DESC = new PagedListDescriptor<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationSubtask>(){

        public String emptyToken() {
            return "";
        }

        public ListMigrationSubtasksRequest injectToken(ListMigrationSubtasksRequest payload, String token) {
            return ListMigrationSubtasksRequest.newBuilder((ListMigrationSubtasksRequest)payload).setPageToken(token).build();
        }

        public ListMigrationSubtasksRequest injectPageSize(ListMigrationSubtasksRequest payload, int pageSize) {
            return ListMigrationSubtasksRequest.newBuilder((ListMigrationSubtasksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMigrationSubtasksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMigrationSubtasksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MigrationSubtask> extractResources(ListMigrationSubtasksResponse payload) {
            return payload.getMigrationSubtasksList();
        }
    };
    private static final PagedListResponseFactory<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationServiceClient.ListMigrationWorkflowsPagedResponse> LIST_MIGRATION_WORKFLOWS_PAGE_STR_FACT = new PagedListResponseFactory<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationServiceClient.ListMigrationWorkflowsPagedResponse>(){

        public ApiFuture<MigrationServiceClient.ListMigrationWorkflowsPagedResponse> getFuturePagedResponse(UnaryCallable<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse> callable, ListMigrationWorkflowsRequest request, ApiCallContext context, ApiFuture<ListMigrationWorkflowsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MIGRATION_WORKFLOWS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MigrationServiceClient.ListMigrationWorkflowsPagedResponse.createAsync((PageContext<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationWorkflow>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationServiceClient.ListMigrationSubtasksPagedResponse> LIST_MIGRATION_SUBTASKS_PAGE_STR_FACT = new PagedListResponseFactory<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationServiceClient.ListMigrationSubtasksPagedResponse>(){

        public ApiFuture<MigrationServiceClient.ListMigrationSubtasksPagedResponse> getFuturePagedResponse(UnaryCallable<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse> callable, ListMigrationSubtasksRequest request, ApiCallContext context, ApiFuture<ListMigrationSubtasksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MIGRATION_SUBTASKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MigrationServiceClient.ListMigrationSubtasksPagedResponse.createAsync((PageContext<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationSubtask>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateMigrationWorkflowRequest, MigrationWorkflow> createMigrationWorkflowSettings() {
        return this.createMigrationWorkflowSettings;
    }

    public UnaryCallSettings<GetMigrationWorkflowRequest, MigrationWorkflow> getMigrationWorkflowSettings() {
        return this.getMigrationWorkflowSettings;
    }

    public PagedCallSettings<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationServiceClient.ListMigrationWorkflowsPagedResponse> listMigrationWorkflowsSettings() {
        return this.listMigrationWorkflowsSettings;
    }

    public UnaryCallSettings<DeleteMigrationWorkflowRequest, Empty> deleteMigrationWorkflowSettings() {
        return this.deleteMigrationWorkflowSettings;
    }

    public UnaryCallSettings<StartMigrationWorkflowRequest, Empty> startMigrationWorkflowSettings() {
        return this.startMigrationWorkflowSettings;
    }

    public UnaryCallSettings<GetMigrationSubtaskRequest, MigrationSubtask> getMigrationSubtaskSettings() {
        return this.getMigrationSubtaskSettings;
    }

    public PagedCallSettings<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationServiceClient.ListMigrationSubtasksPagedResponse> listMigrationSubtasksSettings() {
        return this.listMigrationSubtasksSettings;
    }

    public MigrationServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMigrationServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonMigrationServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "bigquerymigration";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "bigquerymigration.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "bigquerymigration.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MigrationServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MigrationServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MigrationServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return MigrationServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MigrationServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createMigrationWorkflowSettings = settingsBuilder.createMigrationWorkflowSettings().build();
        this.getMigrationWorkflowSettings = settingsBuilder.getMigrationWorkflowSettings().build();
        this.listMigrationWorkflowsSettings = settingsBuilder.listMigrationWorkflowsSettings().build();
        this.deleteMigrationWorkflowSettings = settingsBuilder.deleteMigrationWorkflowSettings().build();
        this.startMigrationWorkflowSettings = settingsBuilder.startMigrationWorkflowSettings().build();
        this.getMigrationSubtaskSettings = settingsBuilder.getMigrationSubtaskSettings().build();
        this.listMigrationSubtasksSettings = settingsBuilder.listMigrationSubtasksSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MigrationServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateMigrationWorkflowRequest, MigrationWorkflow> createMigrationWorkflowSettings;
        private final UnaryCallSettings.Builder<GetMigrationWorkflowRequest, MigrationWorkflow> getMigrationWorkflowSettings;
        private final PagedCallSettings.Builder<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationServiceClient.ListMigrationWorkflowsPagedResponse> listMigrationWorkflowsSettings;
        private final UnaryCallSettings.Builder<DeleteMigrationWorkflowRequest, Empty> deleteMigrationWorkflowSettings;
        private final UnaryCallSettings.Builder<StartMigrationWorkflowRequest, Empty> startMigrationWorkflowSettings;
        private final UnaryCallSettings.Builder<GetMigrationSubtaskRequest, MigrationSubtask> getMigrationSubtaskSettings;
        private final PagedCallSettings.Builder<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationServiceClient.ListMigrationSubtasksPagedResponse> listMigrationSubtasksSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createMigrationWorkflowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getMigrationWorkflowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMigrationWorkflowsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MIGRATION_WORKFLOWS_PAGE_STR_FACT);
            this.deleteMigrationWorkflowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startMigrationWorkflowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getMigrationSubtaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMigrationSubtasksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MIGRATION_SUBTASKS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createMigrationWorkflowSettings, this.getMigrationWorkflowSettings, this.listMigrationWorkflowsSettings, this.deleteMigrationWorkflowSettings, this.startMigrationWorkflowSettings, this.getMigrationSubtaskSettings, this.listMigrationSubtasksSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MigrationServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createMigrationWorkflowSettings = settings.createMigrationWorkflowSettings.toBuilder();
            this.getMigrationWorkflowSettings = settings.getMigrationWorkflowSettings.toBuilder();
            this.listMigrationWorkflowsSettings = settings.listMigrationWorkflowsSettings.toBuilder();
            this.deleteMigrationWorkflowSettings = settings.deleteMigrationWorkflowSettings.toBuilder();
            this.startMigrationWorkflowSettings = settings.startMigrationWorkflowSettings.toBuilder();
            this.getMigrationSubtaskSettings = settings.getMigrationSubtaskSettings.toBuilder();
            this.listMigrationSubtasksSettings = settings.listMigrationSubtasksSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createMigrationWorkflowSettings, this.getMigrationWorkflowSettings, this.listMigrationWorkflowsSettings, this.deleteMigrationWorkflowSettings, this.startMigrationWorkflowSettings, this.getMigrationSubtaskSettings, this.listMigrationSubtasksSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MigrationServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MigrationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MigrationServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MigrationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)MigrationServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)MigrationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MigrationServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MigrationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createMigrationWorkflowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getMigrationWorkflowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listMigrationWorkflowsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteMigrationWorkflowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.startMigrationWorkflowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getMigrationSubtaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listMigrationSubtasksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateMigrationWorkflowRequest, MigrationWorkflow> createMigrationWorkflowSettings() {
            return this.createMigrationWorkflowSettings;
        }

        public UnaryCallSettings.Builder<GetMigrationWorkflowRequest, MigrationWorkflow> getMigrationWorkflowSettings() {
            return this.getMigrationWorkflowSettings;
        }

        public PagedCallSettings.Builder<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationServiceClient.ListMigrationWorkflowsPagedResponse> listMigrationWorkflowsSettings() {
            return this.listMigrationWorkflowsSettings;
        }

        public UnaryCallSettings.Builder<DeleteMigrationWorkflowRequest, Empty> deleteMigrationWorkflowSettings() {
            return this.deleteMigrationWorkflowSettings;
        }

        public UnaryCallSettings.Builder<StartMigrationWorkflowRequest, Empty> startMigrationWorkflowSettings() {
            return this.startMigrationWorkflowSettings;
        }

        public UnaryCallSettings.Builder<GetMigrationSubtaskRequest, MigrationSubtask> getMigrationSubtaskSettings() {
            return this.getMigrationSubtaskSettings;
        }

        public PagedCallSettings.Builder<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationServiceClient.ListMigrationSubtasksPagedResponse> listMigrationSubtasksSettings() {
            return this.listMigrationSubtasksSettings;
        }

        public MigrationServiceStubSettings build() throws IOException {
            return new MigrationServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

