/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.migration.v2alpha;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.migration.v2alpha.CreateMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2alpha.DeleteMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2alpha.GetMigrationSubtaskRequest;
import com.google.cloud.bigquery.migration.v2alpha.GetMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2alpha.ListMigrationSubtasksRequest;
import com.google.cloud.bigquery.migration.v2alpha.ListMigrationSubtasksResponse;
import com.google.cloud.bigquery.migration.v2alpha.ListMigrationWorkflowsRequest;
import com.google.cloud.bigquery.migration.v2alpha.ListMigrationWorkflowsResponse;
import com.google.cloud.bigquery.migration.v2alpha.LocationName;
import com.google.cloud.bigquery.migration.v2alpha.MigrationServiceSettings;
import com.google.cloud.bigquery.migration.v2alpha.MigrationSubtask;
import com.google.cloud.bigquery.migration.v2alpha.MigrationSubtaskName;
import com.google.cloud.bigquery.migration.v2alpha.MigrationWorkflow;
import com.google.cloud.bigquery.migration.v2alpha.MigrationWorkflowName;
import com.google.cloud.bigquery.migration.v2alpha.StartMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2alpha.stub.MigrationServiceStub;
import com.google.cloud.bigquery.migration.v2alpha.stub.MigrationServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class MigrationServiceClient
implements BackgroundResource {
    private final MigrationServiceSettings settings;
    private final MigrationServiceStub stub;

    public static final MigrationServiceClient create() throws IOException {
        return MigrationServiceClient.create(MigrationServiceSettings.newBuilder().build());
    }

    public static final MigrationServiceClient create(MigrationServiceSettings settings) throws IOException {
        return new MigrationServiceClient(settings);
    }

    public static final MigrationServiceClient create(MigrationServiceStub stub) {
        return new MigrationServiceClient(stub);
    }

    protected MigrationServiceClient(MigrationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MigrationServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected MigrationServiceClient(MigrationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MigrationServiceSettings getSettings() {
        return this.settings;
    }

    public MigrationServiceStub getStub() {
        return this.stub;
    }

    public final MigrationWorkflow createMigrationWorkflow(LocationName parent, MigrationWorkflow migrationWorkflow) {
        CreateMigrationWorkflowRequest request = CreateMigrationWorkflowRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMigrationWorkflow(migrationWorkflow).build();
        return this.createMigrationWorkflow(request);
    }

    public final MigrationWorkflow createMigrationWorkflow(String parent, MigrationWorkflow migrationWorkflow) {
        CreateMigrationWorkflowRequest request = CreateMigrationWorkflowRequest.newBuilder().setParent(parent).setMigrationWorkflow(migrationWorkflow).build();
        return this.createMigrationWorkflow(request);
    }

    public final MigrationWorkflow createMigrationWorkflow(CreateMigrationWorkflowRequest request) {
        return (MigrationWorkflow)this.createMigrationWorkflowCallable().call((Object)request);
    }

    public final UnaryCallable<CreateMigrationWorkflowRequest, MigrationWorkflow> createMigrationWorkflowCallable() {
        return this.stub.createMigrationWorkflowCallable();
    }

    public final MigrationWorkflow getMigrationWorkflow(MigrationWorkflowName name) {
        GetMigrationWorkflowRequest request = GetMigrationWorkflowRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMigrationWorkflow(request);
    }

    public final MigrationWorkflow getMigrationWorkflow(String name) {
        GetMigrationWorkflowRequest request = GetMigrationWorkflowRequest.newBuilder().setName(name).build();
        return this.getMigrationWorkflow(request);
    }

    public final MigrationWorkflow getMigrationWorkflow(GetMigrationWorkflowRequest request) {
        return (MigrationWorkflow)this.getMigrationWorkflowCallable().call((Object)request);
    }

    public final UnaryCallable<GetMigrationWorkflowRequest, MigrationWorkflow> getMigrationWorkflowCallable() {
        return this.stub.getMigrationWorkflowCallable();
    }

    public final ListMigrationWorkflowsPagedResponse listMigrationWorkflows(LocationName parent) {
        ListMigrationWorkflowsRequest request = ListMigrationWorkflowsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMigrationWorkflows(request);
    }

    public final ListMigrationWorkflowsPagedResponse listMigrationWorkflows(String parent) {
        ListMigrationWorkflowsRequest request = ListMigrationWorkflowsRequest.newBuilder().setParent(parent).build();
        return this.listMigrationWorkflows(request);
    }

    public final ListMigrationWorkflowsPagedResponse listMigrationWorkflows(ListMigrationWorkflowsRequest request) {
        return (ListMigrationWorkflowsPagedResponse)((Object)this.listMigrationWorkflowsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMigrationWorkflowsRequest, ListMigrationWorkflowsPagedResponse> listMigrationWorkflowsPagedCallable() {
        return this.stub.listMigrationWorkflowsPagedCallable();
    }

    public final UnaryCallable<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse> listMigrationWorkflowsCallable() {
        return this.stub.listMigrationWorkflowsCallable();
    }

    public final void deleteMigrationWorkflow(MigrationWorkflowName name) {
        DeleteMigrationWorkflowRequest request = DeleteMigrationWorkflowRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteMigrationWorkflow(request);
    }

    public final void deleteMigrationWorkflow(String name) {
        DeleteMigrationWorkflowRequest request = DeleteMigrationWorkflowRequest.newBuilder().setName(name).build();
        this.deleteMigrationWorkflow(request);
    }

    public final void deleteMigrationWorkflow(DeleteMigrationWorkflowRequest request) {
        this.deleteMigrationWorkflowCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteMigrationWorkflowRequest, Empty> deleteMigrationWorkflowCallable() {
        return this.stub.deleteMigrationWorkflowCallable();
    }

    public final void startMigrationWorkflow(MigrationWorkflowName name) {
        StartMigrationWorkflowRequest request = StartMigrationWorkflowRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.startMigrationWorkflow(request);
    }

    public final void startMigrationWorkflow(String name) {
        StartMigrationWorkflowRequest request = StartMigrationWorkflowRequest.newBuilder().setName(name).build();
        this.startMigrationWorkflow(request);
    }

    public final void startMigrationWorkflow(StartMigrationWorkflowRequest request) {
        this.startMigrationWorkflowCallable().call((Object)request);
    }

    public final UnaryCallable<StartMigrationWorkflowRequest, Empty> startMigrationWorkflowCallable() {
        return this.stub.startMigrationWorkflowCallable();
    }

    public final MigrationSubtask getMigrationSubtask(MigrationSubtaskName name) {
        GetMigrationSubtaskRequest request = GetMigrationSubtaskRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMigrationSubtask(request);
    }

    public final MigrationSubtask getMigrationSubtask(String name) {
        GetMigrationSubtaskRequest request = GetMigrationSubtaskRequest.newBuilder().setName(name).build();
        return this.getMigrationSubtask(request);
    }

    public final MigrationSubtask getMigrationSubtask(GetMigrationSubtaskRequest request) {
        return (MigrationSubtask)this.getMigrationSubtaskCallable().call((Object)request);
    }

    public final UnaryCallable<GetMigrationSubtaskRequest, MigrationSubtask> getMigrationSubtaskCallable() {
        return this.stub.getMigrationSubtaskCallable();
    }

    public final ListMigrationSubtasksPagedResponse listMigrationSubtasks(MigrationWorkflowName parent) {
        ListMigrationSubtasksRequest request = ListMigrationSubtasksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMigrationSubtasks(request);
    }

    public final ListMigrationSubtasksPagedResponse listMigrationSubtasks(String parent) {
        ListMigrationSubtasksRequest request = ListMigrationSubtasksRequest.newBuilder().setParent(parent).build();
        return this.listMigrationSubtasks(request);
    }

    public final ListMigrationSubtasksPagedResponse listMigrationSubtasks(ListMigrationSubtasksRequest request) {
        return (ListMigrationSubtasksPagedResponse)((Object)this.listMigrationSubtasksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMigrationSubtasksRequest, ListMigrationSubtasksPagedResponse> listMigrationSubtasksPagedCallable() {
        return this.stub.listMigrationSubtasksPagedCallable();
    }

    public final UnaryCallable<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse> listMigrationSubtasksCallable() {
        return this.stub.listMigrationSubtasksCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListMigrationSubtasksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationSubtask, ListMigrationSubtasksPage, ListMigrationSubtasksFixedSizeCollection> {
        private ListMigrationSubtasksFixedSizeCollection(List<ListMigrationSubtasksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMigrationSubtasksFixedSizeCollection createEmptyCollection() {
            return new ListMigrationSubtasksFixedSizeCollection(null, 0);
        }

        protected ListMigrationSubtasksFixedSizeCollection createCollection(List<ListMigrationSubtasksPage> pages, int collectionSize) {
            return new ListMigrationSubtasksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMigrationSubtasksPage
    extends AbstractPage<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationSubtask, ListMigrationSubtasksPage> {
        private ListMigrationSubtasksPage(PageContext<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationSubtask> context, ListMigrationSubtasksResponse response) {
            super(context, (Object)response);
        }

        private static ListMigrationSubtasksPage createEmptyPage() {
            return new ListMigrationSubtasksPage(null, null);
        }

        protected ListMigrationSubtasksPage createPage(PageContext<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationSubtask> context, ListMigrationSubtasksResponse response) {
            return new ListMigrationSubtasksPage(context, response);
        }

        public ApiFuture<ListMigrationSubtasksPage> createPageAsync(PageContext<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationSubtask> context, ApiFuture<ListMigrationSubtasksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMigrationSubtasksPagedResponse
    extends AbstractPagedListResponse<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationSubtask, ListMigrationSubtasksPage, ListMigrationSubtasksFixedSizeCollection> {
        public static ApiFuture<ListMigrationSubtasksPagedResponse> createAsync(PageContext<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse, MigrationSubtask> context, ApiFuture<ListMigrationSubtasksResponse> futureResponse) {
            ApiFuture<ListMigrationSubtasksPage> futurePage = ListMigrationSubtasksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMigrationSubtasksPagedResponse((ListMigrationSubtasksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMigrationSubtasksPagedResponse(ListMigrationSubtasksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMigrationSubtasksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMigrationWorkflowsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationWorkflow, ListMigrationWorkflowsPage, ListMigrationWorkflowsFixedSizeCollection> {
        private ListMigrationWorkflowsFixedSizeCollection(List<ListMigrationWorkflowsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMigrationWorkflowsFixedSizeCollection createEmptyCollection() {
            return new ListMigrationWorkflowsFixedSizeCollection(null, 0);
        }

        protected ListMigrationWorkflowsFixedSizeCollection createCollection(List<ListMigrationWorkflowsPage> pages, int collectionSize) {
            return new ListMigrationWorkflowsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMigrationWorkflowsPage
    extends AbstractPage<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationWorkflow, ListMigrationWorkflowsPage> {
        private ListMigrationWorkflowsPage(PageContext<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationWorkflow> context, ListMigrationWorkflowsResponse response) {
            super(context, (Object)response);
        }

        private static ListMigrationWorkflowsPage createEmptyPage() {
            return new ListMigrationWorkflowsPage(null, null);
        }

        protected ListMigrationWorkflowsPage createPage(PageContext<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationWorkflow> context, ListMigrationWorkflowsResponse response) {
            return new ListMigrationWorkflowsPage(context, response);
        }

        public ApiFuture<ListMigrationWorkflowsPage> createPageAsync(PageContext<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationWorkflow> context, ApiFuture<ListMigrationWorkflowsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMigrationWorkflowsPagedResponse
    extends AbstractPagedListResponse<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationWorkflow, ListMigrationWorkflowsPage, ListMigrationWorkflowsFixedSizeCollection> {
        public static ApiFuture<ListMigrationWorkflowsPagedResponse> createAsync(PageContext<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse, MigrationWorkflow> context, ApiFuture<ListMigrationWorkflowsResponse> futureResponse) {
            ApiFuture<ListMigrationWorkflowsPage> futurePage = ListMigrationWorkflowsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMigrationWorkflowsPagedResponse((ListMigrationWorkflowsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMigrationWorkflowsPagedResponse(ListMigrationWorkflowsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMigrationWorkflowsFixedSizeCollection.createEmptyCollection());
        }
    }
}

