/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.migration.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.migration.v2.CreateMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2.DeleteMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2.GetMigrationSubtaskRequest;
import com.google.cloud.bigquery.migration.v2.GetMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2.ListMigrationSubtasksRequest;
import com.google.cloud.bigquery.migration.v2.ListMigrationSubtasksResponse;
import com.google.cloud.bigquery.migration.v2.ListMigrationWorkflowsRequest;
import com.google.cloud.bigquery.migration.v2.ListMigrationWorkflowsResponse;
import com.google.cloud.bigquery.migration.v2.MigrationServiceClient;
import com.google.cloud.bigquery.migration.v2.MigrationSubtask;
import com.google.cloud.bigquery.migration.v2.MigrationWorkflow;
import com.google.cloud.bigquery.migration.v2.StartMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2.stub.HttpJsonMigrationServiceCallableFactory;
import com.google.cloud.bigquery.migration.v2.stub.MigrationServiceStub;
import com.google.cloud.bigquery.migration.v2.stub.MigrationServiceStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonMigrationServiceStub
extends MigrationServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateMigrationWorkflowRequest, MigrationWorkflow> createMigrationWorkflowMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.migration.v2.MigrationService/CreateMigrationWorkflow").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/workflows", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("migrationWorkflow", (Message)request.getMigrationWorkflow(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)MigrationWorkflow.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetMigrationWorkflowRequest, MigrationWorkflow> getMigrationWorkflowMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.migration.v2.MigrationService/GetMigrationWorkflow").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/workflows/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "readMask", (Object)request.getReadMask());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)MigrationWorkflow.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse> listMigrationWorkflowsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.migration.v2.MigrationService/ListMigrationWorkflows").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/workflows", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "readMask", (Object)request.getReadMask());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListMigrationWorkflowsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteMigrationWorkflowRequest, Empty> deleteMigrationWorkflowMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.migration.v2.MigrationService/DeleteMigrationWorkflow").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/workflows/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<StartMigrationWorkflowRequest, Empty> startMigrationWorkflowMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.migration.v2.MigrationService/StartMigrationWorkflow").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/workflows/*}:start", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetMigrationSubtaskRequest, MigrationSubtask> getMigrationSubtaskMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.migration.v2.MigrationService/GetMigrationSubtask").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/workflows/*/subtasks/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "readMask", (Object)request.getReadMask());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)MigrationSubtask.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse> listMigrationSubtasksMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.migration.v2.MigrationService/ListMigrationSubtasks").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*/workflows/*}/subtasks", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "readMask", (Object)request.getReadMask());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListMigrationSubtasksResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateMigrationWorkflowRequest, MigrationWorkflow> createMigrationWorkflowCallable;
    private final UnaryCallable<GetMigrationWorkflowRequest, MigrationWorkflow> getMigrationWorkflowCallable;
    private final UnaryCallable<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse> listMigrationWorkflowsCallable;
    private final UnaryCallable<ListMigrationWorkflowsRequest, MigrationServiceClient.ListMigrationWorkflowsPagedResponse> listMigrationWorkflowsPagedCallable;
    private final UnaryCallable<DeleteMigrationWorkflowRequest, Empty> deleteMigrationWorkflowCallable;
    private final UnaryCallable<StartMigrationWorkflowRequest, Empty> startMigrationWorkflowCallable;
    private final UnaryCallable<GetMigrationSubtaskRequest, MigrationSubtask> getMigrationSubtaskCallable;
    private final UnaryCallable<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse> listMigrationSubtasksCallable;
    private final UnaryCallable<ListMigrationSubtasksRequest, MigrationServiceClient.ListMigrationSubtasksPagedResponse> listMigrationSubtasksPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonMigrationServiceStub create(MigrationServiceStubSettings settings) throws IOException {
        return new HttpJsonMigrationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonMigrationServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonMigrationServiceStub(MigrationServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonMigrationServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonMigrationServiceStub(MigrationServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonMigrationServiceStub(MigrationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonMigrationServiceCallableFactory());
    }

    protected HttpJsonMigrationServiceStub(MigrationServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createMigrationWorkflowTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createMigrationWorkflowMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getMigrationWorkflowTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMigrationWorkflowMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listMigrationWorkflowsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMigrationWorkflowsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteMigrationWorkflowTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMigrationWorkflowMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings startMigrationWorkflowTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(startMigrationWorkflowMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getMigrationSubtaskTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMigrationSubtaskMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listMigrationSubtasksTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMigrationSubtasksMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.createMigrationWorkflowCallable = callableFactory.createUnaryCallable(createMigrationWorkflowTransportSettings, settings.createMigrationWorkflowSettings(), clientContext);
        this.getMigrationWorkflowCallable = callableFactory.createUnaryCallable(getMigrationWorkflowTransportSettings, settings.getMigrationWorkflowSettings(), clientContext);
        this.listMigrationWorkflowsCallable = callableFactory.createUnaryCallable(listMigrationWorkflowsTransportSettings, settings.listMigrationWorkflowsSettings(), clientContext);
        this.listMigrationWorkflowsPagedCallable = callableFactory.createPagedCallable(listMigrationWorkflowsTransportSettings, settings.listMigrationWorkflowsSettings(), clientContext);
        this.deleteMigrationWorkflowCallable = callableFactory.createUnaryCallable(deleteMigrationWorkflowTransportSettings, settings.deleteMigrationWorkflowSettings(), clientContext);
        this.startMigrationWorkflowCallable = callableFactory.createUnaryCallable(startMigrationWorkflowTransportSettings, settings.startMigrationWorkflowSettings(), clientContext);
        this.getMigrationSubtaskCallable = callableFactory.createUnaryCallable(getMigrationSubtaskTransportSettings, settings.getMigrationSubtaskSettings(), clientContext);
        this.listMigrationSubtasksCallable = callableFactory.createUnaryCallable(listMigrationSubtasksTransportSettings, settings.listMigrationSubtasksSettings(), clientContext);
        this.listMigrationSubtasksPagedCallable = callableFactory.createPagedCallable(listMigrationSubtasksTransportSettings, settings.listMigrationSubtasksSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createMigrationWorkflowMethodDescriptor);
        methodDescriptors.add(getMigrationWorkflowMethodDescriptor);
        methodDescriptors.add(listMigrationWorkflowsMethodDescriptor);
        methodDescriptors.add(deleteMigrationWorkflowMethodDescriptor);
        methodDescriptors.add(startMigrationWorkflowMethodDescriptor);
        methodDescriptors.add(getMigrationSubtaskMethodDescriptor);
        methodDescriptors.add(listMigrationSubtasksMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateMigrationWorkflowRequest, MigrationWorkflow> createMigrationWorkflowCallable() {
        return this.createMigrationWorkflowCallable;
    }

    @Override
    public UnaryCallable<GetMigrationWorkflowRequest, MigrationWorkflow> getMigrationWorkflowCallable() {
        return this.getMigrationWorkflowCallable;
    }

    @Override
    public UnaryCallable<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse> listMigrationWorkflowsCallable() {
        return this.listMigrationWorkflowsCallable;
    }

    @Override
    public UnaryCallable<ListMigrationWorkflowsRequest, MigrationServiceClient.ListMigrationWorkflowsPagedResponse> listMigrationWorkflowsPagedCallable() {
        return this.listMigrationWorkflowsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteMigrationWorkflowRequest, Empty> deleteMigrationWorkflowCallable() {
        return this.deleteMigrationWorkflowCallable;
    }

    @Override
    public UnaryCallable<StartMigrationWorkflowRequest, Empty> startMigrationWorkflowCallable() {
        return this.startMigrationWorkflowCallable;
    }

    @Override
    public UnaryCallable<GetMigrationSubtaskRequest, MigrationSubtask> getMigrationSubtaskCallable() {
        return this.getMigrationSubtaskCallable;
    }

    @Override
    public UnaryCallable<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse> listMigrationSubtasksCallable() {
        return this.listMigrationSubtasksCallable;
    }

    @Override
    public UnaryCallable<ListMigrationSubtasksRequest, MigrationServiceClient.ListMigrationSubtasksPagedResponse> listMigrationSubtasksPagedCallable() {
        return this.listMigrationSubtasksPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

