package com.google.cloud.bigquery;

import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ForeignKey extends ForeignKey {

  private final String name;

  private final TableId referencedTable;

  private final List<ColumnReference> columnReferences;

  private AutoValue_ForeignKey(
      @Nullable String name,
      @Nullable TableId referencedTable,
      @Nullable List<ColumnReference> columnReferences) {
    this.name = name;
    this.referencedTable = referencedTable;
    this.columnReferences = columnReferences;
  }

  @Nullable
  @Override
  public String getName() {
    return name;
  }

  @Nullable
  @Override
  public TableId getReferencedTable() {
    return referencedTable;
  }

  @Nullable
  @Override
  public List<ColumnReference> getColumnReferences() {
    return columnReferences;
  }

  @Override
  public String toString() {
    return "ForeignKey{"
        + "name=" + name + ", "
        + "referencedTable=" + referencedTable + ", "
        + "columnReferences=" + columnReferences
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ForeignKey) {
      ForeignKey that = (ForeignKey) o;
      return (this.name == null ? that.getName() == null : this.name.equals(that.getName()))
          && (this.referencedTable == null ? that.getReferencedTable() == null : this.referencedTable.equals(that.getReferencedTable()))
          && (this.columnReferences == null ? that.getColumnReferences() == null : this.columnReferences.equals(that.getColumnReferences()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (name == null) ? 0 : name.hashCode();
    h$ *= 1000003;
    h$ ^= (referencedTable == null) ? 0 : referencedTable.hashCode();
    h$ *= 1000003;
    h$ ^= (columnReferences == null) ? 0 : columnReferences.hashCode();
    return h$;
  }

  @Override
  public ForeignKey.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ForeignKey.Builder {
    private String name;
    private TableId referencedTable;
    private List<ColumnReference> columnReferences;
    Builder() {
    }
    private Builder(ForeignKey source) {
      this.name = source.getName();
      this.referencedTable = source.getReferencedTable();
      this.columnReferences = source.getColumnReferences();
    }
    @Override
    public ForeignKey.Builder setName(String name) {
      this.name = name;
      return this;
    }
    @Override
    public ForeignKey.Builder setReferencedTable(TableId referencedTable) {
      this.referencedTable = referencedTable;
      return this;
    }
    @Override
    public ForeignKey.Builder setColumnReferences(List<ColumnReference> columnReferences) {
      this.columnReferences = columnReferences;
      return this;
    }
    @Override
    public ForeignKey build() {
      return new AutoValue_ForeignKey(
          this.name,
          this.referencedTable,
          this.columnReferences);
    }
  }

}
