package com.google.cloud.bigquery;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_MaterializedViewDefinition extends MaterializedViewDefinition {

  private final TableDefinition.Type type;

  private final Schema schema;

  private final Long lastRefreshTime;

  private final String query;

  private final Boolean enableRefresh;

  private final Long refreshIntervalMs;

  private final TimePartitioning timePartitioning;

  private final RangePartitioning rangePartitioning;

  private final Clustering clustering;

  private AutoValue_MaterializedViewDefinition(
      TableDefinition.Type type,
      @Nullable Schema schema,
      @Nullable Long lastRefreshTime,
      @Nullable String query,
      @Nullable Boolean enableRefresh,
      @Nullable Long refreshIntervalMs,
      @Nullable TimePartitioning timePartitioning,
      @Nullable RangePartitioning rangePartitioning,
      @Nullable Clustering clustering) {
    this.type = type;
    this.schema = schema;
    this.lastRefreshTime = lastRefreshTime;
    this.query = query;
    this.enableRefresh = enableRefresh;
    this.refreshIntervalMs = refreshIntervalMs;
    this.timePartitioning = timePartitioning;
    this.rangePartitioning = rangePartitioning;
    this.clustering = clustering;
  }

  @Override
  public TableDefinition.Type getType() {
    return type;
  }

  @Nullable
  @Override
  public Schema getSchema() {
    return schema;
  }

  @Nullable
  @Override
  public Long getLastRefreshTime() {
    return lastRefreshTime;
  }

  @Nullable
  @Override
  public String getQuery() {
    return query;
  }

  @Nullable
  @Override
  public Boolean getEnableRefresh() {
    return enableRefresh;
  }

  @Nullable
  @Override
  public Long getRefreshIntervalMs() {
    return refreshIntervalMs;
  }

  @Nullable
  @Override
  public TimePartitioning getTimePartitioning() {
    return timePartitioning;
  }

  @Nullable
  @Override
  public RangePartitioning getRangePartitioning() {
    return rangePartitioning;
  }

  @Nullable
  @Override
  public Clustering getClustering() {
    return clustering;
  }

  @Override
  public String toString() {
    return "MaterializedViewDefinition{"
        + "type=" + type + ", "
        + "schema=" + schema + ", "
        + "lastRefreshTime=" + lastRefreshTime + ", "
        + "query=" + query + ", "
        + "enableRefresh=" + enableRefresh + ", "
        + "refreshIntervalMs=" + refreshIntervalMs + ", "
        + "timePartitioning=" + timePartitioning + ", "
        + "rangePartitioning=" + rangePartitioning + ", "
        + "clustering=" + clustering
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MaterializedViewDefinition) {
      MaterializedViewDefinition that = (MaterializedViewDefinition) o;
      return this.type.equals(that.getType())
          && (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema()))
          && (this.lastRefreshTime == null ? that.getLastRefreshTime() == null : this.lastRefreshTime.equals(that.getLastRefreshTime()))
          && (this.query == null ? that.getQuery() == null : this.query.equals(that.getQuery()))
          && (this.enableRefresh == null ? that.getEnableRefresh() == null : this.enableRefresh.equals(that.getEnableRefresh()))
          && (this.refreshIntervalMs == null ? that.getRefreshIntervalMs() == null : this.refreshIntervalMs.equals(that.getRefreshIntervalMs()))
          && (this.timePartitioning == null ? that.getTimePartitioning() == null : this.timePartitioning.equals(that.getTimePartitioning()))
          && (this.rangePartitioning == null ? that.getRangePartitioning() == null : this.rangePartitioning.equals(that.getRangePartitioning()))
          && (this.clustering == null ? that.getClustering() == null : this.clustering.equals(that.getClustering()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (schema == null) ? 0 : schema.hashCode();
    h$ *= 1000003;
    h$ ^= (lastRefreshTime == null) ? 0 : lastRefreshTime.hashCode();
    h$ *= 1000003;
    h$ ^= (query == null) ? 0 : query.hashCode();
    h$ *= 1000003;
    h$ ^= (enableRefresh == null) ? 0 : enableRefresh.hashCode();
    h$ *= 1000003;
    h$ ^= (refreshIntervalMs == null) ? 0 : refreshIntervalMs.hashCode();
    h$ *= 1000003;
    h$ ^= (timePartitioning == null) ? 0 : timePartitioning.hashCode();
    h$ *= 1000003;
    h$ ^= (rangePartitioning == null) ? 0 : rangePartitioning.hashCode();
    h$ *= 1000003;
    h$ ^= (clustering == null) ? 0 : clustering.hashCode();
    return h$;
  }

  private static final long serialVersionUID = 5898696389126164276L;

  @Override
  public MaterializedViewDefinition.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends MaterializedViewDefinition.Builder {
    private TableDefinition.Type type;
    private Schema schema;
    private Long lastRefreshTime;
    private String query;
    private Boolean enableRefresh;
    private Long refreshIntervalMs;
    private TimePartitioning timePartitioning;
    private RangePartitioning rangePartitioning;
    private Clustering clustering;
    Builder() {
    }
    private Builder(MaterializedViewDefinition source) {
      this.type = source.getType();
      this.schema = source.getSchema();
      this.lastRefreshTime = source.getLastRefreshTime();
      this.query = source.getQuery();
      this.enableRefresh = source.getEnableRefresh();
      this.refreshIntervalMs = source.getRefreshIntervalMs();
      this.timePartitioning = source.getTimePartitioning();
      this.rangePartitioning = source.getRangePartitioning();
      this.clustering = source.getClustering();
    }
    @Override
    public MaterializedViewDefinition.Builder setType(TableDefinition.Type type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public MaterializedViewDefinition.Builder setSchema(Schema schema) {
      this.schema = schema;
      return this;
    }
    @Override
    MaterializedViewDefinition.Builder setLastRefreshTime(Long lastRefreshTime) {
      this.lastRefreshTime = lastRefreshTime;
      return this;
    }
    @Override
    public MaterializedViewDefinition.Builder setQuery(String query) {
      this.query = query;
      return this;
    }
    @Override
    public MaterializedViewDefinition.Builder setEnableRefresh(Boolean enableRefresh) {
      this.enableRefresh = enableRefresh;
      return this;
    }
    @Override
    public MaterializedViewDefinition.Builder setRefreshIntervalMs(Long refreshIntervalMs) {
      this.refreshIntervalMs = refreshIntervalMs;
      return this;
    }
    @Override
    public MaterializedViewDefinition.Builder setTimePartitioning(TimePartitioning timePartitioning) {
      this.timePartitioning = timePartitioning;
      return this;
    }
    @Override
    public MaterializedViewDefinition.Builder setRangePartitioning(RangePartitioning rangePartitioning) {
      this.rangePartitioning = rangePartitioning;
      return this;
    }
    @Override
    public MaterializedViewDefinition.Builder setClustering(Clustering clustering) {
      this.clustering = clustering;
      return this;
    }
    @Override
    public MaterializedViewDefinition build() {
      if (this.type == null) {
        String missing = " type";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MaterializedViewDefinition(
          this.type,
          this.schema,
          this.lastRefreshTime,
          this.query,
          this.enableRefresh,
          this.refreshIntervalMs,
          this.timePartitioning,
          this.rangePartitioning,
          this.clustering);
    }
  }

}
