/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.ApiClock;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.QueryParameter;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableRow;
import com.google.cloud.RetryHelper;
import com.google.cloud.Tuple;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryBaseService;
import com.google.cloud.bigquery.BigQueryDryRunResult;
import com.google.cloud.bigquery.BigQueryDryRunResultImpl;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.BigQueryResult;
import com.google.cloud.bigquery.BigQueryResultImpl;
import com.google.cloud.bigquery.BigQueryResultStats;
import com.google.cloud.bigquery.BigQueryResultStatsImpl;
import com.google.cloud.bigquery.BigQueryRetryConfig;
import com.google.cloud.bigquery.BigQueryRetryHelper;
import com.google.cloud.bigquery.BigQuerySQLException;
import com.google.cloud.bigquery.Connection;
import com.google.cloud.bigquery.ConnectionProperty;
import com.google.cloud.bigquery.ConnectionSettings;
import com.google.cloud.bigquery.DmlStats;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.Parameter;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.cloud.bigquery.spi.v2.BigQueryRpc;
import com.google.cloud.bigquery.storage.v1.ArrowRecordBatch;
import com.google.cloud.bigquery.storage.v1.ArrowSchema;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;

class ConnectionImpl
implements Connection {
    private final ConnectionSettings connectionSettings;
    private final BigQueryOptions bigQueryOptions;
    private final BigQueryRpc bigQueryRpc;
    private final BigQueryRetryConfig retryConfig;
    private final int bufferSize;
    private final int MAX_PROCESS_QUERY_THREADS_CNT = 5;
    private final ExecutorService queryTaskExecutor = Executors.newFixedThreadPool(5);
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private BigQueryReadClient bqReadClient;
    private static final long EXECUTOR_TIMEOUT_SEC = 10L;
    private BlockingQueue<AbstractList<FieldValue>> bufferFvl;
    private BlockingQueue<BigQueryResultImpl.Row> bufferRow;
    private static final Function<Parameter, QueryParameter> POSITIONAL_PARAMETER_TO_PB_FUNCTION = value -> {
        QueryParameter queryParameterPb = new QueryParameter();
        queryParameterPb.setParameterValue(value.getValue().toValuePb());
        queryParameterPb.setParameterType(value.getValue().toTypePb());
        return queryParameterPb;
    };
    private static final Function<Parameter, QueryParameter> NAMED_PARAMETER_TO_PB_FUNCTION = value -> {
        QueryParameter queryParameterPb = new QueryParameter();
        queryParameterPb.setName(value.getName());
        queryParameterPb.setParameterValue(value.getValue().toValuePb());
        queryParameterPb.setParameterType(value.getValue().toTypePb());
        return queryParameterPb;
    };
    private static final Function<QueryParameter, Parameter> QUERY_PARAMETER_FROM_PB_FUNCTION = pb -> Parameter.newBuilder().setName(pb.getName() == null ? "" : pb.getName()).setValue(QueryParameterValue.fromPb(pb.getParameterValue(), pb.getParameterType())).build();

    ConnectionImpl(ConnectionSettings connectionSettings, BigQueryOptions bigQueryOptions, BigQueryRpc bigQueryRpc, BigQueryRetryConfig retryConfig) {
        this.connectionSettings = connectionSettings;
        this.bigQueryOptions = bigQueryOptions;
        this.bigQueryRpc = bigQueryRpc;
        this.retryConfig = retryConfig;
        this.bufferSize = connectionSettings == null || connectionSettings.getNumBufferedRows() == null || connectionSettings.getNumBufferedRows() < 10000 ? 20000 : Math.min(connectionSettings.getNumBufferedRows() * 2, 100000);
    }

    private int getBufferSize() {
        return this.connectionSettings == null || this.connectionSettings.getNumBufferedRows() == null || this.connectionSettings.getNumBufferedRows() < 10000 ? 20000 : Math.min(this.connectionSettings.getNumBufferedRows() * 2, 100000);
    }

    @Override
    @BetaApi
    public synchronized boolean close() throws BigQuerySQLException {
        this.flagEndOfStream();
        this.queryTaskExecutor.shutdownNow();
        try {
            if (this.queryTaskExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                return true;
            }
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Exception while awaitTermination", e);
        }
        return this.queryTaskExecutor.isShutdown();
    }

    @Override
    @BetaApi
    public BigQueryDryRunResult dryRun(String sql) throws BigQuerySQLException {
        com.google.api.services.bigquery.model.Job dryRunJob = this.createDryRunJob(sql);
        Schema schema = Schema.fromPb(dryRunJob.getStatistics().getQuery().getSchema());
        List queryParametersPb = dryRunJob.getStatistics().getQuery().getUndeclaredQueryParameters();
        List queryParameters = Lists.transform((List)queryParametersPb, QUERY_PARAMETER_FROM_PB_FUNCTION);
        JobStatistics.QueryStatistics queryStatistics = (JobStatistics.QueryStatistics)JobStatistics.fromPb(dryRunJob);
        JobStatistics.SessionInfo sessionInfo = queryStatistics.getSessionInfo() == null ? null : queryStatistics.getSessionInfo();
        BigQueryResultStatsImpl bigQueryResultStats = new BigQueryResultStatsImpl(queryStatistics, sessionInfo);
        return new BigQueryDryRunResultImpl(schema, queryParameters, bigQueryResultStats);
    }

    @Override
    @BetaApi
    public BigQueryResult executeSelect(String sql) throws BigQuerySQLException {
        try {
            if (this.isFastQuerySupported()) {
                String projectId = this.bigQueryOptions.getProjectId();
                QueryRequest queryRequest = this.createQueryRequest(this.connectionSettings, sql, null, null);
                return this.queryRpc(projectId, queryRequest, false);
            }
            com.google.api.services.bigquery.model.Job queryJob = this.createQueryJob(sql, this.connectionSettings, null, null);
            JobId jobId = JobId.fromPb(queryJob.getJobReference());
            GetQueryResultsResponse firstPage = this.getQueryResultsFirstPage(jobId);
            return this.getResultSet(firstPage, jobId, sql, false);
        }
        catch (BigQueryException e) {
            throw new BigQuerySQLException(e.getMessage(), (Throwable)((Object)e), e.getErrors());
        }
    }

    @Override
    @BetaApi
    public BigQueryResult executeSelect(String sql, List<Parameter> parameters, Map<String, String> ... labels) throws BigQuerySQLException {
        Map<String, String> labelMap = null;
        if (labels != null && labels.length == 1) {
            labelMap = labels[0];
        }
        try {
            if (this.isFastQuerySupported()) {
                String projectId = this.bigQueryOptions.getProjectId();
                QueryRequest queryRequest = this.createQueryRequest(this.connectionSettings, sql, parameters, labelMap);
                return this.queryRpc(projectId, queryRequest, parameters != null);
            }
            com.google.api.services.bigquery.model.Job queryJob = this.createQueryJob(sql, this.connectionSettings, parameters, labelMap);
            JobId jobId = JobId.fromPb(queryJob.getJobReference());
            GetQueryResultsResponse firstPage = this.getQueryResultsFirstPage(jobId);
            return this.getResultSet(firstPage, jobId, sql, parameters != null);
        }
        catch (BigQueryException e) {
            throw new BigQuerySQLException(e.getMessage(), (Throwable)((Object)e), e.getErrors());
        }
    }

    @VisibleForTesting
    BigQueryResult getResultSet(GetQueryResultsResponse firstPage, JobId jobId, String sql, Boolean hasQueryParameters) {
        if (firstPage.getJobComplete().booleanValue() && firstPage.getTotalRows() != null && firstPage.getSchema() != null) {
            return this.getSubsequentQueryResultsWithJob(firstPage.getTotalRows().longValue(), Long.valueOf(firstPage.getRows().size()), jobId, firstPage, hasQueryParameters);
        }
        com.google.api.services.bigquery.model.Job dryRunJob = this.createDryRunJob(sql);
        Schema schema = Schema.fromPb(dryRunJob.getStatistics().getQuery().getSchema());
        return this.getSubsequentQueryResultsWithJob(null, null, jobId, firstPage, schema, hasQueryParameters);
    }

    private BigQueryResult queryRpc(String projectId, QueryRequest queryRequest, Boolean hasQueryParameters) {
        QueryResponse results;
        try {
            results = BigQueryRetryHelper.runWithRetries(() -> this.bigQueryRpc.queryRpc(projectId, queryRequest), this.bigQueryOptions.getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, this.bigQueryOptions.getClock(), this.retryConfig);
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
        if (results.getErrors() != null) {
            List<BigQueryError> bigQueryErrors = results.getErrors().stream().map(BigQueryError.FROM_PB_FUNCTION).collect(Collectors.toList());
            throw new BigQueryException(bigQueryErrors);
        }
        if (results.getJobComplete().booleanValue() && results.getSchema() != null) {
            return this.processQueryResponseResults(results);
        }
        Long totalRows = results.getTotalRows() == null ? null : Long.valueOf(results.getTotalRows().longValue());
        Long pageRows = results.getRows() == null ? null : Long.valueOf(results.getRows().size());
        JobId jobId = JobId.fromPb(results.getJobReference());
        GetQueryResultsResponse firstPage = this.getQueryResultsFirstPage(jobId);
        return this.getSubsequentQueryResultsWithJob(totalRows, pageRows, jobId, firstPage, hasQueryParameters);
    }

    @VisibleForTesting
    BigQueryResultStats getBigQueryResultSetStats(JobId jobId) {
        Job queryJob = this.getQueryJobRpc(jobId);
        JobStatistics.QueryStatistics queryStatistics = (JobStatistics.QueryStatistics)queryJob.getStatistics();
        JobStatistics.SessionInfo sessionInfo = queryStatistics.getSessionInfo() == null ? null : queryStatistics.getSessionInfo();
        return new BigQueryResultStatsImpl(queryStatistics, sessionInfo);
    }

    @VisibleForTesting
    BigQueryResult tableDataList(GetQueryResultsResponse firstPage, JobId jobId) {
        Schema schema = Schema.fromPb(firstPage.getSchema());
        long numRows = firstPage.getTotalRows().longValue();
        BigQueryResultStats bigQueryResultStats = this.getBigQueryResultSetStats(jobId);
        this.bufferFvl = new LinkedBlockingDeque<AbstractList<FieldValue>>(this.getBufferSize());
        LinkedBlockingDeque<Tuple<Iterable<FieldValueList>, Boolean>> pageCache = new LinkedBlockingDeque<Tuple<Iterable<FieldValueList>, Boolean>>(this.getPageCacheSize(this.connectionSettings.getNumBufferedRows(), schema));
        LinkedBlockingDeque<Tuple<TableDataList, Boolean>> rpcResponseQueue = new LinkedBlockingDeque<Tuple<TableDataList, Boolean>>(this.getPageCacheSize(this.connectionSettings.getNumBufferedRows(), schema));
        this.runNextPageTaskAsync(firstPage.getPageToken(), this.getDestinationTable(jobId), rpcResponseQueue);
        this.parseRpcDataAsync(firstPage.getRows(), schema, pageCache, rpcResponseQueue);
        this.populateBufferAsync(rpcResponseQueue, pageCache, this.bufferFvl);
        return new BigQueryResultImpl<AbstractList<FieldValue>>(schema, numRows, this.bufferFvl, bigQueryResultStats);
    }

    @VisibleForTesting
    BigQueryResult processQueryResponseResults(QueryResponse results) {
        Schema schema = Schema.fromPb(results.getSchema());
        long numRows = results.getTotalRows() == null ? 0L : results.getTotalRows().longValue();
        DmlStats dmlStats = results.getDmlStats() == null ? null : DmlStats.fromPb(results.getDmlStats());
        Boolean cacheHit = results.getCacheHit();
        JobStatistics.QueryStatistics queryStatistics = JobStatistics.QueryStatistics.newBuilder().setDmlStats(dmlStats).setCacheHit(cacheHit).build();
        JobStatistics.SessionInfo sessionInfo = results.getSessionInfo() == null ? null : JobStatistics.SessionInfo.fromPb(results.getSessionInfo());
        BigQueryResultStatsImpl bigQueryResultStats = new BigQueryResultStatsImpl(queryStatistics, sessionInfo);
        this.bufferFvl = new LinkedBlockingDeque<AbstractList<FieldValue>>(this.getBufferSize());
        LinkedBlockingDeque<Tuple<Iterable<FieldValueList>, Boolean>> pageCache = new LinkedBlockingDeque<Tuple<Iterable<FieldValueList>, Boolean>>(this.getPageCacheSize(this.connectionSettings.getNumBufferedRows(), schema));
        LinkedBlockingDeque<Tuple<TableDataList, Boolean>> rpcResponseQueue = new LinkedBlockingDeque<Tuple<TableDataList, Boolean>>(this.getPageCacheSize(this.connectionSettings.getNumBufferedRows(), schema));
        JobId jobId = JobId.fromPb(results.getJobReference());
        this.runNextPageTaskAsync(results.getPageToken(), this.getDestinationTable(jobId), rpcResponseQueue);
        this.parseRpcDataAsync(results.getRows(), schema, pageCache, rpcResponseQueue);
        this.populateBufferAsync(rpcResponseQueue, pageCache, this.bufferFvl);
        return new BigQueryResultImpl<AbstractList<FieldValue>>(schema, numRows, this.bufferFvl, bigQueryResultStats);
    }

    @VisibleForTesting
    void runNextPageTaskAsync(String firstPageToken, TableId destinationTable, BlockingQueue<Tuple<TableDataList, Boolean>> rpcResponseQueue) {
        Runnable nextPageTask = () -> {
            String pageToken = firstPageToken;
            try {
                while (pageToken != null) {
                    if (Thread.currentThread().isInterrupted() || this.queryTaskExecutor.isShutdown()) {
                        this.logger.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ runNextPageTaskAsync");
                        break;
                    }
                    TableDataList tabledataList = this.tableDataListRpc(destinationTable, pageToken);
                    pageToken = tabledataList.getPageToken();
                    rpcResponseQueue.put(Tuple.of((Object)tabledataList, (Object)true));
                }
                rpcResponseQueue.put(Tuple.of(null, (Object)false));
            }
            catch (Exception e) {
                throw new BigQueryException(0, e.getMessage(), e);
            }
        };
        this.queryTaskExecutor.execute(nextPageTask);
    }

    @VisibleForTesting
    void parseRpcDataAsync(List<TableRow> tableRows, Schema schema, BlockingQueue<Tuple<Iterable<FieldValueList>, Boolean>> pageCache, BlockingQueue<Tuple<TableDataList, Boolean>> rpcResponseQueue) {
        Iterable<FieldValueList> firstFieldValueLists = ConnectionImpl.getIterableFieldValueList(tableRows, schema);
        try {
            pageCache.put((Tuple<Iterable<FieldValueList>, Boolean>)Tuple.of(firstFieldValueLists, (Object)true));
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ parseRpcDataAsync");
        }
        Runnable parseDataTask = () -> {
            try {
                boolean hasMorePages = true;
                while (hasMorePages) {
                    if (Thread.currentThread().isInterrupted() || this.queryTaskExecutor.isShutdown()) {
                        this.logger.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ parseRpcDataAsync");
                        break;
                    }
                    Tuple rpcResponse = (Tuple)rpcResponseQueue.take();
                    TableDataList tabledataList = (TableDataList)rpcResponse.x();
                    hasMorePages = (Boolean)rpcResponse.y();
                    if (tabledataList == null) continue;
                    Iterable<FieldValueList> fieldValueLists = ConnectionImpl.getIterableFieldValueList(tabledataList.getRows(), schema);
                    pageCache.put(Tuple.of(fieldValueLists, (Object)true));
                }
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ parseRpcDataAsync", e);
            }
            try {
                pageCache.put(Tuple.of(null, (Object)false));
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ parseRpcDataAsync", e);
            }
        };
        this.queryTaskExecutor.execute(parseDataTask);
    }

    @VisibleForTesting
    void populateBufferAsync(BlockingQueue<Tuple<TableDataList, Boolean>> rpcResponseQueue, BlockingQueue<Tuple<Iterable<FieldValueList>, Boolean>> pageCache, BlockingQueue<AbstractList<FieldValue>> buffer) {
        Runnable populateBufferRunnable = () -> {
            Iterable fieldValueLists = null;
            boolean hasRows = true;
            block9: while (hasRows) {
                try {
                    Tuple nextPageTuple = (Tuple)pageCache.take();
                    hasRows = (Boolean)nextPageTuple.y();
                    fieldValueLists = (Iterable)nextPageTuple.x();
                }
                catch (InterruptedException e) {
                    this.logger.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted", e);
                    break;
                }
                if (Thread.currentThread().isInterrupted() || this.queryTaskExecutor.isShutdown() || fieldValueLists == null) break;
                for (FieldValueList fieldValueList : fieldValueLists) {
                    try {
                        if (Thread.currentThread().isInterrupted() || this.queryTaskExecutor.isShutdown()) continue block9;
                        buffer.put(fieldValueList);
                    }
                    catch (InterruptedException e) {
                        throw new BigQueryException(0, e.getMessage(), e);
                    }
                }
            }
            try {
                buffer.put(new EndOfFieldValueList());
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ populateBufferAsync", e);
            }
            finally {
                this.queryTaskExecutor.shutdownNow();
            }
        };
        this.queryTaskExecutor.execute(populateBufferRunnable);
    }

    @InternalApi
    void flagEndOfStream() {
        try {
            if (this.bufferFvl != null) {
                this.bufferFvl.put(new EndOfFieldValueList());
            } else if (this.bufferRow != null) {
                this.bufferRow.put(new BigQueryResultImpl.Row(null, true));
            } else {
                this.logger.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Could not flag End of Stream, both the buffer types are null. This might happen when the connection is close without executing a query");
            }
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ flagEndOfStream", e);
        }
    }

    private static Iterable<FieldValueList> getIterableFieldValueList(Iterable<TableRow> tableDataPb, final Schema schema) {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)(tableDataPb != null ? tableDataPb : ImmutableList.of()), (Function)new Function<TableRow, FieldValueList>(){
            final FieldList fields;
            {
                this.fields = schema != null ? schema.getFields() : null;
            }

            public FieldValueList apply(TableRow rowPb) {
                return FieldValueList.fromPb(rowPb.getF(), this.fields);
            }
        }));
    }

    @VisibleForTesting
    int getPageCacheSize(Integer numBufferedRows, Schema schema) {
        long numCachedRows;
        int MIN_CACHE_SIZE = 3;
        int MAX_CACHE_SIZE = 20;
        int numColumns = schema.getFields().size();
        long l = numCachedRows = numBufferedRows == null ? 0L : numBufferedRows.longValue();
        int numCachedPages = numCachedRows > 10000L ? 2 : (numColumns > 15 && numCachedRows > 5000L ? 3 : (numCachedRows < 2000L && numColumns < 15 ? 20 : 5));
        return numCachedPages < 3 ? 3 : Math.min(numCachedPages, 20);
    }

    @VisibleForTesting
    BigQueryResult getSubsequentQueryResultsWithJob(Long totalRows, Long pageRows, JobId jobId, GetQueryResultsResponse firstPage, Boolean hasQueryParameters) {
        TableId destinationTable = this.getDestinationTable(jobId);
        return this.useReadAPI(totalRows, pageRows, Schema.fromPb(firstPage.getSchema()), hasQueryParameters) ? this.highThroughPutRead(destinationTable, firstPage.getTotalRows().longValue(), Schema.fromPb(firstPage.getSchema()), this.getBigQueryResultSetStats(jobId)) : this.tableDataList(firstPage, jobId);
    }

    @VisibleForTesting
    BigQueryResult getSubsequentQueryResultsWithJob(Long totalRows, Long pageRows, JobId jobId, GetQueryResultsResponse firstPage, Schema schema, Boolean hasQueryParameters) {
        TableId destinationTable = this.getDestinationTable(jobId);
        return this.useReadAPI(totalRows, pageRows, schema, hasQueryParameters) ? this.highThroughPutRead(destinationTable, totalRows == null ? -1L : totalRows, schema, this.getBigQueryResultSetStats(jobId)) : this.tableDataList(firstPage, jobId);
    }

    private Job getQueryJobRpc(JobId jobId) {
        com.google.api.services.bigquery.model.Job jobPb;
        JobId completeJobId = jobId.setProjectId(this.bigQueryOptions.getProjectId()).setLocation(jobId.getLocation() == null && this.bigQueryOptions.getLocation() != null ? this.bigQueryOptions.getLocation() : jobId.getLocation());
        try {
            jobPb = (com.google.api.services.bigquery.model.Job)RetryHelper.runWithRetries(() -> this.bigQueryRpc.getQueryJob(completeJobId.getProject(), completeJobId.getJob(), completeJobId.getLocation()), (RetrySettings)this.bigQueryOptions.getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)this.bigQueryOptions.getClock());
            if (this.bigQueryOptions.getThrowNotFound() && jobPb == null) {
                throw new BigQueryException(404, "Query job not found");
            }
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
        return Job.fromPb((BigQuery)this.bigQueryOptions.getService(), jobPb);
    }

    @VisibleForTesting
    TableId getDestinationTable(JobId jobId) {
        Job job = this.getQueryJobRpc(jobId);
        return ((QueryJobConfiguration)job.getConfiguration()).getDestinationTable();
    }

    @VisibleForTesting
    TableDataList tableDataListRpc(TableId destinationTable, String pageToken) {
        try {
            TableId completeTableId = destinationTable.setProjectId(Strings.isNullOrEmpty((String)destinationTable.getProject()) ? this.bigQueryOptions.getProjectId() : destinationTable.getProject());
            TableDataList results = (TableDataList)RetryHelper.runWithRetries(() -> this.bigQueryOptions.getBigQueryRpcV2().listTableDataWithRowLimit(completeTableId.getProject(), completeTableId.getDataset(), completeTableId.getTable(), this.connectionSettings.getMaxResultPerPage(), pageToken), (RetrySettings)this.bigQueryOptions.getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)this.bigQueryOptions.getClock());
            return results;
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @VisibleForTesting
    BigQueryResult highThroughPutRead(TableId destinationTable, long totalRows, Schema schema, BigQueryResultStats stats) {
        try {
            if (this.bqReadClient == null) {
                this.bqReadClient = BigQueryReadClient.create();
            }
            String parent = String.format("projects/%s", destinationTable.getProject());
            String srcTable = String.format("projects/%s/datasets/%s/tables/%s", destinationTable.getProject(), destinationTable.getDataset(), destinationTable.getTable());
            ReadSession.Builder sessionBuilder = ReadSession.newBuilder().setTable(srcTable).setDataFormat(DataFormat.ARROW);
            CreateReadSessionRequest.Builder builder = CreateReadSessionRequest.newBuilder().setParent(parent).setReadSession(sessionBuilder).setMaxStreamCount(1);
            ReadSession readSession = this.bqReadClient.createReadSession(builder.build());
            this.bufferRow = new LinkedBlockingDeque<BigQueryResultImpl.Row>(this.getBufferSize());
            HashMap arrowNameToIndex = new HashMap();
            this.processArrowStreamAsync(readSession, this.bufferRow, new ArrowRowReader(readSession.getArrowSchema(), arrowNameToIndex), schema);
            this.logger.log(Level.INFO, "\n Using BigQuery Read API");
            return new BigQueryResultImpl<BigQueryResultImpl.Row>(schema, totalRows, this.bufferRow, stats);
        }
        catch (IOException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    private void processArrowStreamAsync(ReadSession readSession, BlockingQueue<BigQueryResultImpl.Row> buffer, ArrowRowReader reader, Schema schema) {
        Runnable arrowStreamProcessor = () -> {
            try {
                String streamName = readSession.getStreams(0).getName();
                ReadRowsRequest readRowsRequest = ReadRowsRequest.newBuilder().setReadStream(streamName).build();
                ServerStream stream = this.bqReadClient.readRowsCallable().call((Object)readRowsRequest);
                for (ReadRowsResponse response : stream) {
                    if (Thread.currentThread().isInterrupted()) break;
                    if (this.queryTaskExecutor.isShutdown()) {
                        break;
                    }
                    reader.processRows(response.getArrowRecordBatch(), buffer, schema);
                }
            }
            catch (Exception e) {
                throw BigQueryException.translateAndThrow(e);
            }
            finally {
                try {
                    buffer.put(new BigQueryResultImpl.Row(null, true));
                }
                catch (InterruptedException e) {
                    this.logger.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ markLast", e);
                }
                this.queryTaskExecutor.shutdownNow();
            }
        };
        this.queryTaskExecutor.execute(arrowStreamProcessor);
    }

    @VisibleForTesting
    GetQueryResultsResponse getQueryResultsFirstPage(JobId jobId) {
        JobId completeJobId = jobId.setProjectId(this.bigQueryOptions.getProjectId()).setLocation(jobId.getLocation() == null && this.bigQueryOptions.getLocation() != null ? this.bigQueryOptions.getLocation() : jobId.getLocation());
        try {
            GetQueryResultsResponse results = BigQueryRetryHelper.runWithRetries(() -> this.bigQueryRpc.getQueryResultsWithRowLimit(completeJobId.getProject(), completeJobId.getJob(), completeJobId.getLocation(), this.connectionSettings.getMaxResultPerPage()), this.bigQueryOptions.getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, this.bigQueryOptions.getClock(), this.retryConfig);
            if (results.getErrors() != null) {
                List<BigQueryError> bigQueryErrors = results.getErrors().stream().map(BigQueryError.FROM_PB_FUNCTION).collect(Collectors.toList());
                throw new BigQueryException(bigQueryErrors);
            }
            return results;
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @VisibleForTesting
    boolean isFastQuerySupported() {
        return this.connectionSettings.getClustering() == null && this.connectionSettings.getCreateDisposition() == null && this.connectionSettings.getDestinationEncryptionConfiguration() == null && this.connectionSettings.getDestinationTable() == null && this.connectionSettings.getJobTimeoutMs() == null && this.connectionSettings.getMaximumBillingTier() == null && this.connectionSettings.getPriority() == null && this.connectionSettings.getRangePartitioning() == null && this.connectionSettings.getSchemaUpdateOptions() == null && this.connectionSettings.getTableDefinitions() == null && this.connectionSettings.getTimePartitioning() == null && this.connectionSettings.getUserDefinedFunctions() == null && this.connectionSettings.getWriteDisposition() == null;
    }

    @VisibleForTesting
    boolean useReadAPI(Long totalRows, Long pageRows, Schema schema, Boolean hasQueryParameters) {
        if ((totalRows == null || pageRows == null) && Boolean.TRUE.equals(this.connectionSettings.getUseReadAPI())) {
            return true;
        }
        if (this.containsIntervalType(schema) || hasQueryParameters.booleanValue()) {
            this.logger.log(Level.INFO, "\n Schema has IntervalType, or QueryParameters. Disabling ReadAPI");
            return false;
        }
        long resultRatio = totalRows / pageRows;
        if (Boolean.TRUE.equals(this.connectionSettings.getUseReadAPI())) {
            return resultRatio >= (long)this.connectionSettings.getTotalToPageRowCountRatio().intValue() && totalRows > (long)this.connectionSettings.getMinResultSize().intValue();
        }
        return false;
    }

    private boolean containsIntervalType(Schema schema) {
        LinkedList<Field> fields = new LinkedList<Field>(schema.getFields());
        while (!fields.isEmpty()) {
            Field curField = (Field)fields.poll();
            if (curField.getType().getStandardType() == StandardSQLTypeName.INTERVAL) {
                return true;
            }
            if (curField.getType().getStandardType() != StandardSQLTypeName.STRUCT && curField.getType().getStandardType() != StandardSQLTypeName.ARRAY) continue;
            fields.addAll(curField.getSubFields());
        }
        return false;
    }

    @VisibleForTesting
    QueryRequest createQueryRequest(ConnectionSettings connectionSettings, String sql, List<Parameter> queryParameters, Map<String, String> labels) {
        QueryRequest content = new QueryRequest();
        String requestId = UUID.randomUUID().toString();
        if (connectionSettings.getConnectionProperties() != null) {
            content.setConnectionProperties(connectionSettings.getConnectionProperties().stream().map(ConnectionProperty.TO_PB_FUNCTION).collect(Collectors.toList()));
        }
        if (connectionSettings.getDefaultDataset() != null) {
            content.setDefaultDataset(connectionSettings.getDefaultDataset().toPb());
        }
        if (connectionSettings.getMaximumBytesBilled() != null) {
            content.setMaximumBytesBilled(connectionSettings.getMaximumBytesBilled());
        }
        if (connectionSettings.getMaxResults() != null) {
            content.setMaxResults(connectionSettings.getMaxResults());
        }
        if (queryParameters != null) {
            if (queryParameters.get(0).getName() == null) {
                content.setParameterMode("POSITIONAL");
                List queryParametersPb = Lists.transform(queryParameters, POSITIONAL_PARAMETER_TO_PB_FUNCTION);
                content.setQueryParameters(queryParametersPb);
            } else {
                content.setParameterMode("NAMED");
                List queryParametersPb = Lists.transform(queryParameters, NAMED_PARAMETER_TO_PB_FUNCTION);
                content.setQueryParameters(queryParametersPb);
            }
        }
        if (connectionSettings.getCreateSession() != null) {
            content.setCreateSession(connectionSettings.getCreateSession());
        }
        if (labels != null) {
            content.setLabels(labels);
        }
        content.setQuery(sql);
        content.setRequestId(requestId);
        content.setUseLegacySql(Boolean.valueOf(false));
        return content;
    }

    @VisibleForTesting
    com.google.api.services.bigquery.model.Job createQueryJob(String sql, ConnectionSettings connectionSettings, List<Parameter> queryParameters, Map<String, String> labels) {
        com.google.api.services.bigquery.model.Job queryJob;
        JobConfiguration configurationPb = new JobConfiguration();
        JobConfigurationQuery queryConfigurationPb = new JobConfigurationQuery();
        queryConfigurationPb.setQuery(sql);
        if (queryParameters != null) {
            List queryParametersPb;
            if (queryParameters.get(0).getName() == null) {
                queryConfigurationPb.setParameterMode("POSITIONAL");
                queryParametersPb = Lists.transform(queryParameters, POSITIONAL_PARAMETER_TO_PB_FUNCTION);
                queryConfigurationPb.setQueryParameters(queryParametersPb);
            } else {
                queryConfigurationPb.setParameterMode("NAMED");
                queryParametersPb = Lists.transform(queryParameters, NAMED_PARAMETER_TO_PB_FUNCTION);
                queryConfigurationPb.setQueryParameters(queryParametersPb);
            }
        }
        if (connectionSettings.getDestinationTable() != null) {
            queryConfigurationPb.setDestinationTable(connectionSettings.getDestinationTable().toPb());
        }
        if (connectionSettings.getTableDefinitions() != null) {
            queryConfigurationPb.setTableDefinitions(Maps.transformValues(connectionSettings.getTableDefinitions(), ExternalTableDefinition.TO_EXTERNAL_DATA_FUNCTION));
        }
        if (connectionSettings.getUserDefinedFunctions() != null) {
            queryConfigurationPb.setUserDefinedFunctionResources(connectionSettings.getUserDefinedFunctions().stream().map(UserDefinedFunction.TO_PB_FUNCTION).collect(Collectors.toList()));
        }
        if (connectionSettings.getCreateDisposition() != null) {
            queryConfigurationPb.setCreateDisposition(connectionSettings.getCreateDisposition().toString());
        }
        if (connectionSettings.getWriteDisposition() != null) {
            queryConfigurationPb.setWriteDisposition(connectionSettings.getWriteDisposition().toString());
        }
        if (connectionSettings.getDefaultDataset() != null) {
            queryConfigurationPb.setDefaultDataset(connectionSettings.getDefaultDataset().toPb());
        }
        if (connectionSettings.getPriority() != null) {
            queryConfigurationPb.setPriority(connectionSettings.getPriority().toString());
        }
        if (connectionSettings.getAllowLargeResults() != null) {
            queryConfigurationPb.setAllowLargeResults(connectionSettings.getAllowLargeResults());
        }
        if (connectionSettings.getUseQueryCache() != null) {
            queryConfigurationPb.setUseQueryCache(connectionSettings.getUseQueryCache());
        }
        if (connectionSettings.getFlattenResults() != null) {
            queryConfigurationPb.setFlattenResults(connectionSettings.getFlattenResults());
        }
        if (connectionSettings.getMaximumBillingTier() != null) {
            queryConfigurationPb.setMaximumBillingTier(connectionSettings.getMaximumBillingTier());
        }
        if (connectionSettings.getMaximumBytesBilled() != null) {
            queryConfigurationPb.setMaximumBytesBilled(connectionSettings.getMaximumBytesBilled());
        }
        if (connectionSettings.getSchemaUpdateOptions() != null) {
            ImmutableList.Builder schemaUpdateOptionsBuilder = new ImmutableList.Builder();
            for (JobInfo.SchemaUpdateOption schemaUpdateOption : connectionSettings.getSchemaUpdateOptions()) {
                schemaUpdateOptionsBuilder.add((Object)schemaUpdateOption.name());
            }
            queryConfigurationPb.setSchemaUpdateOptions((List)schemaUpdateOptionsBuilder.build());
        }
        if (connectionSettings.getDestinationEncryptionConfiguration() != null) {
            queryConfigurationPb.setDestinationEncryptionConfiguration(connectionSettings.getDestinationEncryptionConfiguration().toPb());
        }
        if (connectionSettings.getTimePartitioning() != null) {
            queryConfigurationPb.setTimePartitioning(connectionSettings.getTimePartitioning().toPb());
        }
        if (connectionSettings.getClustering() != null) {
            queryConfigurationPb.setClustering(connectionSettings.getClustering().toPb());
        }
        if (connectionSettings.getRangePartitioning() != null) {
            queryConfigurationPb.setRangePartitioning(connectionSettings.getRangePartitioning().toPb());
        }
        if (connectionSettings.getConnectionProperties() != null) {
            queryConfigurationPb.setConnectionProperties(connectionSettings.getConnectionProperties().stream().map(ConnectionProperty.TO_PB_FUNCTION).collect(Collectors.toList()));
        }
        if (connectionSettings.getCreateSession() != null) {
            queryConfigurationPb.setCreateSession(connectionSettings.getCreateSession());
        }
        if (connectionSettings.getJobTimeoutMs() != null) {
            configurationPb.setJobTimeoutMs(connectionSettings.getJobTimeoutMs());
        }
        if (labels != null) {
            configurationPb.setLabels(labels);
        }
        queryConfigurationPb.setUseLegacySql(Boolean.valueOf(false));
        configurationPb.setQuery(queryConfigurationPb);
        com.google.api.services.bigquery.model.Job jobPb = JobInfo.of(QueryJobConfiguration.fromPb(configurationPb)).toPb();
        try {
            queryJob = BigQueryRetryHelper.runWithRetries(() -> this.bigQueryRpc.createJobForQuery(jobPb), this.bigQueryOptions.getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, this.bigQueryOptions.getClock(), this.retryConfig);
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
        return queryJob;
    }

    private com.google.api.services.bigquery.model.Job createDryRunJob(String sql) {
        com.google.api.services.bigquery.model.Job dryRunJob;
        JobConfiguration configurationPb = new JobConfiguration();
        configurationPb.setDryRun(Boolean.valueOf(true));
        JobConfigurationQuery queryConfigurationPb = new JobConfigurationQuery();
        String parameterMode = sql.contains("?") ? "POSITIONAL" : "NAMED";
        queryConfigurationPb.setParameterMode(parameterMode);
        queryConfigurationPb.setQuery(sql);
        queryConfigurationPb.setUseLegacySql(Boolean.valueOf(false));
        if (this.connectionSettings.getDefaultDataset() != null) {
            queryConfigurationPb.setDefaultDataset(this.connectionSettings.getDefaultDataset().toPb());
        }
        if (this.connectionSettings.getCreateSession() != null) {
            queryConfigurationPb.setCreateSession(this.connectionSettings.getCreateSession());
        }
        configurationPb.setQuery(queryConfigurationPb);
        com.google.api.services.bigquery.model.Job jobPb = JobInfo.of(QueryJobConfiguration.fromPb(configurationPb)).toPb();
        try {
            dryRunJob = BigQueryRetryHelper.runWithRetries(() -> this.bigQueryRpc.createJobForQuery(jobPb), this.bigQueryOptions.getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, this.bigQueryOptions.getClock(), this.retryConfig);
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
        return dryRunJob;
    }

    private class ArrowRowReader
    implements AutoCloseable {
        BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
        private final VectorSchemaRoot root;
        private final VectorLoader loader;

        private ArrowRowReader(ArrowSchema arrowSchema, Map<String, Integer> arrowNameToIndex) throws IOException {
            org.apache.arrow.vector.types.pojo.Schema schema = MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel((ReadableByteChannel)new ByteArrayReadableSeekableByteChannel(arrowSchema.getSerializedSchema().toByteArray())));
            ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
            List fields = schema.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                vectors.add(((org.apache.arrow.vector.types.pojo.Field)fields.get(i)).createVector(this.allocator));
                arrowNameToIndex.put(((org.apache.arrow.vector.types.pojo.Field)fields.get(i)).getName(), i);
            }
            this.root = new VectorSchemaRoot(vectors);
            this.loader = new VectorLoader(this.root);
        }

        private void processRows(ArrowRecordBatch batch, BlockingQueue<BigQueryResultImpl.Row> buffer, Schema schema) throws IOException {
            try {
                org.apache.arrow.vector.ipc.message.ArrowRecordBatch deserializedBatch = MessageSerializer.deserializeRecordBatch((ReadChannel)new ReadChannel((ReadableByteChannel)new ByteArrayReadableSeekableByteChannel(batch.getSerializedRecordBatch().toByteArray())), (BufferAllocator)this.allocator);
                this.loader.load(deserializedBatch);
                deserializedBatch.close();
                FieldList fields = schema.getFields();
                for (int rowNum = 0; rowNum < this.root.getRowCount() && !Thread.currentThread().isInterrupted() && !ConnectionImpl.this.queryTaskExecutor.isShutdown(); ++rowNum) {
                    HashMap<String, Object> curRow = new HashMap<String, Object>();
                    for (int col = 0; col < fields.size(); ++col) {
                        Field field = fields.get(col);
                        FieldVector curFieldVec = this.root.getVector(field.getName());
                        curRow.put(field.getName(), curFieldVec.getObject(rowNum));
                    }
                    buffer.put(new BigQueryResultImpl.Row(curRow));
                }
                this.root.clear();
            }
            catch (InterruptedException | RuntimeException e) {
                throw BigQueryException.translateAndThrow(e);
            }
            finally {
                try {
                    this.root.clear();
                }
                catch (RuntimeException e) {
                    ConnectionImpl.this.logger.log(Level.WARNING, "\n Error while clearing VectorSchemaRoot ", e);
                }
            }
        }

        @Override
        public void close() {
            this.root.close();
            this.allocator.close();
        }
    }

    static class EndOfFieldValueList
    extends AbstractList<FieldValue> {
        EndOfFieldValueList() {
        }

        @Override
        public FieldValue get(int index) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

