/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.testing;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.RetryParams;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteBigQueryHelper {
    private static final Logger log = Logger.getLogger(RemoteBigQueryHelper.class.getName());
    private static final String DATASET_NAME_PREFIX = "gcloud_test_dataset_temp_";
    private final BigQueryOptions options;

    private RemoteBigQueryHelper(BigQueryOptions options) {
        this.options = options;
    }

    @Deprecated
    public BigQueryOptions options() {
        return this.options;
    }

    public BigQueryOptions getOptions() {
        return this.options;
    }

    public static boolean forceDelete(BigQuery bigquery, String dataset) {
        return bigquery.delete(dataset, BigQuery.DatasetDeleteOption.deleteContents());
    }

    public static String generateDatasetName() {
        return DATASET_NAME_PREFIX + UUID.randomUUID().toString().replace('-', '_');
    }

    public static RemoteBigQueryHelper create(String projectId, InputStream keyStream) throws BigQueryHelperException {
        try {
            BigQueryOptions bigqueryOptions = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)keyStream))).setProjectId(projectId)).setRetryParams(RemoteBigQueryHelper.retryParams())).setConnectTimeout(60000)).setReadTimeout(60000)).build();
            return new RemoteBigQueryHelper(bigqueryOptions);
        }
        catch (IOException ex) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, ex.getMessage());
            }
            throw BigQueryHelperException.translate(ex);
        }
    }

    public static RemoteBigQueryHelper create() {
        BigQueryOptions bigqueryOptions = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setRetryParams(RemoteBigQueryHelper.retryParams())).setConnectTimeout(60000)).setReadTimeout(60000)).build();
        return new RemoteBigQueryHelper(bigqueryOptions);
    }

    private static RetryParams retryParams() {
        return RetryParams.newBuilder().setRetryMaxAttempts(10).setRetryMinAttempts(6).setMaxRetryDelayMillis(30000L).setTotalRetryPeriodMillis(120000L).setInitialRetryDelayMillis(250L).build();
    }

    public static class BigQueryHelperException
    extends RuntimeException {
        private static final long serialVersionUID = 3984993496060055562L;

        public BigQueryHelperException(String message, Throwable cause) {
            super(message, cause);
        }

        public static BigQueryHelperException translate(Exception ex) {
            return new BigQueryHelperException(ex.getMessage(), ex);
        }
    }
}

