/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.DatasetId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public final class QueryRequest
implements Serializable {
    private static final long serialVersionUID = -8727328332415880852L;
    private final String query;
    private final Long pageSize;
    private final DatasetId defaultDataset;
    private final Long maxWaitTime;
    private final Boolean dryRun;
    private final Boolean useQueryCache;
    private final Boolean useLegacySql;

    private QueryRequest(Builder builder) {
        this.query = builder.query;
        this.pageSize = builder.pageSize;
        this.defaultDataset = builder.defaultDataset;
        this.maxWaitTime = builder.maxWaitTime;
        this.dryRun = builder.dryRun;
        this.useQueryCache = builder.useQueryCache;
        this.useLegacySql = builder.useLegacySql;
    }

    @Deprecated
    public String query() {
        return this.getQuery();
    }

    public String getQuery() {
        return this.query;
    }

    @Deprecated
    public Long pageSize() {
        return this.getPageSize();
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    @Deprecated
    public DatasetId defaultDataset() {
        return this.getDefaultDataset();
    }

    public DatasetId getDefaultDataset() {
        return this.defaultDataset;
    }

    @Deprecated
    public Long maxWaitTime() {
        return this.getMaxWaitTime();
    }

    public Long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    public Boolean useQueryCache() {
        return this.useQueryCache;
    }

    public Boolean useLegacySql() {
        return this.useLegacySql;
    }

    public Builder toBuilder() {
        return new Builder().setQuery(this.query).setPageSize(this.pageSize).setDefaultDataset(this.defaultDataset).setMaxWaitTime(this.maxWaitTime).setDryRun(this.dryRun).setUseQueryCache(this.useQueryCache).setUseLegacySql(this.useLegacySql);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("query", (Object)this.query).add("pageSize", (Object)this.pageSize).add("defaultDataset", (Object)this.defaultDataset).add("maxWaitTime", (Object)this.maxWaitTime).add("dryRun", (Object)this.dryRun).add("useQueryCache", (Object)this.useQueryCache).add("useLegacySql", (Object)this.useLegacySql).toString();
    }

    public int hashCode() {
        return Objects.hash(this.query, this.pageSize, this.defaultDataset, this.maxWaitTime, this.dryRun, this.useQueryCache, this.useLegacySql);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof QueryRequest && Objects.equals(this.toPb(), ((QueryRequest)obj).toPb());
    }

    QueryRequest setProjectId(String projectId) {
        Builder builder = this.toBuilder();
        if (this.getDefaultDataset() != null) {
            builder.setDefaultDataset(this.getDefaultDataset().setProjectId(projectId));
        }
        return builder.build();
    }

    com.google.api.services.bigquery.model.QueryRequest toPb() {
        com.google.api.services.bigquery.model.QueryRequest queryRequestPb = new com.google.api.services.bigquery.model.QueryRequest().setQuery(this.query);
        if (this.pageSize != null) {
            queryRequestPb.setMaxResults(this.pageSize);
        }
        if (this.defaultDataset != null) {
            queryRequestPb.setDefaultDataset(this.defaultDataset.toPb());
        }
        if (this.maxWaitTime != null) {
            queryRequestPb.setTimeoutMs(this.maxWaitTime);
        }
        if (this.dryRun != null) {
            queryRequestPb.setDryRun(this.dryRun);
        }
        if (this.useQueryCache != null) {
            queryRequestPb.setUseQueryCache(this.useQueryCache);
        }
        if (this.useLegacySql != null) {
            queryRequestPb.setUseLegacySql(this.useLegacySql);
        }
        return queryRequestPb;
    }

    @Deprecated
    public static Builder builder(String query) {
        return QueryRequest.newBuilder(query);
    }

    public static Builder newBuilder(String query) {
        return new Builder().setQuery(query);
    }

    public static QueryRequest of(String query) {
        return new Builder().setQuery(query).build();
    }

    static QueryRequest fromPb(com.google.api.services.bigquery.model.QueryRequest queryRequestPb) {
        Builder builder = QueryRequest.newBuilder(queryRequestPb.getQuery());
        if (queryRequestPb.getMaxResults() != null) {
            builder.setPageSize(queryRequestPb.getMaxResults());
        }
        if (queryRequestPb.getDefaultDataset() != null) {
            builder.setDefaultDataset(DatasetId.fromPb(queryRequestPb.getDefaultDataset()));
        }
        if (queryRequestPb.getTimeoutMs() != null) {
            builder.setMaxWaitTime(queryRequestPb.getTimeoutMs());
        }
        if (queryRequestPb.getDryRun() != null) {
            builder.setDryRun(queryRequestPb.getDryRun());
        }
        if (queryRequestPb.getUseQueryCache() != null) {
            builder.setUseQueryCache(queryRequestPb.getUseQueryCache());
        }
        if (queryRequestPb.getUseLegacySql() != null) {
            builder.setUseLegacySql(queryRequestPb.getUseLegacySql());
        }
        return builder.build();
    }

    public static final class Builder {
        private String query;
        private Long pageSize;
        private DatasetId defaultDataset;
        private Long maxWaitTime;
        private Boolean dryRun;
        private Boolean useQueryCache;
        private Boolean useLegacySql;

        private Builder() {
        }

        @Deprecated
        public Builder query(String query) {
            return this.setQuery(query);
        }

        public Builder setQuery(String query) {
            this.query = (String)Preconditions.checkNotNull((Object)query);
            return this;
        }

        @Deprecated
        public Builder pageSize(Long pageSize) {
            return this.setPageSize(pageSize);
        }

        public Builder setPageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Deprecated
        public Builder defaultDataset(DatasetId defaultDataset) {
            return this.setDefaultDataset(defaultDataset);
        }

        public Builder setDefaultDataset(DatasetId defaultDataset) {
            this.defaultDataset = defaultDataset;
            return this;
        }

        @Deprecated
        public Builder defaultDataset(String defaultDataset) {
            return this.setDefaultDataset(DatasetId.of(defaultDataset));
        }

        public Builder setDefaultDataset(String defaultDataset) {
            return this.setDefaultDataset(DatasetId.of(defaultDataset));
        }

        @Deprecated
        public Builder maxWaitTime(Long maxWaitTime) {
            return this.setMaxWaitTime(maxWaitTime);
        }

        public Builder setMaxWaitTime(Long maxWaitTime) {
            this.maxWaitTime = maxWaitTime;
            return this;
        }

        @Deprecated
        public Builder dryRun(Boolean dryRun) {
            return this.setDryRun(dryRun);
        }

        public Builder setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Deprecated
        public Builder useQueryCache(Boolean useQueryCache) {
            return this.setUseQueryCache(useQueryCache);
        }

        public Builder setUseQueryCache(Boolean useQueryCache) {
            this.useQueryCache = useQueryCache;
            return this;
        }

        @Deprecated
        public Builder useLegacySql(Boolean useLegacySql) {
            return this.setUseLegacySql(useLegacySql);
        }

        public Builder setUseLegacySql(Boolean useLegacySql) {
            this.useLegacySql = useLegacySql;
            return this;
        }

        public QueryRequest build() {
            return new QueryRequest(this);
        }
    }
}

