/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class LoadJobConfiguration
extends JobConfiguration
implements LoadConfiguration {
    private static final long serialVersionUID = -2673554846792429829L;
    private final List<String> sourceUris;
    private final TableId destinationTable;
    private final JobInfo.CreateDisposition createDisposition;
    private final JobInfo.WriteDisposition writeDisposition;
    private final FormatOptions formatOptions;
    private final Integer maxBadRecords;
    private final Schema schema;
    private final Boolean ignoreUnknownValues;
    private final List<String> projectionFields;

    private LoadJobConfiguration(Builder builder) {
        super(builder);
        this.sourceUris = builder.sourceUris;
        this.destinationTable = builder.destinationTable;
        this.createDisposition = builder.createDisposition;
        this.writeDisposition = builder.writeDisposition;
        this.formatOptions = builder.formatOptions;
        this.maxBadRecords = builder.maxBadRecords;
        this.schema = builder.schema;
        this.ignoreUnknownValues = builder.ignoreUnknownValues;
        this.projectionFields = builder.projectionFields;
    }

    @Override
    public TableId destinationTable() {
        return this.destinationTable;
    }

    @Override
    public JobInfo.CreateDisposition createDisposition() {
        return this.createDisposition;
    }

    @Override
    public JobInfo.WriteDisposition writeDisposition() {
        return this.writeDisposition;
    }

    @Override
    public CsvOptions csvOptions() {
        return this.formatOptions instanceof CsvOptions ? (CsvOptions)this.formatOptions : null;
    }

    @Override
    public Integer maxBadRecords() {
        return this.maxBadRecords;
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public String format() {
        return this.formatOptions != null ? this.formatOptions.type() : null;
    }

    @Override
    public Boolean ignoreUnknownValues() {
        return this.ignoreUnknownValues;
    }

    @Override
    public List<String> projectionFields() {
        return this.projectionFields;
    }

    public List<String> sourceUris() {
        return this.sourceUris;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("destinationTable", (Object)this.destinationTable).add("createDisposition", (Object)this.createDisposition).add("writeDisposition", (Object)this.writeDisposition).add("formatOptions", (Object)this.formatOptions).add("maxBadRecords", (Object)this.maxBadRecords).add("schema", (Object)this.schema).add("ignoreUnknownValue", (Object)this.ignoreUnknownValues).add("projectionFields", this.projectionFields).add("sourceUris", this.sourceUris);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof LoadJobConfiguration && this.baseEquals((LoadJobConfiguration)obj);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.sourceUris);
    }

    @Override
    LoadJobConfiguration setProjectId(String projectId) {
        return this.toBuilder().destinationTable(this.destinationTable().setProjectId(projectId)).build();
    }

    @Override
    com.google.api.services.bigquery.model.JobConfiguration toPb() {
        JobConfigurationLoad loadConfigurationPb = new JobConfigurationLoad();
        loadConfigurationPb.setDestinationTable(this.destinationTable.toPb());
        if (this.createDisposition != null) {
            loadConfigurationPb.setCreateDisposition(this.createDisposition.toString());
        }
        if (this.writeDisposition != null) {
            loadConfigurationPb.setWriteDisposition(this.writeDisposition.toString());
        }
        if (this.csvOptions() != null) {
            CsvOptions csvOptions = this.csvOptions();
            loadConfigurationPb.setFieldDelimiter(csvOptions.fieldDelimiter()).setAllowJaggedRows(csvOptions.allowJaggedRows()).setAllowQuotedNewlines(csvOptions.allowQuotedNewLines()).setEncoding(csvOptions.encoding()).setQuote(csvOptions.quote());
            if (csvOptions.skipLeadingRows() != null) {
                loadConfigurationPb.setSkipLeadingRows(Integer.valueOf(Ints.checkedCast((long)csvOptions.skipLeadingRows())));
            }
        }
        if (this.schema != null) {
            loadConfigurationPb.setSchema(this.schema.toPb());
        }
        if (this.formatOptions != null) {
            loadConfigurationPb.setSourceFormat(this.formatOptions.type());
        }
        loadConfigurationPb.setMaxBadRecords(this.maxBadRecords);
        loadConfigurationPb.setIgnoreUnknownValues(this.ignoreUnknownValues);
        loadConfigurationPb.setProjectionFields(this.projectionFields);
        if (this.sourceUris != null) {
            loadConfigurationPb.setSourceUris((List)ImmutableList.copyOf(this.sourceUris));
        }
        return new com.google.api.services.bigquery.model.JobConfiguration().setLoad(loadConfigurationPb);
    }

    public static Builder builder(TableId destinationTable, List<String> sourceUris) {
        return new Builder().destinationTable(destinationTable).sourceUris(sourceUris);
    }

    public static Builder builder(TableId destinationTable, String sourceUri) {
        return LoadJobConfiguration.builder(destinationTable, (List<String>)ImmutableList.of((Object)sourceUri));
    }

    public static Builder builder(TableId destinationTable, List<String> sourceUris, FormatOptions format) {
        return LoadJobConfiguration.builder(destinationTable, sourceUris).formatOptions(format);
    }

    public static Builder builder(TableId destinationTable, String sourceUri, FormatOptions format) {
        return LoadJobConfiguration.builder(destinationTable, (List<String>)ImmutableList.of((Object)sourceUri), format);
    }

    public static LoadJobConfiguration of(TableId destinationTable, List<String> sourceUris) {
        return LoadJobConfiguration.builder(destinationTable, sourceUris).build();
    }

    public static LoadJobConfiguration of(TableId destinationTable, String sourceUri) {
        return LoadJobConfiguration.of(destinationTable, (List<String>)ImmutableList.of((Object)sourceUri));
    }

    public static LoadJobConfiguration of(TableId destinationTable, List<String> sourceUris, FormatOptions format) {
        return LoadJobConfiguration.builder(destinationTable, sourceUris, format).build();
    }

    public static LoadJobConfiguration of(TableId destinationTable, String sourceUri, FormatOptions format) {
        return LoadJobConfiguration.of(destinationTable, (List<String>)ImmutableList.of((Object)sourceUri), format);
    }

    static LoadJobConfiguration fromPb(com.google.api.services.bigquery.model.JobConfiguration confPb) {
        return new Builder(confPb).build();
    }

    public static final class Builder
    extends JobConfiguration.Builder<LoadJobConfiguration, Builder>
    implements LoadConfiguration.Builder {
        private List<String> sourceUris;
        private TableId destinationTable;
        private JobInfo.CreateDisposition createDisposition;
        private JobInfo.WriteDisposition writeDisposition;
        private FormatOptions formatOptions;
        private Integer maxBadRecords;
        private Schema schema;
        private Boolean ignoreUnknownValues;
        private List<String> projectionFields;

        private Builder() {
            super(JobConfiguration.Type.LOAD);
        }

        private Builder(LoadJobConfiguration loadConfiguration) {
            this();
            this.destinationTable = loadConfiguration.destinationTable;
            this.createDisposition = loadConfiguration.createDisposition;
            this.writeDisposition = loadConfiguration.writeDisposition;
            this.formatOptions = loadConfiguration.formatOptions;
            this.maxBadRecords = loadConfiguration.maxBadRecords;
            this.schema = loadConfiguration.schema;
            this.ignoreUnknownValues = loadConfiguration.ignoreUnknownValues;
            this.projectionFields = loadConfiguration.projectionFields;
            this.sourceUris = loadConfiguration.sourceUris;
        }

        private Builder(com.google.api.services.bigquery.model.JobConfiguration configurationPb) {
            this();
            JobConfigurationLoad loadConfigurationPb = configurationPb.getLoad();
            this.destinationTable = TableId.fromPb(loadConfigurationPb.getDestinationTable());
            if (loadConfigurationPb.getCreateDisposition() != null) {
                this.createDisposition = JobInfo.CreateDisposition.valueOf(loadConfigurationPb.getCreateDisposition());
            }
            if (loadConfigurationPb.getWriteDisposition() != null) {
                this.writeDisposition = JobInfo.WriteDisposition.valueOf(loadConfigurationPb.getWriteDisposition());
            }
            if (loadConfigurationPb.getSourceFormat() != null) {
                this.formatOptions = FormatOptions.of(loadConfigurationPb.getSourceFormat());
            }
            if (loadConfigurationPb.getAllowJaggedRows() != null || loadConfigurationPb.getAllowQuotedNewlines() != null || loadConfigurationPb.getEncoding() != null || loadConfigurationPb.getFieldDelimiter() != null || loadConfigurationPb.getQuote() != null || loadConfigurationPb.getSkipLeadingRows() != null) {
                CsvOptions.Builder builder = CsvOptions.builder().encoding(loadConfigurationPb.getEncoding()).fieldDelimiter(loadConfigurationPb.getFieldDelimiter()).quote(loadConfigurationPb.getQuote());
                if (loadConfigurationPb.getAllowJaggedRows() != null) {
                    builder.allowJaggedRows(loadConfigurationPb.getAllowJaggedRows());
                }
                if (loadConfigurationPb.getAllowQuotedNewlines() != null) {
                    builder.allowQuotedNewLines(loadConfigurationPb.getAllowQuotedNewlines());
                }
                if (loadConfigurationPb.getSkipLeadingRows() != null) {
                    builder.skipLeadingRows(loadConfigurationPb.getSkipLeadingRows().intValue());
                }
                this.formatOptions = builder.build();
            }
            this.maxBadRecords = loadConfigurationPb.getMaxBadRecords();
            if (loadConfigurationPb.getSchema() != null) {
                this.schema = Schema.fromPb(loadConfigurationPb.getSchema());
            }
            this.ignoreUnknownValues = loadConfigurationPb.getIgnoreUnknownValues();
            this.projectionFields = loadConfigurationPb.getProjectionFields();
            if (loadConfigurationPb.getSourceUris() != null) {
                this.sourceUris = ImmutableList.copyOf((Collection)configurationPb.getLoad().getSourceUris());
            }
        }

        @Override
        public Builder destinationTable(TableId destinationTable) {
            this.destinationTable = destinationTable;
            return this;
        }

        @Override
        public Builder createDisposition(JobInfo.CreateDisposition createDisposition) {
            this.createDisposition = createDisposition;
            return this;
        }

        @Override
        public Builder writeDisposition(JobInfo.WriteDisposition writeDisposition) {
            this.writeDisposition = writeDisposition;
            return this;
        }

        @Override
        public Builder formatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        @Override
        public Builder maxBadRecords(Integer maxBadRecords) {
            this.maxBadRecords = maxBadRecords;
            return this;
        }

        @Override
        public Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public Builder ignoreUnknownValues(Boolean ignoreUnknownValues) {
            this.ignoreUnknownValues = ignoreUnknownValues;
            return this;
        }

        @Override
        public Builder projectionFields(List<String> projectionFields) {
            this.projectionFields = projectionFields != null ? ImmutableList.copyOf(projectionFields) : null;
            return this;
        }

        public Builder sourceUris(List<String> sourceUris) {
            this.sourceUris = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sourceUris)));
            return this;
        }

        @Override
        public LoadJobConfiguration build() {
            return new LoadJobConfiguration(this);
        }
    }
}

