/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;

final class AutoValue_QueryParameterValue
extends QueryParameterValue {
    private final String value;
    private final ImmutableList<QueryParameterValue> arrayValuesInner;
    private final StandardSQLTypeName type;
    private final StandardSQLTypeName arrayType;
    private static final long serialVersionUID = -5620695863123562896L;

    private AutoValue_QueryParameterValue(@Nullable String value, @Nullable ImmutableList<QueryParameterValue> arrayValuesInner, StandardSQLTypeName type, @Nullable StandardSQLTypeName arrayType) {
        this.value = value;
        this.arrayValuesInner = arrayValuesInner;
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        this.arrayType = arrayType;
    }

    @Override
    @Nullable
    public String getValue() {
        return this.value;
    }

    @Override
    @Nullable
    ImmutableList<QueryParameterValue> getArrayValuesInner() {
        return this.arrayValuesInner;
    }

    @Override
    public StandardSQLTypeName getType() {
        return this.type;
    }

    @Override
    @Nullable
    public StandardSQLTypeName getArrayType() {
        return this.arrayType;
    }

    public String toString() {
        return "QueryParameterValue{value=" + this.value + ", arrayValuesInner=" + this.arrayValuesInner + ", type=" + (Object)((Object)this.type) + ", arrayType=" + (Object)((Object)this.arrayType) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof QueryParameterValue) {
            QueryParameterValue that = (QueryParameterValue)o;
            return (this.value == null ? that.getValue() == null : this.value.equals(that.getValue())) && (this.arrayValuesInner == null ? that.getArrayValuesInner() == null : this.arrayValuesInner.equals(that.getArrayValuesInner())) && this.type.equals((Object)that.getType()) && (this.arrayType == null ? that.getArrayType() == null : this.arrayType.equals((Object)that.getArrayType()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.value == null ? 0 : this.value.hashCode();
        h *= 1000003;
        h ^= this.arrayValuesInner == null ? 0 : this.arrayValuesInner.hashCode();
        h *= 1000003;
        h ^= this.type.hashCode();
        h *= 1000003;
        return h ^= this.arrayType == null ? 0 : this.arrayType.hashCode();
    }

    @Override
    public QueryParameterValue.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends QueryParameterValue.Builder {
        private String value;
        private ImmutableList<QueryParameterValue> arrayValuesInner;
        private StandardSQLTypeName type;
        private StandardSQLTypeName arrayType;

        Builder() {
        }

        Builder(QueryParameterValue source) {
            this.value = source.getValue();
            this.arrayValuesInner = source.getArrayValuesInner();
            this.type = source.getType();
            this.arrayType = source.getArrayType();
        }

        @Override
        public QueryParameterValue.Builder setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        @Override
        public QueryParameterValue.Builder setArrayValuesInner(@Nullable ImmutableList<QueryParameterValue> arrayValuesInner) {
            this.arrayValuesInner = arrayValuesInner;
            return this;
        }

        @Override
        public QueryParameterValue.Builder setType(StandardSQLTypeName type) {
            this.type = type;
            return this;
        }

        @Override
        public QueryParameterValue.Builder setArrayType(@Nullable StandardSQLTypeName arrayType) {
            this.arrayType = arrayType;
            return this;
        }

        @Override
        public QueryParameterValue autoBuild() {
            String missing = "";
            if (this.type == null) {
                missing = missing + " type";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_QueryParameterValue(this.value, this.arrayValuesInner, this.type, this.arrayType);
        }
    }
}

