/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.Field;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class Schema
implements Serializable {
    static final Function<TableSchema, Schema> FROM_PB_FUNCTION = new Function<TableSchema, Schema>(){

        public Schema apply(TableSchema pb) {
            return Schema.fromPb(pb);
        }
    };
    static final Function<Schema, TableSchema> TO_PB_FUNCTION = new Function<Schema, TableSchema>(){

        public TableSchema apply(Schema schema) {
            return schema.toPb();
        }
    };
    private static final long serialVersionUID = 2007400596384553696L;
    private final List<Field> fields;

    private Schema(Builder builder) {
        this.fields = builder.fields != null ? ImmutableList.copyOf((Collection)builder.fields) : ImmutableList.of();
    }

    public List<Field> fields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return Schema.builder().fields(this.fields);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fields", this.fields).toString();
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Schema && Objects.equals(this.toPb(), ((Schema)obj).toPb());
    }

    TableSchema toPb() {
        TableSchema tableSchemaPb = new TableSchema();
        if (this.fields != null) {
            List fieldsPb = Lists.transform(this.fields, Field.TO_PB_FUNCTION);
            tableSchemaPb.setFields(fieldsPb);
        }
        return tableSchemaPb;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Schema of(Iterable<Field> fields) {
        return Schema.builder().fields(fields).build();
    }

    public static Schema of(Field ... fields) {
        return Schema.builder().fields(fields).build();
    }

    static Schema fromPb(TableSchema tableSchemaPb) {
        return Schema.of(Lists.transform((List)tableSchemaPb.getFields(), Field.FROM_PB_FUNCTION));
    }

    public static final class Builder {
        private List<Field> fields;

        private Builder() {
        }

        public Builder addField(Field field) {
            if (this.fields == null) {
                this.fields = Lists.newArrayList();
            }
            this.fields.add((Field)Preconditions.checkNotNull((Object)field));
            return this;
        }

        public Builder fields(Iterable<Field> fields) {
            this.fields = Lists.newArrayList((Iterable)((Iterable)Preconditions.checkNotNull(fields)));
            return this;
        }

        public Builder fields(Field ... fields) {
            this.fields = Lists.newArrayList((Object[])fields);
            return this;
        }

        public Schema build() {
            return new Schema(this);
        }
    }
}

