/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.QueryParameterType;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class QueryParameterValue
implements Serializable {
    private static final DateTimeFormatter timestampFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSSZZ").withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final DateTimeFormatter timeFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss.SSSSSS");
    private static final DateTimeFormatter datetimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSS");
    static final Function<QueryParameterValue, com.google.api.services.bigquery.model.QueryParameterValue> TO_VALUE_PB_FUNCTION = new Function<QueryParameterValue, com.google.api.services.bigquery.model.QueryParameterValue>(){

        public com.google.api.services.bigquery.model.QueryParameterValue apply(QueryParameterValue value) {
            return value.toValuePb();
        }
    };
    private static final long serialVersionUID = -5620695863123562896L;
    private final String value;
    private final StandardSQLTypeName type;
    private final List<QueryParameterValue> arrayValues;
    private final StandardSQLTypeName arrayType;

    private QueryParameterValue(Builder builder) {
        if (builder.arrayValues != null) {
            Preconditions.checkArgument((boolean)StandardSQLTypeName.ARRAY.equals((Object)builder.type), (Object)"type must be ARRAY if arrayValues is set");
            Preconditions.checkArgument((builder.arrayType != null ? 1 : 0) != 0, (Object)"arrayType must be set if arrayValues is set");
            Preconditions.checkArgument((builder.value == null ? 1 : 0) != 0, (Object)"value can't be set if arrayValues is set");
            this.arrayValues = ImmutableList.copyOf((Collection)builder.arrayValues);
        } else {
            Preconditions.checkArgument((!StandardSQLTypeName.ARRAY.equals((Object)builder.type) ? 1 : 0) != 0, (Object)"type can't be ARRAY if arrayValues is not set");
            Preconditions.checkArgument((builder.arrayType == null ? 1 : 0) != 0, (Object)"arrayType can't be set if arrayValues is not set");
            Preconditions.checkArgument((builder.value != null ? 1 : 0) != 0, (Object)"value must be set if arrayValues is not set");
            this.arrayValues = null;
        }
        this.type = (StandardSQLTypeName)((Object)Preconditions.checkNotNull((Object)((Object)builder.type)));
        this.value = builder.value;
        this.arrayType = builder.arrayType;
    }

    public String getValue() {
        return this.value;
    }

    public List<QueryParameterValue> getArrayValues() {
        return this.arrayValues;
    }

    public StandardSQLTypeName getType() {
        return this.type;
    }

    public StandardSQLTypeName getArrayType() {
        return this.arrayType;
    }

    public static <T> QueryParameterValue of(T value, Class<T> type) {
        return QueryParameterValue.of(value, QueryParameterValue.classToType(type));
    }

    public static <T> QueryParameterValue of(T value, StandardSQLTypeName type) {
        return QueryParameterValue.newBuilder().setValue(QueryParameterValue.valueToStringOrNull(value, type)).setType(type).build();
    }

    public static QueryParameterValue bool(Boolean value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.BOOL);
    }

    public static QueryParameterValue int64(Long value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.INT64);
    }

    public static QueryParameterValue int64(Integer value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.INT64);
    }

    public static QueryParameterValue float64(Double value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.FLOAT64);
    }

    public static QueryParameterValue float64(Float value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.FLOAT64);
    }

    public static QueryParameterValue string(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.STRING);
    }

    public static QueryParameterValue bytes(byte[] value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.BYTES);
    }

    public static QueryParameterValue timestamp(Long value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.TIMESTAMP);
    }

    public static QueryParameterValue timestamp(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.TIMESTAMP);
    }

    public static QueryParameterValue date(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.DATE);
    }

    public static QueryParameterValue time(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.TIME);
    }

    public static QueryParameterValue dateTime(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.DATETIME);
    }

    public static <T> QueryParameterValue array(T[] array, Class<T> clazz) {
        return QueryParameterValue.array(array, QueryParameterValue.classToType(clazz));
    }

    public static <T> QueryParameterValue array(T[] array, StandardSQLTypeName type) {
        ArrayList<QueryParameterValue> listValues = new ArrayList<QueryParameterValue>();
        for (T obj : array) {
            listValues.add(QueryParameterValue.of(obj, type));
        }
        return QueryParameterValue.newBuilder().setArrayValues(listValues).setType(StandardSQLTypeName.ARRAY).setArrayType(type).build();
    }

    private static <T> StandardSQLTypeName classToType(Class<T> type) {
        if (Boolean.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.BOOL;
        }
        if (String.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.STRING;
        }
        if (Integer.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.INT64;
        }
        if (Long.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.INT64;
        }
        if (Double.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.FLOAT64;
        }
        if (Float.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.FLOAT64;
        }
        String string = String.valueOf(String.valueOf(type));
        throw new IllegalArgumentException(new StringBuilder(44 + string.length()).append("Unsupported object type for QueryParameter: ").append(string).toString());
    }

    private static <T> String valueToStringOrNull(T value, StandardSQLTypeName type) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case BOOL: {
                if (!(value instanceof Boolean)) break;
                return value.toString();
            }
            case INT64: {
                if (!(value instanceof Integer) && !(value instanceof Long)) break;
                return value.toString();
            }
            case FLOAT64: {
                if (!(value instanceof Double) && !(value instanceof Float)) break;
                return value.toString();
            }
            case BYTES: {
                if (!(value instanceof byte[])) break;
                return BaseEncoding.base64().encode((byte[])value);
            }
            case STRING: {
                return value.toString();
            }
            case STRUCT: {
                throw new IllegalArgumentException("Cannot convert STRUCT to String value");
            }
            case ARRAY: {
                throw new IllegalArgumentException("Cannot convert ARRAY to String value");
            }
            case TIMESTAMP: {
                if (value instanceof Long) {
                    return timestampFormatter.print((Long)value / 1000L);
                }
                if (!(value instanceof String)) break;
                timestampFormatter.parseMillis((String)value);
                return (String)value;
            }
            case DATE: {
                if (!(value instanceof String)) break;
                dateFormatter.parseMillis((String)value);
                return (String)value;
            }
            case TIME: {
                if (!(value instanceof String)) break;
                timeFormatter.parseMillis((String)value);
                return (String)value;
            }
            case DATETIME: {
                if (!(value instanceof String)) break;
                datetimeFormatter.parseMillis((String)value);
                return (String)value;
            }
            default: {
                String string = String.valueOf(String.valueOf((Object)type));
                throw new UnsupportedOperationException(new StringBuilder(41 + string.length()).append("Implementation error - Unsupported type: ").append(string).toString());
            }
        }
        String string = String.valueOf(String.valueOf((Object)type));
        String string2 = String.valueOf(String.valueOf(value.getClass().getCanonicalName()));
        throw new IllegalArgumentException(new StringBuilder(24 + string.length() + string2.length()).append("Type ").append(string).append(" incompatible with ").append(string2).toString());
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).add("arrayValues", this.arrayValues).add("type", (Object)this.type).add("arrayType", (Object)this.arrayType).toString();
    }

    public int hashCode() {
        return Objects.hash(this.value, this.arrayValues);
    }

    public boolean equals(Object obj) {
        return obj instanceof QueryParameterValue && Objects.equals(this.toValuePb(), ((QueryParameterValue)obj).toValuePb()) && Objects.equals(this.toTypePb(), ((QueryParameterValue)obj).toTypePb());
    }

    com.google.api.services.bigquery.model.QueryParameterValue toValuePb() {
        com.google.api.services.bigquery.model.QueryParameterValue valuePb = new com.google.api.services.bigquery.model.QueryParameterValue();
        valuePb.setValue(this.value);
        if (this.arrayValues != null && !this.arrayValues.isEmpty()) {
            valuePb.setArrayValues(Lists.transform(this.arrayValues, TO_VALUE_PB_FUNCTION));
        }
        return valuePb;
    }

    QueryParameterType toTypePb() {
        QueryParameterType typePb = new QueryParameterType();
        typePb.setType(this.type.toString());
        if (this.arrayType != null) {
            QueryParameterType arrayTypePb = new QueryParameterType();
            arrayTypePb.setType(this.arrayType.toString());
            typePb.setArrayType(arrayTypePb);
        }
        return typePb;
    }

    static QueryParameterValue fromPb(com.google.api.services.bigquery.model.QueryParameterValue valuePb, QueryParameterType typePb) {
        Builder valueBuilder = new Builder();
        valueBuilder.setValue(valuePb.getValue());
        if (valuePb.getArrayValues() != null && valuePb.getArrayValues().size() > 0) {
            ArrayList<QueryParameterValue> arrayValues = new ArrayList<QueryParameterValue>();
            for (com.google.api.services.bigquery.model.QueryParameterValue elementValuePb : valuePb.getArrayValues()) {
                arrayValues.add(QueryParameterValue.fromPb(elementValuePb, typePb.getArrayType()));
            }
            valueBuilder.setArrayValues(arrayValues);
            valueBuilder.setArrayType(StandardSQLTypeName.valueOf(typePb.getArrayType().getType()));
        }
        valueBuilder.setType(StandardSQLTypeName.valueOf(typePb.getType()));
        return valueBuilder.build();
    }

    public static final class Builder {
        private String value;
        private List<QueryParameterValue> arrayValues;
        private StandardSQLTypeName type;
        private StandardSQLTypeName arrayType;

        private Builder() {
        }

        private Builder(QueryParameterValue queryParameterValue) {
            this.value = queryParameterValue.value;
            this.arrayValues = queryParameterValue.arrayValues == null ? null : Lists.newArrayList((Iterable)queryParameterValue.arrayValues);
            this.type = queryParameterValue.type;
            this.arrayType = queryParameterValue.arrayType;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public Builder setArrayValues(List<QueryParameterValue> arrayValues) {
            this.arrayValues = arrayValues == null ? null : Lists.newArrayList(arrayValues);
            return this;
        }

        public Builder setType(StandardSQLTypeName type) {
            this.type = (StandardSQLTypeName)((Object)Preconditions.checkNotNull((Object)((Object)type)));
            return this;
        }

        public Builder setArrayType(StandardSQLTypeName arrayType) {
            this.arrayType = arrayType;
            return this;
        }

        public QueryParameterValue build() {
            return new QueryParameterValue(this);
        }
    }
}

