/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.automl.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.automl.v1beta1.BatchPredictInputConfig;
import com.google.cloud.automl.v1beta1.BatchPredictOutputConfig;
import com.google.cloud.automl.v1beta1.BatchPredictRequest;
import com.google.cloud.automl.v1beta1.BatchPredictResult;
import com.google.cloud.automl.v1beta1.ExamplePayload;
import com.google.cloud.automl.v1beta1.ModelName;
import com.google.cloud.automl.v1beta1.OperationMetadata;
import com.google.cloud.automl.v1beta1.PredictRequest;
import com.google.cloud.automl.v1beta1.PredictResponse;
import com.google.cloud.automl.v1beta1.PredictionServiceSettings;
import com.google.cloud.automl.v1beta1.stub.PredictionServiceStub;
import com.google.cloud.automl.v1beta1.stub.PredictionServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PredictionServiceClient
implements BackgroundResource {
    private final PredictionServiceSettings settings;
    private final PredictionServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final PredictionServiceClient create() throws IOException {
        return PredictionServiceClient.create(PredictionServiceSettings.newBuilder().build());
    }

    public static final PredictionServiceClient create(PredictionServiceSettings settings) throws IOException {
        return new PredictionServiceClient(settings);
    }

    public static final PredictionServiceClient create(PredictionServiceStub stub) {
        return new PredictionServiceClient(stub);
    }

    protected PredictionServiceClient(PredictionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PredictionServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected PredictionServiceClient(PredictionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final PredictionServiceSettings getSettings() {
        return this.settings;
    }

    public PredictionServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final PredictResponse predict(ModelName name, ExamplePayload payload, Map<String, String> params) {
        PredictRequest request = PredictRequest.newBuilder().setName(name == null ? null : name.toString()).setPayload(payload).putAllParams(params).build();
        return this.predict(request);
    }

    public final PredictResponse predict(String name, ExamplePayload payload, Map<String, String> params) {
        PredictRequest request = PredictRequest.newBuilder().setName(name).setPayload(payload).putAllParams(params).build();
        return this.predict(request);
    }

    public final PredictResponse predict(PredictRequest request) {
        return (PredictResponse)this.predictCallable().call((Object)request);
    }

    public final UnaryCallable<PredictRequest, PredictResponse> predictCallable() {
        return this.stub.predictCallable();
    }

    public final OperationFuture<BatchPredictResult, OperationMetadata> batchPredictAsync(ModelName name, BatchPredictInputConfig inputConfig, BatchPredictOutputConfig outputConfig, Map<String, String> params) {
        BatchPredictRequest request = BatchPredictRequest.newBuilder().setName(name == null ? null : name.toString()).setInputConfig(inputConfig).setOutputConfig(outputConfig).putAllParams(params).build();
        return this.batchPredictAsync(request);
    }

    public final OperationFuture<BatchPredictResult, OperationMetadata> batchPredictAsync(String name, BatchPredictInputConfig inputConfig, BatchPredictOutputConfig outputConfig, Map<String, String> params) {
        BatchPredictRequest request = BatchPredictRequest.newBuilder().setName(name).setInputConfig(inputConfig).setOutputConfig(outputConfig).putAllParams(params).build();
        return this.batchPredictAsync(request);
    }

    public final OperationFuture<BatchPredictResult, OperationMetadata> batchPredictAsync(BatchPredictRequest request) {
        return this.batchPredictOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchPredictRequest, BatchPredictResult, OperationMetadata> batchPredictOperationCallable() {
        return this.stub.batchPredictOperationCallable();
    }

    public final UnaryCallable<BatchPredictRequest, Operation> batchPredictCallable() {
        return this.stub.batchPredictCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

