/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.automl.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.automl.v1beta1.AnnotationSpec;
import com.google.cloud.automl.v1beta1.AnnotationSpecName;
import com.google.cloud.automl.v1beta1.AutoMlSettings;
import com.google.cloud.automl.v1beta1.ColumnSpec;
import com.google.cloud.automl.v1beta1.ColumnSpecName;
import com.google.cloud.automl.v1beta1.CreateDatasetRequest;
import com.google.cloud.automl.v1beta1.CreateModelRequest;
import com.google.cloud.automl.v1beta1.Dataset;
import com.google.cloud.automl.v1beta1.DatasetName;
import com.google.cloud.automl.v1beta1.DeleteDatasetRequest;
import com.google.cloud.automl.v1beta1.DeleteModelRequest;
import com.google.cloud.automl.v1beta1.DeployModelRequest;
import com.google.cloud.automl.v1beta1.ExportDataRequest;
import com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOutputConfig;
import com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesRequest;
import com.google.cloud.automl.v1beta1.ExportModelRequest;
import com.google.cloud.automl.v1beta1.GetAnnotationSpecRequest;
import com.google.cloud.automl.v1beta1.GetColumnSpecRequest;
import com.google.cloud.automl.v1beta1.GetDatasetRequest;
import com.google.cloud.automl.v1beta1.GetModelEvaluationRequest;
import com.google.cloud.automl.v1beta1.GetModelRequest;
import com.google.cloud.automl.v1beta1.GetTableSpecRequest;
import com.google.cloud.automl.v1beta1.ImportDataRequest;
import com.google.cloud.automl.v1beta1.InputConfig;
import com.google.cloud.automl.v1beta1.ListColumnSpecsRequest;
import com.google.cloud.automl.v1beta1.ListColumnSpecsResponse;
import com.google.cloud.automl.v1beta1.ListDatasetsRequest;
import com.google.cloud.automl.v1beta1.ListDatasetsResponse;
import com.google.cloud.automl.v1beta1.ListModelEvaluationsRequest;
import com.google.cloud.automl.v1beta1.ListModelEvaluationsResponse;
import com.google.cloud.automl.v1beta1.ListModelsRequest;
import com.google.cloud.automl.v1beta1.ListModelsResponse;
import com.google.cloud.automl.v1beta1.ListTableSpecsRequest;
import com.google.cloud.automl.v1beta1.ListTableSpecsResponse;
import com.google.cloud.automl.v1beta1.LocationName;
import com.google.cloud.automl.v1beta1.Model;
import com.google.cloud.automl.v1beta1.ModelEvaluation;
import com.google.cloud.automl.v1beta1.ModelEvaluationName;
import com.google.cloud.automl.v1beta1.ModelExportOutputConfig;
import com.google.cloud.automl.v1beta1.ModelName;
import com.google.cloud.automl.v1beta1.OperationMetadata;
import com.google.cloud.automl.v1beta1.OutputConfig;
import com.google.cloud.automl.v1beta1.TableSpec;
import com.google.cloud.automl.v1beta1.TableSpecName;
import com.google.cloud.automl.v1beta1.UndeployModelRequest;
import com.google.cloud.automl.v1beta1.UpdateColumnSpecRequest;
import com.google.cloud.automl.v1beta1.UpdateDatasetRequest;
import com.google.cloud.automl.v1beta1.UpdateTableSpecRequest;
import com.google.cloud.automl.v1beta1.stub.AutoMlStub;
import com.google.cloud.automl.v1beta1.stub.AutoMlStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AutoMlClient
implements BackgroundResource {
    private final AutoMlSettings settings;
    private final AutoMlStub stub;
    private final OperationsClient operationsClient;

    public static final AutoMlClient create() throws IOException {
        return AutoMlClient.create(AutoMlSettings.newBuilder().build());
    }

    public static final AutoMlClient create(AutoMlSettings settings) throws IOException {
        return new AutoMlClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AutoMlClient create(AutoMlStub stub) {
        return new AutoMlClient(stub);
    }

    protected AutoMlClient(AutoMlSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AutoMlStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AutoMlClient(AutoMlStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final AutoMlSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AutoMlStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Dataset createDataset(LocationName parent, Dataset dataset) {
        CreateDatasetRequest request = CreateDatasetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataset(dataset).build();
        return this.createDataset(request);
    }

    public final Dataset createDataset(String parent, Dataset dataset) {
        CreateDatasetRequest request = CreateDatasetRequest.newBuilder().setParent(parent).setDataset(dataset).build();
        return this.createDataset(request);
    }

    public final Dataset createDataset(CreateDatasetRequest request) {
        return (Dataset)this.createDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDatasetRequest, Dataset> createDatasetCallable() {
        return this.stub.createDatasetCallable();
    }

    public final Dataset getDataset(DatasetName name) {
        GetDatasetRequest request = GetDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataset(request);
    }

    public final Dataset getDataset(String name) {
        GetDatasetRequest request = GetDatasetRequest.newBuilder().setName(name).build();
        return this.getDataset(request);
    }

    public final Dataset getDataset(GetDatasetRequest request) {
        return (Dataset)this.getDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable() {
        return this.stub.getDatasetCallable();
    }

    public final ListDatasetsPagedResponse listDatasets(LocationName parent) {
        ListDatasetsRequest request = ListDatasetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatasets(request);
    }

    public final ListDatasetsPagedResponse listDatasets(String parent) {
        ListDatasetsRequest request = ListDatasetsRequest.newBuilder().setParent(parent).build();
        return this.listDatasets(request);
    }

    public final ListDatasetsPagedResponse listDatasets(ListDatasetsRequest request) {
        return (ListDatasetsPagedResponse)((Object)this.listDatasetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsPagedResponse> listDatasetsPagedCallable() {
        return this.stub.listDatasetsPagedCallable();
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable() {
        return this.stub.listDatasetsCallable();
    }

    public final Dataset updateDataset(Dataset dataset) {
        UpdateDatasetRequest request = UpdateDatasetRequest.newBuilder().setDataset(dataset).build();
        return this.updateDataset(request);
    }

    public final Dataset updateDataset(UpdateDatasetRequest request) {
        return (Dataset)this.updateDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDatasetRequest, Dataset> updateDatasetCallable() {
        return this.stub.updateDatasetCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteDatasetAsync(DatasetName name) {
        DeleteDatasetRequest request = DeleteDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDatasetAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteDatasetAsync(String name) {
        DeleteDatasetRequest request = DeleteDatasetRequest.newBuilder().setName(name).build();
        return this.deleteDatasetAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteDatasetAsync(DeleteDatasetRequest request) {
        return this.deleteDatasetOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<DeleteDatasetRequest, Empty, OperationMetadata> deleteDatasetOperationCallable() {
        return this.stub.deleteDatasetOperationCallable();
    }

    public final UnaryCallable<DeleteDatasetRequest, Operation> deleteDatasetCallable() {
        return this.stub.deleteDatasetCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> importDataAsync(DatasetName name, InputConfig inputConfig) {
        ImportDataRequest request = ImportDataRequest.newBuilder().setName(name == null ? null : name.toString()).setInputConfig(inputConfig).build();
        return this.importDataAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> importDataAsync(String name, InputConfig inputConfig) {
        ImportDataRequest request = ImportDataRequest.newBuilder().setName(name).setInputConfig(inputConfig).build();
        return this.importDataAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> importDataAsync(ImportDataRequest request) {
        return this.importDataOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<ImportDataRequest, Empty, OperationMetadata> importDataOperationCallable() {
        return this.stub.importDataOperationCallable();
    }

    public final UnaryCallable<ImportDataRequest, Operation> importDataCallable() {
        return this.stub.importDataCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> exportDataAsync(DatasetName name, OutputConfig outputConfig) {
        ExportDataRequest request = ExportDataRequest.newBuilder().setName(name == null ? null : name.toString()).setOutputConfig(outputConfig).build();
        return this.exportDataAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> exportDataAsync(String name, OutputConfig outputConfig) {
        ExportDataRequest request = ExportDataRequest.newBuilder().setName(name).setOutputConfig(outputConfig).build();
        return this.exportDataAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> exportDataAsync(ExportDataRequest request) {
        return this.exportDataOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<ExportDataRequest, Empty, OperationMetadata> exportDataOperationCallable() {
        return this.stub.exportDataOperationCallable();
    }

    public final UnaryCallable<ExportDataRequest, Operation> exportDataCallable() {
        return this.stub.exportDataCallable();
    }

    public final AnnotationSpec getAnnotationSpec(AnnotationSpecName name) {
        GetAnnotationSpecRequest request = GetAnnotationSpecRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAnnotationSpec(request);
    }

    public final AnnotationSpec getAnnotationSpec(String name) {
        GetAnnotationSpecRequest request = GetAnnotationSpecRequest.newBuilder().setName(name).build();
        return this.getAnnotationSpec(request);
    }

    public final AnnotationSpec getAnnotationSpec(GetAnnotationSpecRequest request) {
        return (AnnotationSpec)this.getAnnotationSpecCallable().call((Object)request);
    }

    public final UnaryCallable<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecCallable() {
        return this.stub.getAnnotationSpecCallable();
    }

    public final TableSpec getTableSpec(TableSpecName name) {
        GetTableSpecRequest request = GetTableSpecRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTableSpec(request);
    }

    public final TableSpec getTableSpec(String name) {
        GetTableSpecRequest request = GetTableSpecRequest.newBuilder().setName(name).build();
        return this.getTableSpec(request);
    }

    public final TableSpec getTableSpec(GetTableSpecRequest request) {
        return (TableSpec)this.getTableSpecCallable().call((Object)request);
    }

    public final UnaryCallable<GetTableSpecRequest, TableSpec> getTableSpecCallable() {
        return this.stub.getTableSpecCallable();
    }

    public final ListTableSpecsPagedResponse listTableSpecs(DatasetName parent) {
        ListTableSpecsRequest request = ListTableSpecsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTableSpecs(request);
    }

    public final ListTableSpecsPagedResponse listTableSpecs(String parent) {
        ListTableSpecsRequest request = ListTableSpecsRequest.newBuilder().setParent(parent).build();
        return this.listTableSpecs(request);
    }

    public final ListTableSpecsPagedResponse listTableSpecs(ListTableSpecsRequest request) {
        return (ListTableSpecsPagedResponse)((Object)this.listTableSpecsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTableSpecsRequest, ListTableSpecsPagedResponse> listTableSpecsPagedCallable() {
        return this.stub.listTableSpecsPagedCallable();
    }

    public final UnaryCallable<ListTableSpecsRequest, ListTableSpecsResponse> listTableSpecsCallable() {
        return this.stub.listTableSpecsCallable();
    }

    public final TableSpec updateTableSpec(TableSpec tableSpec) {
        UpdateTableSpecRequest request = UpdateTableSpecRequest.newBuilder().setTableSpec(tableSpec).build();
        return this.updateTableSpec(request);
    }

    public final TableSpec updateTableSpec(UpdateTableSpecRequest request) {
        return (TableSpec)this.updateTableSpecCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTableSpecRequest, TableSpec> updateTableSpecCallable() {
        return this.stub.updateTableSpecCallable();
    }

    public final ColumnSpec getColumnSpec(ColumnSpecName name) {
        GetColumnSpecRequest request = GetColumnSpecRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getColumnSpec(request);
    }

    public final ColumnSpec getColumnSpec(String name) {
        GetColumnSpecRequest request = GetColumnSpecRequest.newBuilder().setName(name).build();
        return this.getColumnSpec(request);
    }

    public final ColumnSpec getColumnSpec(GetColumnSpecRequest request) {
        return (ColumnSpec)this.getColumnSpecCallable().call((Object)request);
    }

    public final UnaryCallable<GetColumnSpecRequest, ColumnSpec> getColumnSpecCallable() {
        return this.stub.getColumnSpecCallable();
    }

    public final ListColumnSpecsPagedResponse listColumnSpecs(TableSpecName parent) {
        ListColumnSpecsRequest request = ListColumnSpecsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listColumnSpecs(request);
    }

    public final ListColumnSpecsPagedResponse listColumnSpecs(String parent) {
        ListColumnSpecsRequest request = ListColumnSpecsRequest.newBuilder().setParent(parent).build();
        return this.listColumnSpecs(request);
    }

    public final ListColumnSpecsPagedResponse listColumnSpecs(ListColumnSpecsRequest request) {
        return (ListColumnSpecsPagedResponse)((Object)this.listColumnSpecsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListColumnSpecsRequest, ListColumnSpecsPagedResponse> listColumnSpecsPagedCallable() {
        return this.stub.listColumnSpecsPagedCallable();
    }

    public final UnaryCallable<ListColumnSpecsRequest, ListColumnSpecsResponse> listColumnSpecsCallable() {
        return this.stub.listColumnSpecsCallable();
    }

    public final ColumnSpec updateColumnSpec(ColumnSpec columnSpec) {
        UpdateColumnSpecRequest request = UpdateColumnSpecRequest.newBuilder().setColumnSpec(columnSpec).build();
        return this.updateColumnSpec(request);
    }

    public final ColumnSpec updateColumnSpec(UpdateColumnSpecRequest request) {
        return (ColumnSpec)this.updateColumnSpecCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateColumnSpecRequest, ColumnSpec> updateColumnSpecCallable() {
        return this.stub.updateColumnSpecCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Model, OperationMetadata> createModelAsync(LocationName parent, Model model) {
        CreateModelRequest request = CreateModelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModel(model).build();
        return this.createModelAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Model, OperationMetadata> createModelAsync(String parent, Model model) {
        CreateModelRequest request = CreateModelRequest.newBuilder().setParent(parent).setModel(model).build();
        return this.createModelAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Model, OperationMetadata> createModelAsync(CreateModelRequest request) {
        return this.createModelOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateModelRequest, Model, OperationMetadata> createModelOperationCallable() {
        return this.stub.createModelOperationCallable();
    }

    public final UnaryCallable<CreateModelRequest, Operation> createModelCallable() {
        return this.stub.createModelCallable();
    }

    public final Model getModel(ModelName name) {
        GetModelRequest request = GetModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getModel(request);
    }

    public final Model getModel(String name) {
        GetModelRequest request = GetModelRequest.newBuilder().setName(name).build();
        return this.getModel(request);
    }

    public final Model getModel(GetModelRequest request) {
        return (Model)this.getModelCallable().call((Object)request);
    }

    public final UnaryCallable<GetModelRequest, Model> getModelCallable() {
        return this.stub.getModelCallable();
    }

    public final ListModelsPagedResponse listModels(LocationName parent) {
        ListModelsRequest request = ListModelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listModels(request);
    }

    public final ListModelsPagedResponse listModels(String parent) {
        ListModelsRequest request = ListModelsRequest.newBuilder().setParent(parent).build();
        return this.listModels(request);
    }

    public final ListModelsPagedResponse listModels(ListModelsRequest request) {
        return (ListModelsPagedResponse)((Object)this.listModelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelsRequest, ListModelsPagedResponse> listModelsPagedCallable() {
        return this.stub.listModelsPagedCallable();
    }

    public final UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable() {
        return this.stub.listModelsCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteModelAsync(ModelName name) {
        DeleteModelRequest request = DeleteModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteModelAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteModelAsync(String name) {
        DeleteModelRequest request = DeleteModelRequest.newBuilder().setName(name).build();
        return this.deleteModelAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteModelAsync(DeleteModelRequest request) {
        return this.deleteModelOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<DeleteModelRequest, Empty, OperationMetadata> deleteModelOperationCallable() {
        return this.stub.deleteModelOperationCallable();
    }

    public final UnaryCallable<DeleteModelRequest, Operation> deleteModelCallable() {
        return this.stub.deleteModelCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deployModelAsync(ModelName name) {
        DeployModelRequest request = DeployModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deployModelAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deployModelAsync(String name) {
        DeployModelRequest request = DeployModelRequest.newBuilder().setName(name).build();
        return this.deployModelAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deployModelAsync(DeployModelRequest request) {
        return this.deployModelOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<DeployModelRequest, Empty, OperationMetadata> deployModelOperationCallable() {
        return this.stub.deployModelOperationCallable();
    }

    public final UnaryCallable<DeployModelRequest, Operation> deployModelCallable() {
        return this.stub.deployModelCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> undeployModelAsync(ModelName name) {
        UndeployModelRequest request = UndeployModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.undeployModelAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> undeployModelAsync(String name) {
        UndeployModelRequest request = UndeployModelRequest.newBuilder().setName(name).build();
        return this.undeployModelAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> undeployModelAsync(UndeployModelRequest request) {
        return this.undeployModelOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<UndeployModelRequest, Empty, OperationMetadata> undeployModelOperationCallable() {
        return this.stub.undeployModelOperationCallable();
    }

    public final UnaryCallable<UndeployModelRequest, Operation> undeployModelCallable() {
        return this.stub.undeployModelCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> exportModelAsync(ModelName name, ModelExportOutputConfig outputConfig) {
        ExportModelRequest request = ExportModelRequest.newBuilder().setName(name == null ? null : name.toString()).setOutputConfig(outputConfig).build();
        return this.exportModelAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> exportModelAsync(String name, ModelExportOutputConfig outputConfig) {
        ExportModelRequest request = ExportModelRequest.newBuilder().setName(name).setOutputConfig(outputConfig).build();
        return this.exportModelAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> exportModelAsync(ExportModelRequest request) {
        return this.exportModelOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<ExportModelRequest, Empty, OperationMetadata> exportModelOperationCallable() {
        return this.stub.exportModelOperationCallable();
    }

    public final UnaryCallable<ExportModelRequest, Operation> exportModelCallable() {
        return this.stub.exportModelCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> exportEvaluatedExamplesAsync(ModelName name, ExportEvaluatedExamplesOutputConfig outputConfig) {
        ExportEvaluatedExamplesRequest request = ExportEvaluatedExamplesRequest.newBuilder().setName(name == null ? null : name.toString()).setOutputConfig(outputConfig).build();
        return this.exportEvaluatedExamplesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> exportEvaluatedExamplesAsync(String name, ExportEvaluatedExamplesOutputConfig outputConfig) {
        ExportEvaluatedExamplesRequest request = ExportEvaluatedExamplesRequest.newBuilder().setName(name).setOutputConfig(outputConfig).build();
        return this.exportEvaluatedExamplesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> exportEvaluatedExamplesAsync(ExportEvaluatedExamplesRequest request) {
        return this.exportEvaluatedExamplesOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<ExportEvaluatedExamplesRequest, Empty, OperationMetadata> exportEvaluatedExamplesOperationCallable() {
        return this.stub.exportEvaluatedExamplesOperationCallable();
    }

    public final UnaryCallable<ExportEvaluatedExamplesRequest, Operation> exportEvaluatedExamplesCallable() {
        return this.stub.exportEvaluatedExamplesCallable();
    }

    public final ModelEvaluation getModelEvaluation(ModelEvaluationName name) {
        GetModelEvaluationRequest request = GetModelEvaluationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getModelEvaluation(request);
    }

    public final ModelEvaluation getModelEvaluation(String name) {
        GetModelEvaluationRequest request = GetModelEvaluationRequest.newBuilder().setName(name).build();
        return this.getModelEvaluation(request);
    }

    public final ModelEvaluation getModelEvaluation(GetModelEvaluationRequest request) {
        return (ModelEvaluation)this.getModelEvaluationCallable().call((Object)request);
    }

    public final UnaryCallable<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationCallable() {
        return this.stub.getModelEvaluationCallable();
    }

    public final ListModelEvaluationsPagedResponse listModelEvaluations(ModelName parent) {
        ListModelEvaluationsRequest request = ListModelEvaluationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listModelEvaluations(request);
    }

    public final ListModelEvaluationsPagedResponse listModelEvaluations(String parent) {
        ListModelEvaluationsRequest request = ListModelEvaluationsRequest.newBuilder().setParent(parent).build();
        return this.listModelEvaluations(request);
    }

    public final ListModelEvaluationsPagedResponse listModelEvaluations(ListModelEvaluationsRequest request) {
        return (ListModelEvaluationsPagedResponse)((Object)this.listModelEvaluationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsPagedResponse> listModelEvaluationsPagedCallable() {
        return this.stub.listModelEvaluationsPagedCallable();
    }

    public final UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsResponse> listModelEvaluationsCallable() {
        return this.stub.listModelEvaluationsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListModelEvaluationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation, ListModelEvaluationsPage, ListModelEvaluationsFixedSizeCollection> {
        private ListModelEvaluationsFixedSizeCollection(List<ListModelEvaluationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelEvaluationsFixedSizeCollection createEmptyCollection() {
            return new ListModelEvaluationsFixedSizeCollection(null, 0);
        }

        protected ListModelEvaluationsFixedSizeCollection createCollection(List<ListModelEvaluationsPage> pages, int collectionSize) {
            return new ListModelEvaluationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelEvaluationsPage
    extends AbstractPage<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation, ListModelEvaluationsPage> {
        private ListModelEvaluationsPage(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ListModelEvaluationsResponse response) {
            super(context, (Object)response);
        }

        private static ListModelEvaluationsPage createEmptyPage() {
            return new ListModelEvaluationsPage(null, null);
        }

        protected ListModelEvaluationsPage createPage(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ListModelEvaluationsResponse response) {
            return new ListModelEvaluationsPage(context, response);
        }

        public ApiFuture<ListModelEvaluationsPage> createPageAsync(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ApiFuture<ListModelEvaluationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelEvaluationsPagedResponse
    extends AbstractPagedListResponse<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation, ListModelEvaluationsPage, ListModelEvaluationsFixedSizeCollection> {
        public static ApiFuture<ListModelEvaluationsPagedResponse> createAsync(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ApiFuture<ListModelEvaluationsResponse> futureResponse) {
            ApiFuture<ListModelEvaluationsPage> futurePage = ListModelEvaluationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListModelEvaluationsPage, ListModelEvaluationsPagedResponse>(){

                public ListModelEvaluationsPagedResponse apply(ListModelEvaluationsPage input) {
                    return new ListModelEvaluationsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListModelEvaluationsPagedResponse(ListModelEvaluationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelEvaluationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListModelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelsRequest, ListModelsResponse, Model, ListModelsPage, ListModelsFixedSizeCollection> {
        private ListModelsFixedSizeCollection(List<ListModelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelsFixedSizeCollection createEmptyCollection() {
            return new ListModelsFixedSizeCollection(null, 0);
        }

        protected ListModelsFixedSizeCollection createCollection(List<ListModelsPage> pages, int collectionSize) {
            return new ListModelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelsPage
    extends AbstractPage<ListModelsRequest, ListModelsResponse, Model, ListModelsPage> {
        private ListModelsPage(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ListModelsResponse response) {
            super(context, (Object)response);
        }

        private static ListModelsPage createEmptyPage() {
            return new ListModelsPage(null, null);
        }

        protected ListModelsPage createPage(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ListModelsResponse response) {
            return new ListModelsPage(context, response);
        }

        public ApiFuture<ListModelsPage> createPageAsync(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ApiFuture<ListModelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelsPagedResponse
    extends AbstractPagedListResponse<ListModelsRequest, ListModelsResponse, Model, ListModelsPage, ListModelsFixedSizeCollection> {
        public static ApiFuture<ListModelsPagedResponse> createAsync(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ApiFuture<ListModelsResponse> futureResponse) {
            ApiFuture<ListModelsPage> futurePage = ListModelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListModelsPage, ListModelsPagedResponse>(){

                public ListModelsPagedResponse apply(ListModelsPage input) {
                    return new ListModelsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListModelsPagedResponse(ListModelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListColumnSpecsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListColumnSpecsRequest, ListColumnSpecsResponse, ColumnSpec, ListColumnSpecsPage, ListColumnSpecsFixedSizeCollection> {
        private ListColumnSpecsFixedSizeCollection(List<ListColumnSpecsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListColumnSpecsFixedSizeCollection createEmptyCollection() {
            return new ListColumnSpecsFixedSizeCollection(null, 0);
        }

        protected ListColumnSpecsFixedSizeCollection createCollection(List<ListColumnSpecsPage> pages, int collectionSize) {
            return new ListColumnSpecsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListColumnSpecsPage
    extends AbstractPage<ListColumnSpecsRequest, ListColumnSpecsResponse, ColumnSpec, ListColumnSpecsPage> {
        private ListColumnSpecsPage(PageContext<ListColumnSpecsRequest, ListColumnSpecsResponse, ColumnSpec> context, ListColumnSpecsResponse response) {
            super(context, (Object)response);
        }

        private static ListColumnSpecsPage createEmptyPage() {
            return new ListColumnSpecsPage(null, null);
        }

        protected ListColumnSpecsPage createPage(PageContext<ListColumnSpecsRequest, ListColumnSpecsResponse, ColumnSpec> context, ListColumnSpecsResponse response) {
            return new ListColumnSpecsPage(context, response);
        }

        public ApiFuture<ListColumnSpecsPage> createPageAsync(PageContext<ListColumnSpecsRequest, ListColumnSpecsResponse, ColumnSpec> context, ApiFuture<ListColumnSpecsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListColumnSpecsPagedResponse
    extends AbstractPagedListResponse<ListColumnSpecsRequest, ListColumnSpecsResponse, ColumnSpec, ListColumnSpecsPage, ListColumnSpecsFixedSizeCollection> {
        public static ApiFuture<ListColumnSpecsPagedResponse> createAsync(PageContext<ListColumnSpecsRequest, ListColumnSpecsResponse, ColumnSpec> context, ApiFuture<ListColumnSpecsResponse> futureResponse) {
            ApiFuture<ListColumnSpecsPage> futurePage = ListColumnSpecsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListColumnSpecsPage, ListColumnSpecsPagedResponse>(){

                public ListColumnSpecsPagedResponse apply(ListColumnSpecsPage input) {
                    return new ListColumnSpecsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListColumnSpecsPagedResponse(ListColumnSpecsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListColumnSpecsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTableSpecsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTableSpecsRequest, ListTableSpecsResponse, TableSpec, ListTableSpecsPage, ListTableSpecsFixedSizeCollection> {
        private ListTableSpecsFixedSizeCollection(List<ListTableSpecsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTableSpecsFixedSizeCollection createEmptyCollection() {
            return new ListTableSpecsFixedSizeCollection(null, 0);
        }

        protected ListTableSpecsFixedSizeCollection createCollection(List<ListTableSpecsPage> pages, int collectionSize) {
            return new ListTableSpecsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTableSpecsPage
    extends AbstractPage<ListTableSpecsRequest, ListTableSpecsResponse, TableSpec, ListTableSpecsPage> {
        private ListTableSpecsPage(PageContext<ListTableSpecsRequest, ListTableSpecsResponse, TableSpec> context, ListTableSpecsResponse response) {
            super(context, (Object)response);
        }

        private static ListTableSpecsPage createEmptyPage() {
            return new ListTableSpecsPage(null, null);
        }

        protected ListTableSpecsPage createPage(PageContext<ListTableSpecsRequest, ListTableSpecsResponse, TableSpec> context, ListTableSpecsResponse response) {
            return new ListTableSpecsPage(context, response);
        }

        public ApiFuture<ListTableSpecsPage> createPageAsync(PageContext<ListTableSpecsRequest, ListTableSpecsResponse, TableSpec> context, ApiFuture<ListTableSpecsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTableSpecsPagedResponse
    extends AbstractPagedListResponse<ListTableSpecsRequest, ListTableSpecsResponse, TableSpec, ListTableSpecsPage, ListTableSpecsFixedSizeCollection> {
        public static ApiFuture<ListTableSpecsPagedResponse> createAsync(PageContext<ListTableSpecsRequest, ListTableSpecsResponse, TableSpec> context, ApiFuture<ListTableSpecsResponse> futureResponse) {
            ApiFuture<ListTableSpecsPage> futurePage = ListTableSpecsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTableSpecsPage, ListTableSpecsPagedResponse>(){

                public ListTableSpecsPagedResponse apply(ListTableSpecsPage input) {
                    return new ListTableSpecsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTableSpecsPagedResponse(ListTableSpecsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTableSpecsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDatasetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        private ListDatasetsFixedSizeCollection(List<ListDatasetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatasetsFixedSizeCollection createEmptyCollection() {
            return new ListDatasetsFixedSizeCollection(null, 0);
        }

        protected ListDatasetsFixedSizeCollection createCollection(List<ListDatasetsPage> pages, int collectionSize) {
            return new ListDatasetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatasetsPage
    extends AbstractPage<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage> {
        private ListDatasetsPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            super(context, (Object)response);
        }

        private static ListDatasetsPage createEmptyPage() {
            return new ListDatasetsPage(null, null);
        }

        protected ListDatasetsPage createPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            return new ListDatasetsPage(context, response);
        }

        public ApiFuture<ListDatasetsPage> createPageAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatasetsPagedResponse
    extends AbstractPagedListResponse<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        public static ApiFuture<ListDatasetsPagedResponse> createAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            ApiFuture<ListDatasetsPage> futurePage = ListDatasetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListDatasetsPage, ListDatasetsPagedResponse>(){

                public ListDatasetsPagedResponse apply(ListDatasetsPage input) {
                    return new ListDatasetsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListDatasetsPagedResponse(ListDatasetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatasetsFixedSizeCollection.createEmptyCollection());
        }
    }
}

