/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.automl.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.automl.v1.BatchPredictInputConfig;
import com.google.cloud.automl.v1.BatchPredictOutputConfig;
import com.google.cloud.automl.v1.BatchPredictRequest;
import com.google.cloud.automl.v1.BatchPredictResult;
import com.google.cloud.automl.v1.ExamplePayload;
import com.google.cloud.automl.v1.ModelName;
import com.google.cloud.automl.v1.OperationMetadata;
import com.google.cloud.automl.v1.PredictRequest;
import com.google.cloud.automl.v1.PredictResponse;
import com.google.cloud.automl.v1.PredictionServiceSettings;
import com.google.cloud.automl.v1.stub.PredictionServiceStub;
import com.google.cloud.automl.v1.stub.PredictionServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PredictionServiceClient
implements BackgroundResource {
    private final PredictionServiceSettings settings;
    private final PredictionServiceStub stub;
    private final OperationsClient operationsClient;

    public static final PredictionServiceClient create() throws IOException {
        return PredictionServiceClient.create(PredictionServiceSettings.newBuilder().build());
    }

    public static final PredictionServiceClient create(PredictionServiceSettings settings) throws IOException {
        return new PredictionServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final PredictionServiceClient create(PredictionServiceStub stub) {
        return new PredictionServiceClient(stub);
    }

    protected PredictionServiceClient(PredictionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PredictionServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected PredictionServiceClient(PredictionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final PredictionServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PredictionServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final PredictResponse predict(ModelName name, ExamplePayload payload, Map<String, String> params) {
        PredictRequest request = PredictRequest.newBuilder().setName(name == null ? null : name.toString()).setPayload(payload).putAllParams(params).build();
        return this.predict(request);
    }

    public final PredictResponse predict(String name, ExamplePayload payload, Map<String, String> params) {
        PredictRequest request = PredictRequest.newBuilder().setName(name).setPayload(payload).putAllParams(params).build();
        return this.predict(request);
    }

    public final PredictResponse predict(PredictRequest request) {
        return (PredictResponse)this.predictCallable().call((Object)request);
    }

    public final UnaryCallable<PredictRequest, PredictResponse> predictCallable() {
        return this.stub.predictCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<BatchPredictResult, OperationMetadata> batchPredictAsync(ModelName name, BatchPredictInputConfig inputConfig, BatchPredictOutputConfig outputConfig, Map<String, String> params) {
        BatchPredictRequest request = BatchPredictRequest.newBuilder().setName(name == null ? null : name.toString()).setInputConfig(inputConfig).setOutputConfig(outputConfig).putAllParams(params).build();
        return this.batchPredictAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<BatchPredictResult, OperationMetadata> batchPredictAsync(String name, BatchPredictInputConfig inputConfig, BatchPredictOutputConfig outputConfig, Map<String, String> params) {
        BatchPredictRequest request = BatchPredictRequest.newBuilder().setName(name).setInputConfig(inputConfig).setOutputConfig(outputConfig).putAllParams(params).build();
        return this.batchPredictAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<BatchPredictResult, OperationMetadata> batchPredictAsync(BatchPredictRequest request) {
        return this.batchPredictOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<BatchPredictRequest, BatchPredictResult, OperationMetadata> batchPredictOperationCallable() {
        return this.stub.batchPredictOperationCallable();
    }

    public final UnaryCallable<BatchPredictRequest, Operation> batchPredictCallable() {
        return this.stub.batchPredictCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

