/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.assuredworkloads.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.assuredworkloads.v1beta1.AnalyzeWorkloadMoveRequest;
import com.google.cloud.assuredworkloads.v1beta1.AnalyzeWorkloadMoveResponse;
import com.google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsServiceSettings;
import com.google.cloud.assuredworkloads.v1beta1.CreateWorkloadOperationMetadata;
import com.google.cloud.assuredworkloads.v1beta1.CreateWorkloadRequest;
import com.google.cloud.assuredworkloads.v1beta1.DeleteWorkloadRequest;
import com.google.cloud.assuredworkloads.v1beta1.GetWorkloadRequest;
import com.google.cloud.assuredworkloads.v1beta1.ListWorkloadsRequest;
import com.google.cloud.assuredworkloads.v1beta1.ListWorkloadsResponse;
import com.google.cloud.assuredworkloads.v1beta1.LocationName;
import com.google.cloud.assuredworkloads.v1beta1.RestrictAllowedResourcesRequest;
import com.google.cloud.assuredworkloads.v1beta1.RestrictAllowedResourcesResponse;
import com.google.cloud.assuredworkloads.v1beta1.UpdateWorkloadRequest;
import com.google.cloud.assuredworkloads.v1beta1.Workload;
import com.google.cloud.assuredworkloads.v1beta1.WorkloadName;
import com.google.cloud.assuredworkloads.v1beta1.stub.AssuredWorkloadsServiceStub;
import com.google.cloud.assuredworkloads.v1beta1.stub.AssuredWorkloadsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AssuredWorkloadsServiceClient
implements BackgroundResource {
    private final AssuredWorkloadsServiceSettings settings;
    private final AssuredWorkloadsServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final AssuredWorkloadsServiceClient create() throws IOException {
        return AssuredWorkloadsServiceClient.create(AssuredWorkloadsServiceSettings.newBuilder().build());
    }

    public static final AssuredWorkloadsServiceClient create(AssuredWorkloadsServiceSettings settings) throws IOException {
        return new AssuredWorkloadsServiceClient(settings);
    }

    public static final AssuredWorkloadsServiceClient create(AssuredWorkloadsServiceStub stub) {
        return new AssuredWorkloadsServiceClient(stub);
    }

    protected AssuredWorkloadsServiceClient(AssuredWorkloadsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AssuredWorkloadsServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected AssuredWorkloadsServiceClient(AssuredWorkloadsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final AssuredWorkloadsServiceSettings getSettings() {
        return this.settings;
    }

    public AssuredWorkloadsServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Workload, CreateWorkloadOperationMetadata> createWorkloadAsync(LocationName parent, Workload workload) {
        CreateWorkloadRequest request = CreateWorkloadRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWorkload(workload).build();
        return this.createWorkloadAsync(request);
    }

    public final OperationFuture<Workload, CreateWorkloadOperationMetadata> createWorkloadAsync(String parent, Workload workload) {
        CreateWorkloadRequest request = CreateWorkloadRequest.newBuilder().setParent(parent).setWorkload(workload).build();
        return this.createWorkloadAsync(request);
    }

    public final OperationFuture<Workload, CreateWorkloadOperationMetadata> createWorkloadAsync(CreateWorkloadRequest request) {
        return this.createWorkloadOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateWorkloadRequest, Workload, CreateWorkloadOperationMetadata> createWorkloadOperationCallable() {
        return this.stub.createWorkloadOperationCallable();
    }

    public final UnaryCallable<CreateWorkloadRequest, Operation> createWorkloadCallable() {
        return this.stub.createWorkloadCallable();
    }

    public final Workload updateWorkload(Workload workload, FieldMask updateMask) {
        UpdateWorkloadRequest request = UpdateWorkloadRequest.newBuilder().setWorkload(workload).setUpdateMask(updateMask).build();
        return this.updateWorkload(request);
    }

    public final Workload updateWorkload(UpdateWorkloadRequest request) {
        return (Workload)this.updateWorkloadCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateWorkloadRequest, Workload> updateWorkloadCallable() {
        return this.stub.updateWorkloadCallable();
    }

    public final RestrictAllowedResourcesResponse restrictAllowedResources(RestrictAllowedResourcesRequest request) {
        return (RestrictAllowedResourcesResponse)this.restrictAllowedResourcesCallable().call((Object)request);
    }

    public final UnaryCallable<RestrictAllowedResourcesRequest, RestrictAllowedResourcesResponse> restrictAllowedResourcesCallable() {
        return this.stub.restrictAllowedResourcesCallable();
    }

    public final void deleteWorkload(WorkloadName name) {
        DeleteWorkloadRequest request = DeleteWorkloadRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteWorkload(request);
    }

    public final void deleteWorkload(String name) {
        DeleteWorkloadRequest request = DeleteWorkloadRequest.newBuilder().setName(name).build();
        this.deleteWorkload(request);
    }

    public final void deleteWorkload(DeleteWorkloadRequest request) {
        this.deleteWorkloadCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteWorkloadRequest, Empty> deleteWorkloadCallable() {
        return this.stub.deleteWorkloadCallable();
    }

    public final Workload getWorkload(WorkloadName name) {
        GetWorkloadRequest request = GetWorkloadRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkload(request);
    }

    public final Workload getWorkload(String name) {
        GetWorkloadRequest request = GetWorkloadRequest.newBuilder().setName(name).build();
        return this.getWorkload(request);
    }

    public final Workload getWorkload(GetWorkloadRequest request) {
        return (Workload)this.getWorkloadCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkloadRequest, Workload> getWorkloadCallable() {
        return this.stub.getWorkloadCallable();
    }

    public final AnalyzeWorkloadMoveResponse analyzeWorkloadMove(String project, String target) {
        AnalyzeWorkloadMoveRequest request = AnalyzeWorkloadMoveRequest.newBuilder().setProject(project).setTarget(target).build();
        return this.analyzeWorkloadMove(request);
    }

    public final AnalyzeWorkloadMoveResponse analyzeWorkloadMove(AnalyzeWorkloadMoveRequest request) {
        return (AnalyzeWorkloadMoveResponse)this.analyzeWorkloadMoveCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeWorkloadMoveRequest, AnalyzeWorkloadMoveResponse> analyzeWorkloadMoveCallable() {
        return this.stub.analyzeWorkloadMoveCallable();
    }

    public final ListWorkloadsPagedResponse listWorkloads(LocationName parent) {
        ListWorkloadsRequest request = ListWorkloadsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkloads(request);
    }

    public final ListWorkloadsPagedResponse listWorkloads(String parent) {
        ListWorkloadsRequest request = ListWorkloadsRequest.newBuilder().setParent(parent).build();
        return this.listWorkloads(request);
    }

    public final ListWorkloadsPagedResponse listWorkloads(ListWorkloadsRequest request) {
        return (ListWorkloadsPagedResponse)((Object)this.listWorkloadsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkloadsRequest, ListWorkloadsPagedResponse> listWorkloadsPagedCallable() {
        return this.stub.listWorkloadsPagedCallable();
    }

    public final UnaryCallable<ListWorkloadsRequest, ListWorkloadsResponse> listWorkloadsCallable() {
        return this.stub.listWorkloadsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListWorkloadsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkloadsRequest, ListWorkloadsResponse, Workload, ListWorkloadsPage, ListWorkloadsFixedSizeCollection> {
        private ListWorkloadsFixedSizeCollection(List<ListWorkloadsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkloadsFixedSizeCollection createEmptyCollection() {
            return new ListWorkloadsFixedSizeCollection(null, 0);
        }

        protected ListWorkloadsFixedSizeCollection createCollection(List<ListWorkloadsPage> pages, int collectionSize) {
            return new ListWorkloadsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkloadsPage
    extends AbstractPage<ListWorkloadsRequest, ListWorkloadsResponse, Workload, ListWorkloadsPage> {
        private ListWorkloadsPage(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, Workload> context, ListWorkloadsResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkloadsPage createEmptyPage() {
            return new ListWorkloadsPage(null, null);
        }

        protected ListWorkloadsPage createPage(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, Workload> context, ListWorkloadsResponse response) {
            return new ListWorkloadsPage(context, response);
        }

        public ApiFuture<ListWorkloadsPage> createPageAsync(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, Workload> context, ApiFuture<ListWorkloadsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkloadsPagedResponse
    extends AbstractPagedListResponse<ListWorkloadsRequest, ListWorkloadsResponse, Workload, ListWorkloadsPage, ListWorkloadsFixedSizeCollection> {
        public static ApiFuture<ListWorkloadsPagedResponse> createAsync(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, Workload> context, ApiFuture<ListWorkloadsResponse> futureResponse) {
            ApiFuture<ListWorkloadsPage> futurePage = ListWorkloadsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWorkloadsPagedResponse((ListWorkloadsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkloadsPagedResponse(ListWorkloadsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkloadsFixedSizeCollection.createEmptyCollection());
        }
    }
}

