/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.assuredworkloads.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.assuredworkloads.v1.AssuredWorkloadsServiceClient;
import com.google.cloud.assuredworkloads.v1.CreateWorkloadOperationMetadata;
import com.google.cloud.assuredworkloads.v1.CreateWorkloadRequest;
import com.google.cloud.assuredworkloads.v1.DeleteWorkloadRequest;
import com.google.cloud.assuredworkloads.v1.GetWorkloadRequest;
import com.google.cloud.assuredworkloads.v1.ListWorkloadsRequest;
import com.google.cloud.assuredworkloads.v1.ListWorkloadsResponse;
import com.google.cloud.assuredworkloads.v1.UpdateWorkloadRequest;
import com.google.cloud.assuredworkloads.v1.Workload;
import com.google.cloud.assuredworkloads.v1.stub.AssuredWorkloadsServiceStub;
import com.google.cloud.assuredworkloads.v1.stub.AssuredWorkloadsServiceStubSettings;
import com.google.cloud.assuredworkloads.v1.stub.GrpcAssuredWorkloadsServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAssuredWorkloadsServiceStub
extends AssuredWorkloadsServiceStub {
    private static final MethodDescriptor<CreateWorkloadRequest, Operation> createWorkloadMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.assuredworkloads.v1.AssuredWorkloadsService/CreateWorkload").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateWorkloadRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateWorkloadRequest, Workload> updateWorkloadMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.assuredworkloads.v1.AssuredWorkloadsService/UpdateWorkload").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateWorkloadRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Workload.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteWorkloadRequest, Empty> deleteWorkloadMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.assuredworkloads.v1.AssuredWorkloadsService/DeleteWorkload").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteWorkloadRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetWorkloadRequest, Workload> getWorkloadMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.assuredworkloads.v1.AssuredWorkloadsService/GetWorkload").setRequestMarshaller(ProtoUtils.marshaller((Message)GetWorkloadRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Workload.getDefaultInstance())).build();
    private static final MethodDescriptor<ListWorkloadsRequest, ListWorkloadsResponse> listWorkloadsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.assuredworkloads.v1.AssuredWorkloadsService/ListWorkloads").setRequestMarshaller(ProtoUtils.marshaller((Message)ListWorkloadsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListWorkloadsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateWorkloadRequest, Operation> createWorkloadCallable;
    private final OperationCallable<CreateWorkloadRequest, Workload, CreateWorkloadOperationMetadata> createWorkloadOperationCallable;
    private final UnaryCallable<UpdateWorkloadRequest, Workload> updateWorkloadCallable;
    private final UnaryCallable<DeleteWorkloadRequest, Empty> deleteWorkloadCallable;
    private final UnaryCallable<GetWorkloadRequest, Workload> getWorkloadCallable;
    private final UnaryCallable<ListWorkloadsRequest, ListWorkloadsResponse> listWorkloadsCallable;
    private final UnaryCallable<ListWorkloadsRequest, AssuredWorkloadsServiceClient.ListWorkloadsPagedResponse> listWorkloadsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAssuredWorkloadsServiceStub create(AssuredWorkloadsServiceStubSettings settings) throws IOException {
        return new GrpcAssuredWorkloadsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAssuredWorkloadsServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAssuredWorkloadsServiceStub(AssuredWorkloadsServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAssuredWorkloadsServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAssuredWorkloadsServiceStub(AssuredWorkloadsServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAssuredWorkloadsServiceStub(AssuredWorkloadsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAssuredWorkloadsServiceCallableFactory());
    }

    protected GrpcAssuredWorkloadsServiceStub(AssuredWorkloadsServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createWorkloadTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createWorkloadMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateWorkloadTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateWorkloadMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"workload.name", (Object)String.valueOf(request.getWorkload().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteWorkloadTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteWorkloadMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getWorkloadTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getWorkloadMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listWorkloadsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listWorkloadsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        this.createWorkloadCallable = callableFactory.createUnaryCallable(createWorkloadTransportSettings, settings.createWorkloadSettings(), clientContext);
        this.createWorkloadOperationCallable = callableFactory.createOperationCallable(createWorkloadTransportSettings, settings.createWorkloadOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateWorkloadCallable = callableFactory.createUnaryCallable(updateWorkloadTransportSettings, settings.updateWorkloadSettings(), clientContext);
        this.deleteWorkloadCallable = callableFactory.createUnaryCallable(deleteWorkloadTransportSettings, settings.deleteWorkloadSettings(), clientContext);
        this.getWorkloadCallable = callableFactory.createUnaryCallable(getWorkloadTransportSettings, settings.getWorkloadSettings(), clientContext);
        this.listWorkloadsCallable = callableFactory.createUnaryCallable(listWorkloadsTransportSettings, settings.listWorkloadsSettings(), clientContext);
        this.listWorkloadsPagedCallable = callableFactory.createPagedCallable(listWorkloadsTransportSettings, settings.listWorkloadsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateWorkloadRequest, Operation> createWorkloadCallable() {
        return this.createWorkloadCallable;
    }

    @Override
    public OperationCallable<CreateWorkloadRequest, Workload, CreateWorkloadOperationMetadata> createWorkloadOperationCallable() {
        return this.createWorkloadOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateWorkloadRequest, Workload> updateWorkloadCallable() {
        return this.updateWorkloadCallable;
    }

    @Override
    public UnaryCallable<DeleteWorkloadRequest, Empty> deleteWorkloadCallable() {
        return this.deleteWorkloadCallable;
    }

    @Override
    public UnaryCallable<GetWorkloadRequest, Workload> getWorkloadCallable() {
        return this.getWorkloadCallable;
    }

    @Override
    public UnaryCallable<ListWorkloadsRequest, ListWorkloadsResponse> listWorkloadsCallable() {
        return this.listWorkloadsCallable;
    }

    @Override
    public UnaryCallable<ListWorkloadsRequest, AssuredWorkloadsServiceClient.ListWorkloadsPagedResponse> listWorkloadsPagedCallable() {
        return this.listWorkloadsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

