/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1p1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.asset.v1p1beta1.AssetServiceClient;
import com.google.cloud.asset.v1p1beta1.IamPolicySearchResult;
import com.google.cloud.asset.v1p1beta1.SearchAllIamPoliciesRequest;
import com.google.cloud.asset.v1p1beta1.SearchAllIamPoliciesResponse;
import com.google.cloud.asset.v1p1beta1.SearchAllResourcesRequest;
import com.google.cloud.asset.v1p1beta1.SearchAllResourcesResponse;
import com.google.cloud.asset.v1p1beta1.StandardResourceMetadata;
import com.google.cloud.asset.v1p1beta1.stub.AssetServiceStub;
import com.google.cloud.asset.v1p1beta1.stub.GrpcAssetServiceStub;
import com.google.cloud.asset.v1p1beta1.stub.HttpJsonAssetServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class AssetServiceStubSettings
extends StubSettings<AssetServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<SearchAllResourcesRequest, SearchAllResourcesResponse, AssetServiceClient.SearchAllResourcesPagedResponse> searchAllResourcesSettings;
    private final PagedCallSettings<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, AssetServiceClient.SearchAllIamPoliciesPagedResponse> searchAllIamPoliciesSettings;
    private static final PagedListDescriptor<SearchAllResourcesRequest, SearchAllResourcesResponse, StandardResourceMetadata> SEARCH_ALL_RESOURCES_PAGE_STR_DESC = new PagedListDescriptor<SearchAllResourcesRequest, SearchAllResourcesResponse, StandardResourceMetadata>(){

        public String emptyToken() {
            return "";
        }

        public SearchAllResourcesRequest injectToken(SearchAllResourcesRequest payload, String token) {
            return SearchAllResourcesRequest.newBuilder((SearchAllResourcesRequest)payload).setPageToken(token).build();
        }

        public SearchAllResourcesRequest injectPageSize(SearchAllResourcesRequest payload, int pageSize) {
            return SearchAllResourcesRequest.newBuilder((SearchAllResourcesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchAllResourcesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchAllResourcesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<StandardResourceMetadata> extractResources(SearchAllResourcesResponse payload) {
            return payload.getResultsList();
        }
    };
    private static final PagedListDescriptor<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult> SEARCH_ALL_IAM_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult>(){

        public String emptyToken() {
            return "";
        }

        public SearchAllIamPoliciesRequest injectToken(SearchAllIamPoliciesRequest payload, String token) {
            return SearchAllIamPoliciesRequest.newBuilder((SearchAllIamPoliciesRequest)payload).setPageToken(token).build();
        }

        public SearchAllIamPoliciesRequest injectPageSize(SearchAllIamPoliciesRequest payload, int pageSize) {
            return SearchAllIamPoliciesRequest.newBuilder((SearchAllIamPoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchAllIamPoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchAllIamPoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<IamPolicySearchResult> extractResources(SearchAllIamPoliciesResponse payload) {
            return payload.getResultsList();
        }
    };
    private static final PagedListResponseFactory<SearchAllResourcesRequest, SearchAllResourcesResponse, AssetServiceClient.SearchAllResourcesPagedResponse> SEARCH_ALL_RESOURCES_PAGE_STR_FACT = new PagedListResponseFactory<SearchAllResourcesRequest, SearchAllResourcesResponse, AssetServiceClient.SearchAllResourcesPagedResponse>(){

        public ApiFuture<AssetServiceClient.SearchAllResourcesPagedResponse> getFuturePagedResponse(UnaryCallable<SearchAllResourcesRequest, SearchAllResourcesResponse> callable, SearchAllResourcesRequest request, ApiCallContext context, ApiFuture<SearchAllResourcesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_ALL_RESOURCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AssetServiceClient.SearchAllResourcesPagedResponse.createAsync((PageContext<SearchAllResourcesRequest, SearchAllResourcesResponse, StandardResourceMetadata>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, AssetServiceClient.SearchAllIamPoliciesPagedResponse> SEARCH_ALL_IAM_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, AssetServiceClient.SearchAllIamPoliciesPagedResponse>(){

        public ApiFuture<AssetServiceClient.SearchAllIamPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse> callable, SearchAllIamPoliciesRequest request, ApiCallContext context, ApiFuture<SearchAllIamPoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_ALL_IAM_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AssetServiceClient.SearchAllIamPoliciesPagedResponse.createAsync((PageContext<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<SearchAllResourcesRequest, SearchAllResourcesResponse, AssetServiceClient.SearchAllResourcesPagedResponse> searchAllResourcesSettings() {
        return this.searchAllResourcesSettings;
    }

    public PagedCallSettings<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, AssetServiceClient.SearchAllIamPoliciesPagedResponse> searchAllIamPoliciesSettings() {
        return this.searchAllIamPoliciesSettings;
    }

    public AssetServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAssetServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAssetServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudasset";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudasset.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudasset.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AssetServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AssetServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AssetServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AssetServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AssetServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.searchAllResourcesSettings = settingsBuilder.searchAllResourcesSettings().build();
        this.searchAllIamPoliciesSettings = settingsBuilder.searchAllIamPoliciesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AssetServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<SearchAllResourcesRequest, SearchAllResourcesResponse, AssetServiceClient.SearchAllResourcesPagedResponse> searchAllResourcesSettings;
        private final PagedCallSettings.Builder<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, AssetServiceClient.SearchAllIamPoliciesPagedResponse> searchAllIamPoliciesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.searchAllResourcesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_ALL_RESOURCES_PAGE_STR_FACT);
            this.searchAllIamPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_ALL_IAM_POLICIES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchAllResourcesSettings, this.searchAllIamPoliciesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AssetServiceStubSettings settings) {
            super((StubSettings)settings);
            this.searchAllResourcesSettings = settings.searchAllResourcesSettings.toBuilder();
            this.searchAllIamPoliciesSettings = settings.searchAllIamPoliciesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchAllResourcesSettings, this.searchAllIamPoliciesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AssetServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AssetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AssetServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AssetServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AssetServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AssetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AssetServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AssetServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.searchAllResourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.searchAllIamPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<SearchAllResourcesRequest, SearchAllResourcesResponse, AssetServiceClient.SearchAllResourcesPagedResponse> searchAllResourcesSettings() {
            return this.searchAllResourcesSettings;
        }

        public PagedCallSettings.Builder<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, AssetServiceClient.SearchAllIamPoliciesPagedResponse> searchAllIamPoliciesSettings() {
            return this.searchAllIamPoliciesSettings;
        }

        public AssetServiceStubSettings build() throws IOException {
            return new AssetServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(15000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(15000L)).setTotalTimeoutDuration(Duration.ofMillis(15000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

