/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1p1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.asset.v1p1beta1.AssetServiceSettings;
import com.google.cloud.asset.v1p1beta1.IamPolicySearchResult;
import com.google.cloud.asset.v1p1beta1.SearchAllIamPoliciesRequest;
import com.google.cloud.asset.v1p1beta1.SearchAllIamPoliciesResponse;
import com.google.cloud.asset.v1p1beta1.SearchAllResourcesRequest;
import com.google.cloud.asset.v1p1beta1.SearchAllResourcesResponse;
import com.google.cloud.asset.v1p1beta1.StandardResourceMetadata;
import com.google.cloud.asset.v1p1beta1.stub.AssetServiceStub;
import com.google.cloud.asset.v1p1beta1.stub.AssetServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AssetServiceClient
implements BackgroundResource {
    private final AssetServiceSettings settings;
    private final AssetServiceStub stub;

    public static final AssetServiceClient create() throws IOException {
        return AssetServiceClient.create(AssetServiceSettings.newBuilder().build());
    }

    public static final AssetServiceClient create(AssetServiceSettings settings) throws IOException {
        return new AssetServiceClient(settings);
    }

    public static final AssetServiceClient create(AssetServiceStub stub) {
        return new AssetServiceClient(stub);
    }

    protected AssetServiceClient(AssetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AssetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AssetServiceClient(AssetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AssetServiceSettings getSettings() {
        return this.settings;
    }

    public AssetServiceStub getStub() {
        return this.stub;
    }

    public final SearchAllResourcesPagedResponse searchAllResources(String scope, String query, List<String> assetTypes) {
        SearchAllResourcesRequest request = SearchAllResourcesRequest.newBuilder().setScope(scope).setQuery(query).addAllAssetTypes(assetTypes).build();
        return this.searchAllResources(request);
    }

    public final SearchAllResourcesPagedResponse searchAllResources(SearchAllResourcesRequest request) {
        return (SearchAllResourcesPagedResponse)((Object)this.searchAllResourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchAllResourcesRequest, SearchAllResourcesPagedResponse> searchAllResourcesPagedCallable() {
        return this.stub.searchAllResourcesPagedCallable();
    }

    public final UnaryCallable<SearchAllResourcesRequest, SearchAllResourcesResponse> searchAllResourcesCallable() {
        return this.stub.searchAllResourcesCallable();
    }

    public final SearchAllIamPoliciesPagedResponse searchAllIamPolicies(String scope, String query) {
        SearchAllIamPoliciesRequest request = SearchAllIamPoliciesRequest.newBuilder().setScope(scope).setQuery(query).build();
        return this.searchAllIamPolicies(request);
    }

    public final SearchAllIamPoliciesPagedResponse searchAllIamPolicies(SearchAllIamPoliciesRequest request) {
        return (SearchAllIamPoliciesPagedResponse)((Object)this.searchAllIamPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchAllIamPoliciesRequest, SearchAllIamPoliciesPagedResponse> searchAllIamPoliciesPagedCallable() {
        return this.stub.searchAllIamPoliciesPagedCallable();
    }

    public final UnaryCallable<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse> searchAllIamPoliciesCallable() {
        return this.stub.searchAllIamPoliciesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchAllIamPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult, SearchAllIamPoliciesPage, SearchAllIamPoliciesFixedSizeCollection> {
        private SearchAllIamPoliciesFixedSizeCollection(List<SearchAllIamPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchAllIamPoliciesFixedSizeCollection createEmptyCollection() {
            return new SearchAllIamPoliciesFixedSizeCollection(null, 0);
        }

        protected SearchAllIamPoliciesFixedSizeCollection createCollection(List<SearchAllIamPoliciesPage> pages, int collectionSize) {
            return new SearchAllIamPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchAllIamPoliciesPage
    extends AbstractPage<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult, SearchAllIamPoliciesPage> {
        private SearchAllIamPoliciesPage(PageContext<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult> context, SearchAllIamPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static SearchAllIamPoliciesPage createEmptyPage() {
            return new SearchAllIamPoliciesPage(null, null);
        }

        protected SearchAllIamPoliciesPage createPage(PageContext<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult> context, SearchAllIamPoliciesResponse response) {
            return new SearchAllIamPoliciesPage(context, response);
        }

        public ApiFuture<SearchAllIamPoliciesPage> createPageAsync(PageContext<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult> context, ApiFuture<SearchAllIamPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchAllIamPoliciesPagedResponse
    extends AbstractPagedListResponse<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult, SearchAllIamPoliciesPage, SearchAllIamPoliciesFixedSizeCollection> {
        public static ApiFuture<SearchAllIamPoliciesPagedResponse> createAsync(PageContext<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult> context, ApiFuture<SearchAllIamPoliciesResponse> futureResponse) {
            ApiFuture<SearchAllIamPoliciesPage> futurePage = SearchAllIamPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchAllIamPoliciesPagedResponse((SearchAllIamPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchAllIamPoliciesPagedResponse(SearchAllIamPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchAllIamPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchAllResourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchAllResourcesRequest, SearchAllResourcesResponse, StandardResourceMetadata, SearchAllResourcesPage, SearchAllResourcesFixedSizeCollection> {
        private SearchAllResourcesFixedSizeCollection(List<SearchAllResourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchAllResourcesFixedSizeCollection createEmptyCollection() {
            return new SearchAllResourcesFixedSizeCollection(null, 0);
        }

        protected SearchAllResourcesFixedSizeCollection createCollection(List<SearchAllResourcesPage> pages, int collectionSize) {
            return new SearchAllResourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchAllResourcesPage
    extends AbstractPage<SearchAllResourcesRequest, SearchAllResourcesResponse, StandardResourceMetadata, SearchAllResourcesPage> {
        private SearchAllResourcesPage(PageContext<SearchAllResourcesRequest, SearchAllResourcesResponse, StandardResourceMetadata> context, SearchAllResourcesResponse response) {
            super(context, (Object)response);
        }

        private static SearchAllResourcesPage createEmptyPage() {
            return new SearchAllResourcesPage(null, null);
        }

        protected SearchAllResourcesPage createPage(PageContext<SearchAllResourcesRequest, SearchAllResourcesResponse, StandardResourceMetadata> context, SearchAllResourcesResponse response) {
            return new SearchAllResourcesPage(context, response);
        }

        public ApiFuture<SearchAllResourcesPage> createPageAsync(PageContext<SearchAllResourcesRequest, SearchAllResourcesResponse, StandardResourceMetadata> context, ApiFuture<SearchAllResourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchAllResourcesPagedResponse
    extends AbstractPagedListResponse<SearchAllResourcesRequest, SearchAllResourcesResponse, StandardResourceMetadata, SearchAllResourcesPage, SearchAllResourcesFixedSizeCollection> {
        public static ApiFuture<SearchAllResourcesPagedResponse> createAsync(PageContext<SearchAllResourcesRequest, SearchAllResourcesResponse, StandardResourceMetadata> context, ApiFuture<SearchAllResourcesResponse> futureResponse) {
            ApiFuture<SearchAllResourcesPage> futurePage = SearchAllResourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchAllResourcesPagedResponse((SearchAllResourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchAllResourcesPagedResponse(SearchAllResourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchAllResourcesFixedSizeCollection.createEmptyCollection());
        }
    }
}

