/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.ApiHubInstance;
import com.google.cloud.apihub.v1.CreateApiHubInstanceRequest;
import com.google.cloud.apihub.v1.GetApiHubInstanceRequest;
import com.google.cloud.apihub.v1.LookupApiHubInstanceRequest;
import com.google.cloud.apihub.v1.LookupApiHubInstanceResponse;
import com.google.cloud.apihub.v1.OperationMetadata;
import com.google.cloud.apihub.v1.ProvisioningClient;
import com.google.cloud.apihub.v1.stub.GrpcProvisioningCallableFactory;
import com.google.cloud.apihub.v1.stub.ProvisioningStub;
import com.google.cloud.apihub.v1.stub.ProvisioningStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcProvisioningStub
extends ProvisioningStub {
    private static final MethodDescriptor<CreateApiHubInstanceRequest, Operation> createApiHubInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apihub.v1.Provisioning/CreateApiHubInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateApiHubInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetApiHubInstanceRequest, ApiHubInstance> getApiHubInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apihub.v1.Provisioning/GetApiHubInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)GetApiHubInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ApiHubInstance.getDefaultInstance())).build();
    private static final MethodDescriptor<LookupApiHubInstanceRequest, LookupApiHubInstanceResponse> lookupApiHubInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apihub.v1.Provisioning/LookupApiHubInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)LookupApiHubInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)LookupApiHubInstanceResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<CreateApiHubInstanceRequest, Operation> createApiHubInstanceCallable;
    private final OperationCallable<CreateApiHubInstanceRequest, ApiHubInstance, OperationMetadata> createApiHubInstanceOperationCallable;
    private final UnaryCallable<GetApiHubInstanceRequest, ApiHubInstance> getApiHubInstanceCallable;
    private final UnaryCallable<LookupApiHubInstanceRequest, LookupApiHubInstanceResponse> lookupApiHubInstanceCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ProvisioningClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcProvisioningStub create(ProvisioningStubSettings settings) throws IOException {
        return new GrpcProvisioningStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcProvisioningStub create(ClientContext clientContext) throws IOException {
        return new GrpcProvisioningStub(ProvisioningStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcProvisioningStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcProvisioningStub(ProvisioningStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcProvisioningStub(ProvisioningStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcProvisioningCallableFactory());
    }

    protected GrpcProvisioningStub(ProvisioningStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createApiHubInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createApiHubInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getApiHubInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getApiHubInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings lookupApiHubInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(lookupApiHubInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createApiHubInstanceCallable = callableFactory.createUnaryCallable(createApiHubInstanceTransportSettings, settings.createApiHubInstanceSettings(), clientContext);
        this.createApiHubInstanceOperationCallable = callableFactory.createOperationCallable(createApiHubInstanceTransportSettings, settings.createApiHubInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getApiHubInstanceCallable = callableFactory.createUnaryCallable(getApiHubInstanceTransportSettings, settings.getApiHubInstanceSettings(), clientContext);
        this.lookupApiHubInstanceCallable = callableFactory.createUnaryCallable(lookupApiHubInstanceTransportSettings, settings.lookupApiHubInstanceSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateApiHubInstanceRequest, Operation> createApiHubInstanceCallable() {
        return this.createApiHubInstanceCallable;
    }

    @Override
    public OperationCallable<CreateApiHubInstanceRequest, ApiHubInstance, OperationMetadata> createApiHubInstanceOperationCallable() {
        return this.createApiHubInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<GetApiHubInstanceRequest, ApiHubInstance> getApiHubInstanceCallable() {
        return this.getApiHubInstanceCallable;
    }

    @Override
    public UnaryCallable<LookupApiHubInstanceRequest, LookupApiHubInstanceResponse> lookupApiHubInstanceCallable() {
        return this.lookupApiHubInstanceCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ProvisioningClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

