/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.CreateSpecialistPoolOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateSpecialistPoolRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.DeleteSpecialistPoolRequest;
import com.google.cloud.aiplatform.v1.GetSpecialistPoolRequest;
import com.google.cloud.aiplatform.v1.ListSpecialistPoolsRequest;
import com.google.cloud.aiplatform.v1.ListSpecialistPoolsResponse;
import com.google.cloud.aiplatform.v1.SpecialistPool;
import com.google.cloud.aiplatform.v1.SpecialistPoolServiceClient;
import com.google.cloud.aiplatform.v1.UpdateSpecialistPoolOperationMetadata;
import com.google.cloud.aiplatform.v1.UpdateSpecialistPoolRequest;
import com.google.cloud.aiplatform.v1.stub.GrpcSpecialistPoolServiceCallableFactory;
import com.google.cloud.aiplatform.v1.stub.SpecialistPoolServiceStub;
import com.google.cloud.aiplatform.v1.stub.SpecialistPoolServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcSpecialistPoolServiceStub
extends SpecialistPoolServiceStub {
    private static final MethodDescriptor<CreateSpecialistPoolRequest, Operation> createSpecialistPoolMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.SpecialistPoolService/CreateSpecialistPool").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSpecialistPoolRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetSpecialistPoolRequest, SpecialistPool> getSpecialistPoolMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.SpecialistPoolService/GetSpecialistPool").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSpecialistPoolRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SpecialistPool.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse> listSpecialistPoolsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.SpecialistPoolService/ListSpecialistPools").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSpecialistPoolsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSpecialistPoolsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteSpecialistPoolRequest, Operation> deleteSpecialistPoolMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.SpecialistPoolService/DeleteSpecialistPool").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSpecialistPoolRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateSpecialistPoolRequest, Operation> updateSpecialistPoolMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.SpecialistPoolService/UpdateSpecialistPool").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSpecialistPoolRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateSpecialistPoolRequest, Operation> createSpecialistPoolCallable;
    private final OperationCallable<CreateSpecialistPoolRequest, SpecialistPool, CreateSpecialistPoolOperationMetadata> createSpecialistPoolOperationCallable;
    private final UnaryCallable<GetSpecialistPoolRequest, SpecialistPool> getSpecialistPoolCallable;
    private final UnaryCallable<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse> listSpecialistPoolsCallable;
    private final UnaryCallable<ListSpecialistPoolsRequest, SpecialistPoolServiceClient.ListSpecialistPoolsPagedResponse> listSpecialistPoolsPagedCallable;
    private final UnaryCallable<DeleteSpecialistPoolRequest, Operation> deleteSpecialistPoolCallable;
    private final OperationCallable<DeleteSpecialistPoolRequest, Empty, DeleteOperationMetadata> deleteSpecialistPoolOperationCallable;
    private final UnaryCallable<UpdateSpecialistPoolRequest, Operation> updateSpecialistPoolCallable;
    private final OperationCallable<UpdateSpecialistPoolRequest, SpecialistPool, UpdateSpecialistPoolOperationMetadata> updateSpecialistPoolOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, SpecialistPoolServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSpecialistPoolServiceStub create(SpecialistPoolServiceStubSettings settings) throws IOException {
        return new GrpcSpecialistPoolServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSpecialistPoolServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcSpecialistPoolServiceStub(SpecialistPoolServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSpecialistPoolServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSpecialistPoolServiceStub(SpecialistPoolServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSpecialistPoolServiceStub(SpecialistPoolServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSpecialistPoolServiceCallableFactory());
    }

    protected GrpcSpecialistPoolServiceStub(SpecialistPoolServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createSpecialistPoolTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSpecialistPoolMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getSpecialistPoolTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSpecialistPoolMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listSpecialistPoolsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSpecialistPoolsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteSpecialistPoolTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSpecialistPoolMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateSpecialistPoolTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSpecialistPoolMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("specialist_pool.name", String.valueOf(request.getSpecialistPool().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createSpecialistPoolCallable = callableFactory.createUnaryCallable(createSpecialistPoolTransportSettings, settings.createSpecialistPoolSettings(), clientContext);
        this.createSpecialistPoolOperationCallable = callableFactory.createOperationCallable(createSpecialistPoolTransportSettings, settings.createSpecialistPoolOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getSpecialistPoolCallable = callableFactory.createUnaryCallable(getSpecialistPoolTransportSettings, settings.getSpecialistPoolSettings(), clientContext);
        this.listSpecialistPoolsCallable = callableFactory.createUnaryCallable(listSpecialistPoolsTransportSettings, settings.listSpecialistPoolsSettings(), clientContext);
        this.listSpecialistPoolsPagedCallable = callableFactory.createPagedCallable(listSpecialistPoolsTransportSettings, settings.listSpecialistPoolsSettings(), clientContext);
        this.deleteSpecialistPoolCallable = callableFactory.createUnaryCallable(deleteSpecialistPoolTransportSettings, settings.deleteSpecialistPoolSettings(), clientContext);
        this.deleteSpecialistPoolOperationCallable = callableFactory.createOperationCallable(deleteSpecialistPoolTransportSettings, settings.deleteSpecialistPoolOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateSpecialistPoolCallable = callableFactory.createUnaryCallable(updateSpecialistPoolTransportSettings, settings.updateSpecialistPoolSettings(), clientContext);
        this.updateSpecialistPoolOperationCallable = callableFactory.createOperationCallable(updateSpecialistPoolTransportSettings, settings.updateSpecialistPoolOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateSpecialistPoolRequest, Operation> createSpecialistPoolCallable() {
        return this.createSpecialistPoolCallable;
    }

    @Override
    public OperationCallable<CreateSpecialistPoolRequest, SpecialistPool, CreateSpecialistPoolOperationMetadata> createSpecialistPoolOperationCallable() {
        return this.createSpecialistPoolOperationCallable;
    }

    @Override
    public UnaryCallable<GetSpecialistPoolRequest, SpecialistPool> getSpecialistPoolCallable() {
        return this.getSpecialistPoolCallable;
    }

    @Override
    public UnaryCallable<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse> listSpecialistPoolsCallable() {
        return this.listSpecialistPoolsCallable;
    }

    @Override
    public UnaryCallable<ListSpecialistPoolsRequest, SpecialistPoolServiceClient.ListSpecialistPoolsPagedResponse> listSpecialistPoolsPagedCallable() {
        return this.listSpecialistPoolsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteSpecialistPoolRequest, Operation> deleteSpecialistPoolCallable() {
        return this.deleteSpecialistPoolCallable;
    }

    @Override
    public OperationCallable<DeleteSpecialistPoolRequest, Empty, DeleteOperationMetadata> deleteSpecialistPoolOperationCallable() {
        return this.deleteSpecialistPoolOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateSpecialistPoolRequest, Operation> updateSpecialistPoolCallable() {
        return this.updateSpecialistPoolCallable;
    }

    @Override
    public OperationCallable<UpdateSpecialistPoolRequest, SpecialistPool, UpdateSpecialistPoolOperationMetadata> updateSpecialistPoolOperationCallable() {
        return this.updateSpecialistPoolOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, SpecialistPoolServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

