/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.BatchCancelPipelineJobsOperationMetadata;
import com.google.cloud.aiplatform.v1.BatchCancelPipelineJobsRequest;
import com.google.cloud.aiplatform.v1.BatchCancelPipelineJobsResponse;
import com.google.cloud.aiplatform.v1.BatchDeletePipelineJobsRequest;
import com.google.cloud.aiplatform.v1.BatchDeletePipelineJobsResponse;
import com.google.cloud.aiplatform.v1.CancelPipelineJobRequest;
import com.google.cloud.aiplatform.v1.CancelTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1.CreatePipelineJobRequest;
import com.google.cloud.aiplatform.v1.CreateTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.DeletePipelineJobRequest;
import com.google.cloud.aiplatform.v1.DeleteTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1.GetPipelineJobRequest;
import com.google.cloud.aiplatform.v1.GetTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1.ListPipelineJobsRequest;
import com.google.cloud.aiplatform.v1.ListPipelineJobsResponse;
import com.google.cloud.aiplatform.v1.ListTrainingPipelinesRequest;
import com.google.cloud.aiplatform.v1.ListTrainingPipelinesResponse;
import com.google.cloud.aiplatform.v1.LocationName;
import com.google.cloud.aiplatform.v1.PipelineJob;
import com.google.cloud.aiplatform.v1.PipelineJobName;
import com.google.cloud.aiplatform.v1.PipelineServiceSettings;
import com.google.cloud.aiplatform.v1.TrainingPipeline;
import com.google.cloud.aiplatform.v1.TrainingPipelineName;
import com.google.cloud.aiplatform.v1.stub.PipelineServiceStub;
import com.google.cloud.aiplatform.v1.stub.PipelineServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class PipelineServiceClient
implements BackgroundResource {
    private final PipelineServiceSettings settings;
    private final PipelineServiceStub stub;
    private final OperationsClient operationsClient;

    public static final PipelineServiceClient create() throws IOException {
        return PipelineServiceClient.create(PipelineServiceSettings.newBuilder().build());
    }

    public static final PipelineServiceClient create(PipelineServiceSettings settings) throws IOException {
        return new PipelineServiceClient(settings);
    }

    public static final PipelineServiceClient create(PipelineServiceStub stub) {
        return new PipelineServiceClient(stub);
    }

    protected PipelineServiceClient(PipelineServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PipelineServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected PipelineServiceClient(PipelineServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final PipelineServiceSettings getSettings() {
        return this.settings;
    }

    public PipelineServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final TrainingPipeline createTrainingPipeline(LocationName parent, TrainingPipeline trainingPipeline) {
        CreateTrainingPipelineRequest request = CreateTrainingPipelineRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTrainingPipeline(trainingPipeline).build();
        return this.createTrainingPipeline(request);
    }

    public final TrainingPipeline createTrainingPipeline(String parent, TrainingPipeline trainingPipeline) {
        CreateTrainingPipelineRequest request = CreateTrainingPipelineRequest.newBuilder().setParent(parent).setTrainingPipeline(trainingPipeline).build();
        return this.createTrainingPipeline(request);
    }

    public final TrainingPipeline createTrainingPipeline(CreateTrainingPipelineRequest request) {
        return (TrainingPipeline)this.createTrainingPipelineCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTrainingPipelineRequest, TrainingPipeline> createTrainingPipelineCallable() {
        return this.stub.createTrainingPipelineCallable();
    }

    public final TrainingPipeline getTrainingPipeline(TrainingPipelineName name) {
        GetTrainingPipelineRequest request = GetTrainingPipelineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTrainingPipeline(request);
    }

    public final TrainingPipeline getTrainingPipeline(String name) {
        GetTrainingPipelineRequest request = GetTrainingPipelineRequest.newBuilder().setName(name).build();
        return this.getTrainingPipeline(request);
    }

    public final TrainingPipeline getTrainingPipeline(GetTrainingPipelineRequest request) {
        return (TrainingPipeline)this.getTrainingPipelineCallable().call((Object)request);
    }

    public final UnaryCallable<GetTrainingPipelineRequest, TrainingPipeline> getTrainingPipelineCallable() {
        return this.stub.getTrainingPipelineCallable();
    }

    public final ListTrainingPipelinesPagedResponse listTrainingPipelines(LocationName parent) {
        ListTrainingPipelinesRequest request = ListTrainingPipelinesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTrainingPipelines(request);
    }

    public final ListTrainingPipelinesPagedResponse listTrainingPipelines(String parent) {
        ListTrainingPipelinesRequest request = ListTrainingPipelinesRequest.newBuilder().setParent(parent).build();
        return this.listTrainingPipelines(request);
    }

    public final ListTrainingPipelinesPagedResponse listTrainingPipelines(ListTrainingPipelinesRequest request) {
        return (ListTrainingPipelinesPagedResponse)((Object)this.listTrainingPipelinesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTrainingPipelinesRequest, ListTrainingPipelinesPagedResponse> listTrainingPipelinesPagedCallable() {
        return this.stub.listTrainingPipelinesPagedCallable();
    }

    public final UnaryCallable<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse> listTrainingPipelinesCallable() {
        return this.stub.listTrainingPipelinesCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteTrainingPipelineAsync(TrainingPipelineName name) {
        DeleteTrainingPipelineRequest request = DeleteTrainingPipelineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteTrainingPipelineAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteTrainingPipelineAsync(String name) {
        DeleteTrainingPipelineRequest request = DeleteTrainingPipelineRequest.newBuilder().setName(name).build();
        return this.deleteTrainingPipelineAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteTrainingPipelineAsync(DeleteTrainingPipelineRequest request) {
        return this.deleteTrainingPipelineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTrainingPipelineRequest, Empty, DeleteOperationMetadata> deleteTrainingPipelineOperationCallable() {
        return this.stub.deleteTrainingPipelineOperationCallable();
    }

    public final UnaryCallable<DeleteTrainingPipelineRequest, Operation> deleteTrainingPipelineCallable() {
        return this.stub.deleteTrainingPipelineCallable();
    }

    public final void cancelTrainingPipeline(TrainingPipelineName name) {
        CancelTrainingPipelineRequest request = CancelTrainingPipelineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.cancelTrainingPipeline(request);
    }

    public final void cancelTrainingPipeline(String name) {
        CancelTrainingPipelineRequest request = CancelTrainingPipelineRequest.newBuilder().setName(name).build();
        this.cancelTrainingPipeline(request);
    }

    public final void cancelTrainingPipeline(CancelTrainingPipelineRequest request) {
        this.cancelTrainingPipelineCallable().call((Object)request);
    }

    public final UnaryCallable<CancelTrainingPipelineRequest, Empty> cancelTrainingPipelineCallable() {
        return this.stub.cancelTrainingPipelineCallable();
    }

    public final PipelineJob createPipelineJob(LocationName parent, PipelineJob pipelineJob, String pipelineJobId) {
        CreatePipelineJobRequest request = CreatePipelineJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPipelineJob(pipelineJob).setPipelineJobId(pipelineJobId).build();
        return this.createPipelineJob(request);
    }

    public final PipelineJob createPipelineJob(String parent, PipelineJob pipelineJob, String pipelineJobId) {
        CreatePipelineJobRequest request = CreatePipelineJobRequest.newBuilder().setParent(parent).setPipelineJob(pipelineJob).setPipelineJobId(pipelineJobId).build();
        return this.createPipelineJob(request);
    }

    public final PipelineJob createPipelineJob(CreatePipelineJobRequest request) {
        return (PipelineJob)this.createPipelineJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreatePipelineJobRequest, PipelineJob> createPipelineJobCallable() {
        return this.stub.createPipelineJobCallable();
    }

    public final PipelineJob getPipelineJob(PipelineJobName name) {
        GetPipelineJobRequest request = GetPipelineJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPipelineJob(request);
    }

    public final PipelineJob getPipelineJob(String name) {
        GetPipelineJobRequest request = GetPipelineJobRequest.newBuilder().setName(name).build();
        return this.getPipelineJob(request);
    }

    public final PipelineJob getPipelineJob(GetPipelineJobRequest request) {
        return (PipelineJob)this.getPipelineJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetPipelineJobRequest, PipelineJob> getPipelineJobCallable() {
        return this.stub.getPipelineJobCallable();
    }

    public final ListPipelineJobsPagedResponse listPipelineJobs(LocationName parent) {
        ListPipelineJobsRequest request = ListPipelineJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPipelineJobs(request);
    }

    public final ListPipelineJobsPagedResponse listPipelineJobs(String parent) {
        ListPipelineJobsRequest request = ListPipelineJobsRequest.newBuilder().setParent(parent).build();
        return this.listPipelineJobs(request);
    }

    public final ListPipelineJobsPagedResponse listPipelineJobs(ListPipelineJobsRequest request) {
        return (ListPipelineJobsPagedResponse)((Object)this.listPipelineJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPipelineJobsRequest, ListPipelineJobsPagedResponse> listPipelineJobsPagedCallable() {
        return this.stub.listPipelineJobsPagedCallable();
    }

    public final UnaryCallable<ListPipelineJobsRequest, ListPipelineJobsResponse> listPipelineJobsCallable() {
        return this.stub.listPipelineJobsCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deletePipelineJobAsync(PipelineJobName name) {
        DeletePipelineJobRequest request = DeletePipelineJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePipelineJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deletePipelineJobAsync(String name) {
        DeletePipelineJobRequest request = DeletePipelineJobRequest.newBuilder().setName(name).build();
        return this.deletePipelineJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deletePipelineJobAsync(DeletePipelineJobRequest request) {
        return this.deletePipelineJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePipelineJobRequest, Empty, DeleteOperationMetadata> deletePipelineJobOperationCallable() {
        return this.stub.deletePipelineJobOperationCallable();
    }

    public final UnaryCallable<DeletePipelineJobRequest, Operation> deletePipelineJobCallable() {
        return this.stub.deletePipelineJobCallable();
    }

    public final OperationFuture<BatchDeletePipelineJobsResponse, DeleteOperationMetadata> batchDeletePipelineJobsAsync(LocationName parent, List<String> names) {
        BatchDeletePipelineJobsRequest request = BatchDeletePipelineJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllNames(names).build();
        return this.batchDeletePipelineJobsAsync(request);
    }

    public final OperationFuture<BatchDeletePipelineJobsResponse, DeleteOperationMetadata> batchDeletePipelineJobsAsync(String parent, List<String> names) {
        BatchDeletePipelineJobsRequest request = BatchDeletePipelineJobsRequest.newBuilder().setParent(parent).addAllNames(names).build();
        return this.batchDeletePipelineJobsAsync(request);
    }

    public final OperationFuture<BatchDeletePipelineJobsResponse, DeleteOperationMetadata> batchDeletePipelineJobsAsync(BatchDeletePipelineJobsRequest request) {
        return this.batchDeletePipelineJobsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchDeletePipelineJobsRequest, BatchDeletePipelineJobsResponse, DeleteOperationMetadata> batchDeletePipelineJobsOperationCallable() {
        return this.stub.batchDeletePipelineJobsOperationCallable();
    }

    public final UnaryCallable<BatchDeletePipelineJobsRequest, Operation> batchDeletePipelineJobsCallable() {
        return this.stub.batchDeletePipelineJobsCallable();
    }

    public final void cancelPipelineJob(PipelineJobName name) {
        CancelPipelineJobRequest request = CancelPipelineJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.cancelPipelineJob(request);
    }

    public final void cancelPipelineJob(String name) {
        CancelPipelineJobRequest request = CancelPipelineJobRequest.newBuilder().setName(name).build();
        this.cancelPipelineJob(request);
    }

    public final void cancelPipelineJob(CancelPipelineJobRequest request) {
        this.cancelPipelineJobCallable().call((Object)request);
    }

    public final UnaryCallable<CancelPipelineJobRequest, Empty> cancelPipelineJobCallable() {
        return this.stub.cancelPipelineJobCallable();
    }

    public final OperationFuture<BatchCancelPipelineJobsResponse, BatchCancelPipelineJobsOperationMetadata> batchCancelPipelineJobsAsync(LocationName parent, List<String> names) {
        BatchCancelPipelineJobsRequest request = BatchCancelPipelineJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllNames(names).build();
        return this.batchCancelPipelineJobsAsync(request);
    }

    public final OperationFuture<BatchCancelPipelineJobsResponse, BatchCancelPipelineJobsOperationMetadata> batchCancelPipelineJobsAsync(String parent, List<String> names) {
        BatchCancelPipelineJobsRequest request = BatchCancelPipelineJobsRequest.newBuilder().setParent(parent).addAllNames(names).build();
        return this.batchCancelPipelineJobsAsync(request);
    }

    public final OperationFuture<BatchCancelPipelineJobsResponse, BatchCancelPipelineJobsOperationMetadata> batchCancelPipelineJobsAsync(BatchCancelPipelineJobsRequest request) {
        return this.batchCancelPipelineJobsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchCancelPipelineJobsRequest, BatchCancelPipelineJobsResponse, BatchCancelPipelineJobsOperationMetadata> batchCancelPipelineJobsOperationCallable() {
        return this.stub.batchCancelPipelineJobsOperationCallable();
    }

    public final UnaryCallable<BatchCancelPipelineJobsRequest, Operation> batchCancelPipelineJobsCallable() {
        return this.stub.batchCancelPipelineJobsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPipelineJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPipelineJobsRequest, ListPipelineJobsResponse, PipelineJob, ListPipelineJobsPage, ListPipelineJobsFixedSizeCollection> {
        private ListPipelineJobsFixedSizeCollection(List<ListPipelineJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPipelineJobsFixedSizeCollection createEmptyCollection() {
            return new ListPipelineJobsFixedSizeCollection(null, 0);
        }

        protected ListPipelineJobsFixedSizeCollection createCollection(List<ListPipelineJobsPage> pages, int collectionSize) {
            return new ListPipelineJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPipelineJobsPage
    extends AbstractPage<ListPipelineJobsRequest, ListPipelineJobsResponse, PipelineJob, ListPipelineJobsPage> {
        private ListPipelineJobsPage(PageContext<ListPipelineJobsRequest, ListPipelineJobsResponse, PipelineJob> context, ListPipelineJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListPipelineJobsPage createEmptyPage() {
            return new ListPipelineJobsPage(null, null);
        }

        protected ListPipelineJobsPage createPage(PageContext<ListPipelineJobsRequest, ListPipelineJobsResponse, PipelineJob> context, ListPipelineJobsResponse response) {
            return new ListPipelineJobsPage(context, response);
        }

        public ApiFuture<ListPipelineJobsPage> createPageAsync(PageContext<ListPipelineJobsRequest, ListPipelineJobsResponse, PipelineJob> context, ApiFuture<ListPipelineJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPipelineJobsPagedResponse
    extends AbstractPagedListResponse<ListPipelineJobsRequest, ListPipelineJobsResponse, PipelineJob, ListPipelineJobsPage, ListPipelineJobsFixedSizeCollection> {
        public static ApiFuture<ListPipelineJobsPagedResponse> createAsync(PageContext<ListPipelineJobsRequest, ListPipelineJobsResponse, PipelineJob> context, ApiFuture<ListPipelineJobsResponse> futureResponse) {
            ApiFuture<ListPipelineJobsPage> futurePage = ListPipelineJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPipelineJobsPagedResponse((ListPipelineJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPipelineJobsPagedResponse(ListPipelineJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPipelineJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTrainingPipelinesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline, ListTrainingPipelinesPage, ListTrainingPipelinesFixedSizeCollection> {
        private ListTrainingPipelinesFixedSizeCollection(List<ListTrainingPipelinesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTrainingPipelinesFixedSizeCollection createEmptyCollection() {
            return new ListTrainingPipelinesFixedSizeCollection(null, 0);
        }

        protected ListTrainingPipelinesFixedSizeCollection createCollection(List<ListTrainingPipelinesPage> pages, int collectionSize) {
            return new ListTrainingPipelinesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTrainingPipelinesPage
    extends AbstractPage<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline, ListTrainingPipelinesPage> {
        private ListTrainingPipelinesPage(PageContext<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline> context, ListTrainingPipelinesResponse response) {
            super(context, (Object)response);
        }

        private static ListTrainingPipelinesPage createEmptyPage() {
            return new ListTrainingPipelinesPage(null, null);
        }

        protected ListTrainingPipelinesPage createPage(PageContext<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline> context, ListTrainingPipelinesResponse response) {
            return new ListTrainingPipelinesPage(context, response);
        }

        public ApiFuture<ListTrainingPipelinesPage> createPageAsync(PageContext<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline> context, ApiFuture<ListTrainingPipelinesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTrainingPipelinesPagedResponse
    extends AbstractPagedListResponse<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline, ListTrainingPipelinesPage, ListTrainingPipelinesFixedSizeCollection> {
        public static ApiFuture<ListTrainingPipelinesPagedResponse> createAsync(PageContext<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline> context, ApiFuture<ListTrainingPipelinesResponse> futureResponse) {
            ApiFuture<ListTrainingPipelinesPage> futurePage = ListTrainingPipelinesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTrainingPipelinesPagedResponse((ListTrainingPipelinesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTrainingPipelinesPagedResponse(ListTrainingPipelinesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTrainingPipelinesFixedSizeCollection.createEmptyCollection());
        }
    }
}

