/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.AppendEventRequest;
import com.google.cloud.aiplatform.v1beta1.AppendEventResponse;
import com.google.cloud.aiplatform.v1beta1.CreateSessionOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateSessionRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeleteSessionRequest;
import com.google.cloud.aiplatform.v1beta1.GetSessionRequest;
import com.google.cloud.aiplatform.v1beta1.ListEventsRequest;
import com.google.cloud.aiplatform.v1beta1.ListEventsResponse;
import com.google.cloud.aiplatform.v1beta1.ListSessionsRequest;
import com.google.cloud.aiplatform.v1beta1.ListSessionsResponse;
import com.google.cloud.aiplatform.v1beta1.ReasoningEngineName;
import com.google.cloud.aiplatform.v1beta1.Session;
import com.google.cloud.aiplatform.v1beta1.SessionEvent;
import com.google.cloud.aiplatform.v1beta1.SessionName;
import com.google.cloud.aiplatform.v1beta1.SessionServiceSettings;
import com.google.cloud.aiplatform.v1beta1.UpdateSessionRequest;
import com.google.cloud.aiplatform.v1beta1.stub.SessionServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.SessionServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SessionServiceClient
implements BackgroundResource {
    private final SessionServiceSettings settings;
    private final SessionServiceStub stub;
    private final OperationsClient operationsClient;

    public static final SessionServiceClient create() throws IOException {
        return SessionServiceClient.create(SessionServiceSettings.newBuilder().build());
    }

    public static final SessionServiceClient create(SessionServiceSettings settings) throws IOException {
        return new SessionServiceClient(settings);
    }

    public static final SessionServiceClient create(SessionServiceStub stub) {
        return new SessionServiceClient(stub);
    }

    protected SessionServiceClient(SessionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SessionServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected SessionServiceClient(SessionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final SessionServiceSettings getSettings() {
        return this.settings;
    }

    public SessionServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Session, CreateSessionOperationMetadata> createSessionAsync(ReasoningEngineName parent, Session session) {
        CreateSessionRequest request = CreateSessionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSession(session).build();
        return this.createSessionAsync(request);
    }

    public final OperationFuture<Session, CreateSessionOperationMetadata> createSessionAsync(String parent, Session session) {
        CreateSessionRequest request = CreateSessionRequest.newBuilder().setParent(parent).setSession(session).build();
        return this.createSessionAsync(request);
    }

    public final OperationFuture<Session, CreateSessionOperationMetadata> createSessionAsync(CreateSessionRequest request) {
        return this.createSessionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSessionRequest, Session, CreateSessionOperationMetadata> createSessionOperationCallable() {
        return this.stub.createSessionOperationCallable();
    }

    public final UnaryCallable<CreateSessionRequest, Operation> createSessionCallable() {
        return this.stub.createSessionCallable();
    }

    public final Session getSession(SessionName name) {
        GetSessionRequest request = GetSessionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSession(request);
    }

    public final Session getSession(String name) {
        GetSessionRequest request = GetSessionRequest.newBuilder().setName(name).build();
        return this.getSession(request);
    }

    public final Session getSession(GetSessionRequest request) {
        return (Session)this.getSessionCallable().call((Object)request);
    }

    public final UnaryCallable<GetSessionRequest, Session> getSessionCallable() {
        return this.stub.getSessionCallable();
    }

    public final ListSessionsPagedResponse listSessions(ReasoningEngineName parent) {
        ListSessionsRequest request = ListSessionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSessions(request);
    }

    public final ListSessionsPagedResponse listSessions(String parent) {
        ListSessionsRequest request = ListSessionsRequest.newBuilder().setParent(parent).build();
        return this.listSessions(request);
    }

    public final ListSessionsPagedResponse listSessions(ListSessionsRequest request) {
        return (ListSessionsPagedResponse)((Object)this.listSessionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSessionsRequest, ListSessionsPagedResponse> listSessionsPagedCallable() {
        return this.stub.listSessionsPagedCallable();
    }

    public final UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable() {
        return this.stub.listSessionsCallable();
    }

    public final Session updateSession(Session session, FieldMask updateMask) {
        UpdateSessionRequest request = UpdateSessionRequest.newBuilder().setSession(session).setUpdateMask(updateMask).build();
        return this.updateSession(request);
    }

    public final Session updateSession(UpdateSessionRequest request) {
        return (Session)this.updateSessionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSessionRequest, Session> updateSessionCallable() {
        return this.stub.updateSessionCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteSessionAsync(SessionName name) {
        DeleteSessionRequest request = DeleteSessionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteSessionAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteSessionAsync(String name) {
        DeleteSessionRequest request = DeleteSessionRequest.newBuilder().setName(name).build();
        return this.deleteSessionAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteSessionAsync(DeleteSessionRequest request) {
        return this.deleteSessionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSessionRequest, Empty, DeleteOperationMetadata> deleteSessionOperationCallable() {
        return this.stub.deleteSessionOperationCallable();
    }

    public final UnaryCallable<DeleteSessionRequest, Operation> deleteSessionCallable() {
        return this.stub.deleteSessionCallable();
    }

    public final ListEventsPagedResponse listEvents(SessionName parent) {
        ListEventsRequest request = ListEventsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEvents(request);
    }

    public final ListEventsPagedResponse listEvents(String parent) {
        ListEventsRequest request = ListEventsRequest.newBuilder().setParent(parent).build();
        return this.listEvents(request);
    }

    public final ListEventsPagedResponse listEvents(ListEventsRequest request) {
        return (ListEventsPagedResponse)((Object)this.listEventsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEventsRequest, ListEventsPagedResponse> listEventsPagedCallable() {
        return this.stub.listEventsPagedCallable();
    }

    public final UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable() {
        return this.stub.listEventsCallable();
    }

    public final AppendEventResponse appendEvent(SessionName name, SessionEvent event) {
        AppendEventRequest request = AppendEventRequest.newBuilder().setName(name == null ? null : name.toString()).setEvent(event).build();
        return this.appendEvent(request);
    }

    public final AppendEventResponse appendEvent(String name, SessionEvent event) {
        AppendEventRequest request = AppendEventRequest.newBuilder().setName(name).setEvent(event).build();
        return this.appendEvent(request);
    }

    public final AppendEventResponse appendEvent(AppendEventRequest request) {
        return (AppendEventResponse)this.appendEventCallable().call((Object)request);
    }

    public final UnaryCallable<AppendEventRequest, AppendEventResponse> appendEventCallable() {
        return this.stub.appendEventCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEventsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEventsRequest, ListEventsResponse, SessionEvent, ListEventsPage, ListEventsFixedSizeCollection> {
        private ListEventsFixedSizeCollection(List<ListEventsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEventsFixedSizeCollection createEmptyCollection() {
            return new ListEventsFixedSizeCollection(null, 0);
        }

        protected ListEventsFixedSizeCollection createCollection(List<ListEventsPage> pages, int collectionSize) {
            return new ListEventsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEventsPage
    extends AbstractPage<ListEventsRequest, ListEventsResponse, SessionEvent, ListEventsPage> {
        private ListEventsPage(PageContext<ListEventsRequest, ListEventsResponse, SessionEvent> context, ListEventsResponse response) {
            super(context, (Object)response);
        }

        private static ListEventsPage createEmptyPage() {
            return new ListEventsPage(null, null);
        }

        protected ListEventsPage createPage(PageContext<ListEventsRequest, ListEventsResponse, SessionEvent> context, ListEventsResponse response) {
            return new ListEventsPage(context, response);
        }

        public ApiFuture<ListEventsPage> createPageAsync(PageContext<ListEventsRequest, ListEventsResponse, SessionEvent> context, ApiFuture<ListEventsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEventsPagedResponse
    extends AbstractPagedListResponse<ListEventsRequest, ListEventsResponse, SessionEvent, ListEventsPage, ListEventsFixedSizeCollection> {
        public static ApiFuture<ListEventsPagedResponse> createAsync(PageContext<ListEventsRequest, ListEventsResponse, SessionEvent> context, ApiFuture<ListEventsResponse> futureResponse) {
            ApiFuture<ListEventsPage> futurePage = ListEventsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEventsPagedResponse((ListEventsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEventsPagedResponse(ListEventsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEventsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSessionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage, ListSessionsFixedSizeCollection> {
        private ListSessionsFixedSizeCollection(List<ListSessionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSessionsFixedSizeCollection createEmptyCollection() {
            return new ListSessionsFixedSizeCollection(null, 0);
        }

        protected ListSessionsFixedSizeCollection createCollection(List<ListSessionsPage> pages, int collectionSize) {
            return new ListSessionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSessionsPage
    extends AbstractPage<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage> {
        private ListSessionsPage(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ListSessionsResponse response) {
            super(context, (Object)response);
        }

        private static ListSessionsPage createEmptyPage() {
            return new ListSessionsPage(null, null);
        }

        protected ListSessionsPage createPage(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ListSessionsResponse response) {
            return new ListSessionsPage(context, response);
        }

        public ApiFuture<ListSessionsPage> createPageAsync(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ApiFuture<ListSessionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSessionsPagedResponse
    extends AbstractPagedListResponse<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage, ListSessionsFixedSizeCollection> {
        public static ApiFuture<ListSessionsPagedResponse> createAsync(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ApiFuture<ListSessionsResponse> futureResponse) {
            ApiFuture<ListSessionsPage> futurePage = ListSessionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSessionsPagedResponse((ListSessionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSessionsPagedResponse(ListSessionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSessionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

