/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.DeleteExtensionRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.Extension;
import com.google.cloud.aiplatform.v1beta1.ExtensionName;
import com.google.cloud.aiplatform.v1beta1.ExtensionRegistryServiceSettings;
import com.google.cloud.aiplatform.v1beta1.GetExtensionRequest;
import com.google.cloud.aiplatform.v1beta1.ImportExtensionOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ImportExtensionRequest;
import com.google.cloud.aiplatform.v1beta1.ListExtensionsRequest;
import com.google.cloud.aiplatform.v1beta1.ListExtensionsResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.UpdateExtensionRequest;
import com.google.cloud.aiplatform.v1beta1.stub.ExtensionRegistryServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.ExtensionRegistryServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ExtensionRegistryServiceClient
implements BackgroundResource {
    private final ExtensionRegistryServiceSettings settings;
    private final ExtensionRegistryServiceStub stub;
    private final OperationsClient operationsClient;

    public static final ExtensionRegistryServiceClient create() throws IOException {
        return ExtensionRegistryServiceClient.create(ExtensionRegistryServiceSettings.newBuilder().build());
    }

    public static final ExtensionRegistryServiceClient create(ExtensionRegistryServiceSettings settings) throws IOException {
        return new ExtensionRegistryServiceClient(settings);
    }

    public static final ExtensionRegistryServiceClient create(ExtensionRegistryServiceStub stub) {
        return new ExtensionRegistryServiceClient(stub);
    }

    protected ExtensionRegistryServiceClient(ExtensionRegistryServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ExtensionRegistryServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected ExtensionRegistryServiceClient(ExtensionRegistryServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ExtensionRegistryServiceSettings getSettings() {
        return this.settings;
    }

    public ExtensionRegistryServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Extension, ImportExtensionOperationMetadata> importExtensionAsync(LocationName parent, Extension extension) {
        ImportExtensionRequest request = ImportExtensionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setExtension(extension).build();
        return this.importExtensionAsync(request);
    }

    public final OperationFuture<Extension, ImportExtensionOperationMetadata> importExtensionAsync(String parent, Extension extension) {
        ImportExtensionRequest request = ImportExtensionRequest.newBuilder().setParent(parent).setExtension(extension).build();
        return this.importExtensionAsync(request);
    }

    public final OperationFuture<Extension, ImportExtensionOperationMetadata> importExtensionAsync(ImportExtensionRequest request) {
        return this.importExtensionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportExtensionRequest, Extension, ImportExtensionOperationMetadata> importExtensionOperationCallable() {
        return this.stub.importExtensionOperationCallable();
    }

    public final UnaryCallable<ImportExtensionRequest, Operation> importExtensionCallable() {
        return this.stub.importExtensionCallable();
    }

    public final Extension getExtension(ExtensionName name) {
        GetExtensionRequest request = GetExtensionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getExtension(request);
    }

    public final Extension getExtension(String name) {
        GetExtensionRequest request = GetExtensionRequest.newBuilder().setName(name).build();
        return this.getExtension(request);
    }

    public final Extension getExtension(GetExtensionRequest request) {
        return (Extension)this.getExtensionCallable().call((Object)request);
    }

    public final UnaryCallable<GetExtensionRequest, Extension> getExtensionCallable() {
        return this.stub.getExtensionCallable();
    }

    public final ListExtensionsPagedResponse listExtensions(LocationName parent) {
        ListExtensionsRequest request = ListExtensionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listExtensions(request);
    }

    public final ListExtensionsPagedResponse listExtensions(String parent) {
        ListExtensionsRequest request = ListExtensionsRequest.newBuilder().setParent(parent).build();
        return this.listExtensions(request);
    }

    public final ListExtensionsPagedResponse listExtensions(ListExtensionsRequest request) {
        return (ListExtensionsPagedResponse)((Object)this.listExtensionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExtensionsRequest, ListExtensionsPagedResponse> listExtensionsPagedCallable() {
        return this.stub.listExtensionsPagedCallable();
    }

    public final UnaryCallable<ListExtensionsRequest, ListExtensionsResponse> listExtensionsCallable() {
        return this.stub.listExtensionsCallable();
    }

    public final Extension updateExtension(Extension extension, FieldMask updateMask) {
        UpdateExtensionRequest request = UpdateExtensionRequest.newBuilder().setExtension(extension).setUpdateMask(updateMask).build();
        return this.updateExtension(request);
    }

    public final Extension updateExtension(UpdateExtensionRequest request) {
        return (Extension)this.updateExtensionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateExtensionRequest, Extension> updateExtensionCallable() {
        return this.stub.updateExtensionCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteExtensionAsync(ExtensionName name) {
        DeleteExtensionRequest request = DeleteExtensionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteExtensionAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteExtensionAsync(String name) {
        DeleteExtensionRequest request = DeleteExtensionRequest.newBuilder().setName(name).build();
        return this.deleteExtensionAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteExtensionAsync(DeleteExtensionRequest request) {
        return this.deleteExtensionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteExtensionRequest, Empty, DeleteOperationMetadata> deleteExtensionOperationCallable() {
        return this.stub.deleteExtensionOperationCallable();
    }

    public final UnaryCallable<DeleteExtensionRequest, Operation> deleteExtensionCallable() {
        return this.stub.deleteExtensionCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListExtensionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExtensionsRequest, ListExtensionsResponse, Extension, ListExtensionsPage, ListExtensionsFixedSizeCollection> {
        private ListExtensionsFixedSizeCollection(List<ListExtensionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExtensionsFixedSizeCollection createEmptyCollection() {
            return new ListExtensionsFixedSizeCollection(null, 0);
        }

        protected ListExtensionsFixedSizeCollection createCollection(List<ListExtensionsPage> pages, int collectionSize) {
            return new ListExtensionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExtensionsPage
    extends AbstractPage<ListExtensionsRequest, ListExtensionsResponse, Extension, ListExtensionsPage> {
        private ListExtensionsPage(PageContext<ListExtensionsRequest, ListExtensionsResponse, Extension> context, ListExtensionsResponse response) {
            super(context, (Object)response);
        }

        private static ListExtensionsPage createEmptyPage() {
            return new ListExtensionsPage(null, null);
        }

        protected ListExtensionsPage createPage(PageContext<ListExtensionsRequest, ListExtensionsResponse, Extension> context, ListExtensionsResponse response) {
            return new ListExtensionsPage(context, response);
        }

        public ApiFuture<ListExtensionsPage> createPageAsync(PageContext<ListExtensionsRequest, ListExtensionsResponse, Extension> context, ApiFuture<ListExtensionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListExtensionsPagedResponse
    extends AbstractPagedListResponse<ListExtensionsRequest, ListExtensionsResponse, Extension, ListExtensionsPage, ListExtensionsFixedSizeCollection> {
        public static ApiFuture<ListExtensionsPagedResponse> createAsync(PageContext<ListExtensionsRequest, ListExtensionsResponse, Extension> context, ApiFuture<ListExtensionsResponse> futureResponse) {
            ApiFuture<ListExtensionsPage> futurePage = ListExtensionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListExtensionsPagedResponse((ListExtensionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListExtensionsPagedResponse(ListExtensionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExtensionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

