/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.AssignNotebookRuntimeOperationMetadata;
import com.google.cloud.aiplatform.v1.AssignNotebookRuntimeRequest;
import com.google.cloud.aiplatform.v1.CreateNotebookRuntimeTemplateOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateNotebookRuntimeTemplateRequest;
import com.google.cloud.aiplatform.v1.DeleteNotebookRuntimeRequest;
import com.google.cloud.aiplatform.v1.DeleteNotebookRuntimeTemplateRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.GetNotebookRuntimeRequest;
import com.google.cloud.aiplatform.v1.GetNotebookRuntimeTemplateRequest;
import com.google.cloud.aiplatform.v1.ListNotebookRuntimeTemplatesRequest;
import com.google.cloud.aiplatform.v1.ListNotebookRuntimeTemplatesResponse;
import com.google.cloud.aiplatform.v1.ListNotebookRuntimesRequest;
import com.google.cloud.aiplatform.v1.ListNotebookRuntimesResponse;
import com.google.cloud.aiplatform.v1.NotebookRuntime;
import com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate;
import com.google.cloud.aiplatform.v1.NotebookServiceClient;
import com.google.cloud.aiplatform.v1.StartNotebookRuntimeOperationMetadata;
import com.google.cloud.aiplatform.v1.StartNotebookRuntimeRequest;
import com.google.cloud.aiplatform.v1.StartNotebookRuntimeResponse;
import com.google.cloud.aiplatform.v1.UpgradeNotebookRuntimeOperationMetadata;
import com.google.cloud.aiplatform.v1.UpgradeNotebookRuntimeRequest;
import com.google.cloud.aiplatform.v1.UpgradeNotebookRuntimeResponse;
import com.google.cloud.aiplatform.v1.stub.GrpcNotebookServiceStub;
import com.google.cloud.aiplatform.v1.stub.NotebookServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class NotebookServiceStubSettings
extends StubSettings<NotebookServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateNotebookRuntimeTemplateRequest, Operation> createNotebookRuntimeTemplateSettings;
    private final OperationCallSettings<CreateNotebookRuntimeTemplateRequest, NotebookRuntimeTemplate, CreateNotebookRuntimeTemplateOperationMetadata> createNotebookRuntimeTemplateOperationSettings;
    private final UnaryCallSettings<GetNotebookRuntimeTemplateRequest, NotebookRuntimeTemplate> getNotebookRuntimeTemplateSettings;
    private final PagedCallSettings<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookServiceClient.ListNotebookRuntimeTemplatesPagedResponse> listNotebookRuntimeTemplatesSettings;
    private final UnaryCallSettings<DeleteNotebookRuntimeTemplateRequest, Operation> deleteNotebookRuntimeTemplateSettings;
    private final OperationCallSettings<DeleteNotebookRuntimeTemplateRequest, Empty, DeleteOperationMetadata> deleteNotebookRuntimeTemplateOperationSettings;
    private final UnaryCallSettings<AssignNotebookRuntimeRequest, Operation> assignNotebookRuntimeSettings;
    private final OperationCallSettings<AssignNotebookRuntimeRequest, NotebookRuntime, AssignNotebookRuntimeOperationMetadata> assignNotebookRuntimeOperationSettings;
    private final UnaryCallSettings<GetNotebookRuntimeRequest, NotebookRuntime> getNotebookRuntimeSettings;
    private final PagedCallSettings<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookServiceClient.ListNotebookRuntimesPagedResponse> listNotebookRuntimesSettings;
    private final UnaryCallSettings<DeleteNotebookRuntimeRequest, Operation> deleteNotebookRuntimeSettings;
    private final OperationCallSettings<DeleteNotebookRuntimeRequest, Empty, DeleteOperationMetadata> deleteNotebookRuntimeOperationSettings;
    private final UnaryCallSettings<UpgradeNotebookRuntimeRequest, Operation> upgradeNotebookRuntimeSettings;
    private final OperationCallSettings<UpgradeNotebookRuntimeRequest, UpgradeNotebookRuntimeResponse, UpgradeNotebookRuntimeOperationMetadata> upgradeNotebookRuntimeOperationSettings;
    private final UnaryCallSettings<StartNotebookRuntimeRequest, Operation> startNotebookRuntimeSettings;
    private final OperationCallSettings<StartNotebookRuntimeRequest, StartNotebookRuntimeResponse, StartNotebookRuntimeOperationMetadata> startNotebookRuntimeOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, NotebookServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookRuntimeTemplate> LIST_NOTEBOOK_RUNTIME_TEMPLATES_PAGE_STR_DESC = new PagedListDescriptor<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookRuntimeTemplate>(){

        public String emptyToken() {
            return "";
        }

        public ListNotebookRuntimeTemplatesRequest injectToken(ListNotebookRuntimeTemplatesRequest payload, String token) {
            return ListNotebookRuntimeTemplatesRequest.newBuilder((ListNotebookRuntimeTemplatesRequest)payload).setPageToken(token).build();
        }

        public ListNotebookRuntimeTemplatesRequest injectPageSize(ListNotebookRuntimeTemplatesRequest payload, int pageSize) {
            return ListNotebookRuntimeTemplatesRequest.newBuilder((ListNotebookRuntimeTemplatesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListNotebookRuntimeTemplatesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListNotebookRuntimeTemplatesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NotebookRuntimeTemplate> extractResources(ListNotebookRuntimeTemplatesResponse payload) {
            return payload.getNotebookRuntimeTemplatesList() == null ? ImmutableList.of() : payload.getNotebookRuntimeTemplatesList();
        }
    };
    private static final PagedListDescriptor<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookRuntime> LIST_NOTEBOOK_RUNTIMES_PAGE_STR_DESC = new PagedListDescriptor<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookRuntime>(){

        public String emptyToken() {
            return "";
        }

        public ListNotebookRuntimesRequest injectToken(ListNotebookRuntimesRequest payload, String token) {
            return ListNotebookRuntimesRequest.newBuilder((ListNotebookRuntimesRequest)payload).setPageToken(token).build();
        }

        public ListNotebookRuntimesRequest injectPageSize(ListNotebookRuntimesRequest payload, int pageSize) {
            return ListNotebookRuntimesRequest.newBuilder((ListNotebookRuntimesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListNotebookRuntimesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListNotebookRuntimesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NotebookRuntime> extractResources(ListNotebookRuntimesResponse payload) {
            return payload.getNotebookRuntimesList() == null ? ImmutableList.of() : payload.getNotebookRuntimesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookServiceClient.ListNotebookRuntimeTemplatesPagedResponse> LIST_NOTEBOOK_RUNTIME_TEMPLATES_PAGE_STR_FACT = new PagedListResponseFactory<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookServiceClient.ListNotebookRuntimeTemplatesPagedResponse>(){

        public ApiFuture<NotebookServiceClient.ListNotebookRuntimeTemplatesPagedResponse> getFuturePagedResponse(UnaryCallable<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse> callable, ListNotebookRuntimeTemplatesRequest request, ApiCallContext context, ApiFuture<ListNotebookRuntimeTemplatesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NOTEBOOK_RUNTIME_TEMPLATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NotebookServiceClient.ListNotebookRuntimeTemplatesPagedResponse.createAsync((PageContext<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookRuntimeTemplate>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookServiceClient.ListNotebookRuntimesPagedResponse> LIST_NOTEBOOK_RUNTIMES_PAGE_STR_FACT = new PagedListResponseFactory<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookServiceClient.ListNotebookRuntimesPagedResponse>(){

        public ApiFuture<NotebookServiceClient.ListNotebookRuntimesPagedResponse> getFuturePagedResponse(UnaryCallable<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse> callable, ListNotebookRuntimesRequest request, ApiCallContext context, ApiFuture<ListNotebookRuntimesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NOTEBOOK_RUNTIMES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NotebookServiceClient.ListNotebookRuntimesPagedResponse.createAsync((PageContext<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookRuntime>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, NotebookServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, NotebookServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<NotebookServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NotebookServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateNotebookRuntimeTemplateRequest, Operation> createNotebookRuntimeTemplateSettings() {
        return this.createNotebookRuntimeTemplateSettings;
    }

    public OperationCallSettings<CreateNotebookRuntimeTemplateRequest, NotebookRuntimeTemplate, CreateNotebookRuntimeTemplateOperationMetadata> createNotebookRuntimeTemplateOperationSettings() {
        return this.createNotebookRuntimeTemplateOperationSettings;
    }

    public UnaryCallSettings<GetNotebookRuntimeTemplateRequest, NotebookRuntimeTemplate> getNotebookRuntimeTemplateSettings() {
        return this.getNotebookRuntimeTemplateSettings;
    }

    public PagedCallSettings<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookServiceClient.ListNotebookRuntimeTemplatesPagedResponse> listNotebookRuntimeTemplatesSettings() {
        return this.listNotebookRuntimeTemplatesSettings;
    }

    public UnaryCallSettings<DeleteNotebookRuntimeTemplateRequest, Operation> deleteNotebookRuntimeTemplateSettings() {
        return this.deleteNotebookRuntimeTemplateSettings;
    }

    public OperationCallSettings<DeleteNotebookRuntimeTemplateRequest, Empty, DeleteOperationMetadata> deleteNotebookRuntimeTemplateOperationSettings() {
        return this.deleteNotebookRuntimeTemplateOperationSettings;
    }

    public UnaryCallSettings<AssignNotebookRuntimeRequest, Operation> assignNotebookRuntimeSettings() {
        return this.assignNotebookRuntimeSettings;
    }

    public OperationCallSettings<AssignNotebookRuntimeRequest, NotebookRuntime, AssignNotebookRuntimeOperationMetadata> assignNotebookRuntimeOperationSettings() {
        return this.assignNotebookRuntimeOperationSettings;
    }

    public UnaryCallSettings<GetNotebookRuntimeRequest, NotebookRuntime> getNotebookRuntimeSettings() {
        return this.getNotebookRuntimeSettings;
    }

    public PagedCallSettings<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookServiceClient.ListNotebookRuntimesPagedResponse> listNotebookRuntimesSettings() {
        return this.listNotebookRuntimesSettings;
    }

    public UnaryCallSettings<DeleteNotebookRuntimeRequest, Operation> deleteNotebookRuntimeSettings() {
        return this.deleteNotebookRuntimeSettings;
    }

    public OperationCallSettings<DeleteNotebookRuntimeRequest, Empty, DeleteOperationMetadata> deleteNotebookRuntimeOperationSettings() {
        return this.deleteNotebookRuntimeOperationSettings;
    }

    public UnaryCallSettings<UpgradeNotebookRuntimeRequest, Operation> upgradeNotebookRuntimeSettings() {
        return this.upgradeNotebookRuntimeSettings;
    }

    public OperationCallSettings<UpgradeNotebookRuntimeRequest, UpgradeNotebookRuntimeResponse, UpgradeNotebookRuntimeOperationMetadata> upgradeNotebookRuntimeOperationSettings() {
        return this.upgradeNotebookRuntimeOperationSettings;
    }

    public UnaryCallSettings<StartNotebookRuntimeRequest, Operation> startNotebookRuntimeSettings() {
        return this.startNotebookRuntimeSettings;
    }

    public OperationCallSettings<StartNotebookRuntimeRequest, StartNotebookRuntimeResponse, StartNotebookRuntimeOperationMetadata> startNotebookRuntimeOperationSettings() {
        return this.startNotebookRuntimeOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, NotebookServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public NotebookServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcNotebookServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NotebookServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NotebookServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NotebookServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createNotebookRuntimeTemplateSettings = settingsBuilder.createNotebookRuntimeTemplateSettings().build();
        this.createNotebookRuntimeTemplateOperationSettings = settingsBuilder.createNotebookRuntimeTemplateOperationSettings().build();
        this.getNotebookRuntimeTemplateSettings = settingsBuilder.getNotebookRuntimeTemplateSettings().build();
        this.listNotebookRuntimeTemplatesSettings = settingsBuilder.listNotebookRuntimeTemplatesSettings().build();
        this.deleteNotebookRuntimeTemplateSettings = settingsBuilder.deleteNotebookRuntimeTemplateSettings().build();
        this.deleteNotebookRuntimeTemplateOperationSettings = settingsBuilder.deleteNotebookRuntimeTemplateOperationSettings().build();
        this.assignNotebookRuntimeSettings = settingsBuilder.assignNotebookRuntimeSettings().build();
        this.assignNotebookRuntimeOperationSettings = settingsBuilder.assignNotebookRuntimeOperationSettings().build();
        this.getNotebookRuntimeSettings = settingsBuilder.getNotebookRuntimeSettings().build();
        this.listNotebookRuntimesSettings = settingsBuilder.listNotebookRuntimesSettings().build();
        this.deleteNotebookRuntimeSettings = settingsBuilder.deleteNotebookRuntimeSettings().build();
        this.deleteNotebookRuntimeOperationSettings = settingsBuilder.deleteNotebookRuntimeOperationSettings().build();
        this.upgradeNotebookRuntimeSettings = settingsBuilder.upgradeNotebookRuntimeSettings().build();
        this.upgradeNotebookRuntimeOperationSettings = settingsBuilder.upgradeNotebookRuntimeOperationSettings().build();
        this.startNotebookRuntimeSettings = settingsBuilder.startNotebookRuntimeSettings().build();
        this.startNotebookRuntimeOperationSettings = settingsBuilder.startNotebookRuntimeOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NotebookServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateNotebookRuntimeTemplateRequest, Operation> createNotebookRuntimeTemplateSettings;
        private final OperationCallSettings.Builder<CreateNotebookRuntimeTemplateRequest, NotebookRuntimeTemplate, CreateNotebookRuntimeTemplateOperationMetadata> createNotebookRuntimeTemplateOperationSettings;
        private final UnaryCallSettings.Builder<GetNotebookRuntimeTemplateRequest, NotebookRuntimeTemplate> getNotebookRuntimeTemplateSettings;
        private final PagedCallSettings.Builder<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookServiceClient.ListNotebookRuntimeTemplatesPagedResponse> listNotebookRuntimeTemplatesSettings;
        private final UnaryCallSettings.Builder<DeleteNotebookRuntimeTemplateRequest, Operation> deleteNotebookRuntimeTemplateSettings;
        private final OperationCallSettings.Builder<DeleteNotebookRuntimeTemplateRequest, Empty, DeleteOperationMetadata> deleteNotebookRuntimeTemplateOperationSettings;
        private final UnaryCallSettings.Builder<AssignNotebookRuntimeRequest, Operation> assignNotebookRuntimeSettings;
        private final OperationCallSettings.Builder<AssignNotebookRuntimeRequest, NotebookRuntime, AssignNotebookRuntimeOperationMetadata> assignNotebookRuntimeOperationSettings;
        private final UnaryCallSettings.Builder<GetNotebookRuntimeRequest, NotebookRuntime> getNotebookRuntimeSettings;
        private final PagedCallSettings.Builder<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookServiceClient.ListNotebookRuntimesPagedResponse> listNotebookRuntimesSettings;
        private final UnaryCallSettings.Builder<DeleteNotebookRuntimeRequest, Operation> deleteNotebookRuntimeSettings;
        private final OperationCallSettings.Builder<DeleteNotebookRuntimeRequest, Empty, DeleteOperationMetadata> deleteNotebookRuntimeOperationSettings;
        private final UnaryCallSettings.Builder<UpgradeNotebookRuntimeRequest, Operation> upgradeNotebookRuntimeSettings;
        private final OperationCallSettings.Builder<UpgradeNotebookRuntimeRequest, UpgradeNotebookRuntimeResponse, UpgradeNotebookRuntimeOperationMetadata> upgradeNotebookRuntimeOperationSettings;
        private final UnaryCallSettings.Builder<StartNotebookRuntimeRequest, Operation> startNotebookRuntimeSettings;
        private final OperationCallSettings.Builder<StartNotebookRuntimeRequest, StartNotebookRuntimeResponse, StartNotebookRuntimeOperationMetadata> startNotebookRuntimeOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, NotebookServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createNotebookRuntimeTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createNotebookRuntimeTemplateOperationSettings = OperationCallSettings.newBuilder();
            this.getNotebookRuntimeTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listNotebookRuntimeTemplatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NOTEBOOK_RUNTIME_TEMPLATES_PAGE_STR_FACT);
            this.deleteNotebookRuntimeTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteNotebookRuntimeTemplateOperationSettings = OperationCallSettings.newBuilder();
            this.assignNotebookRuntimeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.assignNotebookRuntimeOperationSettings = OperationCallSettings.newBuilder();
            this.getNotebookRuntimeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listNotebookRuntimesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NOTEBOOK_RUNTIMES_PAGE_STR_FACT);
            this.deleteNotebookRuntimeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteNotebookRuntimeOperationSettings = OperationCallSettings.newBuilder();
            this.upgradeNotebookRuntimeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.upgradeNotebookRuntimeOperationSettings = OperationCallSettings.newBuilder();
            this.startNotebookRuntimeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startNotebookRuntimeOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createNotebookRuntimeTemplateSettings, this.getNotebookRuntimeTemplateSettings, this.listNotebookRuntimeTemplatesSettings, this.deleteNotebookRuntimeTemplateSettings, this.assignNotebookRuntimeSettings, this.getNotebookRuntimeSettings, this.listNotebookRuntimesSettings, this.deleteNotebookRuntimeSettings, this.upgradeNotebookRuntimeSettings, this.startNotebookRuntimeSettings, this.listLocationsSettings, this.getLocationSettings, (Object[])new UnaryCallSettings.Builder[]{this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(NotebookServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createNotebookRuntimeTemplateSettings = settings.createNotebookRuntimeTemplateSettings.toBuilder();
            this.createNotebookRuntimeTemplateOperationSettings = settings.createNotebookRuntimeTemplateOperationSettings.toBuilder();
            this.getNotebookRuntimeTemplateSettings = settings.getNotebookRuntimeTemplateSettings.toBuilder();
            this.listNotebookRuntimeTemplatesSettings = settings.listNotebookRuntimeTemplatesSettings.toBuilder();
            this.deleteNotebookRuntimeTemplateSettings = settings.deleteNotebookRuntimeTemplateSettings.toBuilder();
            this.deleteNotebookRuntimeTemplateOperationSettings = settings.deleteNotebookRuntimeTemplateOperationSettings.toBuilder();
            this.assignNotebookRuntimeSettings = settings.assignNotebookRuntimeSettings.toBuilder();
            this.assignNotebookRuntimeOperationSettings = settings.assignNotebookRuntimeOperationSettings.toBuilder();
            this.getNotebookRuntimeSettings = settings.getNotebookRuntimeSettings.toBuilder();
            this.listNotebookRuntimesSettings = settings.listNotebookRuntimesSettings.toBuilder();
            this.deleteNotebookRuntimeSettings = settings.deleteNotebookRuntimeSettings.toBuilder();
            this.deleteNotebookRuntimeOperationSettings = settings.deleteNotebookRuntimeOperationSettings.toBuilder();
            this.upgradeNotebookRuntimeSettings = settings.upgradeNotebookRuntimeSettings.toBuilder();
            this.upgradeNotebookRuntimeOperationSettings = settings.upgradeNotebookRuntimeOperationSettings.toBuilder();
            this.startNotebookRuntimeSettings = settings.startNotebookRuntimeSettings.toBuilder();
            this.startNotebookRuntimeOperationSettings = settings.startNotebookRuntimeOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createNotebookRuntimeTemplateSettings, this.getNotebookRuntimeTemplateSettings, this.listNotebookRuntimeTemplatesSettings, this.deleteNotebookRuntimeTemplateSettings, this.assignNotebookRuntimeSettings, this.getNotebookRuntimeSettings, this.listNotebookRuntimesSettings, this.deleteNotebookRuntimeSettings, this.upgradeNotebookRuntimeSettings, this.startNotebookRuntimeSettings, this.listLocationsSettings, this.getLocationSettings, (Object[])new UnaryCallSettings.Builder[]{this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NotebookServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NotebookServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NotebookServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(NotebookServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createNotebookRuntimeTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getNotebookRuntimeTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listNotebookRuntimeTemplatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteNotebookRuntimeTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.assignNotebookRuntimeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getNotebookRuntimeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listNotebookRuntimesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteNotebookRuntimeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.upgradeNotebookRuntimeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.startNotebookRuntimeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createNotebookRuntimeTemplateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(NotebookRuntimeTemplate.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateNotebookRuntimeTemplateOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteNotebookRuntimeTemplateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.assignNotebookRuntimeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(NotebookRuntime.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AssignNotebookRuntimeOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteNotebookRuntimeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.upgradeNotebookRuntimeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(UpgradeNotebookRuntimeResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpgradeNotebookRuntimeOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.startNotebookRuntimeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(StartNotebookRuntimeResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(StartNotebookRuntimeOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateNotebookRuntimeTemplateRequest, Operation> createNotebookRuntimeTemplateSettings() {
            return this.createNotebookRuntimeTemplateSettings;
        }

        public OperationCallSettings.Builder<CreateNotebookRuntimeTemplateRequest, NotebookRuntimeTemplate, CreateNotebookRuntimeTemplateOperationMetadata> createNotebookRuntimeTemplateOperationSettings() {
            return this.createNotebookRuntimeTemplateOperationSettings;
        }

        public UnaryCallSettings.Builder<GetNotebookRuntimeTemplateRequest, NotebookRuntimeTemplate> getNotebookRuntimeTemplateSettings() {
            return this.getNotebookRuntimeTemplateSettings;
        }

        public PagedCallSettings.Builder<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookServiceClient.ListNotebookRuntimeTemplatesPagedResponse> listNotebookRuntimeTemplatesSettings() {
            return this.listNotebookRuntimeTemplatesSettings;
        }

        public UnaryCallSettings.Builder<DeleteNotebookRuntimeTemplateRequest, Operation> deleteNotebookRuntimeTemplateSettings() {
            return this.deleteNotebookRuntimeTemplateSettings;
        }

        public OperationCallSettings.Builder<DeleteNotebookRuntimeTemplateRequest, Empty, DeleteOperationMetadata> deleteNotebookRuntimeTemplateOperationSettings() {
            return this.deleteNotebookRuntimeTemplateOperationSettings;
        }

        public UnaryCallSettings.Builder<AssignNotebookRuntimeRequest, Operation> assignNotebookRuntimeSettings() {
            return this.assignNotebookRuntimeSettings;
        }

        public OperationCallSettings.Builder<AssignNotebookRuntimeRequest, NotebookRuntime, AssignNotebookRuntimeOperationMetadata> assignNotebookRuntimeOperationSettings() {
            return this.assignNotebookRuntimeOperationSettings;
        }

        public UnaryCallSettings.Builder<GetNotebookRuntimeRequest, NotebookRuntime> getNotebookRuntimeSettings() {
            return this.getNotebookRuntimeSettings;
        }

        public PagedCallSettings.Builder<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookServiceClient.ListNotebookRuntimesPagedResponse> listNotebookRuntimesSettings() {
            return this.listNotebookRuntimesSettings;
        }

        public UnaryCallSettings.Builder<DeleteNotebookRuntimeRequest, Operation> deleteNotebookRuntimeSettings() {
            return this.deleteNotebookRuntimeSettings;
        }

        public OperationCallSettings.Builder<DeleteNotebookRuntimeRequest, Empty, DeleteOperationMetadata> deleteNotebookRuntimeOperationSettings() {
            return this.deleteNotebookRuntimeOperationSettings;
        }

        public UnaryCallSettings.Builder<UpgradeNotebookRuntimeRequest, Operation> upgradeNotebookRuntimeSettings() {
            return this.upgradeNotebookRuntimeSettings;
        }

        public OperationCallSettings.Builder<UpgradeNotebookRuntimeRequest, UpgradeNotebookRuntimeResponse, UpgradeNotebookRuntimeOperationMetadata> upgradeNotebookRuntimeOperationSettings() {
            return this.upgradeNotebookRuntimeOperationSettings;
        }

        public UnaryCallSettings.Builder<StartNotebookRuntimeRequest, Operation> startNotebookRuntimeSettings() {
            return this.startNotebookRuntimeSettings;
        }

        public OperationCallSettings.Builder<StartNotebookRuntimeRequest, StartNotebookRuntimeResponse, StartNotebookRuntimeOperationMetadata> startNotebookRuntimeOperationSettings() {
            return this.startNotebookRuntimeOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, NotebookServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public NotebookServiceStubSettings build() throws IOException {
            return new NotebookServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

