/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.BatchPredictionJob;
import com.google.cloud.aiplatform.v1beta1.BatchPredictionJobName;
import com.google.cloud.aiplatform.v1beta1.CancelBatchPredictionJobRequest;
import com.google.cloud.aiplatform.v1beta1.CancelCustomJobRequest;
import com.google.cloud.aiplatform.v1beta1.CancelDataLabelingJobRequest;
import com.google.cloud.aiplatform.v1beta1.CancelHyperparameterTuningJobRequest;
import com.google.cloud.aiplatform.v1beta1.CancelNasJobRequest;
import com.google.cloud.aiplatform.v1beta1.CreateBatchPredictionJobRequest;
import com.google.cloud.aiplatform.v1beta1.CreateCustomJobRequest;
import com.google.cloud.aiplatform.v1beta1.CreateDataLabelingJobRequest;
import com.google.cloud.aiplatform.v1beta1.CreateHyperparameterTuningJobRequest;
import com.google.cloud.aiplatform.v1beta1.CreateModelDeploymentMonitoringJobRequest;
import com.google.cloud.aiplatform.v1beta1.CreateNasJobRequest;
import com.google.cloud.aiplatform.v1beta1.CustomJob;
import com.google.cloud.aiplatform.v1beta1.CustomJobName;
import com.google.cloud.aiplatform.v1beta1.DataLabelingJob;
import com.google.cloud.aiplatform.v1beta1.DataLabelingJobName;
import com.google.cloud.aiplatform.v1beta1.DeleteBatchPredictionJobRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteCustomJobRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteDataLabelingJobRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteHyperparameterTuningJobRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteModelDeploymentMonitoringJobRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteNasJobRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.GetBatchPredictionJobRequest;
import com.google.cloud.aiplatform.v1beta1.GetCustomJobRequest;
import com.google.cloud.aiplatform.v1beta1.GetDataLabelingJobRequest;
import com.google.cloud.aiplatform.v1beta1.GetHyperparameterTuningJobRequest;
import com.google.cloud.aiplatform.v1beta1.GetModelDeploymentMonitoringJobRequest;
import com.google.cloud.aiplatform.v1beta1.GetNasJobRequest;
import com.google.cloud.aiplatform.v1beta1.GetNasTrialDetailRequest;
import com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob;
import com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJobName;
import com.google.cloud.aiplatform.v1beta1.JobServiceSettings;
import com.google.cloud.aiplatform.v1beta1.ListBatchPredictionJobsRequest;
import com.google.cloud.aiplatform.v1beta1.ListBatchPredictionJobsResponse;
import com.google.cloud.aiplatform.v1beta1.ListCustomJobsRequest;
import com.google.cloud.aiplatform.v1beta1.ListCustomJobsResponse;
import com.google.cloud.aiplatform.v1beta1.ListDataLabelingJobsRequest;
import com.google.cloud.aiplatform.v1beta1.ListDataLabelingJobsResponse;
import com.google.cloud.aiplatform.v1beta1.ListHyperparameterTuningJobsRequest;
import com.google.cloud.aiplatform.v1beta1.ListHyperparameterTuningJobsResponse;
import com.google.cloud.aiplatform.v1beta1.ListModelDeploymentMonitoringJobsRequest;
import com.google.cloud.aiplatform.v1beta1.ListModelDeploymentMonitoringJobsResponse;
import com.google.cloud.aiplatform.v1beta1.ListNasJobsRequest;
import com.google.cloud.aiplatform.v1beta1.ListNasJobsResponse;
import com.google.cloud.aiplatform.v1beta1.ListNasTrialDetailsRequest;
import com.google.cloud.aiplatform.v1beta1.ListNasTrialDetailsResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob;
import com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobName;
import com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies;
import com.google.cloud.aiplatform.v1beta1.NasJob;
import com.google.cloud.aiplatform.v1beta1.NasJobName;
import com.google.cloud.aiplatform.v1beta1.NasTrialDetail;
import com.google.cloud.aiplatform.v1beta1.NasTrialDetailName;
import com.google.cloud.aiplatform.v1beta1.PauseModelDeploymentMonitoringJobRequest;
import com.google.cloud.aiplatform.v1beta1.ResumeModelDeploymentMonitoringJobRequest;
import com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest;
import com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateModelDeploymentMonitoringJobOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateModelDeploymentMonitoringJobRequest;
import com.google.cloud.aiplatform.v1beta1.stub.JobServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.JobServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class JobServiceClient
implements BackgroundResource {
    private final JobServiceSettings settings;
    private final JobServiceStub stub;
    private final OperationsClient operationsClient;

    public static final JobServiceClient create() throws IOException {
        return JobServiceClient.create(JobServiceSettings.newBuilder().build());
    }

    public static final JobServiceClient create(JobServiceSettings settings) throws IOException {
        return new JobServiceClient(settings);
    }

    public static final JobServiceClient create(JobServiceStub stub) {
        return new JobServiceClient(stub);
    }

    protected JobServiceClient(JobServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((JobServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected JobServiceClient(JobServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final JobServiceSettings getSettings() {
        return this.settings;
    }

    public JobServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final CustomJob createCustomJob(LocationName parent, CustomJob customJob) {
        CreateCustomJobRequest request = CreateCustomJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCustomJob(customJob).build();
        return this.createCustomJob(request);
    }

    public final CustomJob createCustomJob(String parent, CustomJob customJob) {
        CreateCustomJobRequest request = CreateCustomJobRequest.newBuilder().setParent(parent).setCustomJob(customJob).build();
        return this.createCustomJob(request);
    }

    public final CustomJob createCustomJob(CreateCustomJobRequest request) {
        return (CustomJob)this.createCustomJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCustomJobRequest, CustomJob> createCustomJobCallable() {
        return this.stub.createCustomJobCallable();
    }

    public final CustomJob getCustomJob(CustomJobName name) {
        GetCustomJobRequest request = GetCustomJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCustomJob(request);
    }

    public final CustomJob getCustomJob(String name) {
        GetCustomJobRequest request = GetCustomJobRequest.newBuilder().setName(name).build();
        return this.getCustomJob(request);
    }

    public final CustomJob getCustomJob(GetCustomJobRequest request) {
        return (CustomJob)this.getCustomJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomJobRequest, CustomJob> getCustomJobCallable() {
        return this.stub.getCustomJobCallable();
    }

    public final ListCustomJobsPagedResponse listCustomJobs(LocationName parent) {
        ListCustomJobsRequest request = ListCustomJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCustomJobs(request);
    }

    public final ListCustomJobsPagedResponse listCustomJobs(String parent) {
        ListCustomJobsRequest request = ListCustomJobsRequest.newBuilder().setParent(parent).build();
        return this.listCustomJobs(request);
    }

    public final ListCustomJobsPagedResponse listCustomJobs(ListCustomJobsRequest request) {
        return (ListCustomJobsPagedResponse)((Object)this.listCustomJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCustomJobsRequest, ListCustomJobsPagedResponse> listCustomJobsPagedCallable() {
        return this.stub.listCustomJobsPagedCallable();
    }

    public final UnaryCallable<ListCustomJobsRequest, ListCustomJobsResponse> listCustomJobsCallable() {
        return this.stub.listCustomJobsCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteCustomJobAsync(CustomJobName name) {
        DeleteCustomJobRequest request = DeleteCustomJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCustomJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteCustomJobAsync(String name) {
        DeleteCustomJobRequest request = DeleteCustomJobRequest.newBuilder().setName(name).build();
        return this.deleteCustomJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteCustomJobAsync(DeleteCustomJobRequest request) {
        return this.deleteCustomJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCustomJobRequest, Empty, DeleteOperationMetadata> deleteCustomJobOperationCallable() {
        return this.stub.deleteCustomJobOperationCallable();
    }

    public final UnaryCallable<DeleteCustomJobRequest, Operation> deleteCustomJobCallable() {
        return this.stub.deleteCustomJobCallable();
    }

    public final void cancelCustomJob(CustomJobName name) {
        CancelCustomJobRequest request = CancelCustomJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.cancelCustomJob(request);
    }

    public final void cancelCustomJob(String name) {
        CancelCustomJobRequest request = CancelCustomJobRequest.newBuilder().setName(name).build();
        this.cancelCustomJob(request);
    }

    public final void cancelCustomJob(CancelCustomJobRequest request) {
        this.cancelCustomJobCallable().call((Object)request);
    }

    public final UnaryCallable<CancelCustomJobRequest, Empty> cancelCustomJobCallable() {
        return this.stub.cancelCustomJobCallable();
    }

    public final DataLabelingJob createDataLabelingJob(LocationName parent, DataLabelingJob dataLabelingJob) {
        CreateDataLabelingJobRequest request = CreateDataLabelingJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataLabelingJob(dataLabelingJob).build();
        return this.createDataLabelingJob(request);
    }

    public final DataLabelingJob createDataLabelingJob(String parent, DataLabelingJob dataLabelingJob) {
        CreateDataLabelingJobRequest request = CreateDataLabelingJobRequest.newBuilder().setParent(parent).setDataLabelingJob(dataLabelingJob).build();
        return this.createDataLabelingJob(request);
    }

    public final DataLabelingJob createDataLabelingJob(CreateDataLabelingJobRequest request) {
        return (DataLabelingJob)this.createDataLabelingJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDataLabelingJobRequest, DataLabelingJob> createDataLabelingJobCallable() {
        return this.stub.createDataLabelingJobCallable();
    }

    public final DataLabelingJob getDataLabelingJob(DataLabelingJobName name) {
        GetDataLabelingJobRequest request = GetDataLabelingJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataLabelingJob(request);
    }

    public final DataLabelingJob getDataLabelingJob(String name) {
        GetDataLabelingJobRequest request = GetDataLabelingJobRequest.newBuilder().setName(name).build();
        return this.getDataLabelingJob(request);
    }

    public final DataLabelingJob getDataLabelingJob(GetDataLabelingJobRequest request) {
        return (DataLabelingJob)this.getDataLabelingJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataLabelingJobRequest, DataLabelingJob> getDataLabelingJobCallable() {
        return this.stub.getDataLabelingJobCallable();
    }

    public final ListDataLabelingJobsPagedResponse listDataLabelingJobs(LocationName parent) {
        ListDataLabelingJobsRequest request = ListDataLabelingJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataLabelingJobs(request);
    }

    public final ListDataLabelingJobsPagedResponse listDataLabelingJobs(String parent) {
        ListDataLabelingJobsRequest request = ListDataLabelingJobsRequest.newBuilder().setParent(parent).build();
        return this.listDataLabelingJobs(request);
    }

    public final ListDataLabelingJobsPagedResponse listDataLabelingJobs(ListDataLabelingJobsRequest request) {
        return (ListDataLabelingJobsPagedResponse)((Object)this.listDataLabelingJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataLabelingJobsRequest, ListDataLabelingJobsPagedResponse> listDataLabelingJobsPagedCallable() {
        return this.stub.listDataLabelingJobsPagedCallable();
    }

    public final UnaryCallable<ListDataLabelingJobsRequest, ListDataLabelingJobsResponse> listDataLabelingJobsCallable() {
        return this.stub.listDataLabelingJobsCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteDataLabelingJobAsync(DataLabelingJobName name) {
        DeleteDataLabelingJobRequest request = DeleteDataLabelingJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDataLabelingJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteDataLabelingJobAsync(String name) {
        DeleteDataLabelingJobRequest request = DeleteDataLabelingJobRequest.newBuilder().setName(name).build();
        return this.deleteDataLabelingJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteDataLabelingJobAsync(DeleteDataLabelingJobRequest request) {
        return this.deleteDataLabelingJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDataLabelingJobRequest, Empty, DeleteOperationMetadata> deleteDataLabelingJobOperationCallable() {
        return this.stub.deleteDataLabelingJobOperationCallable();
    }

    public final UnaryCallable<DeleteDataLabelingJobRequest, Operation> deleteDataLabelingJobCallable() {
        return this.stub.deleteDataLabelingJobCallable();
    }

    public final void cancelDataLabelingJob(DataLabelingJobName name) {
        CancelDataLabelingJobRequest request = CancelDataLabelingJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.cancelDataLabelingJob(request);
    }

    public final void cancelDataLabelingJob(String name) {
        CancelDataLabelingJobRequest request = CancelDataLabelingJobRequest.newBuilder().setName(name).build();
        this.cancelDataLabelingJob(request);
    }

    public final void cancelDataLabelingJob(CancelDataLabelingJobRequest request) {
        this.cancelDataLabelingJobCallable().call((Object)request);
    }

    public final UnaryCallable<CancelDataLabelingJobRequest, Empty> cancelDataLabelingJobCallable() {
        return this.stub.cancelDataLabelingJobCallable();
    }

    public final HyperparameterTuningJob createHyperparameterTuningJob(LocationName parent, HyperparameterTuningJob hyperparameterTuningJob) {
        CreateHyperparameterTuningJobRequest request = CreateHyperparameterTuningJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setHyperparameterTuningJob(hyperparameterTuningJob).build();
        return this.createHyperparameterTuningJob(request);
    }

    public final HyperparameterTuningJob createHyperparameterTuningJob(String parent, HyperparameterTuningJob hyperparameterTuningJob) {
        CreateHyperparameterTuningJobRequest request = CreateHyperparameterTuningJobRequest.newBuilder().setParent(parent).setHyperparameterTuningJob(hyperparameterTuningJob).build();
        return this.createHyperparameterTuningJob(request);
    }

    public final HyperparameterTuningJob createHyperparameterTuningJob(CreateHyperparameterTuningJobRequest request) {
        return (HyperparameterTuningJob)this.createHyperparameterTuningJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateHyperparameterTuningJobRequest, HyperparameterTuningJob> createHyperparameterTuningJobCallable() {
        return this.stub.createHyperparameterTuningJobCallable();
    }

    public final HyperparameterTuningJob getHyperparameterTuningJob(HyperparameterTuningJobName name) {
        GetHyperparameterTuningJobRequest request = GetHyperparameterTuningJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getHyperparameterTuningJob(request);
    }

    public final HyperparameterTuningJob getHyperparameterTuningJob(String name) {
        GetHyperparameterTuningJobRequest request = GetHyperparameterTuningJobRequest.newBuilder().setName(name).build();
        return this.getHyperparameterTuningJob(request);
    }

    public final HyperparameterTuningJob getHyperparameterTuningJob(GetHyperparameterTuningJobRequest request) {
        return (HyperparameterTuningJob)this.getHyperparameterTuningJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetHyperparameterTuningJobRequest, HyperparameterTuningJob> getHyperparameterTuningJobCallable() {
        return this.stub.getHyperparameterTuningJobCallable();
    }

    public final ListHyperparameterTuningJobsPagedResponse listHyperparameterTuningJobs(LocationName parent) {
        ListHyperparameterTuningJobsRequest request = ListHyperparameterTuningJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listHyperparameterTuningJobs(request);
    }

    public final ListHyperparameterTuningJobsPagedResponse listHyperparameterTuningJobs(String parent) {
        ListHyperparameterTuningJobsRequest request = ListHyperparameterTuningJobsRequest.newBuilder().setParent(parent).build();
        return this.listHyperparameterTuningJobs(request);
    }

    public final ListHyperparameterTuningJobsPagedResponse listHyperparameterTuningJobs(ListHyperparameterTuningJobsRequest request) {
        return (ListHyperparameterTuningJobsPagedResponse)((Object)this.listHyperparameterTuningJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListHyperparameterTuningJobsRequest, ListHyperparameterTuningJobsPagedResponse> listHyperparameterTuningJobsPagedCallable() {
        return this.stub.listHyperparameterTuningJobsPagedCallable();
    }

    public final UnaryCallable<ListHyperparameterTuningJobsRequest, ListHyperparameterTuningJobsResponse> listHyperparameterTuningJobsCallable() {
        return this.stub.listHyperparameterTuningJobsCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteHyperparameterTuningJobAsync(HyperparameterTuningJobName name) {
        DeleteHyperparameterTuningJobRequest request = DeleteHyperparameterTuningJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteHyperparameterTuningJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteHyperparameterTuningJobAsync(String name) {
        DeleteHyperparameterTuningJobRequest request = DeleteHyperparameterTuningJobRequest.newBuilder().setName(name).build();
        return this.deleteHyperparameterTuningJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteHyperparameterTuningJobAsync(DeleteHyperparameterTuningJobRequest request) {
        return this.deleteHyperparameterTuningJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteHyperparameterTuningJobRequest, Empty, DeleteOperationMetadata> deleteHyperparameterTuningJobOperationCallable() {
        return this.stub.deleteHyperparameterTuningJobOperationCallable();
    }

    public final UnaryCallable<DeleteHyperparameterTuningJobRequest, Operation> deleteHyperparameterTuningJobCallable() {
        return this.stub.deleteHyperparameterTuningJobCallable();
    }

    public final void cancelHyperparameterTuningJob(HyperparameterTuningJobName name) {
        CancelHyperparameterTuningJobRequest request = CancelHyperparameterTuningJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.cancelHyperparameterTuningJob(request);
    }

    public final void cancelHyperparameterTuningJob(String name) {
        CancelHyperparameterTuningJobRequest request = CancelHyperparameterTuningJobRequest.newBuilder().setName(name).build();
        this.cancelHyperparameterTuningJob(request);
    }

    public final void cancelHyperparameterTuningJob(CancelHyperparameterTuningJobRequest request) {
        this.cancelHyperparameterTuningJobCallable().call((Object)request);
    }

    public final UnaryCallable<CancelHyperparameterTuningJobRequest, Empty> cancelHyperparameterTuningJobCallable() {
        return this.stub.cancelHyperparameterTuningJobCallable();
    }

    public final NasJob createNasJob(LocationName parent, NasJob nasJob) {
        CreateNasJobRequest request = CreateNasJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNasJob(nasJob).build();
        return this.createNasJob(request);
    }

    public final NasJob createNasJob(String parent, NasJob nasJob) {
        CreateNasJobRequest request = CreateNasJobRequest.newBuilder().setParent(parent).setNasJob(nasJob).build();
        return this.createNasJob(request);
    }

    public final NasJob createNasJob(CreateNasJobRequest request) {
        return (NasJob)this.createNasJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateNasJobRequest, NasJob> createNasJobCallable() {
        return this.stub.createNasJobCallable();
    }

    public final NasJob getNasJob(NasJobName name) {
        GetNasJobRequest request = GetNasJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNasJob(request);
    }

    public final NasJob getNasJob(String name) {
        GetNasJobRequest request = GetNasJobRequest.newBuilder().setName(name).build();
        return this.getNasJob(request);
    }

    public final NasJob getNasJob(GetNasJobRequest request) {
        return (NasJob)this.getNasJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetNasJobRequest, NasJob> getNasJobCallable() {
        return this.stub.getNasJobCallable();
    }

    public final ListNasJobsPagedResponse listNasJobs(LocationName parent) {
        ListNasJobsRequest request = ListNasJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNasJobs(request);
    }

    public final ListNasJobsPagedResponse listNasJobs(String parent) {
        ListNasJobsRequest request = ListNasJobsRequest.newBuilder().setParent(parent).build();
        return this.listNasJobs(request);
    }

    public final ListNasJobsPagedResponse listNasJobs(ListNasJobsRequest request) {
        return (ListNasJobsPagedResponse)((Object)this.listNasJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNasJobsRequest, ListNasJobsPagedResponse> listNasJobsPagedCallable() {
        return this.stub.listNasJobsPagedCallable();
    }

    public final UnaryCallable<ListNasJobsRequest, ListNasJobsResponse> listNasJobsCallable() {
        return this.stub.listNasJobsCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteNasJobAsync(NasJobName name) {
        DeleteNasJobRequest request = DeleteNasJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteNasJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteNasJobAsync(String name) {
        DeleteNasJobRequest request = DeleteNasJobRequest.newBuilder().setName(name).build();
        return this.deleteNasJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteNasJobAsync(DeleteNasJobRequest request) {
        return this.deleteNasJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNasJobRequest, Empty, DeleteOperationMetadata> deleteNasJobOperationCallable() {
        return this.stub.deleteNasJobOperationCallable();
    }

    public final UnaryCallable<DeleteNasJobRequest, Operation> deleteNasJobCallable() {
        return this.stub.deleteNasJobCallable();
    }

    public final void cancelNasJob(NasJobName name) {
        CancelNasJobRequest request = CancelNasJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.cancelNasJob(request);
    }

    public final void cancelNasJob(String name) {
        CancelNasJobRequest request = CancelNasJobRequest.newBuilder().setName(name).build();
        this.cancelNasJob(request);
    }

    public final void cancelNasJob(CancelNasJobRequest request) {
        this.cancelNasJobCallable().call((Object)request);
    }

    public final UnaryCallable<CancelNasJobRequest, Empty> cancelNasJobCallable() {
        return this.stub.cancelNasJobCallable();
    }

    public final NasTrialDetail getNasTrialDetail(NasTrialDetailName name) {
        GetNasTrialDetailRequest request = GetNasTrialDetailRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNasTrialDetail(request);
    }

    public final NasTrialDetail getNasTrialDetail(String name) {
        GetNasTrialDetailRequest request = GetNasTrialDetailRequest.newBuilder().setName(name).build();
        return this.getNasTrialDetail(request);
    }

    public final NasTrialDetail getNasTrialDetail(GetNasTrialDetailRequest request) {
        return (NasTrialDetail)this.getNasTrialDetailCallable().call((Object)request);
    }

    public final UnaryCallable<GetNasTrialDetailRequest, NasTrialDetail> getNasTrialDetailCallable() {
        return this.stub.getNasTrialDetailCallable();
    }

    public final ListNasTrialDetailsPagedResponse listNasTrialDetails(NasJobName parent) {
        ListNasTrialDetailsRequest request = ListNasTrialDetailsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNasTrialDetails(request);
    }

    public final ListNasTrialDetailsPagedResponse listNasTrialDetails(String parent) {
        ListNasTrialDetailsRequest request = ListNasTrialDetailsRequest.newBuilder().setParent(parent).build();
        return this.listNasTrialDetails(request);
    }

    public final ListNasTrialDetailsPagedResponse listNasTrialDetails(ListNasTrialDetailsRequest request) {
        return (ListNasTrialDetailsPagedResponse)((Object)this.listNasTrialDetailsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNasTrialDetailsRequest, ListNasTrialDetailsPagedResponse> listNasTrialDetailsPagedCallable() {
        return this.stub.listNasTrialDetailsPagedCallable();
    }

    public final UnaryCallable<ListNasTrialDetailsRequest, ListNasTrialDetailsResponse> listNasTrialDetailsCallable() {
        return this.stub.listNasTrialDetailsCallable();
    }

    public final BatchPredictionJob createBatchPredictionJob(LocationName parent, BatchPredictionJob batchPredictionJob) {
        CreateBatchPredictionJobRequest request = CreateBatchPredictionJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBatchPredictionJob(batchPredictionJob).build();
        return this.createBatchPredictionJob(request);
    }

    public final BatchPredictionJob createBatchPredictionJob(String parent, BatchPredictionJob batchPredictionJob) {
        CreateBatchPredictionJobRequest request = CreateBatchPredictionJobRequest.newBuilder().setParent(parent).setBatchPredictionJob(batchPredictionJob).build();
        return this.createBatchPredictionJob(request);
    }

    public final BatchPredictionJob createBatchPredictionJob(CreateBatchPredictionJobRequest request) {
        return (BatchPredictionJob)this.createBatchPredictionJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateBatchPredictionJobRequest, BatchPredictionJob> createBatchPredictionJobCallable() {
        return this.stub.createBatchPredictionJobCallable();
    }

    public final BatchPredictionJob getBatchPredictionJob(BatchPredictionJobName name) {
        GetBatchPredictionJobRequest request = GetBatchPredictionJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBatchPredictionJob(request);
    }

    public final BatchPredictionJob getBatchPredictionJob(String name) {
        GetBatchPredictionJobRequest request = GetBatchPredictionJobRequest.newBuilder().setName(name).build();
        return this.getBatchPredictionJob(request);
    }

    public final BatchPredictionJob getBatchPredictionJob(GetBatchPredictionJobRequest request) {
        return (BatchPredictionJob)this.getBatchPredictionJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetBatchPredictionJobRequest, BatchPredictionJob> getBatchPredictionJobCallable() {
        return this.stub.getBatchPredictionJobCallable();
    }

    public final ListBatchPredictionJobsPagedResponse listBatchPredictionJobs(LocationName parent) {
        ListBatchPredictionJobsRequest request = ListBatchPredictionJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBatchPredictionJobs(request);
    }

    public final ListBatchPredictionJobsPagedResponse listBatchPredictionJobs(String parent) {
        ListBatchPredictionJobsRequest request = ListBatchPredictionJobsRequest.newBuilder().setParent(parent).build();
        return this.listBatchPredictionJobs(request);
    }

    public final ListBatchPredictionJobsPagedResponse listBatchPredictionJobs(ListBatchPredictionJobsRequest request) {
        return (ListBatchPredictionJobsPagedResponse)((Object)this.listBatchPredictionJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBatchPredictionJobsRequest, ListBatchPredictionJobsPagedResponse> listBatchPredictionJobsPagedCallable() {
        return this.stub.listBatchPredictionJobsPagedCallable();
    }

    public final UnaryCallable<ListBatchPredictionJobsRequest, ListBatchPredictionJobsResponse> listBatchPredictionJobsCallable() {
        return this.stub.listBatchPredictionJobsCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteBatchPredictionJobAsync(BatchPredictionJobName name) {
        DeleteBatchPredictionJobRequest request = DeleteBatchPredictionJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteBatchPredictionJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteBatchPredictionJobAsync(String name) {
        DeleteBatchPredictionJobRequest request = DeleteBatchPredictionJobRequest.newBuilder().setName(name).build();
        return this.deleteBatchPredictionJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteBatchPredictionJobAsync(DeleteBatchPredictionJobRequest request) {
        return this.deleteBatchPredictionJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBatchPredictionJobRequest, Empty, DeleteOperationMetadata> deleteBatchPredictionJobOperationCallable() {
        return this.stub.deleteBatchPredictionJobOperationCallable();
    }

    public final UnaryCallable<DeleteBatchPredictionJobRequest, Operation> deleteBatchPredictionJobCallable() {
        return this.stub.deleteBatchPredictionJobCallable();
    }

    public final void cancelBatchPredictionJob(BatchPredictionJobName name) {
        CancelBatchPredictionJobRequest request = CancelBatchPredictionJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.cancelBatchPredictionJob(request);
    }

    public final void cancelBatchPredictionJob(String name) {
        CancelBatchPredictionJobRequest request = CancelBatchPredictionJobRequest.newBuilder().setName(name).build();
        this.cancelBatchPredictionJob(request);
    }

    public final void cancelBatchPredictionJob(CancelBatchPredictionJobRequest request) {
        this.cancelBatchPredictionJobCallable().call((Object)request);
    }

    public final UnaryCallable<CancelBatchPredictionJobRequest, Empty> cancelBatchPredictionJobCallable() {
        return this.stub.cancelBatchPredictionJobCallable();
    }

    public final ModelDeploymentMonitoringJob createModelDeploymentMonitoringJob(LocationName parent, ModelDeploymentMonitoringJob modelDeploymentMonitoringJob) {
        CreateModelDeploymentMonitoringJobRequest request = CreateModelDeploymentMonitoringJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModelDeploymentMonitoringJob(modelDeploymentMonitoringJob).build();
        return this.createModelDeploymentMonitoringJob(request);
    }

    public final ModelDeploymentMonitoringJob createModelDeploymentMonitoringJob(String parent, ModelDeploymentMonitoringJob modelDeploymentMonitoringJob) {
        CreateModelDeploymentMonitoringJobRequest request = CreateModelDeploymentMonitoringJobRequest.newBuilder().setParent(parent).setModelDeploymentMonitoringJob(modelDeploymentMonitoringJob).build();
        return this.createModelDeploymentMonitoringJob(request);
    }

    public final ModelDeploymentMonitoringJob createModelDeploymentMonitoringJob(CreateModelDeploymentMonitoringJobRequest request) {
        return (ModelDeploymentMonitoringJob)this.createModelDeploymentMonitoringJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateModelDeploymentMonitoringJobRequest, ModelDeploymentMonitoringJob> createModelDeploymentMonitoringJobCallable() {
        return this.stub.createModelDeploymentMonitoringJobCallable();
    }

    public final SearchModelDeploymentMonitoringStatsAnomaliesPagedResponse searchModelDeploymentMonitoringStatsAnomalies(ModelDeploymentMonitoringJobName modelDeploymentMonitoringJob, String deployedModelId) {
        SearchModelDeploymentMonitoringStatsAnomaliesRequest request = SearchModelDeploymentMonitoringStatsAnomaliesRequest.newBuilder().setModelDeploymentMonitoringJob(modelDeploymentMonitoringJob == null ? null : modelDeploymentMonitoringJob.toString()).setDeployedModelId(deployedModelId).build();
        return this.searchModelDeploymentMonitoringStatsAnomalies(request);
    }

    public final SearchModelDeploymentMonitoringStatsAnomaliesPagedResponse searchModelDeploymentMonitoringStatsAnomalies(String modelDeploymentMonitoringJob, String deployedModelId) {
        SearchModelDeploymentMonitoringStatsAnomaliesRequest request = SearchModelDeploymentMonitoringStatsAnomaliesRequest.newBuilder().setModelDeploymentMonitoringJob(modelDeploymentMonitoringJob).setDeployedModelId(deployedModelId).build();
        return this.searchModelDeploymentMonitoringStatsAnomalies(request);
    }

    public final SearchModelDeploymentMonitoringStatsAnomaliesPagedResponse searchModelDeploymentMonitoringStatsAnomalies(SearchModelDeploymentMonitoringStatsAnomaliesRequest request) {
        return (SearchModelDeploymentMonitoringStatsAnomaliesPagedResponse)((Object)this.searchModelDeploymentMonitoringStatsAnomaliesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchModelDeploymentMonitoringStatsAnomaliesRequest, SearchModelDeploymentMonitoringStatsAnomaliesPagedResponse> searchModelDeploymentMonitoringStatsAnomaliesPagedCallable() {
        return this.stub.searchModelDeploymentMonitoringStatsAnomaliesPagedCallable();
    }

    public final UnaryCallable<SearchModelDeploymentMonitoringStatsAnomaliesRequest, SearchModelDeploymentMonitoringStatsAnomaliesResponse> searchModelDeploymentMonitoringStatsAnomaliesCallable() {
        return this.stub.searchModelDeploymentMonitoringStatsAnomaliesCallable();
    }

    public final ModelDeploymentMonitoringJob getModelDeploymentMonitoringJob(ModelDeploymentMonitoringJobName name) {
        GetModelDeploymentMonitoringJobRequest request = GetModelDeploymentMonitoringJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getModelDeploymentMonitoringJob(request);
    }

    public final ModelDeploymentMonitoringJob getModelDeploymentMonitoringJob(String name) {
        GetModelDeploymentMonitoringJobRequest request = GetModelDeploymentMonitoringJobRequest.newBuilder().setName(name).build();
        return this.getModelDeploymentMonitoringJob(request);
    }

    public final ModelDeploymentMonitoringJob getModelDeploymentMonitoringJob(GetModelDeploymentMonitoringJobRequest request) {
        return (ModelDeploymentMonitoringJob)this.getModelDeploymentMonitoringJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetModelDeploymentMonitoringJobRequest, ModelDeploymentMonitoringJob> getModelDeploymentMonitoringJobCallable() {
        return this.stub.getModelDeploymentMonitoringJobCallable();
    }

    public final ListModelDeploymentMonitoringJobsPagedResponse listModelDeploymentMonitoringJobs(LocationName parent) {
        ListModelDeploymentMonitoringJobsRequest request = ListModelDeploymentMonitoringJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listModelDeploymentMonitoringJobs(request);
    }

    public final ListModelDeploymentMonitoringJobsPagedResponse listModelDeploymentMonitoringJobs(String parent) {
        ListModelDeploymentMonitoringJobsRequest request = ListModelDeploymentMonitoringJobsRequest.newBuilder().setParent(parent).build();
        return this.listModelDeploymentMonitoringJobs(request);
    }

    public final ListModelDeploymentMonitoringJobsPagedResponse listModelDeploymentMonitoringJobs(ListModelDeploymentMonitoringJobsRequest request) {
        return (ListModelDeploymentMonitoringJobsPagedResponse)((Object)this.listModelDeploymentMonitoringJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelDeploymentMonitoringJobsRequest, ListModelDeploymentMonitoringJobsPagedResponse> listModelDeploymentMonitoringJobsPagedCallable() {
        return this.stub.listModelDeploymentMonitoringJobsPagedCallable();
    }

    public final UnaryCallable<ListModelDeploymentMonitoringJobsRequest, ListModelDeploymentMonitoringJobsResponse> listModelDeploymentMonitoringJobsCallable() {
        return this.stub.listModelDeploymentMonitoringJobsCallable();
    }

    public final OperationFuture<ModelDeploymentMonitoringJob, UpdateModelDeploymentMonitoringJobOperationMetadata> updateModelDeploymentMonitoringJobAsync(ModelDeploymentMonitoringJob modelDeploymentMonitoringJob, FieldMask updateMask) {
        UpdateModelDeploymentMonitoringJobRequest request = UpdateModelDeploymentMonitoringJobRequest.newBuilder().setModelDeploymentMonitoringJob(modelDeploymentMonitoringJob).setUpdateMask(updateMask).build();
        return this.updateModelDeploymentMonitoringJobAsync(request);
    }

    public final OperationFuture<ModelDeploymentMonitoringJob, UpdateModelDeploymentMonitoringJobOperationMetadata> updateModelDeploymentMonitoringJobAsync(UpdateModelDeploymentMonitoringJobRequest request) {
        return this.updateModelDeploymentMonitoringJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateModelDeploymentMonitoringJobRequest, ModelDeploymentMonitoringJob, UpdateModelDeploymentMonitoringJobOperationMetadata> updateModelDeploymentMonitoringJobOperationCallable() {
        return this.stub.updateModelDeploymentMonitoringJobOperationCallable();
    }

    public final UnaryCallable<UpdateModelDeploymentMonitoringJobRequest, Operation> updateModelDeploymentMonitoringJobCallable() {
        return this.stub.updateModelDeploymentMonitoringJobCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelDeploymentMonitoringJobAsync(ModelDeploymentMonitoringJobName name) {
        DeleteModelDeploymentMonitoringJobRequest request = DeleteModelDeploymentMonitoringJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteModelDeploymentMonitoringJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelDeploymentMonitoringJobAsync(String name) {
        DeleteModelDeploymentMonitoringJobRequest request = DeleteModelDeploymentMonitoringJobRequest.newBuilder().setName(name).build();
        return this.deleteModelDeploymentMonitoringJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelDeploymentMonitoringJobAsync(DeleteModelDeploymentMonitoringJobRequest request) {
        return this.deleteModelDeploymentMonitoringJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteModelDeploymentMonitoringJobRequest, Empty, DeleteOperationMetadata> deleteModelDeploymentMonitoringJobOperationCallable() {
        return this.stub.deleteModelDeploymentMonitoringJobOperationCallable();
    }

    public final UnaryCallable<DeleteModelDeploymentMonitoringJobRequest, Operation> deleteModelDeploymentMonitoringJobCallable() {
        return this.stub.deleteModelDeploymentMonitoringJobCallable();
    }

    public final void pauseModelDeploymentMonitoringJob(ModelDeploymentMonitoringJobName name) {
        PauseModelDeploymentMonitoringJobRequest request = PauseModelDeploymentMonitoringJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.pauseModelDeploymentMonitoringJob(request);
    }

    public final void pauseModelDeploymentMonitoringJob(String name) {
        PauseModelDeploymentMonitoringJobRequest request = PauseModelDeploymentMonitoringJobRequest.newBuilder().setName(name).build();
        this.pauseModelDeploymentMonitoringJob(request);
    }

    public final void pauseModelDeploymentMonitoringJob(PauseModelDeploymentMonitoringJobRequest request) {
        this.pauseModelDeploymentMonitoringJobCallable().call((Object)request);
    }

    public final UnaryCallable<PauseModelDeploymentMonitoringJobRequest, Empty> pauseModelDeploymentMonitoringJobCallable() {
        return this.stub.pauseModelDeploymentMonitoringJobCallable();
    }

    public final void resumeModelDeploymentMonitoringJob(ModelDeploymentMonitoringJobName name) {
        ResumeModelDeploymentMonitoringJobRequest request = ResumeModelDeploymentMonitoringJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.resumeModelDeploymentMonitoringJob(request);
    }

    public final void resumeModelDeploymentMonitoringJob(String name) {
        ResumeModelDeploymentMonitoringJobRequest request = ResumeModelDeploymentMonitoringJobRequest.newBuilder().setName(name).build();
        this.resumeModelDeploymentMonitoringJob(request);
    }

    public final void resumeModelDeploymentMonitoringJob(ResumeModelDeploymentMonitoringJobRequest request) {
        this.resumeModelDeploymentMonitoringJobCallable().call((Object)request);
    }

    public final UnaryCallable<ResumeModelDeploymentMonitoringJobRequest, Empty> resumeModelDeploymentMonitoringJobCallable() {
        return this.stub.resumeModelDeploymentMonitoringJobCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListModelDeploymentMonitoringJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelDeploymentMonitoringJobsRequest, ListModelDeploymentMonitoringJobsResponse, ModelDeploymentMonitoringJob, ListModelDeploymentMonitoringJobsPage, ListModelDeploymentMonitoringJobsFixedSizeCollection> {
        private ListModelDeploymentMonitoringJobsFixedSizeCollection(List<ListModelDeploymentMonitoringJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelDeploymentMonitoringJobsFixedSizeCollection createEmptyCollection() {
            return new ListModelDeploymentMonitoringJobsFixedSizeCollection(null, 0);
        }

        protected ListModelDeploymentMonitoringJobsFixedSizeCollection createCollection(List<ListModelDeploymentMonitoringJobsPage> pages, int collectionSize) {
            return new ListModelDeploymentMonitoringJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelDeploymentMonitoringJobsPage
    extends AbstractPage<ListModelDeploymentMonitoringJobsRequest, ListModelDeploymentMonitoringJobsResponse, ModelDeploymentMonitoringJob, ListModelDeploymentMonitoringJobsPage> {
        private ListModelDeploymentMonitoringJobsPage(PageContext<ListModelDeploymentMonitoringJobsRequest, ListModelDeploymentMonitoringJobsResponse, ModelDeploymentMonitoringJob> context, ListModelDeploymentMonitoringJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListModelDeploymentMonitoringJobsPage createEmptyPage() {
            return new ListModelDeploymentMonitoringJobsPage(null, null);
        }

        protected ListModelDeploymentMonitoringJobsPage createPage(PageContext<ListModelDeploymentMonitoringJobsRequest, ListModelDeploymentMonitoringJobsResponse, ModelDeploymentMonitoringJob> context, ListModelDeploymentMonitoringJobsResponse response) {
            return new ListModelDeploymentMonitoringJobsPage(context, response);
        }

        public ApiFuture<ListModelDeploymentMonitoringJobsPage> createPageAsync(PageContext<ListModelDeploymentMonitoringJobsRequest, ListModelDeploymentMonitoringJobsResponse, ModelDeploymentMonitoringJob> context, ApiFuture<ListModelDeploymentMonitoringJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelDeploymentMonitoringJobsPagedResponse
    extends AbstractPagedListResponse<ListModelDeploymentMonitoringJobsRequest, ListModelDeploymentMonitoringJobsResponse, ModelDeploymentMonitoringJob, ListModelDeploymentMonitoringJobsPage, ListModelDeploymentMonitoringJobsFixedSizeCollection> {
        public static ApiFuture<ListModelDeploymentMonitoringJobsPagedResponse> createAsync(PageContext<ListModelDeploymentMonitoringJobsRequest, ListModelDeploymentMonitoringJobsResponse, ModelDeploymentMonitoringJob> context, ApiFuture<ListModelDeploymentMonitoringJobsResponse> futureResponse) {
            ApiFuture<ListModelDeploymentMonitoringJobsPage> futurePage = ListModelDeploymentMonitoringJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListModelDeploymentMonitoringJobsPagedResponse((ListModelDeploymentMonitoringJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListModelDeploymentMonitoringJobsPagedResponse(ListModelDeploymentMonitoringJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelDeploymentMonitoringJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchModelDeploymentMonitoringStatsAnomaliesFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchModelDeploymentMonitoringStatsAnomaliesRequest, SearchModelDeploymentMonitoringStatsAnomaliesResponse, ModelMonitoringStatsAnomalies, SearchModelDeploymentMonitoringStatsAnomaliesPage, SearchModelDeploymentMonitoringStatsAnomaliesFixedSizeCollection> {
        private SearchModelDeploymentMonitoringStatsAnomaliesFixedSizeCollection(List<SearchModelDeploymentMonitoringStatsAnomaliesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchModelDeploymentMonitoringStatsAnomaliesFixedSizeCollection createEmptyCollection() {
            return new SearchModelDeploymentMonitoringStatsAnomaliesFixedSizeCollection(null, 0);
        }

        protected SearchModelDeploymentMonitoringStatsAnomaliesFixedSizeCollection createCollection(List<SearchModelDeploymentMonitoringStatsAnomaliesPage> pages, int collectionSize) {
            return new SearchModelDeploymentMonitoringStatsAnomaliesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchModelDeploymentMonitoringStatsAnomaliesPage
    extends AbstractPage<SearchModelDeploymentMonitoringStatsAnomaliesRequest, SearchModelDeploymentMonitoringStatsAnomaliesResponse, ModelMonitoringStatsAnomalies, SearchModelDeploymentMonitoringStatsAnomaliesPage> {
        private SearchModelDeploymentMonitoringStatsAnomaliesPage(PageContext<SearchModelDeploymentMonitoringStatsAnomaliesRequest, SearchModelDeploymentMonitoringStatsAnomaliesResponse, ModelMonitoringStatsAnomalies> context, SearchModelDeploymentMonitoringStatsAnomaliesResponse response) {
            super(context, (Object)response);
        }

        private static SearchModelDeploymentMonitoringStatsAnomaliesPage createEmptyPage() {
            return new SearchModelDeploymentMonitoringStatsAnomaliesPage(null, null);
        }

        protected SearchModelDeploymentMonitoringStatsAnomaliesPage createPage(PageContext<SearchModelDeploymentMonitoringStatsAnomaliesRequest, SearchModelDeploymentMonitoringStatsAnomaliesResponse, ModelMonitoringStatsAnomalies> context, SearchModelDeploymentMonitoringStatsAnomaliesResponse response) {
            return new SearchModelDeploymentMonitoringStatsAnomaliesPage(context, response);
        }

        public ApiFuture<SearchModelDeploymentMonitoringStatsAnomaliesPage> createPageAsync(PageContext<SearchModelDeploymentMonitoringStatsAnomaliesRequest, SearchModelDeploymentMonitoringStatsAnomaliesResponse, ModelMonitoringStatsAnomalies> context, ApiFuture<SearchModelDeploymentMonitoringStatsAnomaliesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchModelDeploymentMonitoringStatsAnomaliesPagedResponse
    extends AbstractPagedListResponse<SearchModelDeploymentMonitoringStatsAnomaliesRequest, SearchModelDeploymentMonitoringStatsAnomaliesResponse, ModelMonitoringStatsAnomalies, SearchModelDeploymentMonitoringStatsAnomaliesPage, SearchModelDeploymentMonitoringStatsAnomaliesFixedSizeCollection> {
        public static ApiFuture<SearchModelDeploymentMonitoringStatsAnomaliesPagedResponse> createAsync(PageContext<SearchModelDeploymentMonitoringStatsAnomaliesRequest, SearchModelDeploymentMonitoringStatsAnomaliesResponse, ModelMonitoringStatsAnomalies> context, ApiFuture<SearchModelDeploymentMonitoringStatsAnomaliesResponse> futureResponse) {
            ApiFuture<SearchModelDeploymentMonitoringStatsAnomaliesPage> futurePage = SearchModelDeploymentMonitoringStatsAnomaliesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchModelDeploymentMonitoringStatsAnomaliesPagedResponse((SearchModelDeploymentMonitoringStatsAnomaliesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchModelDeploymentMonitoringStatsAnomaliesPagedResponse(SearchModelDeploymentMonitoringStatsAnomaliesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchModelDeploymentMonitoringStatsAnomaliesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBatchPredictionJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBatchPredictionJobsRequest, ListBatchPredictionJobsResponse, BatchPredictionJob, ListBatchPredictionJobsPage, ListBatchPredictionJobsFixedSizeCollection> {
        private ListBatchPredictionJobsFixedSizeCollection(List<ListBatchPredictionJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBatchPredictionJobsFixedSizeCollection createEmptyCollection() {
            return new ListBatchPredictionJobsFixedSizeCollection(null, 0);
        }

        protected ListBatchPredictionJobsFixedSizeCollection createCollection(List<ListBatchPredictionJobsPage> pages, int collectionSize) {
            return new ListBatchPredictionJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBatchPredictionJobsPage
    extends AbstractPage<ListBatchPredictionJobsRequest, ListBatchPredictionJobsResponse, BatchPredictionJob, ListBatchPredictionJobsPage> {
        private ListBatchPredictionJobsPage(PageContext<ListBatchPredictionJobsRequest, ListBatchPredictionJobsResponse, BatchPredictionJob> context, ListBatchPredictionJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListBatchPredictionJobsPage createEmptyPage() {
            return new ListBatchPredictionJobsPage(null, null);
        }

        protected ListBatchPredictionJobsPage createPage(PageContext<ListBatchPredictionJobsRequest, ListBatchPredictionJobsResponse, BatchPredictionJob> context, ListBatchPredictionJobsResponse response) {
            return new ListBatchPredictionJobsPage(context, response);
        }

        public ApiFuture<ListBatchPredictionJobsPage> createPageAsync(PageContext<ListBatchPredictionJobsRequest, ListBatchPredictionJobsResponse, BatchPredictionJob> context, ApiFuture<ListBatchPredictionJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBatchPredictionJobsPagedResponse
    extends AbstractPagedListResponse<ListBatchPredictionJobsRequest, ListBatchPredictionJobsResponse, BatchPredictionJob, ListBatchPredictionJobsPage, ListBatchPredictionJobsFixedSizeCollection> {
        public static ApiFuture<ListBatchPredictionJobsPagedResponse> createAsync(PageContext<ListBatchPredictionJobsRequest, ListBatchPredictionJobsResponse, BatchPredictionJob> context, ApiFuture<ListBatchPredictionJobsResponse> futureResponse) {
            ApiFuture<ListBatchPredictionJobsPage> futurePage = ListBatchPredictionJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBatchPredictionJobsPagedResponse((ListBatchPredictionJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBatchPredictionJobsPagedResponse(ListBatchPredictionJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBatchPredictionJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNasTrialDetailsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNasTrialDetailsRequest, ListNasTrialDetailsResponse, NasTrialDetail, ListNasTrialDetailsPage, ListNasTrialDetailsFixedSizeCollection> {
        private ListNasTrialDetailsFixedSizeCollection(List<ListNasTrialDetailsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNasTrialDetailsFixedSizeCollection createEmptyCollection() {
            return new ListNasTrialDetailsFixedSizeCollection(null, 0);
        }

        protected ListNasTrialDetailsFixedSizeCollection createCollection(List<ListNasTrialDetailsPage> pages, int collectionSize) {
            return new ListNasTrialDetailsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNasTrialDetailsPage
    extends AbstractPage<ListNasTrialDetailsRequest, ListNasTrialDetailsResponse, NasTrialDetail, ListNasTrialDetailsPage> {
        private ListNasTrialDetailsPage(PageContext<ListNasTrialDetailsRequest, ListNasTrialDetailsResponse, NasTrialDetail> context, ListNasTrialDetailsResponse response) {
            super(context, (Object)response);
        }

        private static ListNasTrialDetailsPage createEmptyPage() {
            return new ListNasTrialDetailsPage(null, null);
        }

        protected ListNasTrialDetailsPage createPage(PageContext<ListNasTrialDetailsRequest, ListNasTrialDetailsResponse, NasTrialDetail> context, ListNasTrialDetailsResponse response) {
            return new ListNasTrialDetailsPage(context, response);
        }

        public ApiFuture<ListNasTrialDetailsPage> createPageAsync(PageContext<ListNasTrialDetailsRequest, ListNasTrialDetailsResponse, NasTrialDetail> context, ApiFuture<ListNasTrialDetailsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNasTrialDetailsPagedResponse
    extends AbstractPagedListResponse<ListNasTrialDetailsRequest, ListNasTrialDetailsResponse, NasTrialDetail, ListNasTrialDetailsPage, ListNasTrialDetailsFixedSizeCollection> {
        public static ApiFuture<ListNasTrialDetailsPagedResponse> createAsync(PageContext<ListNasTrialDetailsRequest, ListNasTrialDetailsResponse, NasTrialDetail> context, ApiFuture<ListNasTrialDetailsResponse> futureResponse) {
            ApiFuture<ListNasTrialDetailsPage> futurePage = ListNasTrialDetailsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNasTrialDetailsPagedResponse((ListNasTrialDetailsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNasTrialDetailsPagedResponse(ListNasTrialDetailsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNasTrialDetailsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNasJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNasJobsRequest, ListNasJobsResponse, NasJob, ListNasJobsPage, ListNasJobsFixedSizeCollection> {
        private ListNasJobsFixedSizeCollection(List<ListNasJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNasJobsFixedSizeCollection createEmptyCollection() {
            return new ListNasJobsFixedSizeCollection(null, 0);
        }

        protected ListNasJobsFixedSizeCollection createCollection(List<ListNasJobsPage> pages, int collectionSize) {
            return new ListNasJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNasJobsPage
    extends AbstractPage<ListNasJobsRequest, ListNasJobsResponse, NasJob, ListNasJobsPage> {
        private ListNasJobsPage(PageContext<ListNasJobsRequest, ListNasJobsResponse, NasJob> context, ListNasJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListNasJobsPage createEmptyPage() {
            return new ListNasJobsPage(null, null);
        }

        protected ListNasJobsPage createPage(PageContext<ListNasJobsRequest, ListNasJobsResponse, NasJob> context, ListNasJobsResponse response) {
            return new ListNasJobsPage(context, response);
        }

        public ApiFuture<ListNasJobsPage> createPageAsync(PageContext<ListNasJobsRequest, ListNasJobsResponse, NasJob> context, ApiFuture<ListNasJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNasJobsPagedResponse
    extends AbstractPagedListResponse<ListNasJobsRequest, ListNasJobsResponse, NasJob, ListNasJobsPage, ListNasJobsFixedSizeCollection> {
        public static ApiFuture<ListNasJobsPagedResponse> createAsync(PageContext<ListNasJobsRequest, ListNasJobsResponse, NasJob> context, ApiFuture<ListNasJobsResponse> futureResponse) {
            ApiFuture<ListNasJobsPage> futurePage = ListNasJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNasJobsPagedResponse((ListNasJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNasJobsPagedResponse(ListNasJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNasJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListHyperparameterTuningJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHyperparameterTuningJobsRequest, ListHyperparameterTuningJobsResponse, HyperparameterTuningJob, ListHyperparameterTuningJobsPage, ListHyperparameterTuningJobsFixedSizeCollection> {
        private ListHyperparameterTuningJobsFixedSizeCollection(List<ListHyperparameterTuningJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHyperparameterTuningJobsFixedSizeCollection createEmptyCollection() {
            return new ListHyperparameterTuningJobsFixedSizeCollection(null, 0);
        }

        protected ListHyperparameterTuningJobsFixedSizeCollection createCollection(List<ListHyperparameterTuningJobsPage> pages, int collectionSize) {
            return new ListHyperparameterTuningJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHyperparameterTuningJobsPage
    extends AbstractPage<ListHyperparameterTuningJobsRequest, ListHyperparameterTuningJobsResponse, HyperparameterTuningJob, ListHyperparameterTuningJobsPage> {
        private ListHyperparameterTuningJobsPage(PageContext<ListHyperparameterTuningJobsRequest, ListHyperparameterTuningJobsResponse, HyperparameterTuningJob> context, ListHyperparameterTuningJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListHyperparameterTuningJobsPage createEmptyPage() {
            return new ListHyperparameterTuningJobsPage(null, null);
        }

        protected ListHyperparameterTuningJobsPage createPage(PageContext<ListHyperparameterTuningJobsRequest, ListHyperparameterTuningJobsResponse, HyperparameterTuningJob> context, ListHyperparameterTuningJobsResponse response) {
            return new ListHyperparameterTuningJobsPage(context, response);
        }

        public ApiFuture<ListHyperparameterTuningJobsPage> createPageAsync(PageContext<ListHyperparameterTuningJobsRequest, ListHyperparameterTuningJobsResponse, HyperparameterTuningJob> context, ApiFuture<ListHyperparameterTuningJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHyperparameterTuningJobsPagedResponse
    extends AbstractPagedListResponse<ListHyperparameterTuningJobsRequest, ListHyperparameterTuningJobsResponse, HyperparameterTuningJob, ListHyperparameterTuningJobsPage, ListHyperparameterTuningJobsFixedSizeCollection> {
        public static ApiFuture<ListHyperparameterTuningJobsPagedResponse> createAsync(PageContext<ListHyperparameterTuningJobsRequest, ListHyperparameterTuningJobsResponse, HyperparameterTuningJob> context, ApiFuture<ListHyperparameterTuningJobsResponse> futureResponse) {
            ApiFuture<ListHyperparameterTuningJobsPage> futurePage = ListHyperparameterTuningJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListHyperparameterTuningJobsPagedResponse((ListHyperparameterTuningJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListHyperparameterTuningJobsPagedResponse(ListHyperparameterTuningJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHyperparameterTuningJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDataLabelingJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataLabelingJobsRequest, ListDataLabelingJobsResponse, DataLabelingJob, ListDataLabelingJobsPage, ListDataLabelingJobsFixedSizeCollection> {
        private ListDataLabelingJobsFixedSizeCollection(List<ListDataLabelingJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataLabelingJobsFixedSizeCollection createEmptyCollection() {
            return new ListDataLabelingJobsFixedSizeCollection(null, 0);
        }

        protected ListDataLabelingJobsFixedSizeCollection createCollection(List<ListDataLabelingJobsPage> pages, int collectionSize) {
            return new ListDataLabelingJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataLabelingJobsPage
    extends AbstractPage<ListDataLabelingJobsRequest, ListDataLabelingJobsResponse, DataLabelingJob, ListDataLabelingJobsPage> {
        private ListDataLabelingJobsPage(PageContext<ListDataLabelingJobsRequest, ListDataLabelingJobsResponse, DataLabelingJob> context, ListDataLabelingJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListDataLabelingJobsPage createEmptyPage() {
            return new ListDataLabelingJobsPage(null, null);
        }

        protected ListDataLabelingJobsPage createPage(PageContext<ListDataLabelingJobsRequest, ListDataLabelingJobsResponse, DataLabelingJob> context, ListDataLabelingJobsResponse response) {
            return new ListDataLabelingJobsPage(context, response);
        }

        public ApiFuture<ListDataLabelingJobsPage> createPageAsync(PageContext<ListDataLabelingJobsRequest, ListDataLabelingJobsResponse, DataLabelingJob> context, ApiFuture<ListDataLabelingJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataLabelingJobsPagedResponse
    extends AbstractPagedListResponse<ListDataLabelingJobsRequest, ListDataLabelingJobsResponse, DataLabelingJob, ListDataLabelingJobsPage, ListDataLabelingJobsFixedSizeCollection> {
        public static ApiFuture<ListDataLabelingJobsPagedResponse> createAsync(PageContext<ListDataLabelingJobsRequest, ListDataLabelingJobsResponse, DataLabelingJob> context, ApiFuture<ListDataLabelingJobsResponse> futureResponse) {
            ApiFuture<ListDataLabelingJobsPage> futurePage = ListDataLabelingJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDataLabelingJobsPagedResponse((ListDataLabelingJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDataLabelingJobsPagedResponse(ListDataLabelingJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataLabelingJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCustomJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCustomJobsRequest, ListCustomJobsResponse, CustomJob, ListCustomJobsPage, ListCustomJobsFixedSizeCollection> {
        private ListCustomJobsFixedSizeCollection(List<ListCustomJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCustomJobsFixedSizeCollection createEmptyCollection() {
            return new ListCustomJobsFixedSizeCollection(null, 0);
        }

        protected ListCustomJobsFixedSizeCollection createCollection(List<ListCustomJobsPage> pages, int collectionSize) {
            return new ListCustomJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCustomJobsPage
    extends AbstractPage<ListCustomJobsRequest, ListCustomJobsResponse, CustomJob, ListCustomJobsPage> {
        private ListCustomJobsPage(PageContext<ListCustomJobsRequest, ListCustomJobsResponse, CustomJob> context, ListCustomJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListCustomJobsPage createEmptyPage() {
            return new ListCustomJobsPage(null, null);
        }

        protected ListCustomJobsPage createPage(PageContext<ListCustomJobsRequest, ListCustomJobsResponse, CustomJob> context, ListCustomJobsResponse response) {
            return new ListCustomJobsPage(context, response);
        }

        public ApiFuture<ListCustomJobsPage> createPageAsync(PageContext<ListCustomJobsRequest, ListCustomJobsResponse, CustomJob> context, ApiFuture<ListCustomJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCustomJobsPagedResponse
    extends AbstractPagedListResponse<ListCustomJobsRequest, ListCustomJobsResponse, CustomJob, ListCustomJobsPage, ListCustomJobsFixedSizeCollection> {
        public static ApiFuture<ListCustomJobsPagedResponse> createAsync(PageContext<ListCustomJobsRequest, ListCustomJobsResponse, CustomJob> context, ApiFuture<ListCustomJobsResponse> futureResponse) {
            ApiFuture<ListCustomJobsPage> futurePage = ListCustomJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCustomJobsPagedResponse((ListCustomJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCustomJobsPagedResponse(ListCustomJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCustomJobsFixedSizeCollection.createEmptyCollection());
        }
    }
}

