/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.CreateIndexEndpointOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateIndexEndpointRequest;
import com.google.cloud.aiplatform.v1.DeleteIndexEndpointRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.DeployIndexOperationMetadata;
import com.google.cloud.aiplatform.v1.DeployIndexRequest;
import com.google.cloud.aiplatform.v1.DeployIndexResponse;
import com.google.cloud.aiplatform.v1.GetIndexEndpointRequest;
import com.google.cloud.aiplatform.v1.IndexEndpoint;
import com.google.cloud.aiplatform.v1.IndexEndpointServiceClient;
import com.google.cloud.aiplatform.v1.ListIndexEndpointsRequest;
import com.google.cloud.aiplatform.v1.ListIndexEndpointsResponse;
import com.google.cloud.aiplatform.v1.MutateDeployedIndexOperationMetadata;
import com.google.cloud.aiplatform.v1.MutateDeployedIndexRequest;
import com.google.cloud.aiplatform.v1.MutateDeployedIndexResponse;
import com.google.cloud.aiplatform.v1.UndeployIndexOperationMetadata;
import com.google.cloud.aiplatform.v1.UndeployIndexRequest;
import com.google.cloud.aiplatform.v1.UndeployIndexResponse;
import com.google.cloud.aiplatform.v1.UpdateIndexEndpointRequest;
import com.google.cloud.aiplatform.v1.stub.GrpcIndexEndpointServiceCallableFactory;
import com.google.cloud.aiplatform.v1.stub.IndexEndpointServiceStub;
import com.google.cloud.aiplatform.v1.stub.IndexEndpointServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcIndexEndpointServiceStub
extends IndexEndpointServiceStub {
    private static final MethodDescriptor<CreateIndexEndpointRequest, Operation> createIndexEndpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.IndexEndpointService/CreateIndexEndpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateIndexEndpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIndexEndpointRequest, IndexEndpoint> getIndexEndpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.IndexEndpointService/GetIndexEndpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIndexEndpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)IndexEndpoint.getDefaultInstance())).build();
    private static final MethodDescriptor<ListIndexEndpointsRequest, ListIndexEndpointsResponse> listIndexEndpointsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.IndexEndpointService/ListIndexEndpoints").setRequestMarshaller(ProtoUtils.marshaller((Message)ListIndexEndpointsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListIndexEndpointsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateIndexEndpointRequest, IndexEndpoint> updateIndexEndpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.IndexEndpointService/UpdateIndexEndpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateIndexEndpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)IndexEndpoint.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteIndexEndpointRequest, Operation> deleteIndexEndpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.IndexEndpointService/DeleteIndexEndpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteIndexEndpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeployIndexRequest, Operation> deployIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.IndexEndpointService/DeployIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)DeployIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UndeployIndexRequest, Operation> undeployIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.IndexEndpointService/UndeployIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)UndeployIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateDeployedIndexRequest, Operation> mutateDeployedIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.IndexEndpointService/MutateDeployedIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateDeployedIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateIndexEndpointRequest, Operation> createIndexEndpointCallable;
    private final OperationCallable<CreateIndexEndpointRequest, IndexEndpoint, CreateIndexEndpointOperationMetadata> createIndexEndpointOperationCallable;
    private final UnaryCallable<GetIndexEndpointRequest, IndexEndpoint> getIndexEndpointCallable;
    private final UnaryCallable<ListIndexEndpointsRequest, ListIndexEndpointsResponse> listIndexEndpointsCallable;
    private final UnaryCallable<ListIndexEndpointsRequest, IndexEndpointServiceClient.ListIndexEndpointsPagedResponse> listIndexEndpointsPagedCallable;
    private final UnaryCallable<UpdateIndexEndpointRequest, IndexEndpoint> updateIndexEndpointCallable;
    private final UnaryCallable<DeleteIndexEndpointRequest, Operation> deleteIndexEndpointCallable;
    private final OperationCallable<DeleteIndexEndpointRequest, Empty, DeleteOperationMetadata> deleteIndexEndpointOperationCallable;
    private final UnaryCallable<DeployIndexRequest, Operation> deployIndexCallable;
    private final OperationCallable<DeployIndexRequest, DeployIndexResponse, DeployIndexOperationMetadata> deployIndexOperationCallable;
    private final UnaryCallable<UndeployIndexRequest, Operation> undeployIndexCallable;
    private final OperationCallable<UndeployIndexRequest, UndeployIndexResponse, UndeployIndexOperationMetadata> undeployIndexOperationCallable;
    private final UnaryCallable<MutateDeployedIndexRequest, Operation> mutateDeployedIndexCallable;
    private final OperationCallable<MutateDeployedIndexRequest, MutateDeployedIndexResponse, MutateDeployedIndexOperationMetadata> mutateDeployedIndexOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, IndexEndpointServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcIndexEndpointServiceStub create(IndexEndpointServiceStubSettings settings) throws IOException {
        return new GrpcIndexEndpointServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcIndexEndpointServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcIndexEndpointServiceStub(IndexEndpointServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcIndexEndpointServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcIndexEndpointServiceStub(IndexEndpointServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcIndexEndpointServiceStub(IndexEndpointServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcIndexEndpointServiceCallableFactory());
    }

    protected GrpcIndexEndpointServiceStub(IndexEndpointServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createIndexEndpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createIndexEndpointMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getIndexEndpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIndexEndpointMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listIndexEndpointsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listIndexEndpointsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateIndexEndpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateIndexEndpointMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"index_endpoint.name", (Object)String.valueOf(request.getIndexEndpoint().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteIndexEndpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteIndexEndpointMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings deployIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deployIndexMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"index_endpoint", (Object)String.valueOf(request.getIndexEndpoint()));
            return params.build();
        }).build();
        GrpcCallSettings undeployIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(undeployIndexMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"index_endpoint", (Object)String.valueOf(request.getIndexEndpoint()));
            return params.build();
        }).build();
        GrpcCallSettings mutateDeployedIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateDeployedIndexMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"index_endpoint", (Object)String.valueOf(request.getIndexEndpoint()));
            return params.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        this.createIndexEndpointCallable = callableFactory.createUnaryCallable(createIndexEndpointTransportSettings, settings.createIndexEndpointSettings(), clientContext);
        this.createIndexEndpointOperationCallable = callableFactory.createOperationCallable(createIndexEndpointTransportSettings, settings.createIndexEndpointOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getIndexEndpointCallable = callableFactory.createUnaryCallable(getIndexEndpointTransportSettings, settings.getIndexEndpointSettings(), clientContext);
        this.listIndexEndpointsCallable = callableFactory.createUnaryCallable(listIndexEndpointsTransportSettings, settings.listIndexEndpointsSettings(), clientContext);
        this.listIndexEndpointsPagedCallable = callableFactory.createPagedCallable(listIndexEndpointsTransportSettings, settings.listIndexEndpointsSettings(), clientContext);
        this.updateIndexEndpointCallable = callableFactory.createUnaryCallable(updateIndexEndpointTransportSettings, settings.updateIndexEndpointSettings(), clientContext);
        this.deleteIndexEndpointCallable = callableFactory.createUnaryCallable(deleteIndexEndpointTransportSettings, settings.deleteIndexEndpointSettings(), clientContext);
        this.deleteIndexEndpointOperationCallable = callableFactory.createOperationCallable(deleteIndexEndpointTransportSettings, settings.deleteIndexEndpointOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deployIndexCallable = callableFactory.createUnaryCallable(deployIndexTransportSettings, settings.deployIndexSettings(), clientContext);
        this.deployIndexOperationCallable = callableFactory.createOperationCallable(deployIndexTransportSettings, settings.deployIndexOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.undeployIndexCallable = callableFactory.createUnaryCallable(undeployIndexTransportSettings, settings.undeployIndexSettings(), clientContext);
        this.undeployIndexOperationCallable = callableFactory.createOperationCallable(undeployIndexTransportSettings, settings.undeployIndexOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.mutateDeployedIndexCallable = callableFactory.createUnaryCallable(mutateDeployedIndexTransportSettings, settings.mutateDeployedIndexSettings(), clientContext);
        this.mutateDeployedIndexOperationCallable = callableFactory.createOperationCallable(mutateDeployedIndexTransportSettings, settings.mutateDeployedIndexOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateIndexEndpointRequest, Operation> createIndexEndpointCallable() {
        return this.createIndexEndpointCallable;
    }

    @Override
    public OperationCallable<CreateIndexEndpointRequest, IndexEndpoint, CreateIndexEndpointOperationMetadata> createIndexEndpointOperationCallable() {
        return this.createIndexEndpointOperationCallable;
    }

    @Override
    public UnaryCallable<GetIndexEndpointRequest, IndexEndpoint> getIndexEndpointCallable() {
        return this.getIndexEndpointCallable;
    }

    @Override
    public UnaryCallable<ListIndexEndpointsRequest, ListIndexEndpointsResponse> listIndexEndpointsCallable() {
        return this.listIndexEndpointsCallable;
    }

    @Override
    public UnaryCallable<ListIndexEndpointsRequest, IndexEndpointServiceClient.ListIndexEndpointsPagedResponse> listIndexEndpointsPagedCallable() {
        return this.listIndexEndpointsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateIndexEndpointRequest, IndexEndpoint> updateIndexEndpointCallable() {
        return this.updateIndexEndpointCallable;
    }

    @Override
    public UnaryCallable<DeleteIndexEndpointRequest, Operation> deleteIndexEndpointCallable() {
        return this.deleteIndexEndpointCallable;
    }

    @Override
    public OperationCallable<DeleteIndexEndpointRequest, Empty, DeleteOperationMetadata> deleteIndexEndpointOperationCallable() {
        return this.deleteIndexEndpointOperationCallable;
    }

    @Override
    public UnaryCallable<DeployIndexRequest, Operation> deployIndexCallable() {
        return this.deployIndexCallable;
    }

    @Override
    public OperationCallable<DeployIndexRequest, DeployIndexResponse, DeployIndexOperationMetadata> deployIndexOperationCallable() {
        return this.deployIndexOperationCallable;
    }

    @Override
    public UnaryCallable<UndeployIndexRequest, Operation> undeployIndexCallable() {
        return this.undeployIndexCallable;
    }

    @Override
    public OperationCallable<UndeployIndexRequest, UndeployIndexResponse, UndeployIndexOperationMetadata> undeployIndexOperationCallable() {
        return this.undeployIndexOperationCallable;
    }

    @Override
    public UnaryCallable<MutateDeployedIndexRequest, Operation> mutateDeployedIndexCallable() {
        return this.mutateDeployedIndexCallable;
    }

    @Override
    public OperationCallable<MutateDeployedIndexRequest, MutateDeployedIndexResponse, MutateDeployedIndexOperationMetadata> mutateDeployedIndexOperationCallable() {
        return this.mutateDeployedIndexOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, IndexEndpointServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

