/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.EntityTypeName;
import com.google.cloud.aiplatform.v1.FeaturestoreOnlineServingServiceSettings;
import com.google.cloud.aiplatform.v1.ReadFeatureValuesRequest;
import com.google.cloud.aiplatform.v1.ReadFeatureValuesResponse;
import com.google.cloud.aiplatform.v1.StreamingReadFeatureValuesRequest;
import com.google.cloud.aiplatform.v1.stub.FeaturestoreOnlineServingServiceStub;
import com.google.cloud.aiplatform.v1.stub.FeaturestoreOnlineServingServiceStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class FeaturestoreOnlineServingServiceClient
implements BackgroundResource {
    private final FeaturestoreOnlineServingServiceSettings settings;
    private final FeaturestoreOnlineServingServiceStub stub;

    public static final FeaturestoreOnlineServingServiceClient create() throws IOException {
        return FeaturestoreOnlineServingServiceClient.create(FeaturestoreOnlineServingServiceSettings.newBuilder().build());
    }

    public static final FeaturestoreOnlineServingServiceClient create(FeaturestoreOnlineServingServiceSettings settings) throws IOException {
        return new FeaturestoreOnlineServingServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final FeaturestoreOnlineServingServiceClient create(FeaturestoreOnlineServingServiceStub stub) {
        return new FeaturestoreOnlineServingServiceClient(stub);
    }

    protected FeaturestoreOnlineServingServiceClient(FeaturestoreOnlineServingServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FeaturestoreOnlineServingServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected FeaturestoreOnlineServingServiceClient(FeaturestoreOnlineServingServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FeaturestoreOnlineServingServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FeaturestoreOnlineServingServiceStub getStub() {
        return this.stub;
    }

    public final ReadFeatureValuesResponse readFeatureValues(EntityTypeName entityType) {
        ReadFeatureValuesRequest request = ReadFeatureValuesRequest.newBuilder().setEntityType(entityType == null ? null : entityType.toString()).build();
        return this.readFeatureValues(request);
    }

    public final ReadFeatureValuesResponse readFeatureValues(String entityType) {
        ReadFeatureValuesRequest request = ReadFeatureValuesRequest.newBuilder().setEntityType(entityType).build();
        return this.readFeatureValues(request);
    }

    public final ReadFeatureValuesResponse readFeatureValues(ReadFeatureValuesRequest request) {
        return (ReadFeatureValuesResponse)this.readFeatureValuesCallable().call((Object)request);
    }

    public final UnaryCallable<ReadFeatureValuesRequest, ReadFeatureValuesResponse> readFeatureValuesCallable() {
        return this.stub.readFeatureValuesCallable();
    }

    public final ServerStreamingCallable<StreamingReadFeatureValuesRequest, ReadFeatureValuesResponse> streamingReadFeatureValuesCallable() {
        return this.stub.streamingReadFeatureValuesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

