/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.CreateEndpointOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateEndpointRequest;
import com.google.cloud.aiplatform.v1.DeleteEndpointRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.DeployModelOperationMetadata;
import com.google.cloud.aiplatform.v1.DeployModelRequest;
import com.google.cloud.aiplatform.v1.DeployModelResponse;
import com.google.cloud.aiplatform.v1.Endpoint;
import com.google.cloud.aiplatform.v1.EndpointServiceClient;
import com.google.cloud.aiplatform.v1.GetEndpointRequest;
import com.google.cloud.aiplatform.v1.ListEndpointsRequest;
import com.google.cloud.aiplatform.v1.ListEndpointsResponse;
import com.google.cloud.aiplatform.v1.UndeployModelOperationMetadata;
import com.google.cloud.aiplatform.v1.UndeployModelRequest;
import com.google.cloud.aiplatform.v1.UndeployModelResponse;
import com.google.cloud.aiplatform.v1.UpdateEndpointRequest;
import com.google.cloud.aiplatform.v1.stub.EndpointServiceStub;
import com.google.cloud.aiplatform.v1.stub.GrpcEndpointServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class EndpointServiceStubSettings
extends StubSettings<EndpointServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateEndpointRequest, Operation> createEndpointSettings;
    private final OperationCallSettings<CreateEndpointRequest, Endpoint, CreateEndpointOperationMetadata> createEndpointOperationSettings;
    private final UnaryCallSettings<GetEndpointRequest, Endpoint> getEndpointSettings;
    private final PagedCallSettings<ListEndpointsRequest, ListEndpointsResponse, EndpointServiceClient.ListEndpointsPagedResponse> listEndpointsSettings;
    private final UnaryCallSettings<UpdateEndpointRequest, Endpoint> updateEndpointSettings;
    private final UnaryCallSettings<DeleteEndpointRequest, Operation> deleteEndpointSettings;
    private final OperationCallSettings<DeleteEndpointRequest, Empty, DeleteOperationMetadata> deleteEndpointOperationSettings;
    private final UnaryCallSettings<DeployModelRequest, Operation> deployModelSettings;
    private final OperationCallSettings<DeployModelRequest, DeployModelResponse, DeployModelOperationMetadata> deployModelOperationSettings;
    private final UnaryCallSettings<UndeployModelRequest, Operation> undeployModelSettings;
    private final OperationCallSettings<UndeployModelRequest, UndeployModelResponse, UndeployModelOperationMetadata> undeployModelOperationSettings;
    private static final PagedListDescriptor<ListEndpointsRequest, ListEndpointsResponse, Endpoint> LIST_ENDPOINTS_PAGE_STR_DESC = new PagedListDescriptor<ListEndpointsRequest, ListEndpointsResponse, Endpoint>(){

        public String emptyToken() {
            return "";
        }

        public ListEndpointsRequest injectToken(ListEndpointsRequest payload, String token) {
            return ListEndpointsRequest.newBuilder((ListEndpointsRequest)payload).setPageToken(token).build();
        }

        public ListEndpointsRequest injectPageSize(ListEndpointsRequest payload, int pageSize) {
            return ListEndpointsRequest.newBuilder((ListEndpointsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEndpointsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEndpointsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Endpoint> extractResources(ListEndpointsResponse payload) {
            return payload.getEndpointsList() == null ? ImmutableList.of() : payload.getEndpointsList();
        }
    };
    private static final PagedListResponseFactory<ListEndpointsRequest, ListEndpointsResponse, EndpointServiceClient.ListEndpointsPagedResponse> LIST_ENDPOINTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEndpointsRequest, ListEndpointsResponse, EndpointServiceClient.ListEndpointsPagedResponse>(){

        public ApiFuture<EndpointServiceClient.ListEndpointsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> callable, ListEndpointsRequest request, ApiCallContext context, ApiFuture<ListEndpointsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENDPOINTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EndpointServiceClient.ListEndpointsPagedResponse.createAsync((PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateEndpointRequest, Operation> createEndpointSettings() {
        return this.createEndpointSettings;
    }

    public OperationCallSettings<CreateEndpointRequest, Endpoint, CreateEndpointOperationMetadata> createEndpointOperationSettings() {
        return this.createEndpointOperationSettings;
    }

    public UnaryCallSettings<GetEndpointRequest, Endpoint> getEndpointSettings() {
        return this.getEndpointSettings;
    }

    public PagedCallSettings<ListEndpointsRequest, ListEndpointsResponse, EndpointServiceClient.ListEndpointsPagedResponse> listEndpointsSettings() {
        return this.listEndpointsSettings;
    }

    public UnaryCallSettings<UpdateEndpointRequest, Endpoint> updateEndpointSettings() {
        return this.updateEndpointSettings;
    }

    public UnaryCallSettings<DeleteEndpointRequest, Operation> deleteEndpointSettings() {
        return this.deleteEndpointSettings;
    }

    public OperationCallSettings<DeleteEndpointRequest, Empty, DeleteOperationMetadata> deleteEndpointOperationSettings() {
        return this.deleteEndpointOperationSettings;
    }

    public UnaryCallSettings<DeployModelRequest, Operation> deployModelSettings() {
        return this.deployModelSettings;
    }

    public OperationCallSettings<DeployModelRequest, DeployModelResponse, DeployModelOperationMetadata> deployModelOperationSettings() {
        return this.deployModelOperationSettings;
    }

    public UnaryCallSettings<UndeployModelRequest, Operation> undeployModelSettings() {
        return this.undeployModelSettings;
    }

    public OperationCallSettings<UndeployModelRequest, UndeployModelResponse, UndeployModelOperationMetadata> undeployModelOperationSettings() {
        return this.undeployModelOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public EndpointServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEndpointServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EndpointServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EndpointServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EndpointServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createEndpointSettings = settingsBuilder.createEndpointSettings().build();
        this.createEndpointOperationSettings = settingsBuilder.createEndpointOperationSettings().build();
        this.getEndpointSettings = settingsBuilder.getEndpointSettings().build();
        this.listEndpointsSettings = settingsBuilder.listEndpointsSettings().build();
        this.updateEndpointSettings = settingsBuilder.updateEndpointSettings().build();
        this.deleteEndpointSettings = settingsBuilder.deleteEndpointSettings().build();
        this.deleteEndpointOperationSettings = settingsBuilder.deleteEndpointOperationSettings().build();
        this.deployModelSettings = settingsBuilder.deployModelSettings().build();
        this.deployModelOperationSettings = settingsBuilder.deployModelOperationSettings().build();
        this.undeployModelSettings = settingsBuilder.undeployModelSettings().build();
        this.undeployModelOperationSettings = settingsBuilder.undeployModelOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EndpointServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateEndpointRequest, Operation> createEndpointSettings;
        private final OperationCallSettings.Builder<CreateEndpointRequest, Endpoint, CreateEndpointOperationMetadata> createEndpointOperationSettings;
        private final UnaryCallSettings.Builder<GetEndpointRequest, Endpoint> getEndpointSettings;
        private final PagedCallSettings.Builder<ListEndpointsRequest, ListEndpointsResponse, EndpointServiceClient.ListEndpointsPagedResponse> listEndpointsSettings;
        private final UnaryCallSettings.Builder<UpdateEndpointRequest, Endpoint> updateEndpointSettings;
        private final UnaryCallSettings.Builder<DeleteEndpointRequest, Operation> deleteEndpointSettings;
        private final OperationCallSettings.Builder<DeleteEndpointRequest, Empty, DeleteOperationMetadata> deleteEndpointOperationSettings;
        private final UnaryCallSettings.Builder<DeployModelRequest, Operation> deployModelSettings;
        private final OperationCallSettings.Builder<DeployModelRequest, DeployModelResponse, DeployModelOperationMetadata> deployModelOperationSettings;
        private final UnaryCallSettings.Builder<UndeployModelRequest, Operation> undeployModelSettings;
        private final OperationCallSettings.Builder<UndeployModelRequest, UndeployModelResponse, UndeployModelOperationMetadata> undeployModelOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEndpointOperationSettings = OperationCallSettings.newBuilder();
            this.getEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEndpointsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENDPOINTS_PAGE_STR_FACT);
            this.updateEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEndpointOperationSettings = OperationCallSettings.newBuilder();
            this.deployModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deployModelOperationSettings = OperationCallSettings.newBuilder();
            this.undeployModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeployModelOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEndpointSettings, this.getEndpointSettings, this.listEndpointsSettings, this.updateEndpointSettings, this.deleteEndpointSettings, this.deployModelSettings, this.undeployModelSettings);
            Builder.initDefaults(this);
        }

        protected Builder(EndpointServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createEndpointSettings = settings.createEndpointSettings.toBuilder();
            this.createEndpointOperationSettings = settings.createEndpointOperationSettings.toBuilder();
            this.getEndpointSettings = settings.getEndpointSettings.toBuilder();
            this.listEndpointsSettings = settings.listEndpointsSettings.toBuilder();
            this.updateEndpointSettings = settings.updateEndpointSettings.toBuilder();
            this.deleteEndpointSettings = settings.deleteEndpointSettings.toBuilder();
            this.deleteEndpointOperationSettings = settings.deleteEndpointOperationSettings.toBuilder();
            this.deployModelSettings = settings.deployModelSettings.toBuilder();
            this.deployModelOperationSettings = settings.deployModelOperationSettings.toBuilder();
            this.undeployModelSettings = settings.undeployModelSettings.toBuilder();
            this.undeployModelOperationSettings = settings.undeployModelOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEndpointSettings, this.getEndpointSettings, this.listEndpointsSettings, this.updateEndpointSettings, this.deleteEndpointSettings, this.deployModelSettings, this.undeployModelSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EndpointServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EndpointServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EndpointServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(EndpointServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(EndpointServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listEndpointsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deployModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.undeployModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createEndpointOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Endpoint.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateEndpointOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteEndpointOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deployModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DeployModelResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeployModelOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.undeployModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(UndeployModelResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UndeployModelOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateEndpointRequest, Operation> createEndpointSettings() {
            return this.createEndpointSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateEndpointRequest, Endpoint, CreateEndpointOperationMetadata> createEndpointOperationSettings() {
            return this.createEndpointOperationSettings;
        }

        public UnaryCallSettings.Builder<GetEndpointRequest, Endpoint> getEndpointSettings() {
            return this.getEndpointSettings;
        }

        public PagedCallSettings.Builder<ListEndpointsRequest, ListEndpointsResponse, EndpointServiceClient.ListEndpointsPagedResponse> listEndpointsSettings() {
            return this.listEndpointsSettings;
        }

        public UnaryCallSettings.Builder<UpdateEndpointRequest, Endpoint> updateEndpointSettings() {
            return this.updateEndpointSettings;
        }

        public UnaryCallSettings.Builder<DeleteEndpointRequest, Operation> deleteEndpointSettings() {
            return this.deleteEndpointSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteEndpointRequest, Empty, DeleteOperationMetadata> deleteEndpointOperationSettings() {
            return this.deleteEndpointOperationSettings;
        }

        public UnaryCallSettings.Builder<DeployModelRequest, Operation> deployModelSettings() {
            return this.deployModelSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeployModelRequest, DeployModelResponse, DeployModelOperationMetadata> deployModelOperationSettings() {
            return this.deployModelOperationSettings;
        }

        public UnaryCallSettings.Builder<UndeployModelRequest, Operation> undeployModelSettings() {
            return this.undeployModelSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UndeployModelRequest, UndeployModelResponse, UndeployModelOperationMetadata> undeployModelOperationSettings() {
            return this.undeployModelOperationSettings;
        }

        public EndpointServiceStubSettings build() throws IOException {
            return new EndpointServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

