/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateIndexOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateIndexRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteIndexRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.GetIndexRequest;
import com.google.cloud.aiplatform.v1beta1.Index;
import com.google.cloud.aiplatform.v1beta1.IndexName;
import com.google.cloud.aiplatform.v1beta1.IndexServiceSettings;
import com.google.cloud.aiplatform.v1beta1.ListIndexesRequest;
import com.google.cloud.aiplatform.v1beta1.ListIndexesResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.UpdateIndexOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateIndexRequest;
import com.google.cloud.aiplatform.v1beta1.stub.IndexServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.IndexServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class IndexServiceClient
implements BackgroundResource {
    private final IndexServiceSettings settings;
    private final IndexServiceStub stub;
    private final OperationsClient operationsClient;

    public static final IndexServiceClient create() throws IOException {
        return IndexServiceClient.create(IndexServiceSettings.newBuilder().build());
    }

    public static final IndexServiceClient create(IndexServiceSettings settings) throws IOException {
        return new IndexServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final IndexServiceClient create(IndexServiceStub stub) {
        return new IndexServiceClient(stub);
    }

    protected IndexServiceClient(IndexServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((IndexServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected IndexServiceClient(IndexServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final IndexServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public IndexServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Index, CreateIndexOperationMetadata> createIndexAsync(LocationName parent, Index index) {
        CreateIndexRequest request = CreateIndexRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setIndex(index).build();
        return this.createIndexAsync(request);
    }

    public final OperationFuture<Index, CreateIndexOperationMetadata> createIndexAsync(String parent, Index index) {
        CreateIndexRequest request = CreateIndexRequest.newBuilder().setParent(parent).setIndex(index).build();
        return this.createIndexAsync(request);
    }

    public final OperationFuture<Index, CreateIndexOperationMetadata> createIndexAsync(CreateIndexRequest request) {
        return this.createIndexOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateIndexRequest, Index, CreateIndexOperationMetadata> createIndexOperationCallable() {
        return this.stub.createIndexOperationCallable();
    }

    public final UnaryCallable<CreateIndexRequest, Operation> createIndexCallable() {
        return this.stub.createIndexCallable();
    }

    public final Index getIndex(IndexName name) {
        GetIndexRequest request = GetIndexRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getIndex(request);
    }

    public final Index getIndex(String name) {
        GetIndexRequest request = GetIndexRequest.newBuilder().setName(name).build();
        return this.getIndex(request);
    }

    public final Index getIndex(GetIndexRequest request) {
        return (Index)this.getIndexCallable().call((Object)request);
    }

    public final UnaryCallable<GetIndexRequest, Index> getIndexCallable() {
        return this.stub.getIndexCallable();
    }

    public final ListIndexesPagedResponse listIndexes(LocationName parent) {
        ListIndexesRequest request = ListIndexesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listIndexes(request);
    }

    public final ListIndexesPagedResponse listIndexes(String parent) {
        ListIndexesRequest request = ListIndexesRequest.newBuilder().setParent(parent).build();
        return this.listIndexes(request);
    }

    public final ListIndexesPagedResponse listIndexes(ListIndexesRequest request) {
        return (ListIndexesPagedResponse)((Object)this.listIndexesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListIndexesRequest, ListIndexesPagedResponse> listIndexesPagedCallable() {
        return this.stub.listIndexesPagedCallable();
    }

    public final UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable() {
        return this.stub.listIndexesCallable();
    }

    public final OperationFuture<Index, UpdateIndexOperationMetadata> updateIndexAsync(Index index, FieldMask updateMask) {
        UpdateIndexRequest request = UpdateIndexRequest.newBuilder().setIndex(index).setUpdateMask(updateMask).build();
        return this.updateIndexAsync(request);
    }

    public final OperationFuture<Index, UpdateIndexOperationMetadata> updateIndexAsync(UpdateIndexRequest request) {
        return this.updateIndexOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateIndexRequest, Index, UpdateIndexOperationMetadata> updateIndexOperationCallable() {
        return this.stub.updateIndexOperationCallable();
    }

    public final UnaryCallable<UpdateIndexRequest, Operation> updateIndexCallable() {
        return this.stub.updateIndexCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteIndexAsync(IndexName name) {
        DeleteIndexRequest request = DeleteIndexRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteIndexAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteIndexAsync(String name) {
        DeleteIndexRequest request = DeleteIndexRequest.newBuilder().setName(name).build();
        return this.deleteIndexAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteIndexAsync(DeleteIndexRequest request) {
        return this.deleteIndexOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteIndexRequest, Empty, DeleteOperationMetadata> deleteIndexOperationCallable() {
        return this.stub.deleteIndexOperationCallable();
    }

    public final UnaryCallable<DeleteIndexRequest, Operation> deleteIndexCallable() {
        return this.stub.deleteIndexCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListIndexesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListIndexesRequest, ListIndexesResponse, Index, ListIndexesPage, ListIndexesFixedSizeCollection> {
        private ListIndexesFixedSizeCollection(List<ListIndexesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListIndexesFixedSizeCollection createEmptyCollection() {
            return new ListIndexesFixedSizeCollection(null, 0);
        }

        protected ListIndexesFixedSizeCollection createCollection(List<ListIndexesPage> pages, int collectionSize) {
            return new ListIndexesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListIndexesPage
    extends AbstractPage<ListIndexesRequest, ListIndexesResponse, Index, ListIndexesPage> {
        private ListIndexesPage(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ListIndexesResponse response) {
            super(context, (Object)response);
        }

        private static ListIndexesPage createEmptyPage() {
            return new ListIndexesPage(null, null);
        }

        protected ListIndexesPage createPage(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ListIndexesResponse response) {
            return new ListIndexesPage(context, response);
        }

        public ApiFuture<ListIndexesPage> createPageAsync(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ApiFuture<ListIndexesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListIndexesPagedResponse
    extends AbstractPagedListResponse<ListIndexesRequest, ListIndexesResponse, Index, ListIndexesPage, ListIndexesFixedSizeCollection> {
        public static ApiFuture<ListIndexesPagedResponse> createAsync(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ApiFuture<ListIndexesResponse> futureResponse) {
            ApiFuture<ListIndexesPage> futurePage = ListIndexesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListIndexesPagedResponse((ListIndexesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListIndexesPagedResponse(ListIndexesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListIndexesFixedSizeCollection.createEmptyCollection());
        }
    }
}

