/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateIndexOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateIndexRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteIndexRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.GetIndexRequest;
import com.google.cloud.aiplatform.v1beta1.Index;
import com.google.cloud.aiplatform.v1beta1.IndexServiceClient;
import com.google.cloud.aiplatform.v1beta1.ListIndexesRequest;
import com.google.cloud.aiplatform.v1beta1.ListIndexesResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateIndexOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateIndexRequest;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcIndexServiceCallableFactory;
import com.google.cloud.aiplatform.v1beta1.stub.IndexServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.IndexServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcIndexServiceStub
extends IndexServiceStub {
    private static final MethodDescriptor<CreateIndexRequest, Operation> createIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.IndexService/CreateIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIndexRequest, Index> getIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.IndexService/GetIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Index.getDefaultInstance())).build();
    private static final MethodDescriptor<ListIndexesRequest, ListIndexesResponse> listIndexesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.IndexService/ListIndexes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListIndexesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListIndexesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateIndexRequest, Operation> updateIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.IndexService/UpdateIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteIndexRequest, Operation> deleteIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.IndexService/DeleteIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<CreateIndexRequest, Operation> createIndexCallable;
    private final OperationCallable<CreateIndexRequest, Index, CreateIndexOperationMetadata> createIndexOperationCallable;
    private final UnaryCallable<GetIndexRequest, Index> getIndexCallable;
    private final UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable;
    private final UnaryCallable<ListIndexesRequest, IndexServiceClient.ListIndexesPagedResponse> listIndexesPagedCallable;
    private final UnaryCallable<UpdateIndexRequest, Operation> updateIndexCallable;
    private final OperationCallable<UpdateIndexRequest, Index, UpdateIndexOperationMetadata> updateIndexOperationCallable;
    private final UnaryCallable<DeleteIndexRequest, Operation> deleteIndexCallable;
    private final OperationCallable<DeleteIndexRequest, Empty, DeleteOperationMetadata> deleteIndexOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcIndexServiceStub create(IndexServiceStubSettings settings) throws IOException {
        return new GrpcIndexServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcIndexServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcIndexServiceStub(IndexServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcIndexServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcIndexServiceStub(IndexServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcIndexServiceStub(IndexServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcIndexServiceCallableFactory());
    }

    protected GrpcIndexServiceStub(IndexServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createIndexMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateIndexRequest>(){

            public Map<String, String> extract(CreateIndexRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIndexMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetIndexRequest>(){

            public Map<String, String> extract(GetIndexRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listIndexesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listIndexesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListIndexesRequest>(){

            public Map<String, String> extract(ListIndexesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateIndexMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateIndexRequest>(){

            public Map<String, String> extract(UpdateIndexRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"index.name", (Object)String.valueOf(request.getIndex().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteIndexMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteIndexRequest>(){

            public Map<String, String> extract(DeleteIndexRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.createIndexCallable = callableFactory.createUnaryCallable(createIndexTransportSettings, settings.createIndexSettings(), clientContext);
        this.createIndexOperationCallable = callableFactory.createOperationCallable(createIndexTransportSettings, settings.createIndexOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getIndexCallable = callableFactory.createUnaryCallable(getIndexTransportSettings, settings.getIndexSettings(), clientContext);
        this.listIndexesCallable = callableFactory.createUnaryCallable(listIndexesTransportSettings, settings.listIndexesSettings(), clientContext);
        this.listIndexesPagedCallable = callableFactory.createPagedCallable(listIndexesTransportSettings, settings.listIndexesSettings(), clientContext);
        this.updateIndexCallable = callableFactory.createUnaryCallable(updateIndexTransportSettings, settings.updateIndexSettings(), clientContext);
        this.updateIndexOperationCallable = callableFactory.createOperationCallable(updateIndexTransportSettings, settings.updateIndexOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteIndexCallable = callableFactory.createUnaryCallable(deleteIndexTransportSettings, settings.deleteIndexSettings(), clientContext);
        this.deleteIndexOperationCallable = callableFactory.createOperationCallable(deleteIndexTransportSettings, settings.deleteIndexOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateIndexRequest, Operation> createIndexCallable() {
        return this.createIndexCallable;
    }

    @Override
    public OperationCallable<CreateIndexRequest, Index, CreateIndexOperationMetadata> createIndexOperationCallable() {
        return this.createIndexOperationCallable;
    }

    @Override
    public UnaryCallable<GetIndexRequest, Index> getIndexCallable() {
        return this.getIndexCallable;
    }

    @Override
    public UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable() {
        return this.listIndexesCallable;
    }

    @Override
    public UnaryCallable<ListIndexesRequest, IndexServiceClient.ListIndexesPagedResponse> listIndexesPagedCallable() {
        return this.listIndexesPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateIndexRequest, Operation> updateIndexCallable() {
        return this.updateIndexCallable;
    }

    @Override
    public OperationCallable<UpdateIndexRequest, Index, UpdateIndexOperationMetadata> updateIndexOperationCallable() {
        return this.updateIndexOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteIndexRequest, Operation> deleteIndexCallable() {
        return this.deleteIndexCallable;
    }

    @Override
    public OperationCallable<DeleteIndexRequest, Empty, DeleteOperationMetadata> deleteIndexOperationCallable() {
        return this.deleteIndexOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

