/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker.http;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class TimeoutFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(TimeoutFilter.class.getName());
    private final int timeoutMs;

    public TimeoutFilter(int timeoutSeconds) {
        this.timeoutMs = timeoutSeconds * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, final ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Timer timer = new Timer(true);
        TimerTask timeoutTask = new TimerTask(){

            @Override
            public void run() {
                if (response instanceof HttpServletResponse) {
                    try {
                        ((HttpServletResponse)response).sendError(408, "Request timed out");
                    }
                    catch (IOException e) {
                        logger.warning("Error while sending HTTP response: " + e.toString());
                    }
                } else {
                    try {
                        response.getWriter().write("Request timed out");
                    }
                    catch (IOException e) {
                        logger.warning("Error while writing response: " + e.toString());
                    }
                }
            }
        };
        timer.schedule(timeoutTask, this.timeoutMs);
        try {
            chain.doFilter(request, response);
            timeoutTask.cancel();
        }
        finally {
            timer.purge();
        }
    }
}

