/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker;

import com.google.cloud.functions.HttpRequest;
import com.google.cloud.functions.HttpResponse;
import com.google.cloud.functions.TypedFunction;
import com.google.cloud.functions.invoker.http.HttpRequestImpl;
import com.google.cloud.functions.invoker.http.HttpResponseImpl;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TypedFunctionExecutor
extends HttpServlet {
    private static final String APPLY_METHOD = "apply";
    private static final Logger logger = Logger.getLogger("com.google.cloud.functions.invoker");
    private final Type argType;
    private final TypedFunction<Object, Object> function;
    private final TypedFunction.WireFormat format;

    private TypedFunctionExecutor(Type argType, TypedFunction<Object, Object> func, TypedFunction.WireFormat format) {
        this.argType = argType;
        this.function = func;
        this.format = format;
    }

    public static TypedFunctionExecutor forClass(Class<?> functionClass) {
        TypedFunction typedFunction;
        if (!TypedFunction.class.isAssignableFrom(functionClass)) {
            throw new RuntimeException("Class " + functionClass.getName() + " does not implement " + TypedFunction.class.getName());
        }
        Class<TypedFunction> typedFunctionClass = functionClass.asSubclass(TypedFunction.class);
        Optional<Type> argType = TypedFunctionExecutor.handlerTypeArgument(typedFunctionClass);
        if (argType.isEmpty()) {
            throw new RuntimeException("Class " + typedFunctionClass.getName() + " does not implement " + TypedFunction.class.getName());
        }
        try {
            typedFunction = typedFunctionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Class " + typedFunctionClass.getName() + " must declare a valid default constructor to be usable as a strongly typed function. Could not use constructor: " + e.toString());
        }
        TypedFunction.WireFormat format = typedFunction.getWireFormat();
        if (format == null) {
            format = LazyDefaultFormatHolder.defaultFormat;
        }
        TypedFunctionExecutor executor = new TypedFunctionExecutor(argType.orElseThrow(), typedFunction, format);
        return executor;
    }

    static Optional<Type> handlerTypeArgument(Class<? extends TypedFunction<?, ?>> functionClass) {
        return Arrays.stream(functionClass.getMethods()).filter(method -> method.getName().equals(APPLY_METHOD) && method.getParameterCount() == 1).map(method -> method.getGenericParameterTypes()[0]).filter(type -> type != Object.class).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(HttpServletRequest req, HttpServletResponse res) {
        HttpRequestImpl reqImpl = new HttpRequestImpl(req);
        HttpResponseImpl resImpl = new HttpResponseImpl(res);
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.function.getClass().getClassLoader());
            this.handleRequest(reqImpl, resImpl);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            resImpl.flush();
        }
    }

    private void handleRequest(HttpRequest req, HttpResponse res) {
        Object resObj;
        Object reqObj;
        try {
            reqObj = this.format.deserialize(req, this.argType);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Failed to parse request for " + this.function.getClass().getName(), t);
            res.setStatusCode(400);
            return;
        }
        try {
            resObj = this.function.apply(reqObj);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Failed to execute " + this.function.getClass().getName(), t);
            res.setStatusCode(500);
            return;
        }
        try {
            this.format.serialize(resObj, res);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Failed to serialize response for " + this.function.getClass().getName(), t);
            res.setStatusCode(500);
            return;
        }
    }

    private static class GsonWireFormat
    implements TypedFunction.WireFormat {
        private final Gson gson = new GsonBuilder().create();

        private GsonWireFormat() {
        }

        @Override
        public void serialize(Object object, HttpResponse response) throws Exception {
            if (object == null) {
                response.setStatusCode(204);
                return;
            }
            try (BufferedWriter bodyWriter = response.getWriter();){
                this.gson.toJson(object, (Appendable)bodyWriter);
            }
        }

        @Override
        public Object deserialize(HttpRequest request, Type type) throws Exception {
            try (BufferedReader bodyReader = request.getReader();){
                Object t = this.gson.fromJson((Reader)bodyReader, type);
                return t;
            }
        }
    }

    private static class LazyDefaultFormatHolder {
        static final TypedFunction.WireFormat defaultFormat = new GsonWireFormat();

        private LazyDefaultFormatHolder() {
        }
    }
}

