/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker;

import com.google.cloud.functions.BackgroundFunction;
import com.google.cloud.functions.CloudEventsFunction;
import com.google.cloud.functions.Context;
import com.google.cloud.functions.RawBackgroundFunction;
import com.google.cloud.functions.invoker.CloudFunctionsContext;
import com.google.cloud.functions.invoker.Event;
import com.google.cloud.functions.invoker.GcfEvents;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.message.MessageReader;
import io.cloudevents.http.HttpMessageFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class BackgroundFunctionExecutor
extends HttpServlet {
    private static final Logger logger = Logger.getLogger("com.google.cloud.functions.invoker");
    private final FunctionExecutor<?> functionExecutor;

    private BackgroundFunctionExecutor(FunctionExecutor<?> functionExecutor) {
        this.functionExecutor = functionExecutor;
    }

    public static Optional<BackgroundFunctionExecutor> maybeForClass(Class<?> functionClass) {
        Optional<FunctionKind> maybeFunctionKind = FunctionKind.forClass(functionClass);
        if (!maybeFunctionKind.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(BackgroundFunctionExecutor.forClass(functionClass, maybeFunctionKind.get()));
    }

    public static BackgroundFunctionExecutor forClass(Class<?> functionClass) {
        Optional<FunctionKind> maybeFunctionKind = FunctionKind.forClass(functionClass);
        if (!maybeFunctionKind.isPresent()) {
            List classNames = FunctionKind.VALUES.stream().map(v -> v.functionClass.getName()).collect(Collectors.toList());
            throw new RuntimeException("Class " + functionClass.getName() + " must implement one of these interfaces: " + String.join((CharSequence)", ", classNames));
        }
        return BackgroundFunctionExecutor.forClass(functionClass, maybeFunctionKind.get());
    }

    private static BackgroundFunctionExecutor forClass(Class<?> functionClass, FunctionKind functionKind) {
        FunctionExecutor executor;
        Object instance;
        try {
            instance = functionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not construct an instance of " + functionClass.getName() + ": " + e, e);
        }
        switch (functionKind) {
            case RAW_BACKGROUND: {
                executor = new RawFunctionExecutor((RawBackgroundFunction)instance);
                break;
            }
            case BACKGROUND: {
                BackgroundFunction backgroundFunction = (BackgroundFunction)instance;
                Class<?> c = backgroundFunction.getClass();
                Optional<Type> maybeTargetType = BackgroundFunctionExecutor.backgroundFunctionTypeArgument(c);
                if (!maybeTargetType.isPresent()) {
                    throw new RuntimeException("Could not determine the payload type for BackgroundFunction of type " + instance.getClass().getName() + "; must implement BackgroundFunction<T> for some T");
                }
                executor = new TypedFunctionExecutor(maybeTargetType.get(), backgroundFunction);
                break;
            }
            case CLOUD_EVENTS: {
                executor = new CloudEventFunctionExecutor((CloudEventsFunction)instance);
                break;
            }
            default: {
                throw new AssertionError((Object)functionKind);
            }
        }
        return new BackgroundFunctionExecutor(executor);
    }

    static Optional<Type> backgroundFunctionTypeArgument(Class<? extends BackgroundFunction<?>> functionClass) {
        return Arrays.stream(functionClass.getMethods()).filter(m -> m.getName().equals("accept") && m.getParameterCount() == 2 && m.getParameterTypes()[1] == Context.class && m.getParameterTypes()[0] != Object.class).map(m -> m.getGenericParameterTypes()[0]).findFirst();
    }

    private static Event parseLegacyEvent(HttpServletRequest req) throws IOException {
        try (BufferedReader bodyReader = req.getReader();){
            Event event = BackgroundFunctionExecutor.parseLegacyEvent(bodyReader);
            return event;
        }
    }

    static Event parseLegacyEvent(Reader reader) throws IOException {
        TypeAdapter<CloudFunctionsContext> typeAdapter = CloudFunctionsContext.typeAdapter(new Gson());
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)CloudFunctionsContext.class), typeAdapter).registerTypeAdapter((Type)((Object)Event.class), new Event.EventDeserializer()).create();
        return gson.fromJson(reader, Event.class);
    }

    private static Context contextFromCloudEvent(CloudEvent cloudEvent) {
        OffsetDateTime timestamp = Optional.ofNullable(cloudEvent.getTime()).orElse(OffsetDateTime.now());
        String timestampString = DateTimeFormatter.ISO_INSTANT.format(timestamp);
        String resource = "{}";
        Map<String, String> attributesMap = cloudEvent.getAttributeNames().stream().collect(Collectors.toMap(a -> a, a -> String.valueOf(cloudEvent.getAttribute((String)a))));
        return CloudFunctionsContext.builder().setEventId(cloudEvent.getId()).setEventType(cloudEvent.getType()).setResource(resource).setTimestamp(timestampString).setAttributes(attributesMap).build();
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String contentType = req.getContentType();
        try {
            if (contentType != null && contentType.startsWith("application/cloudevents+json") || req.getHeader("ce-specversion") != null) {
                this.serviceCloudEvent(req);
            } else {
                this.serviceLegacyEvent(req);
            }
            res.setStatus(200);
        }
        catch (Throwable t) {
            res.setStatus(500);
            logger.log(Level.SEVERE, "Failed to execute " + this.functionExecutor.functionName(), t);
        }
    }

    private <CloudEventT> void serviceCloudEvent(HttpServletRequest req) throws Exception {
        FunctionExecutor<?> executor = this.functionExecutor;
        byte[] body = req.getInputStream().readAllBytes();
        MessageReader reader = HttpMessageFactory.createReaderFromMultimap(BackgroundFunctionExecutor.headerMap(req), body);
        this.runWithContextClassLoader(() -> executor.serviceCloudEvent(reader.toEvent(data -> data)));
    }

    private static Map<String, List<String>> headerMap(HttpServletRequest req) {
        TreeMap<String, List<String>> headerMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (String header : Collections.list(req.getHeaderNames())) {
            for (String value : Collections.list(req.getHeaders(header))) {
                headerMap.computeIfAbsent(header, unused -> new ArrayList()).add(value);
            }
        }
        return headerMap;
    }

    private void serviceLegacyEvent(HttpServletRequest req) throws Exception {
        Event event = BackgroundFunctionExecutor.parseLegacyEvent(req);
        this.runWithContextClassLoader(() -> this.functionExecutor.serviceLegacyEvent(event));
    }

    private void runWithContextClassLoader(ContextClassLoaderTask task) throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.functionExecutor.functionClassLoader());
            task.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    @FunctionalInterface
    private static interface ContextClassLoaderTask {
        public void run() throws Exception;
    }

    private static enum CloudEventKind {
        BINARY,
        STRUCTURED;

    }

    private static class CloudEventFunctionExecutor
    extends FunctionExecutor<Void> {
        private final CloudEventsFunction function;

        CloudEventFunctionExecutor(CloudEventsFunction function) {
            super(function.getClass());
            this.function = function;
        }

        @Override
        void serviceLegacyEvent(Event legacyEvent) throws Exception {
            CloudEvent cloudEvent = GcfEvents.convertToCloudEvent(legacyEvent);
            this.function.accept(cloudEvent);
        }

        @Override
        void serviceCloudEvent(CloudEvent cloudEvent) throws Exception {
            this.function.accept(cloudEvent);
        }
    }

    private static class TypedFunctionExecutor<T>
    extends FunctionExecutor<T> {
        private final Type type;
        private final BackgroundFunction<T> function;

        private TypedFunctionExecutor(Type type, BackgroundFunction<T> function) {
            super(function.getClass());
            this.type = type;
            this.function = function;
        }

        static <T> TypedFunctionExecutor<T> of(Type type, BackgroundFunction<?> instance) {
            BackgroundFunction<?> function = instance;
            return new TypedFunctionExecutor(type, function);
        }

        @Override
        void serviceLegacyEvent(Event legacyEvent) throws Exception {
            Object payload = new Gson().fromJson(legacyEvent.getData(), this.type);
            this.function.accept(payload, legacyEvent.getContext());
        }

        @Override
        void serviceCloudEvent(CloudEvent cloudEvent) throws Exception {
            if (cloudEvent.getData() == null) {
                throw new IllegalStateException("Event has no \"data\" component");
            }
            String data = new String(cloudEvent.getData().toBytes(), StandardCharsets.UTF_8);
            Object payload = new Gson().fromJson(data, this.type);
            Context context = BackgroundFunctionExecutor.contextFromCloudEvent(cloudEvent);
            this.function.accept(payload, context);
        }
    }

    private static class RawFunctionExecutor
    extends FunctionExecutor<Map<?, ?>> {
        private static Gson gson = new GsonBuilder().serializeNulls().create();
        private final RawBackgroundFunction function;

        RawFunctionExecutor(RawBackgroundFunction function) {
            super(function.getClass());
            this.function = function;
        }

        @Override
        void serviceLegacyEvent(Event legacyEvent) throws Exception {
            this.function.accept(gson.toJson(legacyEvent.getData()), legacyEvent.getContext());
        }

        @Override
        void serviceCloudEvent(CloudEvent cloudEvent) throws Exception {
            Context context = BackgroundFunctionExecutor.contextFromCloudEvent(cloudEvent);
            String jsonData = cloudEvent.getData() == null ? "{}" : new String(cloudEvent.getData().toBytes(), StandardCharsets.UTF_8);
            this.function.accept(jsonData, context);
        }
    }

    private static abstract class FunctionExecutor<CloudEventDataT> {
        private final Class<?> functionClass;

        FunctionExecutor(Class<?> functionClass) {
            this.functionClass = functionClass;
        }

        final String functionName() {
            return this.functionClass.getCanonicalName();
        }

        final ClassLoader functionClassLoader() {
            return this.functionClass.getClassLoader();
        }

        abstract void serviceLegacyEvent(Event var1) throws Exception;

        abstract void serviceCloudEvent(CloudEvent var1) throws Exception;
    }

    private static enum FunctionKind {
        BACKGROUND(BackgroundFunction.class),
        RAW_BACKGROUND(RawBackgroundFunction.class),
        CLOUD_EVENTS(CloudEventsFunction.class);

        static final List<FunctionKind> VALUES;
        final Class<?> functionClass;

        private FunctionKind(Class<?> functionClass) {
            this.functionClass = functionClass;
        }

        static Optional<FunctionKind> forClass(Class<?> functionClass) {
            return VALUES.stream().filter(v -> v.functionClass.isAssignableFrom(functionClass)).findFirst();
        }

        static {
            VALUES = Arrays.asList(FunctionKind.values());
        }
    }
}

