/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker;

import com.google.cloud.functions.invoker.CloudFunction;
import com.google.cloud.functions.invoker.FunctionSignatureMatcher;

public class FunctionLoader<T extends CloudFunction> {
    private final String functionTarget;
    private final ClassLoader classLoader;
    private final FunctionSignatureMatcher<T> matcher;
    private final ClassNotFoundException newStyleException;

    public FunctionLoader(String functionTarget, ClassLoader classLoader, FunctionSignatureMatcher<T> matcher, ClassNotFoundException newStyleException) {
        this.functionTarget = functionTarget;
        this.classLoader = classLoader;
        this.matcher = matcher;
        this.newStyleException = newStyleException;
    }

    public T loadUserFunction() throws Exception {
        Class<?> targetClass;
        int lastDotIndex = this.functionTarget.lastIndexOf(".");
        if (lastDotIndex == -1) {
            throw this.newStyleException;
        }
        String targetClassName = this.functionTarget.substring(0, lastDotIndex);
        String targetMethodName = this.functionTarget.substring(lastDotIndex + 1);
        try {
            targetClass = this.classLoader.loadClass(targetClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load either " + this.functionTarget + " (new form) or " + targetClassName + " (old form)", this.newStyleException);
        }
        Object targetInstance = targetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return this.matcher.match(targetClass, targetInstance, targetMethodName, this.functionTarget);
    }
}

