/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker.http;

import com.google.cloud.functions.HttpRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;

public class HttpRequestImpl
implements HttpRequest {
    private final HttpServletRequest request;

    public HttpRequestImpl(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getUri() {
        String url = this.request.getRequestURL().toString();
        if (this.request.getQueryString() != null) {
            String string = String.valueOf(url);
            String string2 = this.request.getQueryString();
            url = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?").append(string2).toString();
        }
        return url;
    }

    @Override
    public String getPath() {
        return this.request.getRequestURI();
    }

    @Override
    public Optional<String> getQuery() {
        return Optional.ofNullable(this.request.getQueryString());
    }

    @Override
    public Map<String, List<String>> getQueryParameters() {
        return this.request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Arrays.asList((String[])e.getValue())));
    }

    @Override
    public Map<String, HttpRequest.HttpPart> getParts() {
        String contentType = this.request.getContentType();
        if (contentType == null || !this.request.getContentType().startsWith("multipart/form-data")) {
            String string = String.valueOf(contentType);
            throw new IllegalStateException(string.length() != 0 ? "Content-Type must be multipart/form-data: ".concat(string) : new String("Content-Type must be multipart/form-data: "));
        }
        try {
            return this.request.getParts().stream().collect(Collectors.toMap(Part::getName, x$0 -> new HttpPartImpl((Part)x$0)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ServletException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Optional<String> getContentType() {
        return Optional.ofNullable(this.request.getContentType());
    }

    @Override
    public long getContentLength() {
        return this.request.getContentLength();
    }

    @Override
    public Optional<String> getCharacterEncoding() {
        return Optional.ofNullable(this.request.getCharacterEncoding());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    @Override
    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return Collections.list(this.request.getHeaderNames()).stream().map(name -> new AbstractMap.SimpleEntry<String, ArrayList<String>>((String)name, Collections.list(this.request.getHeaders((String)name)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static class HttpPartImpl
    implements HttpRequest.HttpPart {
        private final Part part;

        private HttpPartImpl(Part part) {
            this.part = part;
        }

        @Override
        public Optional<String> getFileName() {
            return Optional.ofNullable(this.part.getSubmittedFileName());
        }

        @Override
        public Optional<String> getContentType() {
            return Optional.ofNullable(this.part.getContentType());
        }

        @Override
        public long getContentLength() {
            return this.part.getSize();
        }

        @Override
        public Optional<String> getCharacterEncoding() {
            String contentType = this.getContentType().orElse(null);
            if (contentType == null) {
                return Optional.empty();
            }
            Pattern charsetPattern = Pattern.compile("(?i).*;\\s*charset\\s*=([^;\\s]*)\\s*(;|$)");
            Matcher matcher = charsetPattern.matcher(contentType);
            return matcher.matches() ? Optional.of(matcher.group(1)) : Optional.empty();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.part.getInputStream();
        }

        @Override
        public BufferedReader getReader() throws IOException {
            String encoding = this.getCharacterEncoding().orElse("utf-8");
            return new BufferedReader(new InputStreamReader(this.getInputStream(), encoding));
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.part.getHeaderNames().stream().map(name -> new AbstractMap.SimpleEntry<String, List<String>>((String)name, HttpPartImpl.list(this.part.getHeaders((String)name)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        private static <T> List<T> list(Collection<T> collection) {
            return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
        }
    }
}

