/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker;

import com.google.cloud.functions.BackgroundFunction;
import com.google.cloud.functions.Context;
import com.google.cloud.functions.RawBackgroundFunction;
import com.google.cloud.functions.invoker.CloudFunctionsContext;
import com.google.cloud.functions.invoker.Event;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import io.cloudevents.CloudEvent;
import io.cloudevents.format.builder.HeadersStep;
import io.cloudevents.v1.AttributesImpl;
import io.cloudevents.v1.http.Unmarshallers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class NewBackgroundFunctionExecutor
extends HttpServlet {
    private static final Logger logger = Logger.getLogger("com.google.cloud.functions.invoker");
    private final FunctionExecutor<?> functionExecutor;

    private NewBackgroundFunctionExecutor(FunctionExecutor<?> functionExecutor) {
        this.functionExecutor = functionExecutor;
    }

    public static NewBackgroundFunctionExecutor forClass(Class<?> functionClass) {
        FunctionExecutor executor;
        Object instance;
        if (!BackgroundFunction.class.isAssignableFrom(functionClass) && !RawBackgroundFunction.class.isAssignableFrom(functionClass)) {
            String string = functionClass.getName();
            String string2 = BackgroundFunction.class.getName();
            String string3 = RawBackgroundFunction.class.getName();
            throw new RuntimeException(new StringBuilder(31 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Class ").append(string).append(" implements neither ").append(string2).append(" nor ").append(string3).toString());
        }
        try {
            instance = functionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            String string = functionClass.getName();
            String string4 = String.valueOf(e);
            throw new RuntimeException(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string4).length()).append("Could not construct an instance of ").append(string).append(": ").append(string4).toString(), e);
        }
        if (instance instanceof RawBackgroundFunction) {
            executor = new RawFunctionExecutor((RawBackgroundFunction)instance);
        } else {
            BackgroundFunction backgroundFunction = (BackgroundFunction)instance;
            Optional<Type> maybeTargetType = NewBackgroundFunctionExecutor.backgroundFunctionTypeArgument(backgroundFunction.getClass());
            if (!maybeTargetType.isPresent()) {
                String string = instance.getClass().getName();
                throw new RuntimeException(new StringBuilder(117 + String.valueOf(string).length()).append("Could not determine the payload type for BackgroundFunction of type ").append(string).append("; must implement BackgroundFunction<T> for some T").toString());
            }
            executor = new TypedFunctionExecutor(maybeTargetType.get(), backgroundFunction);
        }
        return new NewBackgroundFunctionExecutor(executor);
    }

    static Optional<Type> backgroundFunctionTypeArgument(Class<? extends BackgroundFunction> functionClass) {
        return Arrays.stream(functionClass.getMethods()).filter(m -> m.getName().equals("accept") && m.getParameterCount() == 2 && m.getParameterTypes()[1] == Context.class && m.getParameterTypes()[0] != Object.class).map(m -> m.getGenericParameterTypes()[0]).findFirst();
    }

    private static Event parseLegacyEvent(HttpServletRequest req) throws IOException {
        try (BufferedReader bodyReader = req.getReader();){
            TypeAdapter<CloudFunctionsContext> typeAdapter = CloudFunctionsContext.typeAdapter(new Gson());
            Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)CloudFunctionsContext.class), typeAdapter).registerTypeAdapter((Type)((Object)Event.class), new Event.EventDeserializer()).create();
            Event event = gson.fromJson((Reader)bodyReader, Event.class);
            return event;
        }
    }

    private static Context contextFromCloudEvent(CloudEvent<AttributesImpl, ?> cloudEvent) {
        AttributesImpl attributes = cloudEvent.getAttributes();
        ZonedDateTime timestamp = attributes.getTime().orElse(ZonedDateTime.now());
        String timestampString = DateTimeFormatter.ISO_INSTANT.format(timestamp);
        String resource = "{}";
        return CloudFunctionsContext.builder().setEventId(attributes.getId()).setEventType(attributes.getType()).setResource(resource).setTimestamp(timestampString).build();
    }

    private static Map<String, Object> httpHeaderMap(HttpServletRequest req) {
        return Collections.list(req.getHeaderNames()).stream().collect(Collectors.toMap(header -> header, req::getHeader));
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String contentType = req.getContentType();
        try {
            if (contentType != null && contentType.startsWith("application/cloudevents+json")) {
                this.serviceCloudEvent(req, CloudEventKind.STRUCTURED);
            } else if (req.getHeader("ce-specversion") != null) {
                this.serviceCloudEvent(req, CloudEventKind.BINARY);
            } else {
                this.serviceLegacyEvent(req);
            }
            res.setStatus(200);
        }
        catch (Throwable t) {
            res.setStatus(500);
            String string = String.valueOf(this.functionExecutor.functionName());
            logger.log(Level.WARNING, string.length() != 0 ? "Failed to execute ".concat(string) : new String("Failed to execute "), t);
        }
    }

    private <CloudEventT> void serviceCloudEvent(HttpServletRequest req, CloudEventKind kind) throws IOException {
        HeadersStep<AttributesImpl, ?, String> unmarshaller;
        FunctionExecutor<?> executor = this.functionExecutor;
        Class<?> cloudEventDataType = executor.cloudEventDataType();
        switch (kind) {
            case BINARY: {
                unmarshaller = Unmarshallers.binary(cloudEventDataType);
                break;
            }
            case STRUCTURED: {
                unmarshaller = Unmarshallers.structured(cloudEventDataType);
                break;
            }
            default: {
                throw new AssertionError((Object)kind);
            }
        }
        executor.serviceCloudEvent(req, unmarshaller);
    }

    private void serviceLegacyEvent(HttpServletRequest req) throws IOException {
        this.functionExecutor.serviceLegacyEvent(req);
    }

    private static enum CloudEventKind {
        BINARY,
        STRUCTURED;

    }

    private static class TypedFunctionExecutor<T>
    extends FunctionExecutor<T> {
        private final Type type;
        private final BackgroundFunction<T> function;

        private TypedFunctionExecutor(Type type, BackgroundFunction<T> function) {
            super(function.getClass().getCanonicalName());
            this.type = type;
            this.function = function;
        }

        static <T> TypedFunctionExecutor<T> of(Type type, BackgroundFunction<?> instance) {
            BackgroundFunction<?> function = instance;
            return new TypedFunctionExecutor(type, function);
        }

        @Override
        void serviceLegacyEvent(HttpServletRequest req) throws IOException {
            Event event = NewBackgroundFunctionExecutor.parseLegacyEvent(req);
            Object payload = new Gson().fromJson(event.getData(), this.type);
            this.function.accept(payload, event.getContext());
        }

        @Override
        void serviceCloudEvent(HttpServletRequest req, HeadersStep<AttributesImpl, T, String> unmarshaller) throws IOException {
            Map httpHeaders = NewBackgroundFunctionExecutor.httpHeaderMap(req);
            String body = req.getReader().lines().collect(Collectors.joining("\n"));
            CloudEvent<AttributesImpl, T> cloudEvent = unmarshaller.withHeaders(() -> httpHeaders).withPayload(() -> body).unmarshal();
            if (!cloudEvent.getData().isPresent()) {
                throw new IllegalStateException("Event has no \"data\" component");
            }
            Context context = NewBackgroundFunctionExecutor.contextFromCloudEvent(cloudEvent);
            this.function.accept(cloudEvent.getData().get(), context);
        }

        @Override
        Class<T> cloudEventDataType() {
            if (!(this.type instanceof Class)) {
                String string = String.valueOf(this.type);
                throw new IllegalStateException(new StringBuilder(101 + String.valueOf(string).length()).append("CloudEvents SDK currently does not permit deserializing types other than classes: cannot deserialize ").append(string).toString());
            }
            Class c = (Class)this.type;
            return c;
        }
    }

    private static class RawFunctionExecutor
    extends FunctionExecutor<Map<?, ?>> {
        private final RawBackgroundFunction function;

        RawFunctionExecutor(RawBackgroundFunction function) {
            super(function.getClass().getCanonicalName());
            this.function = function;
        }

        @Override
        void serviceLegacyEvent(HttpServletRequest req) throws IOException {
            Event event = NewBackgroundFunctionExecutor.parseLegacyEvent(req);
            this.function.accept(new Gson().toJson(event.getData()), event.getContext());
        }

        @Override
        void serviceCloudEvent(HttpServletRequest req, HeadersStep<AttributesImpl, Map<?, ?>, String> unmarshaller) throws IOException {
            Map httpHeaders = NewBackgroundFunctionExecutor.httpHeaderMap(req);
            String body = req.getReader().lines().collect(Collectors.joining("\n"));
            CloudEvent<AttributesImpl, Map<?, ?>> cloudEvent = unmarshaller.withHeaders(() -> httpHeaders).withPayload(() -> body).unmarshal();
            Context context = NewBackgroundFunctionExecutor.contextFromCloudEvent(cloudEvent);
            String jsonData = cloudEvent.getData().map(data -> new Gson().toJson(data)).orElse("{}");
            this.function.accept(jsonData, context);
        }

        @Override
        Class<Map<?, ?>> cloudEventDataType() {
            Class<Map> c = Map.class;
            return c;
        }
    }

    private static abstract class FunctionExecutor<CloudEventDataT> {
        private final String functionName;

        FunctionExecutor(String functionName) {
            this.functionName = functionName;
        }

        final String functionName() {
            return this.functionName;
        }

        abstract void serviceLegacyEvent(HttpServletRequest var1) throws IOException;

        abstract void serviceCloudEvent(HttpServletRequest var1, HeadersStep<AttributesImpl, CloudEventDataT, String> var2) throws IOException;

        abstract Class<CloudEventDataT> cloudEventDataType();
    }
}

