/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker;

import com.google.cloud.functions.invoker.CloudFunctionsContext;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

class Event {
    private JsonElement data;
    private CloudFunctionsContext context;

    Event(JsonElement data, CloudFunctionsContext context) {
        this.data = data;
        this.context = context;
    }

    JsonElement getData() {
        return this.data;
    }

    CloudFunctionsContext getContext() {
        return this.context;
    }

    static class EventDeserializer
    implements JsonDeserializer<Event> {
        EventDeserializer() {
        }

        @Override
        public Event deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            CloudFunctionsContext context;
            JsonObject root = jsonElement.getAsJsonObject();
            JsonElement data = root.get("data");
            if (root.has("context")) {
                JsonObject contextCopy = root.getAsJsonObject("context").deepCopy();
                context = (CloudFunctionsContext)jsonDeserializationContext.deserialize(this.adjustContextResource(contextCopy), (Type)((Object)CloudFunctionsContext.class));
            } else {
                JsonObject rootCopy = root.deepCopy();
                rootCopy.remove("data");
                context = (CloudFunctionsContext)jsonDeserializationContext.deserialize(this.adjustContextResource(rootCopy), (Type)((Object)CloudFunctionsContext.class));
            }
            return new Event(data, context);
        }

        private JsonObject adjustContextResource(JsonObject contextObject) {
            String resourceValue = contextObject.has("resource") ? contextObject.get("resource").toString() : "";
            contextObject.remove("resource");
            contextObject.addProperty("resource", resourceValue);
            return contextObject;
        }
    }
}

