/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.ValueBinder;
import com.google.cloud.spanner.r2dbc.BindingFailureException;
import com.google.cloud.spanner.r2dbc.SpannerType;
import com.google.cloud.spanner.r2dbc.statement.TypedNull;
import com.google.cloud.spanner.r2dbc.util.Assert;
import com.google.cloud.spanner.r2dbc.v2.ArrayToIterableBinder;
import com.google.cloud.spanner.r2dbc.v2.ClientLibraryTypeBinder;
import com.google.cloud.spanner.r2dbc.v2.IterableBinder;
import com.google.cloud.spanner.r2dbc.v2.JsonWrapper;
import com.google.cloud.spanner.r2dbc.v2.SingleTypeBinder;
import io.r2dbc.spi.Parameter;
import io.r2dbc.spi.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class ClientLibraryBinder {
    private static final List<ClientLibraryTypeBinder> binders = ClientLibraryBinder.buildBinders();

    ClientLibraryBinder() {
    }

    private static List<ClientLibraryTypeBinder> buildBinders() {
        ArrayList<ClientLibraryTypeBinder> binders = new ArrayList<ClientLibraryTypeBinder>();
        binders.add(new SingleTypeBinder<Integer>(Integer.class, (binder, val) -> binder.to(ClientLibraryBinder.longFromInteger(val))));
        binders.add(new SingleTypeBinder<Long>(Long.class, ValueBinder::to));
        binders.add(new SingleTypeBinder<Double>(Double.class, ValueBinder::to));
        binders.add(new SingleTypeBinder<Boolean>(Boolean.class, ValueBinder::to));
        binders.add(new SingleTypeBinder<ByteArray>(ByteArray.class, ValueBinder::to));
        binders.add(new SingleTypeBinder<Date>(Date.class, ValueBinder::to));
        binders.add(new SingleTypeBinder<String>(String.class, ValueBinder::to));
        binders.add(new SingleTypeBinder<Timestamp>(Timestamp.class, ValueBinder::to));
        binders.add(new SingleTypeBinder<BigDecimal>(BigDecimal.class, ValueBinder::to));
        binders.add(new SingleTypeBinder<JsonWrapper>(JsonWrapper.class, (binder, val) -> binder.to(val == null ? Value.json(null) : val.getJsonVal())));
        binders.add(new SingleTypeBinder<boolean[]>(boolean[].class, ValueBinder::toBoolArray));
        binders.add(new SingleTypeBinder<long[]>(long[].class, ValueBinder::toInt64Array));
        binders.add(new SingleTypeBinder<double[]>(double[].class, ValueBinder::toFloat64Array));
        binders.add(new SingleTypeBinder<int[]>(int[].class, (binder, val) -> binder.toInt64Array(ClientLibraryBinder.toLongArray(val))));
        binders.add(new SingleTypeBinder<float[]>(float[].class, (binder, val) -> binder.toFloat64Array(ClientLibraryBinder.toDoubleArray(val))));
        binders.add(new ArrayToIterableBinder(Boolean[].class, ValueBinder::toBoolArray));
        binders.add(new ArrayToIterableBinder(ByteArray[].class, ValueBinder::toBytesArray));
        binders.add(new ArrayToIterableBinder(Date[].class, ValueBinder::toDateArray));
        binders.add(new ArrayToIterableBinder(String[].class, ValueBinder::toStringArray));
        binders.add(new ArrayToIterableBinder(Timestamp[].class, ValueBinder::toTimestampArray));
        binders.add(new ArrayToIterableBinder(BigDecimal[].class, ValueBinder::toNumericArray));
        binders.add(new IterableBinder());
        return binders;
    }

    private static long[] toLongArray(int[] input) {
        if (input == null) {
            return new long[0];
        }
        long[] output = new long[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    private static double[] toDoubleArray(float[] input) {
        if (input == null) {
            return new double[0];
        }
        double[] output = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    static void bind(Statement.Builder builder, String name, Object value) {
        Class valueClass;
        SpannerType spannerType;
        Object finalValue;
        Assert.requireNonNull(name, "Column name must not be null");
        Assert.requireNonNull(value, "Value must not be null");
        if (value instanceof Parameter) {
            Parameter param = (Parameter)value;
            finalValue = param.getValue();
            Type type = param.getType();
            spannerType = type instanceof SpannerType ? (SpannerType)param.getType() : null;
            valueClass = type.getJavaType();
        } else if (ClientLibraryBinder.isTypedNull(value)) {
            finalValue = null;
            valueClass = ((TypedNull)value).getType();
            spannerType = null;
        } else {
            finalValue = value;
            valueClass = value.getClass();
            spannerType = null;
        }
        Optional<ClientLibraryTypeBinder> optionalBinder = binders.stream().filter(e -> e.canBind(valueClass, spannerType)).findFirst();
        if (!optionalBinder.isPresent()) {
            throw new BindingFailureException("Can't find a binder for type: " + valueClass);
        }
        optionalBinder.get().bind(builder, name, finalValue, spannerType);
    }

    private static boolean isTypedNull(Object value) {
        return value.getClass().equals(TypedNull.class);
    }

    private static Long longFromInteger(Integer intValue) {
        return intValue == null ? null : Long.valueOf(intValue.longValue());
    }
}

