/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class CredentialsHelper {
    CredentialsHelper() {
    }

    GoogleCredentials getOauthCredentials(String oauthToken) {
        return new GoogleCredentials(new AccessToken(oauthToken, null));
    }

    GoogleCredentials getDefaultCredentials() {
        try {
            return GoogleCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Error loading default credentials", e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    GoogleCredentials getFileCredentials(String filePath) {
        File credentialsFile = new File(filePath);
        if (!credentialsFile.isFile()) {
            throw new IllegalArgumentException(String.format("Error reading credential file %s: File does not exist", filePath));
        }
        try (FileInputStream credentialsStream = new FileInputStream(credentialsFile);){
            GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)credentialsStream);
            return googleCredentials;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Error reading credential file %s", filePath), e);
        }
    }
}

