/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.statement;

import com.google.cloud.spanner.r2dbc.codecs.Codec;
import com.google.cloud.spanner.r2dbc.codecs.Codecs;
import com.google.cloud.spanner.r2dbc.codecs.DefaultCodecs;
import com.google.cloud.spanner.r2dbc.statement.TypedNull;
import com.google.cloud.spanner.r2dbc.util.Assert;
import com.google.protobuf.Struct;
import com.google.spanner.v1.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatementBindings {
    private static final Codecs codecs = new DefaultCodecs();
    private Struct.Builder currentStruct = Struct.newBuilder();
    private final List<Struct> structList = new ArrayList<Struct>();
    private final Map<String, Codec> resolvedCodecs = new HashMap<String, Codec>();
    private final Map<String, Type> typesMap = new HashMap<String, Type>();

    public void completeBinding() {
        if (this.currentStruct.getFieldsCount() > 0) {
            this.structList.add(this.currentStruct.build());
            this.currentStruct = Struct.newBuilder();
        }
    }

    public void createBind(String identifier, Object value) {
        Class<?> classToStore;
        Object valToStore;
        Assert.requireNonNull(identifier, "Identifier must not be null.");
        Assert.requireNonNull(value, "Value bound must not be null.");
        if (value.getClass().equals(TypedNull.class)) {
            valToStore = null;
            classToStore = ((TypedNull)value).getType();
        } else {
            valToStore = value;
            classToStore = value.getClass();
        }
        Codec codec = this.resolvedCodecs.computeIfAbsent(identifier, n -> codecs.getCodec(classToStore));
        this.currentStruct.putFields(identifier, codec.encode(valToStore));
        if (this.structList.isEmpty()) {
            Type.Builder typeBuilder = Type.newBuilder().setCode(codec.getTypeCode());
            if (codec.getArrayElementTypeCode() != null) {
                typeBuilder.setArrayElementType(Type.newBuilder().setCode(codec.getArrayElementTypeCode()).build());
            }
            this.typesMap.put(identifier, typeBuilder.build());
        }
    }

    public List<Struct> getBindings() {
        this.completeBinding();
        if (this.structList.isEmpty()) {
            return Collections.singletonList(Struct.getDefaultInstance());
        }
        return this.structList;
    }

    public Map<String, Type> getTypes() {
        return this.typesMap;
    }
}

