/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.codecs;

import com.google.cloud.spanner.r2dbc.codecs.Codecs;
import com.google.cloud.spanner.r2dbc.codecs.SpannerCodec;
import com.google.cloud.spanner.r2dbc.codecs.ValueUtils;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.TypeCode;

final class ArrayCodec<A>
extends SpannerCodec<A[]> {
    private Codecs codecs;
    private TypeCode elementTypeCode;

    ArrayCodec(Codecs codecs, Class<A[]> klass, TypeCode elementTypeCode) {
        super(klass, TypeCode.ARRAY, null, (val, spannerType) -> (Object[])ValueUtils.decodeValue(spannerType, val));
        this.codecs = codecs;
        this.elementTypeCode = elementTypeCode;
    }

    @Override
    Value doEncode(A[] value) {
        ListValue.Builder builder = ListValue.newBuilder();
        for (A val : value) {
            builder.addValues(this.codecs.encode(val));
        }
        return Value.newBuilder().setListValue(builder.build()).build();
    }

    @Override
    public TypeCode getArrayElementTypeCode() {
        return this.elementTypeCode;
    }
}

