/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc;

import com.google.cloud.spanner.r2dbc.SpannerColumnMetadata;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SpannerRowMetadata
implements RowMetadata {
    private final List<ColumnMetadata> columnMetadatas;
    private final List<String> columnNames;
    private final HashMap<String, Integer> columnNameIndex = new HashMap();

    public SpannerRowMetadata(ResultSetMetadata resultSetMetadata) {
        ArrayList<SpannerColumnMetadata> tmpColumnMetadata = new ArrayList<SpannerColumnMetadata>();
        ArrayList<String> tmpColumnNames = new ArrayList<String>();
        for (int i = 0; i < resultSetMetadata.getRowType().getFieldsCount(); ++i) {
            StructType.Field field = resultSetMetadata.getRowType().getFields(i);
            SpannerColumnMetadata metadata = new SpannerColumnMetadata(field);
            tmpColumnMetadata.add(metadata);
            tmpColumnNames.add(field.getName());
            this.columnNameIndex.put(field.getName(), i);
        }
        this.columnMetadatas = Collections.unmodifiableList(tmpColumnMetadata);
        this.columnNames = Collections.unmodifiableList(tmpColumnNames);
    }

    public ColumnMetadata getColumnMetadata(int index) {
        return this.columnMetadatas.get(index);
    }

    public ColumnMetadata getColumnMetadata(String identifier) {
        int index = this.getColumnIndexByName(identifier);
        return this.columnMetadatas.get(index);
    }

    public Iterable<? extends ColumnMetadata> getColumnMetadatas() {
        return Collections.unmodifiableList(this.columnMetadatas);
    }

    public Collection<String> getColumnNames() {
        return this.columnNames;
    }

    protected int getColumnIndexByName(String name) {
        if (!this.columnNameIndex.containsKey(name)) {
            throw new IllegalArgumentException("The column name " + name + " does not exist for the Spanner row. Available columns: " + this.columnNameIndex.keySet());
        }
        return this.columnNameIndex.get(name);
    }
}

