/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc;

import com.google.cloud.spanner.r2dbc.SpannerRowMetadata;
import com.google.cloud.spanner.r2dbc.codecs.Codecs;
import com.google.cloud.spanner.r2dbc.codecs.DefaultCodecs;
import com.google.protobuf.Value;
import com.google.spanner.v1.Type;
import io.r2dbc.spi.Row;
import java.util.List;

public class SpannerRow
implements Row {
    private static final Codecs codecs = new DefaultCodecs();
    private final List<Value> values;
    private final SpannerRowMetadata rowMetadata;

    public SpannerRow(List<Value> values, SpannerRowMetadata rowMetadata) {
        this.values = values;
        this.rowMetadata = rowMetadata;
    }

    public <T> T get(int columnIndex, Class<T> returnType) {
        Value spannerValue = this.values.get(columnIndex);
        Type spannerType = (Type)this.rowMetadata.getColumnMetadata(columnIndex).getNativeTypeMetadata();
        T decodedValue = codecs.decode(spannerValue, spannerType, returnType);
        return decodedValue;
    }

    public <T> T get(String columnName, Class<T> returnType) {
        Value spannerValue = this.values.get(this.rowMetadata.getColumnIndexByName(columnName));
        Type spannerType = (Type)this.rowMetadata.getColumnMetadata(columnName).getNativeTypeMetadata();
        T decodedValue = codecs.decode(spannerValue, spannerType, returnType);
        return decodedValue;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public SpannerRowMetadata getRowMetadata() {
        return this.rowMetadata;
    }
}

