/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc;

import com.google.cloud.spanner.r2dbc.SpannerRow;
import com.google.cloud.spanner.r2dbc.util.Assert;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.function.BiFunction;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SpannerResult
implements Result {
    private final Flux<SpannerRow> resultRows;
    private final Mono<Integer> rowsUpdated;

    public SpannerResult(Flux<SpannerRow> resultRows, Mono<Integer> rowsUpdated) {
        this.resultRows = Assert.requireNonNull(resultRows, "A non-null flux of rows is required.");
        this.rowsUpdated = Assert.requireNonNull(rowsUpdated, "A non-null mono of rows updated is required.").cache();
    }

    public Mono<Integer> getRowsUpdated() {
        return this.rowsUpdated;
    }

    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> f) {
        if (this.resultRows == null) {
            return Flux.empty();
        }
        return this.resultRows.map(row -> f.apply((Row)row, row.getRowMetadata()));
    }
}

