/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.util.AutoValue_AsyncWriteChannelOptions;

@AutoValue
public abstract class AsyncWriteChannelOptions {
    public static final int BUFFER_SIZE_DEFAULT = 0x800000;
    public static final int PIPE_BUFFER_SIZE_DEFAULT = 0x100000;
    public static final int UPLOAD_CHUNK_SIZE_DEFAULT = 0x4000000;
    public static final int UPLOAD_CACHE_SIZE_DEFAULT = 0;
    public static final boolean DIRECT_UPLOAD_ENABLED_DEFAULT = false;
    public static final boolean GRPC_CHECKSUMS_ENABLED_DEFAULT = false;
    public static final PipeType PIPE_TYPE_DEFAULT = PipeType.IO_STREAM_PIPE;
    public static final AsyncWriteChannelOptions DEFAULT = AsyncWriteChannelOptions.builder().build();

    @Deprecated
    public static Builder newBuilder() {
        return AsyncWriteChannelOptions.builder();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_AsyncWriteChannelOptions.Builder().setBufferSize(0x800000).setPipeBufferSize(0x100000).setPipeType(PIPE_TYPE_DEFAULT).setUploadChunkSize(0x4000000).setUploadCacheSize(0).setDirectUploadEnabled(false).setGrpcChecksumsEnabled(false);
    }

    public abstract int getBufferSize();

    public abstract int getPipeBufferSize();

    public abstract PipeType getPipeType();

    public abstract int getUploadChunkSize();

    public abstract int getUploadCacheSize();

    public abstract boolean isDirectUploadEnabled();

    public abstract boolean isGrpcChecksumsEnabled();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBufferSize(int var1);

        public abstract Builder setPipeBufferSize(int var1);

        public abstract Builder setPipeType(PipeType var1);

        public abstract Builder setUploadChunkSize(int var1);

        public abstract Builder setUploadCacheSize(int var1);

        public abstract Builder setDirectUploadEnabled(boolean var1);

        public abstract Builder setGrpcChecksumsEnabled(boolean var1);

        public abstract AsyncWriteChannelOptions build();
    }

    public static enum PipeType {
        NIO_CHANNEL_PIPE,
        IO_STREAM_PIPE;

    }
}

