/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.FileCredentialStore;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.compute.ComputeCredential;
import com.google.api.client.googleapis.extensions.java6.auth.oauth2.GooglePromptReceiver;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.ObjectParser;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialFactory {
    public static final List<String> GCS_SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/devstorage.full_control");
    public static final List<String> DATASTORE_SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/datastore", (Object)"https://www.googleapis.com/auth/userinfo.email");
    private static final Logger LOG = LoggerFactory.getLogger(CredentialFactory.class);
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private static HttpTransport httpTransport = null;

    private static synchronized HttpTransport getHttpTransport() throws IOException, GeneralSecurityException {
        if (httpTransport == null) {
            httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        return httpTransport;
    }

    public Credential getCredentialFromMetadataServiceAccount() throws IOException, GeneralSecurityException {
        LOG.debug("getCredentialFromMetadataServiceAccount()");
        ComputeCredentialWithRetry cred = new ComputeCredentialWithRetry(new ComputeCredential.Builder(CredentialFactory.getHttpTransport(), JSON_FACTORY).setRequestInitializer((HttpRequestInitializer)new CredentialHttpRetryInitializer()));
        try {
            cred.refreshToken();
        }
        catch (IOException e) {
            throw new IOException("Error getting access token from metadata server at: http://metadata/computeMetadata/v1/instance/service-accounts/default/token", e);
        }
        return cred;
    }

    public Credential getCredentialFromPrivateKeyServiceAccount(String serviceAccountEmail, String privateKeyFile, List<String> scopes) throws IOException, GeneralSecurityException {
        LOG.debug("getCredentialFromPrivateKeyServiceAccount({}, {}, {})", new Object[]{serviceAccountEmail, privateKeyFile, scopes});
        return new GoogleCredentialWithRetry(new GoogleCredential.Builder().setTransport(CredentialFactory.getHttpTransport()).setJsonFactory(JSON_FACTORY).setServiceAccountId(serviceAccountEmail).setServiceAccountScopes(scopes).setServiceAccountPrivateKeyFromP12File(new File(privateKeyFile)).setRequestInitializer((HttpRequestInitializer)new CredentialHttpRetryInitializer()));
    }

    public Credential getCredentialFromJsonKeyFile(String serviceAccountJsonKeyFile, List<String> scopes) throws IOException, GeneralSecurityException {
        LOG.debug("getCredentialFromJsonKeyFile({}, {})", (Object)serviceAccountJsonKeyFile, scopes);
        try (FileInputStream fis = new FileInputStream(serviceAccountJsonKeyFile);){
            GoogleCredentialWithRetry googleCredentialWithRetry = GoogleCredentialWithRetry.fromGoogleCredential(GoogleCredential.fromStream((InputStream)fis, (HttpTransport)CredentialFactory.getHttpTransport(), (JsonFactory)JSON_FACTORY).createScoped(scopes));
            return googleCredentialWithRetry;
        }
    }

    public Credential getCredentialFromFileCredentialStoreForInstalledApp(String clientId, String clientSecret, String filePath, List<String> scopes) throws IOException, GeneralSecurityException {
        LOG.debug("getCredentialFromFileCredentialStoreForInstalledApp({}, {}, {}, {})", new Object[]{clientId, clientSecret, filePath, scopes});
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)clientId) ? 1 : 0) != 0, (Object)"clientId must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)clientSecret) ? 1 : 0) != 0, (Object)"clientSecret must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)filePath) ? 1 : 0) != 0, (Object)"filePath must not be null or empty");
        Preconditions.checkArgument((scopes != null ? 1 : 0) != 0, (Object)"scopes must not be null or empty");
        GoogleClientSecrets.Details details = new GoogleClientSecrets.Details();
        details.setClientId(clientId);
        details.setClientSecret(clientSecret);
        GoogleClientSecrets clientSecrets = new GoogleClientSecrets();
        clientSecrets.setInstalled(details);
        FileCredentialStore credentialStore = new FileCredentialStore(new File(filePath), JSON_FACTORY);
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(CredentialFactory.getHttpTransport(), JSON_FACTORY, clientSecrets, scopes).setCredentialStore((CredentialStore)credentialStore).setRequestInitializer((HttpRequestInitializer)new CredentialHttpRetryInitializer()).build();
        return new AuthorizationCodeInstalledApp((AuthorizationCodeFlow)flow, (VerificationCodeReceiver)new GooglePromptReceiver()).authorize("user");
    }

    public Credential getStorageCredential(String clientId, String clientSecret) throws IOException, GeneralSecurityException {
        LOG.debug("getStorageCredential({}, {})", (Object)clientId, (Object)clientSecret);
        String filePath = System.getProperty("user.home") + "/.credentials/storage.json";
        return this.getCredentialFromFileCredentialStoreForInstalledApp(clientId, clientSecret, filePath, GCS_SCOPES);
    }

    public Credential getDatastoreCredential(String clientId, String clientSecret) throws IOException, GeneralSecurityException {
        LOG.debug("getStorageCredential({}, {})", (Object)clientId, (Object)clientSecret);
        String filePath = System.getProperty("user.home") + "/.credentials/datastore.json";
        return this.getCredentialFromFileCredentialStoreForInstalledApp(clientId, clientSecret, filePath, DATASTORE_SCOPES);
    }

    public static class ComputeCredentialWithRetry
    extends ComputeCredential {
        public ComputeCredentialWithRetry(ComputeCredential.Builder builder) {
            super(builder);
        }

        protected TokenResponse executeRefreshToken() throws IOException {
            GenericUrl tokenUrl = new GenericUrl(this.getTokenServerEncodedUrl());
            HttpRequest request = this.getTransport().createRequestFactory(this.getRequestInitializer()).buildGetRequest(tokenUrl);
            request.setParser((ObjectParser)new JsonObjectParser(this.getJsonFactory()));
            request.getHeaders().set("Metadata-Flavor", (Object)"Google");
            return (TokenResponse)request.execute().parseAs(TokenResponse.class);
        }
    }

    public static class GoogleCredentialWithRetry
    extends GoogleCredential {
        private static final int DEFAULT_TOKEN_EXPIRATION_SECONDS = 3600;

        public static GoogleCredentialWithRetry fromGoogleCredential(GoogleCredential credential) {
            GoogleCredential.Builder builder = new GoogleCredential.Builder().setServiceAccountPrivateKey(credential.getServiceAccountPrivateKey()).setServiceAccountPrivateKeyId(credential.getServiceAccountPrivateKeyId()).setServiceAccountId(credential.getServiceAccountId()).setServiceAccountUser(credential.getServiceAccountUser()).setServiceAccountScopes(credential.getServiceAccountScopes()).setTokenServerEncodedUrl(credential.getTokenServerEncodedUrl()).setTransport(credential.getTransport()).setJsonFactory(credential.getJsonFactory()).setClock(credential.getClock());
            return new GoogleCredentialWithRetry(builder);
        }

        public GoogleCredentialWithRetry(GoogleCredential.Builder builder) {
            super(builder);
        }

        protected TokenResponse executeRefreshToken() throws IOException {
            if (this.getServiceAccountPrivateKey() == null) {
                return super.executeRefreshToken();
            }
            JsonWebSignature.Header header = new JsonWebSignature.Header();
            header.setAlgorithm("RS256");
            header.setType("JWT");
            header.setKeyId(this.getServiceAccountPrivateKeyId());
            JsonWebToken.Payload payload = new JsonWebToken.Payload();
            long currentTime = this.getClock().currentTimeMillis();
            payload.setIssuer(this.getServiceAccountId());
            payload.setAudience((Object)this.getTokenServerEncodedUrl());
            payload.setIssuedAtTimeSeconds(Long.valueOf(currentTime / 1000L));
            payload.setExpirationTimeSeconds(Long.valueOf(currentTime / 1000L + 3600L));
            payload.setSubject(this.getServiceAccountUser());
            payload.put("scope", (Object)Joiner.on((char)' ').join((Iterable)this.getServiceAccountScopes()));
            try {
                String assertion = JsonWebSignature.signUsingRsaSha256((PrivateKey)this.getServiceAccountPrivateKey(), (JsonFactory)this.getJsonFactory(), (JsonWebSignature.Header)header, (JsonWebToken.Payload)payload);
                TokenRequest request = new TokenRequest(this.getTransport(), this.getJsonFactory(), new GenericUrl(this.getTokenServerEncodedUrl()), "urn:ietf:params:oauth:grant-type:jwt-bearer");
                request.put("assertion", (Object)assertion);
                request.setRequestInitializer(this.getRequestInitializer());
                return request.execute();
            }
            catch (GeneralSecurityException exception) {
                IOException e = new IOException();
                e.initCause(exception);
                throw e;
            }
        }
    }

    public static class CredentialHttpRetryInitializer
    implements HttpRequestInitializer {
        public void initialize(HttpRequest httpRequest) throws IOException {
            httpRequest.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler((BackOff)new ExponentialBackOff()));
            httpRequest.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)new HttpBackOffUnsuccessfulResponseHandler((BackOff)new ExponentialBackOff()));
        }
    }
}

